/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.util.Var;

public interface LaserBuild {
    public float laser();

    public float rawLaser();

    public float laserRequirement();

    public float maxPower();

    public boolean consumer();

    public boolean supplier();

    public LaserGraph graph();

    default public void drawStatus(Building building) {
        if (this.graph().broken()) {
            Draw.color((Color)Pal.remove, (float)(0.8f + Mathf.cos((float)Time.time, (float)10.0f, (float)0.2f)));
        }
    }

    default public void updateLaser(Building building) {
        if (this.graph() != null) {
            this.graph().update(building);
        }
        if (building instanceof LaserBuild) {
            LaserBuild lb = (LaserBuild)building;
            lb.graph().powerOut = lb.rawLaser() > this.maxPower();
        }
    }

    default public void clearLaser(Building building) {
        if (this.graph() != null) {
            this.graph().clearGraph(building);
        }
    }

    default public float inputLaser(Building building) {
        try {
            Var<Float> laser = Var.f();
            this.graph().getSuppliers().each(b -> {
                if (b instanceof LaserBuild) {
                    LaserBuild lb = (LaserBuild)b;
                    laser.val = Float.valueOf(((Float)laser.val).floatValue() + lb.laser());
                }
            });
            return ((Float)laser.val).floatValue();
        }
        catch (StackOverflowError e) {
            return 0.0f;
        }
    }
}

