/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser;

import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import java.util.ArrayList;
import java.util.List;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Tile;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserLink;

public class LaserGraph {
    public Seq<Building> consumers = new Seq(false, 4, Building.class);
    public Seq<Building> suppliers = new Seq(false, 4, Building.class);
    public Seq<Building> all = new Seq(false, 4, Building.class);
    public int lastChange = -2;
    public int lastRotation = -2;
    public boolean broken = false;
    public boolean powerOut = false;

    public boolean broken() {
        return this.broken || this.powerOut;
    }

    public static List<LaserLink> getLinks(int x, int y, int rotation, Block block) {
        ArrayList<LaserLink> links = new ArrayList<LaserLink>();
        int sides = 4;
        LaserBlock selfBlock = (LaserBlock)block;
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return links;
        }
        int offset = block.size / 2;
        short outputRange = selfBlock.outputRange();
        short inputRange = selfBlock.inputRange();
        ArrayList selfInputs = new ArrayList();
        ArrayList selfOutputs = new ArrayList();
        selfBlock.inputs().each(input -> selfInputs.add((input + rotation) % 4));
        selfBlock.outputs().each(output -> selfOutputs.add((output + rotation) % 4));
        block0: for (int i = 0; i < sides; ++i) {
            int finalJ;
            int finalI;
            LaserBuild otherBuild;
            IntSeq otherInputs;
            LaserBlock lb;
            Building other;
            int j;
            Point2 dir = Geometry.d4[i];
            int invI = (i + 2) % 4;
            for (j = 1 + offset; !(j > outputRange + offset || (other = Vars.world.build(tile.x + j * dir.x, tile.y + j * dir.y)) != null && other.isInsulated() || other != null && dir.y != 0 && other.tileX() != tile.x + j * dir.x || other != null && dir.x != 0 && other.tileY() != tile.y + j * dir.y); ++j) {
                Block block2;
                if (other == null || !((block2 = other.block) instanceof LaserBlock)) continue;
                lb = (LaserBlock)block2;
                otherInputs = lb.inputs();
                ArrayList consInputs = new ArrayList();
                otherInputs.each(input -> consInputs.add((input + other.rotation) % 4));
                if (!selfOutputs.contains(i) || !consInputs.contains(invI) || j > lb.inputRange() + offset) break;
                otherBuild = (LaserBuild)other;
                finalI = i;
                finalJ = j;
                links.add(new LaserLink(){
                    {
                        this.object = other;
                        this.isSupplier = false;
                        this.isConsumer = otherBuild.consumer();
                        this.side = finalI;
                        this.len = finalJ;
                    }
                });
                break;
            }
            for (j = 1 + offset; !(j > inputRange + offset || (other = Vars.world.build(tile.x + j * dir.x, tile.y + j * dir.y)) != null && other.isInsulated() || other != null && dir.y != 0 && other.tileX() != tile.x + j * dir.x || other != null && dir.x != 0 && other.tileY() != tile.y + j * dir.y); ++j) {
                if (other == null || !((otherInputs = other.block) instanceof LaserBlock)) continue;
                lb = (LaserBlock)otherInputs;
                IntSeq otherOutputs = lb.outputs();
                ArrayList consOutputs = new ArrayList();
                otherOutputs.each(output -> consOutputs.add((output + other.rotation) % 4));
                if (!selfInputs.contains(i) || !consOutputs.contains(invI) || j > lb.outputRange() + offset) continue block0;
                otherBuild = (LaserBuild)other;
                finalI = i;
                finalJ = j;
                links.add(new LaserLink(){
                    {
                        this.object = other;
                        this.isSupplier = otherBuild.supplier();
                        this.side = finalI;
                        this.len = finalJ;
                    }
                });
                continue block0;
            }
        }
        return links;
    }

    public List<LaserLink> getLinks(Building building) {
        return LaserGraph.getLinks(building.tileX(), building.tileY(), building.rotation, building.block);
    }

    public void reloadLinks(Building building) {
        this.clearGraph(building);
        List<LaserLink> newLinks = this.getLinks(building);
        for (LaserLink link : newLinks) {
            Building obj = link.object;
            LaserGraph objGraph = ((LaserBuild)obj).graph();
            if (link.isConsumer) {
                this.addConsumer(obj);
                this.removeSupplier(obj);
                objGraph.addSupplier(building);
                objGraph.removeConsumer(building);
            }
            if (!link.isSupplier) continue;
            this.addSupplier(obj);
            this.removeConsumer(obj);
            objGraph.addConsumer(building);
            objGraph.removeSupplier(building);
        }
    }

    public void addSupplier(Building building) {
        if (!(building instanceof LaserBuild)) {
            return;
        }
        LaserBuild laserBuild = (LaserBuild)building;
        if (laserBuild.supplier()) {
            this.suppliers.add((Object)((Building)laserBuild));
        }
        this.all.add((Object)((Building)laserBuild));
    }

    public void addConsumer(Building building) {
        if (!(building instanceof LaserBuild)) {
            return;
        }
        LaserBuild laserBuild = (LaserBuild)building;
        if (laserBuild.consumer()) {
            this.consumers.add((Object)((Building)laserBuild));
        }
        this.all.add((Object)((Building)laserBuild));
    }

    public void add(Building building) {
        if (!(building instanceof LaserBuild)) {
            return;
        }
        LaserBuild laserBuild = (LaserBuild)building;
        this.addSupplier(building);
        this.addConsumer(building);
        this.all.add((Object)((Building)laserBuild));
    }

    public boolean hasConsumer(LaserBuild b, LaserBuild consumer) {
        try {
            boolean has = false;
            for (Building cons : b.graph().consumers) {
                LaserBuild lb;
                if (cons == consumer) {
                    return true;
                }
                if (!(cons instanceof LaserBuild) || !this.hasConsumer(lb = (LaserBuild)cons, consumer)) continue;
                return true;
            }
            return has;
        }
        catch (StackOverflowError e) {
            return true;
        }
    }

    public void update(Building build) {
        if (this.suppliers.size > ((LaserBlock)build.block).maxSuppliers()) {
            for (Building supplier : this.suppliers) {
                if (!(supplier instanceof LaserBuild)) continue;
                LaserBuild lb = (LaserBuild)supplier;
                lb.graph().broken = true;
            }
            this.broken = true;
            this.removeSuppliers(build);
        }
        if (this.hasConsumer((LaserBuild)build, (LaserBuild)build)) {
            this.broken = true;
            this.consumers.each(e -> {
                if (e instanceof LaserBuild) {
                    LaserBuild lb = (LaserBuild)e;
                    lb.graph().broken = true;
                }
            });
            this.removeConsumers(build);
        }
        if (this.lastRotation != build.rotation) {
            ++Vars.world.tileChanges;
            this.lastRotation = build.rotation;
        }
        if (this.lastChange != Vars.world.tileChanges) {
            this.lastChange = Vars.world.tileChanges;
            this.reloadLinks(build);
            this.broken = false;
        }
        ArrayList toRemove = new ArrayList();
        this.consumers.each(cons -> {
            if (Vars.world.tile(cons.tileX(), cons.tileY()).block() == Blocks.air) {
                toRemove.add(cons);
            }
        });
        this.suppliers.each(cons -> {
            if (Vars.world.tile(cons.tileX(), cons.tileY()).block() == Blocks.air) {
                toRemove.add(cons);
            }
        });
        this.all.each(cons -> {
            if (Vars.world.tile(cons.tileX(), cons.tileY()).block() == Blocks.air) {
                toRemove.add(cons);
            }
        });
        for (Building building : toRemove) {
            this.all.remove((Object)building);
            this.consumers.remove((Object)building);
            this.suppliers.remove((Object)building);
            Vars.world.tile((int)building.tileX(), (int)building.tileY()).build = null;
        }
    }

    public Seq<Building> getSuppliers() {
        return this.suppliers;
    }

    public Seq<Building> getConsumers() {
        return this.consumers;
    }

    public void clearGraph(Building build) {
        this.all.each(building -> {
            if (!(building instanceof LaserBuild)) {
                return;
            }
            LaserBuild laserBuild = (LaserBuild)building;
            laserBuild.graph().remove(build);
        });
        this.consumers.each(consumer -> {
            if (!(consumer instanceof LaserBuild)) {
                return;
            }
            LaserBuild laserBuild = (LaserBuild)consumer;
            laserBuild.graph().all.remove((Object)build);
            laserBuild.graph().suppliers.remove((Object)build);
        });
        this.suppliers.each(supplier -> {
            if (!(supplier instanceof LaserBuild)) {
                return;
            }
            LaserBuild laserBuild = (LaserBuild)supplier;
            laserBuild.graph().all.remove((Object)build);
            laserBuild.graph().consumers.remove((Object)build);
        });
        this.suppliers.clear();
        this.consumers.clear();
    }

    private void remove(Building build) {
        this.all.remove((Object)build);
        this.suppliers.remove((Object)build);
        this.consumers.remove((Object)build);
    }

    private void removeSupplier(Building graphBuilding) {
        this.suppliers.remove((Object)graphBuilding);
    }

    private void removeConsumer(Building graphBuilding) {
        this.consumers.remove((Object)graphBuilding);
    }

    public void removeSuppliers(Building build) {
        for (Building supplier : this.suppliers) {
            if (!(supplier instanceof LaserBuild)) continue;
            LaserBuild laserBuild = (LaserBuild)supplier;
            laserBuild.graph().remove(build);
            laserBuild.graph().removeConsumer(build);
        }
        this.suppliers.clear();
    }

    public void removeConsumers(Building build) {
        for (Building consumer : this.consumers) {
            if (!(consumer instanceof LaserBuild)) continue;
            LaserBuild laserBuild = (LaserBuild)consumer;
            laserBuild.graph().remove(build);
            laserBuild.graph().removeSupplier(build);
        }
        this.consumers.clear();
    }
}

