/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser.blocks;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import subvoyage.content.other.SvStat;
import subvoyage.core.anno.LoadAnnoProcessor;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserUtil;

public class LaserGenerator
extends Block
implements LaserBlock {
    public TextureRegion heatRegion;
    public IntSeq inputs = IntSeq.with((int[])new int[0]);
    public IntSeq outputs = IntSeq.with((int[])new int[]{0});
    public short inputRange = 0;
    public short outputRange = (short)8;
    public byte maxSuppliers = (byte)4;
    public float capacity = 60.0f;
    public float laserOutput = 10.0f;
    @LoadAnnoProcessor.LoadAnno(value="@-top1")
    public TextureRegion top1;
    @LoadAnnoProcessor.LoadAnno(value="@-top2", def="@-top1")
    public TextureRegion top2;
    public float itemDuration = 120.0f;

    public LaserGenerator(String name) {
        super(name);
        this.destructible = true;
        this.regionRotated1 = 1;
        this.update = true;
        this.quickRotate = true;
        this.solid = true;
        this.group = BlockGroup.logic;
        this.sync = true;
        this.rotate = true;
        this.rotateDraw = true;
        this.replaceable = true;
        this.allowDiagonal = false;
        this.drawArrow = false;
    }

    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, (float)(Math.max(this.inputRange(), this.outputRange()) * 8));
        this.capacity = this.laserOutput + 5.0f;
    }

    public void setStats() {
        super.setStats();
        if (this.laserOutput != 0.0f) {
            this.stats.add(SvStat.laserOutput, this.laserOutput, SvStat.laserPower);
        }
    }

    public void setBars() {
        super.setBars();
        this.addBar("laser", entity -> {
            if (entity instanceof LaserBuild) {
                LaserBuild lb = (LaserBuild)entity;
                return new Bar(() -> Core.bundle.format("bar.laserpercent", new Object[]{(int)(lb.rawLaser() + 0.01f), (int)(entity.efficiency * 100.0f + 0.01f)}), () -> LaserUtil.getLaserColor(lb.rawLaser()), () -> lb.laser() / this.laserOutput);
            }
            return new Bar();
        });
    }

    public void load() {
        super.load();
        this.heatRegion = Core.atlas.find(this.name + "-heat");
        this.top1 = Core.atlas.find(this.name + "-top1");
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.top1};
    }

    public void drawDefaultPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        TextureRegion reg = this.region;
        Draw.rect((TextureRegion)reg, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        if (plan.worldContext && Vars.player != null && this.teamRegion != null && this.teamRegion.found()) {
            if (this.teamRegions[Vars.player.team().id] == this.teamRegion) {
                Draw.color((Color)Vars.player.team().color);
            }
            Draw.rect((TextureRegion)this.teamRegions[Vars.player.team().id], (float)plan.drawx(), (float)plan.drawy());
            Draw.color();
        }
        Draw.rect((TextureRegion)(plan.rotation > 1 ? this.top2 : this.top1), (float)plan.drawx(), (float)plan.drawy(), (float)(!this.rotate || !this.rotateDraw ? 0.0f : (float)(plan.rotation * 90)));
        this.drawPlanConfig(plan, list);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (valid) {
            this.drawLinks(this, x, y, rotation, true, true);
        }
    }

    @Override
    public short inputRange() {
        return this.inputRange;
    }

    @Override
    public short outputRange() {
        return this.outputRange;
    }

    @Override
    public byte maxSuppliers() {
        return this.maxSuppliers;
    }

    @Override
    public IntSeq inputs() {
        return this.inputs;
    }

    @Override
    public IntSeq outputs() {
        return this.outputs;
    }

    public class LaserGeneratorBuild
    extends Building
    implements LaserBuild {
        LaserGraph graph;
        float generationTime = 0.0f;
        float smthScl = 0.0f;

        public void updateTile() {
            boolean valid;
            super.updateTile();
            if (this.laser() > 0.5f) {
                Advancement.laser.unlock();
            }
            boolean bl = valid = this.efficiency > 0.0f;
            if (LaserGenerator.this.hasItems && valid && this.generationTime <= 0.0f) {
                this.consume();
                this.generationTime = 1.0f;
            }
            this.generationTime -= this.delta() / LaserGenerator.this.itemDuration;
            this.updateLaser(this);
        }

        public void draw() {
            this.drawStatus(this);
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y, (float)0.0f);
            this.drawTeamTop();
            Draw.rect((TextureRegion)(this.rotation > 1 ? LaserGenerator.this.top2 : LaserGenerator.this.top1), (float)this.x, (float)this.y, (float)this.drawrot());
            if (this.graph() == null) {
                return;
            }
            float laser = this.laser();
            float scl = Mathf.clamp((float)laser);
            this.smthScl = Mathf.lerp((float)this.smthScl, (float)scl, (float)(Time.delta / 20.0f));
            Color color = LaserUtil.getLaserColor(laser);
            for (Building consumer : this.graph().consumers) {
                Draw.color((Color)color);
                LaserGenerator.this.drawLaser(this.x, this.y, consumer.x, consumer.y, LaserGenerator.this.size, consumer.block.size, this.laser(), this.smthScl, Mathf.clamp((float)((laser - 300.0f) / 700.0f)));
            }
        }

        public void onRemoved() {
            this.clearLaser(this);
        }

        public void onDestroyed() {
            this.clearLaser(this);
        }

        public void created() {
            this.graph = new LaserGraph();
        }

        @Override
        public float laser() {
            return this.graph().broken() ? 0.0f : LaserGenerator.this.laserOutput * this.efficiency;
        }

        @Override
        public float rawLaser() {
            return LaserGenerator.this.laserOutput * this.efficiency;
        }

        @Override
        public float laserRequirement() {
            return 0.0f;
        }

        @Override
        public float maxPower() {
            return LaserGenerator.this.capacity;
        }

        @Override
        public boolean consumer() {
            return false;
        }

        @Override
        public boolean supplier() {
            return true;
        }

        @Override
        public LaserGraph graph() {
            return this.graph;
        }
    }
}

