/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser.blocks;

import arc.Core;
import arc.math.Mathf;
import arc.struct.IntSeq;
import mindustry.gen.Building;
import mindustry.ui.Bar;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import subvoyage.content.other.SvStat;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserUtil;

public class LaserReconstructor
extends Reconstructor
implements LaserBlock {
    public float laserRequirement = 0.0f;
    public IntSeq inputs = IntSeq.with((int[])new int[]{0, 1, 2, 3});
    public IntSeq outputs = IntSeq.with((int[])new int[0]);
    public short inputRange = (short)8;
    public short outputRange = 0;
    public byte maxSuppliers = 1;
    public float capacity = 300.0f;
    public float laserMaxEfficiency = 1.0f;
    public float laserOverpowerScale = 1.0f;
    public boolean drawInputs = false;
    public boolean drawOutputs = true;

    public LaserReconstructor(String name) {
        super(name);
    }

    public void setBars() {
        super.setBars();
        this.addBar("laser", entity -> {
            if (entity instanceof LaserBuild) {
                LaserBuild lb = (LaserBuild)entity;
                return new Bar(() -> Core.bundle.format("bar.laserpercent", new Object[]{(int)(lb.rawLaser() + 0.01f), (int)(entity.efficiencyScale() * 100.0f + 0.01f)}), () -> LaserUtil.getLaserColor(lb.rawLaser()), () -> lb.laser() / lb.laserRequirement());
            }
            return new Bar();
        });
    }

    public void setStats() {
        super.setStats();
        if (this.laserRequirement > 0.0f) {
            this.stats.add(SvStat.laserUse, this.laserRequirement, SvStat.laserPower);
        }
        if (this.laserMaxEfficiency > 0.0f) {
            this.stats.add(Stat.maxEfficiency, this.laserMaxEfficiency * 100.0f, StatUnit.percent);
        }
    }

    @Override
    public short inputRange() {
        return this.inputRange;
    }

    @Override
    public short outputRange() {
        return this.outputRange;
    }

    @Override
    public byte maxSuppliers() {
        return this.maxSuppliers;
    }

    @Override
    public IntSeq inputs() {
        return this.inputs;
    }

    @Override
    public IntSeq outputs() {
        return this.outputs;
    }

    public class LaserReconstructorBuild
    extends Reconstructor.ReconstructorBuild
    implements LaserBuild {
        LaserGraph graph;

        public LaserReconstructorBuild() {
            super((Reconstructor)LaserReconstructor.this);
        }

        public void onRemoved() {
            this.clearLaser((Building)this);
        }

        public void onDestroyed() {
            this.clearLaser((Building)this);
        }

        public void created() {
            this.graph = new LaserGraph();
        }

        public float efficiencyScale() {
            float over = Math.max(this.laser() - this.laserRequirement(), 0.0f);
            return Math.min(Mathf.clamp((float)(this.laser() / this.laserRequirement())) + over / this.laserRequirement() * LaserReconstructor.this.laserOverpowerScale, LaserReconstructor.this.laserMaxEfficiency);
        }

        @Override
        public float laser() {
            return this.graph().broken() ? 0.0f : this.inputLaser((Building)this);
        }

        @Override
        public float rawLaser() {
            return this.inputLaser((Building)this);
        }

        @Override
        public float laserRequirement() {
            return LaserReconstructor.this.laserRequirement;
        }

        @Override
        public float maxPower() {
            return LaserReconstructor.this.capacity;
        }

        @Override
        public boolean consumer() {
            return true;
        }

        @Override
        public boolean supplier() {
            return false;
        }

        @Override
        public LaserGraph graph() {
            return this.graph;
        }

        public void draw() {
            this.drawStatus((Building)this);
            super.draw();
        }

        public void updateTile() {
            super.updateTile();
            this.updateLaser((Building)this);
        }
    }
}

