/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser.blocks;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.struct.IntSeq;
import arc.util.Reflect;
import arc.util.Scaling;
import arc.util.Strings;
import java.lang.reflect.InvocationTargetException;
import mindustry.core.Version;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.type.PayloadStack;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import subvoyage.content.other.SvStat;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserUtil;

public class LaserUnitAssembler
extends UnitAssembler
implements LaserBlock {
    public float consumeLaserTier0 = 0.0f;
    public float consumeLaserTier1 = 0.0f;
    public IntSeq inputs = IntSeq.with((int[])new int[]{0, 1, 2, 3});
    public IntSeq outputs = IntSeq.with((int[])new int[0]);
    public short inputRange = (short)8;
    public short outputRange = 0;
    public byte maxSuppliers = 1;
    public float capacity = 300.0f;
    public float laserMaxEfficiency = 1.0f;
    public float laserOverpowerScale = 1.0f;
    public boolean drawInputs = false;
    public boolean drawOutputs = true;

    public LaserUnitAssembler(String name) {
        super(name);
    }

    public void setBars() {
        super.setBars();
        this.addBar("laser", entity -> {
            if (entity instanceof LaserBuild) {
                LaserBuild lb = (LaserBuild)entity;
                return new Bar(() -> Core.bundle.format("bar.laserpercent", new Object[]{(int)(lb.rawLaser() + 0.01f), (int)(entity.efficiencyScale() * 100.0f + 0.01f)}), () -> LaserUtil.getLaserColor(lb.rawLaser()), () -> lb.laser() / lb.laserRequirement());
            }
            return new Bar();
        });
    }

    @Override
    public short inputRange() {
        return this.inputRange;
    }

    @Override
    public short outputRange() {
        return this.outputRange;
    }

    @Override
    public byte maxSuppliers() {
        return this.maxSuppliers;
    }

    @Override
    public IntSeq inputs() {
        return this.inputs;
    }

    @Override
    public IntSeq outputs() {
        return this.outputs;
    }

    public void setStats() {
        this.stats.add(Stat.size, "@x@", new Object[]{this.size, this.size});
        if (this.synthetic()) {
            this.stats.add(Stat.health, (float)this.health, StatUnit.none);
            if (this.armor > 0.0f) {
                this.stats.add(Stat.armor, this.armor, StatUnit.none);
            }
        }
        if (this.canBeBuilt() && this.requirements.length > 0) {
            this.stats.add(Stat.buildTime, this.buildTime / 60.0f, StatUnit.seconds);
            this.stats.add(Stat.buildCost, StatValues.items((boolean)false, (ItemStack[])this.requirements));
        }
        if (this.instantTransfer) {
            this.stats.add(Stat.maxConsecutive, 2.0f, StatUnit.none);
        }
        for (Consume c : this.consumers) {
            c.display(this.stats);
        }
        if (this.hasLiquids) {
            this.stats.add(Stat.liquidCapacity, this.liquidCapacity, StatUnit.liquidUnits);
        }
        if (this.hasItems && this.itemCapacity > 0) {
            this.stats.add(Stat.itemCapacity, (float)this.itemCapacity, StatUnit.items);
        }
        this.stats.add(Stat.output, table -> {
            table.row();
            int tier = 0;
            for (UnitAssembler.AssemblerUnitPlan plan : this.plans) {
                int ttier = tier++;
                table.table(Styles.grayPanel, t -> {
                    if (plan.unit.isBanned()) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f).pad(10.0f);
                        return;
                    }
                    if (plan.unit.unlockedNow()) {
                        t.image(plan.unit.uiIcon).scaling(Scaling.fit).size(40.0f).pad(10.0f).left();
                        t.table(info -> {
                            info.defaults().left();
                            info.add((CharSequence)plan.unit.localizedName);
                            info.row();
                            info.add((CharSequence)(Strings.autoFixed((float)(plan.time / 60.0f), (int)1) + " " + Core.bundle.get("unit.seconds"))).color(Color.lightGray);
                            info.row();
                            info.add((CharSequence)(SvStat.laserUse.localized() + ": " + SvStat.laserPower.icon + Strings.fixed((float)(ttier > 0 ? this.consumeLaserTier1 : this.consumeLaserTier0), (int)0))).color(Color.lightGray);
                            if (ttier > 0) {
                                info.row();
                                info.add((CharSequence)(Stat.moduleTier.localized() + ": " + ttier)).color(Color.lightGray);
                            }
                        }).left();
                        t.table(req -> {
                            req.right();
                            for (int i = 0; i < plan.requirements.size; ++i) {
                                if (i % 6 == 0) {
                                    req.row();
                                }
                                PayloadStack stack = (PayloadStack)plan.requirements.get(i);
                                if (Version.isAtLeast((String)"147")) {
                                    req.add((Element)Reflect.invoke(StatValues.class, (String)"stack", (Object[])new Object[]{stack}, (Class[])new Class[]{PayloadStack.class})).pad(5.0f);
                                    continue;
                                }
                                try {
                                    Class<?> itemImage = Class.forName("mindustry.ui.ItemImage");
                                    req.add((Element)itemImage.getConstructor(PayloadStack.class).newInstance(stack)).pad(5.0f);
                                    continue;
                                }
                                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        }).right().grow().pad(10.0f);
                    } else {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f).pad(10.0f);
                    }
                }).growX().pad(5.0f);
                table.row();
            }
        });
        if (this.laserMaxEfficiency > 0.0f) {
            this.stats.add(Stat.maxEfficiency, this.laserMaxEfficiency * 100.0f, StatUnit.percent);
        }
    }

    public class LaserAssemblerBuild
    extends UnitAssembler.UnitAssemblerBuild
    implements LaserBuild {
        LaserGraph graph;

        public LaserAssemblerBuild() {
            super((UnitAssembler)LaserUnitAssembler.this);
        }

        public void onRemoved() {
            this.clearLaser((Building)this);
        }

        public void onDestroyed() {
            this.clearLaser((Building)this);
        }

        public void created() {
            this.graph = new LaserGraph();
        }

        public float efficiencyScale() {
            float over = Math.max(this.laser() - this.laserRequirement(), 0.0f);
            return Math.min(Mathf.clamp((float)(this.laser() / this.laserRequirement())) + over / this.laserRequirement() * LaserUnitAssembler.this.laserOverpowerScale, LaserUnitAssembler.this.laserMaxEfficiency);
        }

        @Override
        public float laser() {
            return this.graph().broken() ? 0.0f : this.inputLaser((Building)this);
        }

        @Override
        public float rawLaser() {
            return this.inputLaser((Building)this);
        }

        @Override
        public float laserRequirement() {
            return this.getNeededLaser();
        }

        @Override
        public float maxPower() {
            return LaserUnitAssembler.this.capacity;
        }

        @Override
        public boolean consumer() {
            return true;
        }

        @Override
        public boolean supplier() {
            return false;
        }

        @Override
        public LaserGraph graph() {
            return this.graph;
        }

        public float getNeededLaser() {
            if (this.currentTier == 1) {
                return LaserUnitAssembler.this.consumeLaserTier1;
            }
            return LaserUnitAssembler.this.consumeLaserTier0;
        }

        public void draw() {
            this.drawStatus((Building)this);
            super.draw();
        }

        public void updateTile() {
            super.updateTile();
            this.updateLaser((Building)this);
        }
    }
}

