/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser.nodes;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.util.Eachable;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import subvoyage.content.other.SvStat;
import subvoyage.core.anno.LoadAnnoProcessor;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserUtil;

public class LaserNode
extends Block
implements LaserBlock {
    public TextureRegion heatRegion;
    public IntSeq inputs = IntSeq.range((int)0, (int)4);
    public IntSeq outputs = IntSeq.range((int)0, (int)4);
    public short inputRange = (short)8;
    public short outputRange = (short)8;
    public byte maxSuppliers = (byte)4;
    public float capacity = 60.0f;
    @LoadAnnoProcessor.LoadAnno(value="@-top1")
    public TextureRegion top1;
    @LoadAnnoProcessor.LoadAnno(value="@-top2", def="@-top1")
    public TextureRegion top2;

    public LaserNode(String name) {
        super(name);
        this.destructible = true;
        this.regionRotated1 = 1;
        this.update = true;
        this.quickRotate = true;
        this.solid = true;
        this.group = BlockGroup.logic;
        this.sync = true;
        this.rotate = true;
        this.rotateDraw = true;
        this.replaceable = true;
        this.allowDiagonal = false;
        this.drawArrow = false;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(SvStat.laserCapacity, this.capacity, SvStat.laserPower);
    }

    public void setBars() {
        super.setBars();
        this.addBar("laser_power", build -> {
            if (build instanceof LaserBuild) {
                LaserBuild lb = (LaserBuild)build;
                return new Bar(() -> Core.bundle.format("bar.sv_laser_power", new Object[]{Strings.fixed((float)lb.rawLaser(), (int)1)}) + " / " + this.capacity, () -> LaserUtil.getLaserColor(lb.laser()), () -> Mathf.clamp((float)(lb.rawLaser() / this.capacity)));
            }
            return new Bar();
        });
    }

    public void drawDefaultPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        TextureRegion reg = this.region;
        Draw.rect((TextureRegion)reg, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        if (plan.worldContext && Vars.player != null && this.teamRegion != null && this.teamRegion.found()) {
            if (this.teamRegions[Vars.player.team().id] == this.teamRegion) {
                Draw.color((Color)Vars.player.team().color);
            }
            Draw.rect((TextureRegion)this.teamRegions[Vars.player.team().id], (float)plan.drawx(), (float)plan.drawy());
            Draw.color();
        }
        Draw.rect((TextureRegion)(plan.rotation > 1 ? this.top2 : this.top1), (float)plan.drawx(), (float)plan.drawy(), (float)(!this.rotate || !this.rotateDraw ? 0.0f : (float)(plan.rotation * 90)));
        this.drawPlanConfig(plan, list);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (valid) {
            this.drawLinks(this, x, y, rotation, false, true);
        }
    }

    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, (float)(Math.max(this.inputRange(), this.outputRange()) * 8));
    }

    public void load() {
        super.load();
        this.heatRegion = Core.atlas.find(this.name + "-heat");
        this.top1 = Core.atlas.find(this.name + "-top1");
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.top1};
    }

    @Override
    public short inputRange() {
        return this.inputRange;
    }

    @Override
    public short outputRange() {
        return this.outputRange;
    }

    @Override
    public byte maxSuppliers() {
        return this.maxSuppliers;
    }

    @Override
    public IntSeq inputs() {
        return this.inputs;
    }

    @Override
    public IntSeq outputs() {
        return this.outputs;
    }

    public class LaserNodeBuild
    extends Building
    implements LaserBuild {
        private LaserGraph graph;
        float smthScl = 0.0f;

        public void updateTile() {
            super.updateTile();
            this.updateLaser(this);
        }

        public void draw() {
            this.drawStatus(this);
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y, (float)0.0f);
            this.drawTeamTop();
            Draw.rect((TextureRegion)(this.rotation > 1 ? LaserNode.this.top2 : LaserNode.this.top1), (float)this.x, (float)this.y, (float)this.drawrot());
            if (this.graph() == null) {
                return;
            }
            float laser = this.laser();
            float scl = Mathf.clamp((float)laser);
            this.smthScl = Mathf.lerp((float)this.smthScl, (float)scl, (float)(Time.delta / 20.0f));
            Color color = LaserUtil.getLaserColor(laser);
            for (Building consumer : this.graph().consumers) {
                Draw.color((Color)color);
                LaserNode.this.drawLaser(this.x, this.y, consumer.x, consumer.y, LaserNode.this.size, consumer.block.size, this.laser(), this.smthScl, Mathf.clamp((float)((laser - 300.0f) / 700.0f)));
            }
        }

        public void onRemoved() {
            this.clearLaser(this);
        }

        public void onDestroyed() {
            this.clearLaser(this);
        }

        public void created() {
            this.graph = new LaserGraph();
        }

        @Override
        public float laser() {
            return this.graph().broken() ? 0.0f : this.inputLaser(this);
        }

        @Override
        public float rawLaser() {
            return this.inputLaser(this);
        }

        @Override
        public float laserRequirement() {
            return 0.0f;
        }

        @Override
        public float maxPower() {
            return LaserNode.this.capacity;
        }

        @Override
        public boolean consumer() {
            return true;
        }

        @Override
        public boolean supplier() {
            return true;
        }

        @Override
        public LaserGraph graph() {
            return this.graph;
        }
    }
}

