/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.power.generator;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.noise.Simplex;
import java.util.ArrayList;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.WeatherState;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Weather;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.SolarGenerator;

public class WindTurbine
extends SolarGenerator {
    public TextureRegion rotator;
    public TextureRegion bottom;
    public float weatherBoost = 0.25f;
    public int spacing = 6;
    public float smoothProgress = 0.0f;

    public WindTurbine(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.rotator = Core.atlas.find(this.name + "-rotator");
        this.bottom = Core.atlas.find(this.name + "-bottom");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottom, this.region, this.rotator};
    }

    public void setBars() {
        super.setBars();
        this.addBar("efficiency", e -> new Bar(() -> Core.bundle.format("bar.efficiency", new Object[]{Strings.fixed((float)(e.productionEfficiency * 100.0f), (int)1)}), () -> Pal.powerBar, () -> e.productionEfficiency));
    }

    public static void select(float x, float y, float radius, float size, Color color) {
        Lines.stroke((float)size, (Color)color);
        Lines.square((float)x, (float)y, (float)(radius - 14.0f));
        Draw.reset();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        WindTurbine.select((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, 8 * (this.size + this.spacing), this.size, Pal.placing);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        int off = 1 - this.size % 2;
        for (int x = tile.x - this.spacing + off; x <= tile.x + this.spacing; ++x) {
            for (int y = tile.y - this.spacing + off; y <= tile.y + this.spacing; ++y) {
                WindTurbine turbine;
                Block block;
                Tile other = Vars.world.tile(x, y);
                if (other == null || !((block = other.block()) instanceof WindTurbine) || (turbine = (WindTurbine)block) != this && !turbine.intersectsSpacing(other.build.tile, tile)) continue;
                return false;
            }
        }
        return true;
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.mixcol();
        int off = 1 - this.size % 2;
        Tile tile = plan.tile();
        if (this.spacing < 1 || tile == null) {
            return;
        }
        for (int x = tile.x - this.spacing + off; x <= tile.x + this.spacing; ++x) {
            for (int y = tile.y - this.spacing + off; y <= tile.y + this.spacing; ++y) {
                WindTurbine s;
                Block block;
                Tile t = Vars.world.tile(x, y);
                if (t == null || !((block = t.block()) instanceof WindTurbine) || (s = (WindTurbine)block) != this && !s.intersectsSpacing(t.build.tile, tile)) continue;
                Drawf.selected((Building)t.build, (Color)Pal.remove);
            }
        }
    }

    public boolean intersectsSpacing(int sx, int sy, int ox, int oy, int ext) {
        if (this.spacing < 1) {
            return true;
        }
        int sizeOffset = 1 - (this.size & 1);
        int spacingOffset = this.spacing + ext;
        return ox >= sx + sizeOffset - spacingOffset && ox <= sx + spacingOffset && oy >= sy + sizeOffset - spacingOffset && oy <= sy + spacingOffset;
    }

    public boolean intersectsSpacing(Tile self, Tile other) {
        return this.intersectsSpacing(self.x, self.y, other.x, other.y, 0);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        if (this.spacing >= 1) {
            Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.intersectsSpacing(point.x, point.y, other.x, other.y, 1));
        }
    }

    public class WindTurbineBuild
    extends SolarGenerator.SolarGeneratorBuild {
        public float boost;
        public float rot;
        public float totalTime;

        public WindTurbineBuild() {
            super((SolarGenerator)WindTurbine.this);
        }

        public void draw() {
            Draw.rect((TextureRegion)WindTurbine.this.bottom, (float)this.x, (float)this.y);
            Drawf.spinSprite((TextureRegion)WindTurbine.this.rotator, (float)this.x, (float)this.y, (float)this.getRot());
            Draw.rect((TextureRegion)WindTurbine.this.region, (float)this.x, (float)this.y);
        }

        public void updateTile() {
            if (this.enabled) {
                WindTurbine.this.smoothProgress = Mathf.lerpDelta((float)WindTurbine.this.smoothProgress, (float)(this.efficiency / (WindTurbine.this.powerProduction - 20.0f)), (float)0.1f);
                int sectorId = Vars.state.rules.sector == null ? 0 : Vars.state.rules.sector.id;
                float value = Mathf.clamp((float)(Simplex.noise3d((int)sectorId, (double)2.0, (double)0.6, (double)0.01f, (double)this.x, (double)(Time.time / 60.0f / 2.0f), (double)this.y) * 2.0f));
                for (Weather.WeatherEntry weather : Vars.state.rules.weather) {
                    value += weather.weather.sound == Sounds.wind ? 1.0f : 0.0f;
                }
                this.boost = Mathf.lerpDelta((float)this.boost, (float)(!Groups.weather.isEmpty() ? 1.1f : 0.0f), (float)0.05f);
                this.productionEfficiency = value + WindTurbine.this.weatherBoost * this.boost;
            }
        }

        public float getRot() {
            float rotation;
            ArrayList<Float> weatherAngles = new ArrayList<Float>();
            weatherAngles.add(Float.valueOf(90.0f));
            float[] angleSum = new float[1];
            for (WeatherState e : Groups.weather) {
                angleSum[0] = angleSum[0] + e.windVector.angle();
                weatherAngles.add(Float.valueOf(e.windVector.angle()));
            }
            float angle = angleSum[0] / (float)weatherAngles.size();
            this.totalTime += this.efficiency / (WindTurbine.this.powerProduction - 20.0f) * this.delta();
            this.rot = rotation = Mathf.clamp((float)this.efficiency, (float)(angle != 90.0f ? this.totalTime * (float)Mathf.sign((float)angle) * 90.0f : this.totalTime * 90.0f), (float)(this.totalTime * 90.0f));
            return this.rot;
        }

        public void drawSelect() {
            WindTurbine.this.drawPlace(this.tileX(), this.tileY(), 0, true);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.boost);
            write.f(this.rot);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.boost = read.f();
            this.rot = read.f();
        }
    }
}

