/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.power.node;

import arc.Core;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerBlock;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;
import subvoyage.core.SvSettings;
import subvoyage.core.draw.SvPal;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.block.power.node.PowerBubbleMerger;
import subvoyage.type.block.production.Sifter;
import subvoyage.util.SvMath;
import subvoyage.util.Var;

public class PowerBubbleNode
extends PowerBlock {
    public int range = 50;

    public PowerBubbleNode(String name) {
        super(name);
        this.configurable = true;
        this.swapDiagonalPlacement = true;
        this.allowDiagonal = true;
        this.config(Integer.class, (entity, value) -> {
            if (!(entity instanceof PowerBubbleNodeBuild)) {
                return;
            }
            PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)((Object)entity);
            Building build = Vars.world.build(value.intValue());
            if (!(build instanceof PowerBubbleNodeBuild)) {
                return;
            }
            PowerBubbleNodeBuild pb2 = (PowerBubbleNodeBuild)build;
            if (pb.link == value) {
                pb.setLink(-1);
                pb2.setLink(-2);
                pb.hasLink = false;
                pb2.hasLink = false;
                pb.removeLinks();
                pb2.removeLinks();
                ++pb.worldChanges;
                ++pb2.worldChanges;
                return;
            }
            pb.setLink((int)value);
            pb2.setLink(pb.pos());
            ++pb.worldChanges;
            ++pb2.worldChanges;
        });
        this.config(Seq.class, (entity, value) -> {
            if (!(entity instanceof PowerBubbleNodeBuild)) {
                return;
            }
            PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)((Object)entity);
            value.each(v -> {
                if (v instanceof BuildPlan) {
                    BuildPlan p = (BuildPlan)v;
                    if (p.x != entity.tileX() || p.y != entity.tileY()) {
                        pb.setLink(new Point2(p.x, p.y).pack());
                        ++pb.worldChanges;
                    }
                }
            });
        });
        this.consumePowerDynamic(t -> {
            if (t instanceof PowerBubbleNodeBuild) {
                PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)((Object)t);
                return pb.getPowerConsumption();
            }
            return 0.0f;
        });
    }

    public void setBars() {
        super.setBars();
        this.addBar("power", entity -> {
            PowerGraph g = entity.power.graph;
            return new Bar(() -> Core.bundle.format("bar.powerbalance", new Object[]{(g.getPowerBalance() >= 0.0f ? "+" : "") + UI.formatAmount((long)((long)(g.getPowerBalance() * 60.0f)))}), () -> Pal.powerBar, () -> Mathf.clamp((float)(entity.power.graph.getLastPowerProduced() / entity.power.graph.getLastPowerNeeded())));
        });
        this.addBar("batteries", PowerNode.makeBatteryBalance());
    }

    public void init() {
        super.init();
        this.clipSize = (float)(this.size * 8) + (float)(this.range * 8) * 2.0f;
    }

    private void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2, float scl, float bloomIntensity) {
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f;
        float len2 = (float)(size2 * 8) / 2.0f;
        float layer = Draw.z();
        scl = Math.max(scl + bloomIntensity / 2.0f, 0.2f);
        Draw.z((float)35.0f);
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.stroke((float)(8.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.color();
        Lines.stroke((float)(3.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(2.0f * scl + Mathf.cos((float)(Time.time + 5.0f), (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(2.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.z((float)layer);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation, boolean diagonalOn) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
        if (points.size > 2) {
            points.removeRange(2, points.size - 1);
        }
    }

    public void handlePlacementLine(Seq<BuildPlan> plans) {
        Seq cpy = Seq.with((Object[])new BuildPlan[0]);
        plans.each(p -> cpy.add((Object)p.copy()));
        plans.each(p -> {
            p.config = cpy.map(e -> Point2.pack((int)e.x, (int)e.y)).find(e -> !e.equals(Point2.pack((int)p.x, (int)p.y)));
        });
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps((Circle)Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, (float)(this.range * 8)), (Rect)Tmp.r1.setSize((float)(this.size * 8)).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    protected static boolean overlaps(float srcx, float srcy, Tile other, Block otherBlock, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)Tmp.r1.setCentered(other.worldx() + otherBlock.offset, other.worldy() + otherBlock.offset, (float)(otherBlock.size * 8), (float)(otherBlock.size * 8)));
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Building src, Building other, float range) {
        return this.overlaps(src.x, src.y, other.tile, range);
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    public boolean linkValid(Building tile, Building link) {
        return this.linkValid(tile, link, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean linkValid(Building tile, Building link, boolean checkMaxNodes) {
        if (tile == link) return false;
        if (link == null) return false;
        if (!(link.block instanceof PowerBubbleNode)) return false;
        if (!link.block.hasPower) return false;
        if (!link.block.connectedPower) return false;
        if (tile.team != link.team) {
            return false;
        }
        if (this.overlaps(tile, link, (float)(this.range * 8))) return true;
        Block block = link.block;
        if (!(block instanceof PowerBubbleNode)) return false;
        PowerBubbleNode node = (PowerBubbleNode)block;
        if (!this.overlaps(link, tile, (float)(node.range * 8))) return false;
        return true;
    }

    public class PowerBubbleNodeBuild
    extends Building {
        public boolean hasLink = false;
        public int link = -1;
        public boolean valid = false;
        int worldChanges = -2;
        float powerUsage = 0.0f;
        public boolean recheck = false;
        boolean tooBig = false;
        boolean tooSmall = false;
        boolean tooMuchEnv = false;
        boolean overlaps = false;

        public Building link() {
            if (this.hasLink) {
                if (Vars.world.build(this.link) != null && !Vars.world.build(this.link).isAdded()) {
                    return null;
                }
                return Vars.world.build(this.link);
            }
            return null;
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (PowerBubbleNode.this.linkValid(this, other)) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public void onRemoved() {
            super.onRemoved();
            this.removeLinks();
        }

        public void updateTile() {
            PowerBubbleNodeBuild pb;
            Building building;
            super.updateTile();
            if (this.hasLink && (building = this.link()) instanceof PowerBubbleNodeBuild) {
                pb = (PowerBubbleNodeBuild)building;
                pb.setLink(this.pos());
            }
            if (this.recheck && this.hasLink && (building = this.link()) instanceof PowerBubbleNodeBuild) {
                pb = (PowerBubbleNodeBuild)building;
                this.power.graph.addGraph(pb.power.graph);
            }
            if (this.worldChanges != Vars.world.tileChanges) {
                this.worldChanges = Vars.world.tileChanges;
                this.updateAll();
            }
            this.consume();
        }

        public void updateAll() {
            PowerBubbleNodeBuild pb;
            Building building;
            if (this.hasLink && (building = this.link()) instanceof PowerBubbleNodeBuild) {
                pb = (PowerBubbleNodeBuild)building;
                pb.setLink(this.pos());
            }
            this.valid = this.checkRectangle();
            if (this.valid) {
                building = this.link();
                if (building instanceof PowerBubbleNodeBuild) {
                    pb = (PowerBubbleNodeBuild)building;
                    float w = Math.abs(pb.x - this.x);
                    float h = Math.abs(pb.y - this.y);
                    this.powerUsage = Mathf.clamp((float)(w * h / 80.0f), (float)0.0f, (float)60.0f) / 60.0f / 2.0f;
                }
                this.updateLinks();
                this.recheck = true;
            } else {
                this.removeLinks();
            }
        }

        public void removeLinks() {
            Seq builds = Seq.with((Object[])new Building[0]);
            this.power.links.each(i -> {
                Building prev = Vars.world.build(i);
                if (!builds.contains((Object)prev) && !(prev instanceof PowerBubbleMerger.EnergyDockBuild)) {
                    if (prev != null) {
                        prev.power.links.removeValue(this.pos());
                    }
                    if (prev != null) {
                        this.power.links.removeValue(prev.pos());
                    }
                    PowerGraph newgraph = new PowerGraph();
                    newgraph.reflow((Building)this);
                    if (prev != null && prev.power.graph != newgraph) {
                        PowerGraph og = new PowerGraph();
                        og.reflow(prev);
                    }
                }
            });
        }

        public void updateLinks() {
            Building building;
            Seq builds = Seq.with((Object[])new Building[0]);
            if (!this.hasLink || !((building = this.link()) instanceof PowerBubbleNodeBuild)) {
                return;
            }
            PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)building;
            SvMath.rectangle(pb.tileX(), pb.tileY(), this.tileX(), this.tileY(), (x, y) -> {
                Tile tile = Vars.world.tile(x, y);
                if (tile.build == null || !tile.build.block.hasPower) {
                    return;
                }
                builds.add((Object)tile.build);
            });
            builds.addUnique((Object)pb);
            IntSeq seq = builds.mapInt(Building::pos);
            this.power.links.each(i -> {
                Building prev = Vars.world.build(i);
                if (!builds.contains((Object)prev) && !(prev instanceof PowerBubbleMerger.EnergyDockBuild)) {
                    if (prev != null) {
                        prev.power.links.removeValue(this.pos());
                    }
                    if (prev != null) {
                        this.power.links.removeValue(prev.pos());
                    }
                    PowerGraph newgraph = new PowerGraph();
                    newgraph.reflow((Building)this);
                    if (prev != null && prev.power.graph != newgraph) {
                        PowerGraph og = new PowerGraph();
                        og.reflow(prev);
                    }
                }
            });
            seq.each(i -> {
                Building next = Vars.world.build(i);
                if (!this.power.links.contains(i)) {
                    this.power.links.addUnique(next.pos());
                    next.power.links.addUnique(this.pos());
                    this.power.graph.addGraph(next.power.graph);
                }
            });
        }

        public boolean checkRectangle() {
            float area;
            Building building;
            this.overlaps = false;
            this.tooMuchEnv = false;
            this.tooSmall = false;
            this.tooBig = false;
            if (!this.hasLink || !((building = this.link()) instanceof PowerBubbleNodeBuild)) {
                return false;
            }
            PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)building;
            float maxArea = PowerBubbleNode.this.range * PowerBubbleNode.this.range * 8;
            float w = Math.abs(pb.x - this.x);
            float h = Math.abs(pb.y - this.y);
            if (w <= 8.0f || h <= 8.0f) {
                this.tooSmall = true;
            }
            if ((area = w * h) > maxArea) {
                this.tooBig = true;
            }
            Var<Integer> envCount = Var.init(0);
            Var<Boolean> rectOverlap = Var.bool();
            SvMath.rectangle(pb.tileX(), pb.tileY(), this.tileX(), this.tileY(), (x, y) -> {
                PowerBubbleNodeBuild pb2;
                Building patt12798$temp;
                Tile tile = Vars.world.tile(x, y);
                if (tile.block() != null && tile.block().isStatic()) {
                    Integer n = (Integer)envCount.val;
                    envCount.val = (Integer)envCount.val + 1;
                }
                if ((patt12798$temp = tile.build) instanceof PowerBubbleNodeBuild && this.link != (pb2 = (PowerBubbleNodeBuild)patt12798$temp).pos() && pb2 != this) {
                    rectOverlap.val = true;
                }
            });
            if ((Integer)envCount.val > 64) {
                this.tooMuchEnv = true;
            }
            if (((Boolean)rectOverlap.val).booleanValue()) {
                this.overlaps = true;
            }
            pb.tooBig = this.tooBig;
            pb.tooSmall = this.tooSmall;
            pb.tooMuchEnv = this.tooMuchEnv;
            pb.overlaps = this.overlaps;
            if (this.tooBig) {
                Advancement.big_bubble.unlock();
            }
            return !this.tooMuchEnv && !this.overlaps && !this.tooBig && !this.tooSmall;
        }

        public void draw() {
            super.draw();
            Building build = this.link();
            if (build instanceof PowerBubbleNodeBuild) {
                PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)build;
                if (this.valid) {
                    Draw.z((float)29.5f);
                    Draw.rect((TextureRegion)PowerBubbleNode.this.region, (float)build.x, (float)this.y, (float)0.0f);
                    Draw.rect((TextureRegion)PowerBubbleNode.this.region, (float)this.x, (float)build.y, (float)0.0f);
                    Draw.z((float)86.7f);
                    Draw.color((Color)SvPal.powerLaser.cpy().saturation(0.2f));
                    if (!SvSettings.bool("power-bubble-shaders")) {
                        Draw.alpha((float)0.2f);
                    }
                    Fill.crect((float)this.x, (float)this.y, (float)(build.x - this.x), (float)(build.y - this.y));
                    Draw.z((float)30.0f);
                } else {
                    Draw.z((float)29.5f);
                    Draw.rect((TextureRegion)PowerBubbleNode.this.region, (float)build.x, (float)this.y, (float)0.0f);
                    Draw.rect((TextureRegion)PowerBubbleNode.this.region, (float)this.x, (float)build.y, (float)0.0f);
                    Draw.z((float)86.7f);
                    Draw.color((Color)Pal.remove);
                    if (!SvSettings.bool("power-bubble-shaders")) {
                        Draw.alpha((float)0.2f);
                    }
                    Fill.crect((float)this.x, (float)this.y, (float)(build.x - this.x), (float)(build.y - this.y));
                    Draw.z((float)30.0f);
                }
                Draw.reset();
            }
        }

        public void drawSelect() {
            Building building;
            super.drawSelect();
            Seq errors = Seq.with((Object[])new String[0]);
            if (this.tooBig) {
                errors.add((Object)"pbubble.error.too-big");
            }
            if (this.tooSmall) {
                errors.add((Object)"pbubble.error.too-small");
            }
            if (this.tooMuchEnv) {
                errors.add((Object)"pbubble.error.env");
            }
            if (this.overlaps) {
                errors.add((Object)"pbubble.error.overlap");
            }
            Sifter.drawErrorInfo(PowerBubbleNode.this.size, this.x - 3.0f, this.y, (Seq<String>)errors);
            if (this.hasLink && (building = this.link()) instanceof PowerBubbleNodeBuild) {
                PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)building;
                Lines.stroke((float)1.5f, (Color)Pal.accent);
                Lines.quad((float)this.x, (float)this.y, (float)pb.x, (float)this.y, (float)pb.x, (float)pb.y, (float)this.x, (float)pb.y);
            }
            Draw.reset();
        }

        public void drawConfigure() {
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Lines.square((float)this.x, (float)this.y, (float)((float)(this.block.size * 8) / 2.0f + 1.0f));
            Draw.reset();
            Building build = this.link();
            if (!(build instanceof PowerBubbleNodeBuild)) {
                return;
            }
            PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)build;
            Lines.stroke((float)1.0f);
            Drawf.square((float)pb.x, (float)pb.y, (float)((float)(PowerBubbleNode.this.size * 8) / 2.0f), (Color)Pal.place);
            Draw.reset();
        }

        public void configured(Unit builder, Object value) {
            Building build;
            Object conf;
            Class<Void> type;
            Class<Void> clazz = value == null ? Void.TYPE : (type = value.getClass().isAnonymousClass() ? value.getClass().getSuperclass() : value.getClass());
            if (value instanceof Item) {
                type = Item.class;
            }
            if (value instanceof Block) {
                type = Block.class;
            }
            if (value instanceof Liquid) {
                type = Liquid.class;
            }
            if (value instanceof UnitType) {
                type = UnitType.class;
            }
            if (value instanceof Point2[]) {
                type = Point2[].class;
            }
            if (builder != null && builder.isPlayer()) {
                this.lastAccessed = builder.getPlayer().coloredName();
            }
            if (this.block.configurations.containsKey(type)) {
                ((Cons2)this.block.configurations.get(type)).get((Object)this, value);
            } else if (value instanceof Building && (conf = (build = (Building)value).config()) != null && !(conf instanceof Building)) {
                this.configured(builder, conf);
            }
        }

        public void setLink(int value) {
            Building building;
            if (this.link == value) {
                this.hasLink = true;
                return;
            }
            if (this.hasLink && (building = Vars.world.build(this.link)) instanceof PowerBubbleNodeBuild) {
                PowerBubbleNodeBuild pb = (PowerBubbleNodeBuild)building;
                pb.link = -1;
                pb.hasLink = false;
                pb.valid = pb.checkRectangle();
                ++pb.worldChanges;
            }
            this.link = value;
            this.hasLink = Vars.world.build(this.link) instanceof PowerBubbleNodeBuild;
            this.valid = this.checkRectangle();
            ++this.worldChanges;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.setLink(read.i());
            }
        }

        public void created() {
            super.created();
            this.updateAll();
        }

        public void placed() {
            super.placed();
            this.updateAll();
        }

        public void updateProximity() {
            super.updateProximity();
            this.updateAll();
        }

        public byte version() {
            return 1;
        }

        public float getPowerConsumption() {
            return this.powerUsage;
        }
    }
}

