/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.production;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.Pump;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import subvoyage.content.SvItems;
import subvoyage.content.block.SvEnvironment;
import subvoyage.core.anno.LoadAnnoProcessor;

public class CoralliteGrinder
extends GenericCrafter {
    public int maxLiquidTiles = 3;
    public ItemStack[] sulfurVariant = new ItemStack[0];
    public DrawBlock sulfurDrawer;
    @LoadAnnoProcessor.LoadAnno(value="@-sulfur")
    public TextureRegion sulfurTx;

    public CoralliteGrinder(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.sulfurDrawer.load((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.output);
        if (this.outputItems != null) {
            this.stats.add(Stat.output, table -> {
                table.margin(8.0f);
                table.row();
                table.table(t -> {
                    t.add((Element)new Image((TextureRegion)Core.atlas.find("subvoyage-hard-water-edge"))).padRight(5.0f);
                    t.label(() -> Core.bundle.get("rules.anyenv") + " [gray]>[]").padRight(20.0f);
                    StatValues.items((float)this.craftTime, (ItemStack[])this.outputItems).display(t);
                }).margin(8.0f).left();
                table.row();
                table.table(t -> {
                    t.add((Element)new Image((TextureRegion)Core.atlas.find("subvoyage-sulfur-sand1"))).padRight(5.0f);
                    t.label(() -> SvEnvironment.sulfurSand.localizedName + " [gray]>[]").padRight(20.0f);
                    StatValues.items((float)this.craftTime, (ItemStack[])this.sulfurVariant).display(t);
                }).margin(8.0f).left();
            });
        }
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        if (this.useSulfur(plan.tile())) {
            this.sulfurDrawer.drawPlan((Block)this, plan, list);
        } else {
            super.drawPlanRegion(plan, list);
        }
    }

    public boolean useSulfur(Tile tile) {
        if (tile == null) {
            return false;
        }
        return tile.getLinkedTilesAs((Block)this, tempTiles).sum(other -> other.floor().itemDrop == SvItems.sulfur ? 1 : 0) > 1;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return tile.getLinkedTilesAs((Block)this, tempTiles).sum(other -> other.floor().isLiquid ? 1 : 0) <= this.maxLiquidTiles;
    }

    public class CoralliteRefinerBuild
    extends GenericCrafter.GenericCrafterBuild {
        public CoralliteRefinerBuild() {
            super((GenericCrafter)CoralliteGrinder.this);
        }

        public void craft() {
            this.consume();
            if (this.output() != null) {
                for (ItemStack output : this.output()) {
                    for (int i = 0; i < output.amount; ++i) {
                        this.offload(output.item);
                    }
                }
            }
            if (this.wasVisible) {
                CoralliteGrinder.this.craftEffect.at(this.x, this.y);
            }
            this.progress %= 1.0f;
        }

        public void dumpOutputs() {
            if (this.output() != null && this.timer(CoralliteGrinder.this.timerDump, (float)CoralliteGrinder.this.dumpTime / this.timeScale)) {
                for (ItemStack output : this.output()) {
                    this.dump(output.item);
                }
            }
            if (CoralliteGrinder.this.outputLiquids != null) {
                for (int i = 0; i < CoralliteGrinder.this.outputLiquids.length; ++i) {
                    int dir = CoralliteGrinder.this.liquidOutputDirections.length > i ? CoralliteGrinder.this.liquidOutputDirections[i] : -1;
                    this.dumpLiquid(CoralliteGrinder.this.outputLiquids[i].liquid, 2.0f, dir);
                }
            }
        }

        public ItemStack[] output() {
            return this.useSulfur() ? CoralliteGrinder.this.sulfurVariant : CoralliteGrinder.this.outputItems;
        }

        public void draw() {
            if (this.useSulfur()) {
                CoralliteGrinder.this.sulfurDrawer.draw((Building)this);
            } else {
                super.draw();
            }
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            if (source instanceof Pump.PumpBuild) {
                return super.acceptLiquid(source, liquid);
            }
            return false;
        }

        public boolean useSulfur() {
            return this.tile.getLinkedTilesAs(this.block, tempTiles).sum(other -> other.floor().itemDrop == SvItems.sulfur ? 1 : 0) > 1;
        }

        public boolean acceptItem(Building source, Item item) {
            return false;
        }
    }
}

