/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.production;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Diffuser
extends Block {
    @Nullable
    protected ConsumeItems consItems;
    public Item[] results;
    public float craftTime;

    public Diffuser(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.sync = true;
    }

    public void setBars() {
        super.setBars();
        this.addBar("harvestspeed", e -> new Bar(() -> Core.bundle.format("bar.harvestspeed", new Object[]{Strings.fixed((float)(60.0f / this.craftTime * Diffuser.decrease(e.efficiency, e.diffuserK)), (int)2)}), () -> Pal.ammo, () -> Diffuser.decrease(e.efficiency, e.diffuserK)));
    }

    public static float decrease(float x, int n) {
        return x / (1.0f + Mathf.pow((float)n, (float)2.0f) / 31.62f);
    }

    public void setStats() {
        this.stats.timePeriod = this.craftTime;
        super.setStats();
        this.stats.add(Stat.output, StatValues.items(item -> Structs.contains((Object[])this.results, i -> i == item)));
        this.stats.add(Stat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
    }

    public void init() {
        super.init();
        this.consItems = (ConsumeItems)this.findConsumer(c -> c instanceof ConsumeItems);
    }

    public class DiffuserBuild
    extends Building {
        public float progress;
        public float totalProgress;
        public float warmup;
        public int seed;
        public int itemIndex;
        public int diffuserK = 1;
        public int tileChanges = -2;

        public void created() {
            this.seed = Mathf.randomSeed((long)this.tile.pos(), (int)0, (int)0x7FFFFFFE);
            this.tileChanges = Vars.world.tileChanges;
            Seq builds = Seq.with((Object[])new DiffuserBuild[0]);
            for (Tile tile : Vars.world.tiles) {
                Building building = tile.build;
                if (!(building instanceof DiffuserBuild)) continue;
                DiffuserBuild db = (DiffuserBuild)building;
                if (!db.added || db.team != this.team) continue;
                builds.addUnique((Object)db);
            }
            this.diffuserK = builds.size;
        }

        public boolean shouldAmbientSound() {
            return this.efficiency > 0.0f;
        }

        public boolean shouldConsume() {
            int total = this.items.total();
            if (Diffuser.this.consItems != null) {
                for (ItemStack stack : Diffuser.this.consItems.items) {
                    total -= this.items.get(stack.item);
                }
            }
            return total < Diffuser.this.itemCapacity && this.enabled;
        }

        public void draw() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y, (float)this.drawrot());
            this.drawTeamTop();
        }

        public float warmup() {
            return this.warmup;
        }

        public float progress() {
            return this.progress;
        }

        public float totalProgress() {
            return this.totalProgress;
        }

        public void updateTile() {
            if (this.tileChanges != Vars.world.tileChanges) {
                this.tileChanges = Vars.world.tileChanges;
                Seq builds = Seq.with((Object[])new DiffuserBuild[0]);
                for (Tile tile : Vars.world.tiles) {
                    Building building = tile.build;
                    if (!(building instanceof DiffuserBuild)) continue;
                    DiffuserBuild db = (DiffuserBuild)building;
                    if (!db.added || db.team != this.team) continue;
                    builds.addUnique((Object)db);
                }
                this.diffuserK = builds.size;
            }
            this.totalProgress += this.warmup * this.delta();
            if (this.efficiency > 0.0f) {
                this.progress += this.getProgressIncrease(Diffuser.this.craftTime);
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)0.02f);
            } else {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.02f);
            }
            if (this.progress >= 1.0f) {
                this.progress %= 1.0f;
                this.consume();
                Item item = Diffuser.this.results[this.itemIndex % Diffuser.this.results.length];
                if (item != null && this.items.get(item) < Diffuser.this.itemCapacity) {
                    this.offload(item);
                    ++this.itemIndex;
                }
            }
            if (this.timer(Diffuser.this.timerDump, Diffuser.this.dumpTime)) {
                this.dump();
            }
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        public float edelta() {
            return Diffuser.decrease(this.efficiency, this.diffuserK) * this.delta();
        }

        public boolean canDump(Building to, Item item) {
            return !Diffuser.this.consumesItem(item);
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
            write.i(this.seed);
            write.i(this.itemIndex);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.warmup = read.f();
            if (revision == 1 || revision == 2) {
                this.seed = read.i();
            }
            if (revision == 2) {
                this.itemIndex = read.i();
            }
        }
    }
}

