/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Scl;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.storage.CoreBlock;
import subvoyage.content.SvItems;
import subvoyage.content.block.SvProduction;
import subvoyage.core.draw.SvDraw;
import subvoyage.core.draw.SvFx;

public class ProductionAnchor
extends Block {
    public TextureRegion itemCircleRegion;
    public ItemStack[] itemBatches = new ItemStack[0];

    public ProductionAnchor(String name) {
        super(name);
        this.breakable = false;
        this.destructible = true;
        this.rotate = false;
        this.update = true;
        this.sync = true;
        this.hasItems = true;
        this.unloadable = false;
        this.fogRadius = 5;
    }

    public boolean canBreak(Tile tile) {
        return false;
    }

    public void load() {
        super.load();
        this.itemCircleRegion = Core.atlas.find("ring-item");
    }

    public void init() {
        super.init();
        this.clipSize = 1000000.0f;
    }

    public class ProductionAnchorBuild
    extends Building {
        Team lastInputTeam;
        float fullTime = 0.0f;
        boolean sent = false;
        boolean deposit = false;
        float waterCount = 0.0f;
        int clayCount = 0;
        float teamProgress = 0.0f;
        float time = 0.0f;
        Color teamColor;
        @Nullable
        CoreBlock.CoreBuild targetCore;
        int genI;
        Team cacheTeam;

        public ProductionAnchorBuild() {
            this.teamColor = Team.derelict.color.cpy();
            this.genI = 0;
            this.cacheTeam = null;
        }

        public void update() {
            super.update();
            this.wasVisible = true;
        }

        public boolean canPickup() {
            return false;
        }

        public void handleItem(Building source, Item item) {
            super.handleItem(source, item);
            this.lastInputTeam = source.team;
        }

        public void updateTile() {
            if (this.team != Team.derelict) {
                if (!(this.team.cores().isEmpty() || this.targetCore != null && this.targetCore.team == this.team)) {
                    this.targetCore = (CoreBlock.CoreBuild)this.team.cores().sort(b -> Mathf.dst((float)this.x, (float)this.y, (float)b.x, (float)b.y)).first();
                }
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j = 0; j < 4; ++j) {
                        Point2 out = new Point2();
                        ProductionAnchor.this.nearbySide(this.tile.x, this.tile.y, j, i2, out);
                        Building building = Vars.world.build(out.x, out.y);
                        if (building == null || !building.block.hasItems && !building.block.hasLiquids) continue;
                        int remainingClay = 25 - this.clayCount;
                        float remainingWater = 60.0f - this.waterCount;
                        if (building.block.hasItems && building.items.has(SvItems.clay) && this.clayCount < 25) {
                            this.clayCount += Math.min(building.items.get(SvItems.clay), remainingClay);
                            building.items.remove(SvItems.clay, Math.min(building.items.get(SvItems.clay), remainingClay));
                            this.lastInputTeam = building.team;
                        }
                        if (building instanceof Duct.DuctBuild) {
                            Duct.DuctBuild b2 = (Duct.DuctBuild)building;
                            if (b2.current == SvItems.clay) {
                                this.clayCount += Math.min(1, remainingClay);
                                b2.current = null;
                                this.lastInputTeam = building.team;
                            }
                        }
                        if (!building.block.hasLiquids || !(building.liquids.get(Liquids.water) >= 1.0f) || !(this.waterCount < 60.0f)) continue;
                        this.waterCount += Math.min(building.liquids.get(Liquids.water), remainingWater);
                        building.liquids.remove(Liquids.water, Math.min(building.liquids.get(Liquids.water), remainingWater));
                        this.lastInputTeam = building.team;
                    }
                }
                if (this.clayCount >= 25 && this.waterCount >= 60.0f && this.lastInputTeam != null) {
                    this.team = this.lastInputTeam;
                    Vars.state.stats.placedBlockCount.put((Object)SvProduction.productionAnchor, Vars.state.stats.placedBlockCount.get((Object)SvProduction.productionAnchor, 0) + 1);
                }
            }
            if (this.targetCore != null) {
                float alpha = (Mathf.sinDeg((float)(this.fullTime * 2.0f - 90.0f)) + 1.0f) / 2.0f;
                if (alpha <= 0.01f && !this.sent) {
                    this.sent = true;
                    this.deposit = false;
                    if (ProductionAnchor.this.itemBatches.length != 0) {
                        ItemStack batch = ProductionAnchor.this.itemBatches[this.genI % ProductionAnchor.this.itemBatches.length];
                        this.items.add(batch.item, batch.amount);
                    }
                    ++this.genI;
                }
                if (alpha >= 0.99f && !this.deposit) {
                    this.deposit = true;
                    this.sent = false;
                    this.items.each((i, c) -> this.targetCore.handleStack(i, c, (Teamc)this));
                    this.items.clear();
                }
                this.fullTime += Time.delta;
            }
        }

        public boolean allowUpdate() {
            return this.block.supportsEnv(Vars.state.rules.env) && (!Vars.state.rules.limitMapArea || !Vars.state.rules.disableOutsideArea || Rect.contains((float)Vars.state.rules.limitX, (float)Vars.state.rules.limitY, (float)Vars.state.rules.limitWidth, (float)Vars.state.rules.limitHeight, (float)this.tile.x, (float)this.tile.y));
        }

        public void draw() {
            this.wasVisible = true;
            Draw.rect((TextureRegion)ProductionAnchor.this.region, (float)this.x, (float)this.y);
            Draw.z((float)35.0f);
            if (this.team == Team.derelict) {
                Draw.color((Color)this.teamColor.cpy().lerp(Color.white, 0.9f));
            } else {
                SvDraw.applyBloomBasic(() -> {
                    Draw.color((Color)this.teamColor);
                    Draw.rect((TextureRegion)ProductionAnchor.this.teamRegion, (float)this.x, (float)this.y);
                    float size = Time.time % 60.0f;
                    float size2 = (Time.time + 15.0f) % 60.0f;
                    float fout = 1.0f - size / 60.0f;
                    float fout2 = 1.0f - size2 / 60.0f;
                    Lines.stroke((float)fout, (Color)this.teamColor.cpy().a(fout));
                    Lines.circle((float)this.x, (float)this.y, (float)((float)(this.block.size * 8) * this.teamProgress * Interp.pow2.apply(fout)));
                    Lines.stroke((float)fout2, (Color)this.teamColor.cpy().a(fout2));
                    Lines.circle((float)this.x, (float)this.y, (float)((float)(this.block.size * 8) * this.teamProgress * Interp.pow2.apply(fout2)));
                });
            }
            this.teamColor.lerp(this.team.color, Time.delta / 10.0f);
            this.teamProgress = Mathf.lerp((float)this.teamProgress, (float)(this.team == Team.derelict ? 0.0f : 1.0f), (float)(Time.delta / 10.0f));
            this.time += Time.delta;
            if (this.time >= 1.0f && this.targetCore != null) {
                float alpha = (Mathf.sinDeg((float)(this.fullTime * 2.0f - 90.0f)) + 1.0f) / 2.0f;
                Tmp.v1.set(this.x, this.y).lerp(this.targetCore.x, this.targetCore.y, alpha);
                float rot = Tmp.v1.angleTo(this.x, this.y);
                SvFx.particle.create(Tmp.v1.x, Tmp.v1.y, rot, this.teamColor, new Object());
                this.time = 0.0f;
            } else if (this.targetCore != null) {
                Item item;
                float alpha = (Mathf.sinDeg((float)(this.fullTime * 2.0f - 90.0f)) + 1.0f) / 2.0f;
                Tmp.v1.set(this.x, this.y).lerp(this.targetCore.x, this.targetCore.y, alpha);
                Draw.z((float)111.0f);
                float rot = Tmp.v1.angleTo(this.x, this.y);
                if (this.items != null && (item = this.items.first()) != null) {
                    float size = 5.0f + Mathf.absin((float)this.fullTime, (float)5.0f, (float)1.0f);
                    Draw.color();
                    Draw.mixcol((Color)Pal.accent, (float)Mathf.absin((float)this.fullTime, (float)5.0f, (float)0.1f));
                    Draw.rect((TextureRegion)item.fullIcon, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)size, (float)size, (float)(rot + 90.0f));
                    Draw.mixcol();
                    if (this.isLocal() && !Vars.renderer.pixelator.enabled()) {
                        Fonts.outline.draw((CharSequence)(this.items.get(item) + ""), Tmp.v1.x, Tmp.v1.y - 3.0f, Pal.accent, 0.25f / Scl.scl((float)1.0f), false, 1);
                    }
                    Draw.reset();
                }
            }
            if (this.team != Team.derelict && !this.team.cores().isEmpty() && this.targetCore == null) {
                this.targetCore = (CoreBlock.CoreBuild)this.team.cores().sort(b -> Mathf.dst((float)this.x, (float)this.y, (float)b.x, (float)b.y)).first();
            }
            Draw.z((float)30.0f);
        }

        public void damage(float damage) {
            if (this.team == Team.derelict) {
                return;
            }
            if (!this.dead()) {
                float dm = Vars.state.rules.blockHealth(this.team);
                this.lastDamageTime = Time.time;
                damage = Mathf.zero((float)dm) ? this.health + 1.0f : (damage /= dm);
                if (!Vars.net.client()) {
                    this.health -= this.handleDamage(damage);
                }
                this.healthChanged();
                if (this.health <= 0.0f) {
                    this.health(this.maxHealth());
                    this.healthChanged();
                    if (this.team == Vars.player.team()) {
                        Vars.state.stats.placedBlockCount.put((Object)SvProduction.productionAnchor, Vars.state.stats.placedBlockCount.get((Object)SvProduction.productionAnchor, 0) - 1);
                    }
                    this.team(this.cacheTeam);
                }
            }
        }

        public void damage(Team source, float damage) {
            this.cacheTeam = source;
            this.damage(damage);
        }

        public void write(Writes write) {
            write.i(this.clayCount);
            write.f(this.waterCount);
            if (this.lastInputTeam != null) {
                write.i(this.lastInputTeam.id);
            } else {
                write.i(-1);
            }
        }

        public void read(Reads read, byte revision) {
            if (revision == 1) {
                this.clayCount = read.i();
                this.waterCount = read.f();
                int teamId = read.i();
                this.lastInputTeam = teamId == -1 ? null : Team.get((int)teamId);
            }
        }

        public byte version() {
            return 1;
        }

        public void team(Team team) {
            if (this.team != null && this.team.data().buildingTree != null) {
                this.team.data().buildingTree.remove((QuadTree.QuadTreeObject)this);
            }
            super.team(team);
            if (this.team != null && this.team.data().buildingTree != null) {
                this.team.data().buildingTree.insert((QuadTree.QuadTreeObject)this);
            }
        }
    }
}

