/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.production;

import arc.Core;
import arc.func.Intc2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.WorldLabel;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.ConsumesOr;

public class Sifter
extends Block {
    HashMap<Integer, Item> populatedOres = new HashMap();
    public DrawBlock drawer = new DrawDefault();
    public float harvestTime = 60.0f;
    public float liquidOutput = 0.16666667f;
    public int oreSearchRadius = 5;

    public Sifter(String name) {
        super(name);
        this.destructible = true;
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.hasPower = true;
        this.sync = true;
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.mineSpeed, 60.0f / this.harvestTime, StatUnit.itemsSecond);
        this.stats.add(Stat.output, StatValues.liquid((Liquid)Liquids.water, (float)(this.liquidOutput * 60.0f), (boolean)true));
    }

    public void setBars() {
        super.setBars();
        this.addBar("harvestspeed", e -> new Bar(() -> Core.bundle.format("bar.harvestspeed", new Object[]{Strings.fixed((float)(60.0f / e.getHarvestTime() * e.efficiency), (int)2)}), () -> Pal.ammo, () -> e.efficiency));
        this.addBar("itemprogress", e -> {
            Item item = this.getPopulatedOreItemCached(e.tileX(), e.tileY());
            return new Bar(() -> item != null ? item.localizedName : Core.bundle.format("bar.noresources", new Object[0]), () -> item != null ? item.color : Color.white, () -> e.progress);
        });
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return tile.floor().isLiquid && !this.hasNearbySelf(tile) && this.getPopulatedOreItemCached(tile.x, tile.y) != null;
    }

    public boolean hasNearbySelf(Tile tile) {
        return this.isSelf(tile, 0) || this.isSelf(tile, 1) || this.isSelf(tile, 2) || this.isSelf(tile, 3);
    }

    public boolean isSelf(Tile tile, int dir) {
        boolean bl;
        switch (dir) {
            case 0: {
                if (tile.nearby(2, 0) != null && tile.nearby(2, 0).block() == this) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (tile.nearby(0, 2) != null && tile.nearby(0, 2).block() == this) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (tile.nearby(-1, 0) != null && tile.nearby(-1, 0).block() == this) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (tile.nearby(0, -1) != null && tile.nearby(0, -1).block() == this) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + dir);
            }
        }
        return bl;
    }

    public Item getPopulatedOreItem(Tile tile) {
        ArrayList candidates = new ArrayList();
        if (tile == null) {
            return null;
        }
        for (int dx = -this.oreSearchRadius; dx <= this.oreSearchRadius; ++dx) {
            for (int dy = -this.oreSearchRadius; dy <= this.oreSearchRadius; ++dy) {
                ((Intc2)(x, y) -> {
                    Tile cTile = Vars.world.tile(x, y);
                    if (cTile == null) {
                        return;
                    }
                    boolean sol = cTile.solid();
                    if (!sol) {
                        return;
                    }
                    Item drop = cTile.wallDrop();
                    if (drop != null) {
                        candidates.add(drop);
                    }
                }).get(tile.x + dx, tile.y + dy);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        int frequentCount = 0;
        Item frequentItem = null;
        for (Item candidate : candidates) {
            if (candidate == null) continue;
            itemCounts.put(candidate, itemCounts.getOrDefault(candidate, 0) + 1);
            int v = (Integer)itemCounts.get(candidate);
            if (frequentItem == candidate || v < frequentCount) continue;
            frequentItem = candidate;
            frequentCount = v;
        }
        return frequentItem;
    }

    @Nullable
    public Item getPopulatedOreItemCached(int x, int y) {
        int pos = Point2.pack((int)x, (int)y);
        if (!this.populatedOres.containsKey(pos)) {
            this.populatedOres.put(pos, this.getPopulatedOreItem(Vars.world.tile(x, y)));
        }
        Item item = this.populatedOres.get(pos);
        return item;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Item toDraw = this.getPopulatedOreItemCached(x, y);
        boolean hasNoWater = Vars.world.tile(x, y) == null || Vars.world.tile(x, y).floor() == null || !Vars.world.tile((int)x, (int)y).floor().isLiquid;
        boolean hasNearby = Vars.world.tile(x, y) != null && this.hasNearbySelf(Vars.world.tile(x, y));
        boolean hasNoOre = toDraw == null || toDraw.fullIcon.texture == null;
        boolean error = hasNoWater || hasNearby || hasNoOre;
        Color oreColor = hasNoOre ? Pal.remove : toDraw.color;
        Seq errors = Seq.with((Object[])new String[0]);
        if (hasNoWater) {
            errors.add((Object)"sifter.error.no-water");
        }
        if (hasNearby) {
            errors.add((Object)"sifter.error.nearby");
        }
        if (hasNoOre) {
            errors.add((Object)"sifter.error.no-ore");
        }
        Draw.z((float)32.0f);
        Drawf.square((float)(((float)x + (float)this.size / 4.0f) * 8.0f), (float)(((float)y + (float)this.size / 4.0f) * 8.0f), (float)(this.oreSearchRadius * 8 * 2 - 20), (float)0.0f, (Color)(error ? Pal.remove : oreColor));
        Sifter.drawErrorInfo(this.size, x * 8, y * 8, (Seq<String>)errors);
        if (toDraw != null && !error) {
            float width = this.drawPlaceText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / this.harvestTime, 2), x, y, valid);
            float dx = (float)(x * 8) + this.offset - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 5.0f;
            float s = 6.0f;
            Draw.mixcol((Color)Color.darkGray, (float)1.0f);
            Draw.rect((TextureRegion)toDraw.fullIcon, (float)dx, (float)(dy - 1.0f), (float)s, (float)s);
            Draw.reset();
            Draw.rect((TextureRegion)toDraw.fullIcon, (float)dx, (float)dy, (float)s, (float)s);
        }
    }

    public static void drawErrorInfo(int size, float x, float y, Seq<String> infos) {
        if (infos.isEmpty()) {
            return;
        }
        Draw.z((float)120.0f);
        Draw.color((Color)Color.black, (float)0.7f);
        Fill.rect((float)(x += 4.0f), (float)(y += (float)infos.size * 7.0f / 2.0f + (float)(size * 8) - 2.0f), (float)70.0f, (float)((float)infos.size * 7.0f));
        y += (float)infos.size * 3.0f - 2.0f;
        int i = 0;
        for (String info : infos) {
            WorldLabel.drawAt((String)"-", (float)(x - 35.0f + 3.0f), (float)(y - (float)(i * 6)), (float)121.0f, (int)2, (float)0.8f);
            WorldLabel.drawAt((String)Core.bundle.get(info), (float)x, (float)(y - (float)(i * 6)), (float)121.0f, (int)2, (float)0.8f);
            ++i;
        }
        Draw.z((float)122.0f);
        Draw.color((Color)Color.scarlet);
        Draw.rect((TextureRegion)Icon.cancel.getRegion(), (float)x, (float)(y + 3.0f));
    }

    public void worldReset() {
        this.populatedOres.clear();
    }

    public class WaterSifterBuild
    extends Building {
        public float progress = 0.0f;

        public void draw() {
            Sifter.this.drawer.draw((Building)this);
        }

        public void drawLight() {
            super.drawLight();
            Sifter.this.drawer.drawLight((Building)this);
        }

        public void updateTile() {
            super.updateTile();
            Item item = Sifter.this.getPopulatedOreItemCached(this.tile.x, this.tile.y);
            if (item == null) {
                return;
            }
            this.progress += this.getProgressIncrease(this.getHarvestTime());
            float liq = Sifter.this.liquidOutput * this.edelta() - (float)item.hardness * 0.8f / 60.0f;
            if (this.liquids.get(Liquids.water) < Sifter.this.liquidCapacity) {
                this.liquids.add(Liquids.water, liq);
            }
            if (this.progress >= 1.0f) {
                this.progress %= 1.0f;
                this.harvest();
                this.consume();
            }
            this.dumpOutputs();
        }

        public float getHarvestTime() {
            Item item = Sifter.this.getPopulatedOreItemCached(this.tile.x, this.tile.y);
            return item != null ? Sifter.this.harvestTime + (float)item.hardness * 15.0f : 0.0f;
        }

        public void dumpOutputs() {
            Item item = Sifter.this.getPopulatedOreItemCached(this.tile.x, this.tile.y);
            if (item != null && this.timer(Sifter.this.timerDump, (float)Sifter.this.dumpTime / this.timeScale)) {
                this.dump(item);
            }
            this.dumpLiquid(Liquids.water);
        }

        private void harvest() {
            Item item = Sifter.this.getPopulatedOreItemCached(this.tile.x, this.tile.y);
            this.offload(item);
        }

        public float warmup() {
            return this.efficiency;
        }

        public double sense(LAccess sensor) {
            Consume consume;
            if (sensor == LAccess.efficiency && (consume = Sifter.this.consumers[0]) instanceof ConsumesOr) {
                ConsumesOr cor = (ConsumesOr)consume;
                return ((Consume)cor.consumes.find(e -> e instanceof ConsumePower)).efficiency((Building)this);
            }
            return super.sense(sensor);
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            if (liquid == Liquids.water) {
                Advancement.water_to_sifter.unlock();
            }
            return super.acceptLiquid(source, liquid);
        }
    }
}

