/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.storage.core;

import arc.Core;
import arc.audio.Music;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.type.Item;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import subvoyage.content.ost.SvMusic;
import subvoyage.core.anno.LoadAnnoProcessor;
import subvoyage.core.draw.SvFx;
import subvoyage.core.draw.SvPal;
import subvoyage.core.logic.SvLogic;

public class AtlacianCore
extends CoreBlock {
    public Seq<Item> bannedItems = new Seq();
    @LoadAnnoProcessor.LoadAnno(value="@-border")
    public TextureRegion border;

    public AtlacianCore(String name) {
        super(name);
        this.buildType = Vars.mobile ? () -> new AtlacianCoreMobileBuild() : () -> new AtlacianCoreBuild();
        this.landMusic = this.launchMusic = SvMusic.atlLand;
    }

    public class AtlacianCoreBuild
    extends CoreBlock.CoreBuild {
        public AtlacianCoreBuild() {
            super((CoreBlock)AtlacianCore.this);
        }

        public void handleStack(Item item, int amount, Teamc source) {
            if (!AtlacianCore.this.bannedItems.contains((Object)item) && item != Items.copper) {
                super.handleStack(item, amount, source);
            } else {
                Fx.coreBurn.at(this.x, this.y);
            }
        }

        public void draw() {
            if (Vars.renderer.getLandTime() <= 0.0f) {
                super.draw();
            }
        }

        public void update() {
            super.update();
            this.items.remove(Items.copper, 1000);
        }

        public void beginLaunch(boolean launching) {
            if (launching) {
                Fx.coreLaunchConstruct.at(this.x, this.y, (float)AtlacianCore.this.size);
            }
            SvLogic.beginLandMusic();
            if (!Vars.headless) {
                if (Vars.renderer.isLaunching()) {
                    float margin = 30.0f;
                    Image image = new Image();
                    image.color.a = 0.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.delay((float)((this.launchDuration() - margin) / 60.0f)), Actions.fadeIn((float)(margin / 60.0f), (Interp)Interp.pow2In), Actions.delay((float)0.1f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                } else {
                    Image image = new Image();
                    image.color.a = 1.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.fadeOut((float)0.5833333f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                    Time.run((float)this.launchDuration(), () -> {
                        AtlacianCore.this.launchEffect.at((Position)this);
                        Effect.shake((float)5.0f, (float)5.0f, (Position)this);
                        if (Vars.state.isCampaign() && Vars.showSectorLandInfo && (Vars.state.rules.sector.preset == null || Vars.state.rules.sector.preset.showSectorLandInfo)) {
                            Vars.ui.announce("[accent]" + Vars.state.rules.sector.name() + "\n" + (Vars.state.rules.sector.info.resources.any() ? "[lightgray]" + Core.bundle.get("sectors.resources") + "[white] " + Vars.state.rules.sector.info.resources.toString(" ", UnlockableContent::emoji) : ""), 5.0f);
                        }
                    });
                }
            }
        }

        public void drawLaunchGlobalZ() {
            float f;
            float fin = Vars.renderer.getLandTimeIn();
            float fout = 1.0f - fin;
            this.drawLanding(this.x, this.y);
            Draw.color();
            Draw.mixcol((Color)Color.white, (float)Interp.pow5In.apply(fout));
            if (Vars.renderer.isLaunching() && (f = Mathf.clamp((float)(1.0f - fout * 12.0f))) > 0.001f) {
                Draw.mixcol((Color)Pal.accent, (float)f);
            }
        }

        public void drawLaunch() {
        }

        public void drawLanding(float x, float y) {
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            float fin2 = Interp.smooth.apply(Interp.slope.apply(Vars.renderer.getLandTimeIn()));
            float s = (float)AtlacianCore.this.region.height / 4.0f * fin;
            Draw.z((float)30.3f);
            float pulse = Mathf.sin((float)10.0f, (float)2.0f);
            Draw.color((Color)SvPal.hardWater.cpy().value(0.8f));
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse + 4.0f));
            Draw.color((Color)SvPal.hardWater.cpy().value(0.9f));
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse + 2.0f));
            Draw.color((Color)SvPal.hardWater);
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse));
            Draw.z((float)1.0f);
            Draw.color();
            Draw.alpha((float)Mathf.clamp((float)(fin / 0.4f)));
            Draw.mixcol((Color)Color.blue.cpy().mul(0.2f), (float)(1.0f - Mathf.clamp((float)(fin / 0.6f))));
            Draw.z((float)30.5f);
            if (fin > 0.2f) {
                Draw.rect((TextureRegion)AtlacianCore.this.border, (float)x, (float)y, (float)((s + 2.0f) * fin2), (float)((s + 2.0f) * fin2));
            }
            Draw.rect((TextureRegion)AtlacianCore.this.region, (float)x, (float)y, (float)s, (float)s);
            if (AtlacianCore.this.teamRegions[this.team.id] == AtlacianCore.this.teamRegion) {
                Draw.color((Color)this.team.color);
            }
            Draw.rect((TextureRegion)AtlacianCore.this.teamRegions[this.team.id], (float)x, (float)y, (float)s, (float)s);
            if (!Vars.renderer.isLaunching()) {
                Draw.draw((float)35.0f, () -> {
                    Draw.scl((float)fin);
                    Shaders.blockbuild.region = AtlacianCore.this.unitType.fullIcon;
                    Shaders.blockbuild.progress = Vars.renderer.getLandTimeIn();
                    Shaders.blockbuild.time = Time.time;
                    Draw.color((Color)Pal.accent);
                    Draw.shader((Shader)Shaders.blockbuild);
                    Draw.rect((TextureRegion)AtlacianCore.this.unitType.fullIcon, (float)x, (float)y, (float)this.rotation);
                    Draw.shader();
                    Draw.reset();
                    Draw.scl((float)1.0f);
                });
            }
        }

        public void updateLaunch() {
            Effect.shake((float)0.3f, (float)5.0f, (Position)this);
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            float in = Vars.renderer.getLandTimeIn() * this.launchDuration();
            float tsize = Mathf.sample((float[])CoreBlock.thrusterSizes, (float)((in + 35.0f) / this.launchDuration()));
            this.landParticleTimer += tsize * Time.delta;
            if (this.landParticleTimer >= 1.0f) {
                this.tile.getLinkedTiles(t -> {
                    if (Mathf.chance((double)0.4f)) {
                        float tx = t.worldx();
                        float ty = t.worldy();
                        float dtx = tx - this.x;
                        float dty = ty - this.y;
                        if (Vars.renderer.getLandTimeIn() < 0.6f && fin > 0.4f) {
                            SvFx.steam.at(this.x + dtx * fin * 1.1f, this.y + dty * fin * 1.1f);
                        }
                    }
                });
                this.landParticleTimer = 0.0f;
            }
        }

        public float zoomLaunch() {
            Core.camera.position.set((Position)this);
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            return Scl.scl((float)(4.0f + 2.0f * (1.0f - fin)));
        }

        public Music launchMusic() {
            return SvMusic.atlLand;
        }

        public Music landMusic() {
            return SvMusic.atlLand;
        }

        public void handleItem(Building source, Item item) {
            if (!AtlacianCore.this.bannedItems.contains((Object)item) && item != Items.copper) {
                super.handleItem(source, item);
            } else {
                StorageBlock.incinerateEffect((Building)this, (Building)source);
            }
        }
    }

    public class AtlacianCoreMobileBuild
    extends CoreBlock.CoreBuild {
        public AtlacianCoreMobileBuild() {
            super((CoreBlock)AtlacianCore.this);
        }

        public void handleStack(Item item, int amount, Teamc source) {
            if (!AtlacianCore.this.bannedItems.contains((Object)item) && item != Items.copper) {
                super.handleStack(item, amount, source);
            } else {
                Fx.coreBurn.at(this.x, this.y);
            }
        }

        public void draw() {
            if (Vars.renderer.getLandTime() <= 0.0f) {
                super.draw();
            }
        }

        public void update() {
            super.update();
            this.items.remove(Items.copper, 1000);
        }

        public void beginLaunch(boolean launching) {
            if (launching) {
                Fx.coreLaunchConstruct.at(this.x, this.y, (float)AtlacianCore.this.size);
            }
            SvLogic.beginLandMusic();
            if (!Vars.headless) {
                if (Vars.renderer.isLaunching()) {
                    float margin = 30.0f;
                    Image image = new Image();
                    image.color.a = 0.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.delay((float)((this.launchDuration() - margin) / 60.0f)), Actions.fadeIn((float)(margin / 60.0f), (Interp)Interp.pow2In), Actions.delay((float)0.1f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                } else {
                    Image image = new Image();
                    image.color.a = 1.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.fadeOut((float)0.5833333f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                    Time.run((float)this.launchDuration(), () -> {
                        AtlacianCore.this.launchEffect.at((Position)this);
                        Effect.shake((float)5.0f, (float)5.0f, (Position)this);
                        if (Vars.state.isCampaign() && Vars.showSectorLandInfo && (Vars.state.rules.sector.preset == null || Vars.state.rules.sector.preset.showSectorLandInfo)) {
                            Vars.ui.announce("[accent]" + Vars.state.rules.sector.name() + "\n" + (Vars.state.rules.sector.info.resources.any() ? "[lightgray]" + Core.bundle.get("sectors.resources") + "[white] " + Vars.state.rules.sector.info.resources.toString(" ", UnlockableContent::emoji) : ""), 5.0f);
                        }
                    });
                }
            }
        }

        public void drawLaunch() {
            float f;
            float fin = Vars.renderer.getLandTimeIn();
            float fout = 1.0f - fin;
            this.drawLanding(this.x, this.y);
            Draw.color();
            Draw.mixcol((Color)Color.white, (float)Interp.pow5In.apply(fout));
            if (Vars.renderer.isLaunching() && (f = Mathf.clamp((float)(1.0f - fout * 12.0f))) > 0.001f) {
                Draw.mixcol((Color)Pal.accent, (float)f);
            }
        }

        public void drawLanding(float x, float y) {
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            float fin2 = Interp.smooth.apply(Interp.slope.apply(Vars.renderer.getLandTimeIn()));
            float s = (float)AtlacianCore.this.region.height / 4.0f * fin;
            Draw.z((float)30.3f);
            float pulse = Mathf.sin((float)10.0f, (float)2.0f);
            Draw.color((Color)SvPal.hardWater.cpy().value(0.8f));
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse + 4.0f));
            Draw.color((Color)SvPal.hardWater.cpy().value(0.9f));
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse + 2.0f));
            Draw.color((Color)SvPal.hardWater);
            Fill.circle((float)x, (float)y, (float)(fin2 * 8.0f * (float)AtlacianCore.this.size + pulse));
            Draw.z((float)1.0f);
            Draw.color();
            Draw.alpha((float)Mathf.clamp((float)(fin / 0.4f)));
            Draw.mixcol((Color)Color.blue.cpy().mul(0.2f), (float)(1.0f - Mathf.clamp((float)(fin / 0.6f))));
            Draw.z((float)30.5f);
            if (fin > 0.2f) {
                Draw.rect((TextureRegion)AtlacianCore.this.border, (float)x, (float)y, (float)((s + 2.0f) * fin2), (float)((s + 2.0f) * fin2));
            }
            Draw.rect((TextureRegion)AtlacianCore.this.region, (float)x, (float)y, (float)s, (float)s);
            if (AtlacianCore.this.teamRegions[this.team.id] == AtlacianCore.this.teamRegion) {
                Draw.color((Color)this.team.color);
            }
            Draw.rect((TextureRegion)AtlacianCore.this.teamRegions[this.team.id], (float)x, (float)y, (float)s, (float)s);
            if (!Vars.renderer.isLaunching()) {
                Draw.draw((float)35.0f, () -> {
                    Draw.scl((float)fin);
                    Shaders.blockbuild.region = AtlacianCore.this.unitType.fullIcon;
                    Shaders.blockbuild.progress = Vars.renderer.getLandTimeIn();
                    Shaders.blockbuild.time = Time.time;
                    Draw.color((Color)Pal.accent);
                    Draw.shader((Shader)Shaders.blockbuild);
                    Draw.rect((TextureRegion)AtlacianCore.this.unitType.fullIcon, (float)x, (float)y, (float)this.rotation);
                    Draw.shader();
                    Draw.reset();
                    Draw.scl((float)1.0f);
                });
            }
        }

        public void updateLaunch() {
            Effect.shake((float)0.3f, (float)5.0f, (Position)this);
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            float in = Vars.renderer.getLandTimeIn() * this.launchDuration();
            float tsize = Mathf.sample((float[])CoreBlock.thrusterSizes, (float)((in + 35.0f) / this.launchDuration()));
            this.landParticleTimer += tsize * Time.delta;
            if (this.landParticleTimer >= 1.0f) {
                this.tile.getLinkedTiles(t -> {
                    if (Mathf.chance((double)0.4f)) {
                        float tx = t.worldx();
                        float ty = t.worldy();
                        float dtx = tx - this.x;
                        float dty = ty - this.y;
                        if (Vars.renderer.getLandTimeIn() < 0.6f && fin > 0.4f) {
                            SvFx.steam.at(this.x + dtx * fin * 1.1f, this.y + dty * fin * 1.1f);
                        }
                    }
                });
                this.landParticleTimer = 0.0f;
            }
        }

        public float zoomLaunch() {
            Core.camera.position.set((Position)this);
            float fin = Interp.pow3.apply(Vars.renderer.getLandTimeIn() + 0.2f);
            return Scl.scl((float)(4.0f + 2.0f * (1.0f - fin)));
        }

        public Music launchMusic() {
            return SvMusic.atlLand;
        }

        public Music landMusic() {
            return SvMusic.atlLand;
        }

        public void handleItem(Building source, Item item) {
            if (!AtlacianCore.this.bannedItems.contains((Object)item) && item != Items.copper) {
                super.handleItem(source, item);
            } else {
                StorageBlock.incinerateEffect((Building)this, (Building)source);
            }
        }
    }
}

