/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.storage.core;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Point2;
import arc.scene.Element;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.util.Structs;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import subvoyage.content.SvUnits;
import subvoyage.core.draw.SvFx;

public class OffloadCore
extends CoreBlock {
    public int minShieldLayers = 3;
    public int maxShieldLayers = 5;
    public TextureRegion dangerIconRegion;
    public UnitType[] lowTierUnits = new UnitType[0];
    public UnitType[] midTierUnits = new UnitType[0];
    public UnitType[] highTierUnits = new UnitType[0];

    public OffloadCore(String name) {
        super(name);
        this.configurable = true;
        this.sync = true;
    }

    public void load() {
        super.load();
        this.dangerIconRegion = Core.atlas.find(this.name + "-danger", "danger-icon");
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return false;
    }

    public boolean canReplace(Block other) {
        return false;
    }

    public class OffloadCoreBuilding
    extends CoreBlock.CoreBuild {
        int shieldLayers;
        float smoothShieldLayers;
        float waveTimer;
        boolean isFirstWave;
        boolean isUpgradeWave;
        int unitTier;
        float smoothTier;
        float shieldCooldown;
        int minutes;
        int seconds;
        Rand rand;
        UnitType nextUnit;

        public OffloadCoreBuilding() {
            super((CoreBlock)OffloadCore.this);
            this.shieldLayers = 0;
            this.smoothShieldLayers = 0.0f;
            this.waveTimer = 0.0f;
            this.isFirstWave = true;
            this.isUpgradeWave = false;
            this.unitTier = 0;
            this.smoothTier = 0.0f;
            this.shieldCooldown = 0.0f;
            this.rand = null;
            this.nextUnit = null;
        }

        public void created() {
            super.created();
            this.waveTimer = this.getWaveTime();
            this.recalculateStats();
        }

        public void spawnWave() {
            this.waveTimer = this.getWaveTime();
            if (this.nextUnit != null) {
                Unit unit = this.nextUnit.spawn(this.team, this.x, this.y);
                unit.rotation(-90.0f);
                unit.shield(40.0f * (float)this.unitTier);
                this.nextUnit = null;
            }
            this.isFirstWave = false;
            this.isUpgradeWave = false;
        }

        public boolean tryBreakLayer() {
            if (this.shieldLayers <= 0) {
                return false;
            }
            if (this.shieldCooldown > 0.0f) {
                return false;
            }
            this.damage(Vars.player.team(), 80.0f);
            Fx.pointHit.create(this.x, this.y, 0.0f, Pal.darkPyraFlame, new Object());
            this.breakLayer();
            return true;
        }

        void breakLayer() {
            UnitType unitType;
            --this.shieldLayers;
            this.upgrade();
            switch (this.unitTier) {
                case 0: {
                    unitType = (UnitType)Structs.random((Rand)this.rand, (Object[])new UnitType[]{SvUnits.lapetus, SvUnits.leeft});
                    break;
                }
                case 1: 
                case 2: {
                    unitType = (UnitType)Structs.random((Rand)this.rand, (Object[])new UnitType[]{SvUnits.skath, SvUnits.flagshi});
                    break;
                }
                case 3: {
                    unitType = (UnitType)Structs.random((Rand)this.rand, (Object[])new UnitType[]{SvUnits.charon, SvUnits.vanguard});
                    break;
                }
                default: {
                    unitType = (UnitType)Structs.random((Rand)this.rand, (Object[])new UnitType[]{SvUnits.charon, SvUnits.vanguard, SvUnits.callees, SvUnits.squadron});
                }
            }
            this.nextUnit = unitType;
            this.waveTimer = (float)this.unitTier * 10.0f * 60.0f;
            this.isUpgradeWave = true;
            SvFx.resonanceExplosion.create(this.x, this.y, 0.0f, Pal.accent, new Object());
            Fx.blastExplosion.create(this.x, this.y, 0.0f, Pal.accent, new Object());
            this.shieldCooldown = 60.0f;
        }

        private void upgrade() {
            ++this.unitTier;
        }

        public void updateTile() {
            super.updateTile();
            if (this.rand == null) {
                this.rand = new Rand((long)Point2.pack((int)this.tileX(), (int)this.tileY()) * 100L + (long)(Vars.state.rules.sector == null ? 1 : Vars.state.rules.sector.id));
            }
            if (this.nextUnit == null) {
                this.selectNextUnit();
            }
            if (this.waveTimer > 0.0f && this.nextUnit != null) {
                this.waveTimer -= Time.delta;
                this.minutes = (int)(this.waveTimer / 60.0f / 60.0f);
                this.seconds = (int)(this.waveTimer / 60.0f) % 60;
            } else if (this.nextUnit != null) {
                this.spawnWave();
            }
            if (this.isUpgradeWave && Time.time % 10.0f <= Time.delta) {
                Fx.shockwave.create(this.x, this.y, 0.0f, Pal.accent, new Object());
            }
            this.shieldCooldown -= Time.delta;
        }

        private void selectNextUnit() {
            Object[] selectFrom = new UnitType[]{};
            if (this.unitTier >= 0 && this.unitTier < 4) {
                for (UnitType u : OffloadCore.this.lowTierUnits) {
                    selectFrom = (UnitType[])Structs.add((Object[])selectFrom, (Object)u);
                }
            }
            if (this.unitTier >= 3 && this.unitTier < 9) {
                for (UnitType u : OffloadCore.this.midTierUnits) {
                    selectFrom = (UnitType[])Structs.add((Object[])selectFrom, (Object)u);
                }
            }
            if (this.unitTier >= 8) {
                for (UnitType u : OffloadCore.this.highTierUnits) {
                    selectFrom = (UnitType[])Structs.add((Object[])selectFrom, (Object)u);
                }
            }
            if (selectFrom.length > 0) {
                this.nextUnit = (UnitType)Structs.random((Rand)this.rand, (Object[])selectFrom);
            }
        }

        public void draw() {
            this.smoothTier = Mathf.lerp((float)this.smoothTier, (float)this.unitTier, (float)(Time.delta / 90.0f));
            super.draw();
            this.drawShieldLayers();
            if (this.nextUnit != null) {
                this.drawConstructingUnit();
                this.drawWaveCountdown();
            }
        }

        private void drawConstructingUnit() {
            float progress = 1.0f - this.waveTimer / this.getWaveTime();
            Draw.draw((float)35.0f, () -> Drawf.construct((Building)this, (UnlockableContent)this.nextUnit, (float)-90.0f, (float)progress, (float)1.0f, (float)Time.time));
        }

        public float getWaveTime() {
            return this.isFirstWave ? (Vars.state.rules.initialWaveSpacing <= 0.0f ? Vars.state.rules.waveSpacing * 2.0f : Vars.state.rules.initialWaveSpacing) : Vars.state.rules.waveSpacing;
        }

        private void drawWaveCountdown() {
            Draw.z((float)35.0f);
            String m = this.minutes + "";
            String se = this.seconds < 10 ? "0" + this.seconds : this.seconds + "";
            float width = OffloadCore.this.drawPlaceText(String.format("%s:%s", m, se), this.tileX(), this.tileY(), false);
            float dx = this.x + OffloadCore.this.offset - width / 2.0f - 4.0f;
            float dy = this.y + OffloadCore.this.offset + (float)(OffloadCore.this.size * 8) / 2.0f + 5.0f;
            float s = 6.0f;
            if (OffloadCore.this.dangerIconRegion.found()) {
                Draw.mixcol((Color)Color.darkGray, (float)1.0f);
                Draw.rect((TextureRegion)OffloadCore.this.dangerIconRegion, (float)dx, (float)(dy - 1.0f), (float)s, (float)s);
                Draw.reset();
                Draw.rect((TextureRegion)OffloadCore.this.dangerIconRegion, (float)dx, (float)dy, (float)s, (float)s);
                Draw.reset();
            }
        }

        private void drawShieldLayers() {
            this.smoothShieldLayers = Mathf.lerp((float)this.smoothShieldLayers, (float)this.shieldLayers, (float)(Time.delta / 10.0f));
            Draw.z((float)125.0f);
            Draw.color((Color)this.team.color);
            if (!Vars.renderer.animateShields) {
                Draw.alpha((float)0.5f);
            }
            int sides = 6;
            for (int i = 0; i < this.shieldLayers; ++i) {
                Lines.stroke((float)6.0f);
                Lines.poly((float)this.x, (float)this.y, (int)6, (float)((float)i / (float)this.shieldLayers * this.smoothShieldLayers * 8.0f + (float)(OffloadCore.this.size * 8)));
            }
            Draw.reset();
        }

        public void buildConfiguration(Table table) {
            this.buildShieldSelection(this, table, OffloadCore.this.minShieldLayers, OffloadCore.this.maxShieldLayers);
        }

        public void buildShieldSelection(OffloadCoreBuilding build, Table table, int minLayers, int maxLayers) {
            Table main = new Table().background(Styles.black6);
            Table cont = new Table().top();
            cont.defaults().size(60.0f).width(200.0f);
            Runnable rebuild = () -> {
                cont.clearChildren();
                cont.label(() -> minLayers + " \u2264 [" + build.shieldLayers + "] \u2264 " + maxLayers);
                cont.row();
                TextButton button = (TextButton)cont.button("-", () -> {}).get();
                button.changed(() -> {
                    if (!button.isChecked()) {
                        return;
                    }
                    --build.shieldLayers;
                    button.setChecked(false);
                });
                TextButton button2 = (TextButton)cont.button("+", () -> {}).get();
                button2.changed(() -> {
                    if (!button2.isChecked()) {
                        return;
                    }
                    ++build.shieldLayers;
                    button2.setChecked(false);
                });
                cont.row();
                TextButton trybreak = (TextButton)cont.button("break layer (try)", () -> {}).get();
                trybreak.changed(() -> {
                    if (!trybreak.isChecked()) {
                        return;
                    }
                    build.tryBreakLayer();
                    trybreak.setChecked(false);
                });
                cont.row();
                TextButton trybreak2 = (TextButton)cont.button("break layer (straight)", () -> {}).get();
                trybreak2.changed(() -> {
                    if (!trybreak2.isChecked()) {
                        return;
                    }
                    build.breakLayer();
                    trybreak2.setChecked(false);
                });
            };
            rebuild.run();
            main.add((Element)cont);
            table.add((Element)main);
        }

        public void damage(Team source, float damage) {
            if (this.shieldLayers >= OffloadCore.this.minShieldLayers) {
                return;
            }
            if (source == null || source == this.team) {
                return;
            }
            super.damage(source, this.calculateDamage(damage));
        }

        public float calculateDamage(float damage) {
            float delta = (float)this.shieldLayers / (float)OffloadCore.this.minShieldLayers;
            return damage * (1.0f - delta) / 2.0f;
        }

        public void recalculateStats() {
            this.shieldLayers = Mathf.clamp((int)this.shieldLayers, (int)OffloadCore.this.minShieldLayers, (int)OffloadCore.this.maxShieldLayers);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.shieldLayers);
            write.bool(this.isFirstWave);
            write.f(this.waveTimer);
            write.i(this.unitTier);
            if (this.nextUnit != null) {
                write.str(this.nextUnit.name);
            } else {
                write.str("nilunit");
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision != this.version()) {
                return;
            }
            this.shieldLayers = read.i();
            this.isFirstWave = read.bool();
            this.waveTimer = Math.min(read.f(), this.getWaveTime());
            this.unitTier = read.i();
            String u = read.str();
            if (!u.equals("nilunit")) {
                this.nextUnit = Vars.content.unit(u);
            }
        }

        public byte version() {
            return 2;
        }
    }
}

