/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.turret.resist;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import subvoyage.type.block.turret.resist.ResistTurret;

public class DrawResist
extends DrawBlock {
    protected static final Rand rand = new Rand();
    public Seq<DrawPart> parts = new Seq();
    public String basePrefix = "";
    @Nullable
    public Liquid liquidDraw;
    public TextureRegion base;
    public TextureRegion liquid;
    public TextureRegion top;
    public TextureRegion heat;
    public TextureRegion preview;
    public TextureRegion outline;

    public DrawResist(String basePrefix) {
        this.basePrefix = basePrefix;
    }

    public DrawResist() {
    }

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        for (DrawPart part : this.parts) {
            part.getOutlines(out);
        }
        if (block.region.found() && (block.outlinedIcon <= 0 || block.outlinedIcon >= block.getGeneratedIcons().length || !block.getGeneratedIcons()[block.outlinedIcon].equals(block.region))) {
            out.add((Object)block.region);
        }
        block.resetGeneratedIcons();
    }

    public void draw(Building build) {
        ResistTurret turret = (ResistTurret)build.block;
        ResistTurret.PowerRingTurretBuild tb = (ResistTurret.PowerRingTurretBuild)build;
        Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
        Draw.color();
        Draw.z((float)49.5f);
        Drawf.shadow((TextureRegion)this.preview, (float)(build.x + tb.recoilOffset.x - turret.elevation), (float)(build.y + tb.recoilOffset.y - turret.elevation), (float)tb.drawrot());
        Draw.z((float)50.0f);
        this.drawTurret(turret, tb);
        this.drawHeat(turret, tb);
        if (this.parts.size > 0) {
            if (this.outline.found()) {
                Draw.z((float)49.99f);
                Draw.rect((TextureRegion)this.outline, (float)(build.x + tb.recoilOffset.x), (float)(build.y + tb.recoilOffset.y), (float)tb.drawrot());
                Draw.z((float)50.0f);
            }
            float progress = tb.progress();
            DrawPart.PartParams params = DrawPart.params.set(build.warmup(), 1.0f - progress, 1.0f - progress, tb.heat, tb.curRecoil, 0.0f, tb.x + tb.recoilOffset.x, tb.y + tb.recoilOffset.y, tb.rotation);
            for (DrawPart part : this.parts) {
                params.setRecoil(tb.curRecoil);
                part.draw(params);
            }
        }
    }

    public void drawTurret(ResistTurret block, ResistTurret.PowerRingTurretBuild build) {
        if (block.region.found()) {
            Draw.rect((TextureRegion)block.region, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
        if (this.liquid.found()) {
            Liquid toDraw = this.liquidDraw == null ? build.liquids.current() : this.liquidDraw;
            Drawf.liquid((TextureRegion)this.liquid, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)(build.liquids.get(toDraw) / block.liquidCapacity), (Color)toDraw.color.write(Tmp.c1).a(1.0f), (float)build.drawrot());
        }
        if (this.top.found()) {
            Draw.rect((TextureRegion)this.top, (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot());
        }
    }

    public void drawHeat(ResistTurret block, ResistTurret.PowerRingTurretBuild build) {
        if (!(build.heat <= 1.0E-5f) && this.heat.found()) {
            Drawf.additive((TextureRegion)this.heat, (Color)block.heatColor.write(Tmp.c1).a(build.heat), (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)build.drawrot(), (float)50.1f);
        }
    }

    public void load(Block block) {
        if (!(block instanceof ResistTurret)) {
            throw new ClassCastException("This drawer can only be used on power ring turrets.");
        }
        this.preview = Core.atlas.find(block.name + "-preview", block.region);
        this.outline = Core.atlas.find(block.name + "-outline");
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
        this.heat = Core.atlas.find(block.name + "-heat");
        this.base = Core.atlas.find(block.name + "-base");
        for (DrawPart part : this.parts) {
            part.turretShading = true;
            part.load(block.name);
        }
        if (!this.base.found() && block.minfo.mod != null) {
            this.base = Core.atlas.find(block.minfo.mod.name + "-" + this.basePrefix + "block-" + block.size);
        }
        if (!this.base.found()) {
            this.base = Core.atlas.find(this.basePrefix + "block-" + block.size);
        }
    }

    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (this.top.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[3];
            textureRegionArray2[0] = this.base;
            textureRegionArray2[1] = this.preview;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[2] = this.top;
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[2];
            textureRegionArray3[0] = this.base;
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[1] = this.preview;
        }
        return textureRegionArray;
    }
}

