/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.turret.resist;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import java.util.ArrayList;
import java.util.List;
import mindustry.Vars;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import subvoyage.content.other.SvStat;
import subvoyage.type.block.laser.LaserBlock;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserUtil;
import subvoyage.type.block.turret.resist.ResistRing;

public class ResistTurret
extends BaseTurret
implements LaserBlock {
    public final int timerTarget;
    public float targetInterval;
    public int spacing;
    public int minRingCount;
    public int boostRingCount;
    public float ringChargeTime;
    public float ringMovementSpeed;
    public float ringRadius;
    public float ringAccuracy;
    public TextureRegion ringRegion;
    public TextureRegion ringSparkRegion;
    public BulletType bulletType;
    public DrawBlock drawer;
    public float recoilTime;
    public float cooldownTime;
    public float recoilPow;
    public float recoil;
    public Color heatColor;
    public float elevation;
    public IntSeq inputs;
    public IntSeq outputs;
    public short inputRange;
    public short outputRange;
    public byte maxSuppliers;
    public float capacity;
    public float laserRequirement;
    public float laserMaxEfficiency;
    public float laserOverpowerScale;
    public float laserOutput;
    public boolean drawInputs;
    public boolean drawOutputs;

    public ResistTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.targetInterval = 20.0f;
        this.spacing = 6;
        this.minRingCount = 1;
        this.boostRingCount = 2;
        this.ringChargeTime = 180.0f;
        this.ringMovementSpeed = 0.5f;
        this.ringRadius = 24.0f;
        this.ringAccuracy = 0.8f;
        this.inputs = IntSeq.with((int[])new int[]{0, 1, 2, 3});
        this.outputs = IntSeq.with((int[])new int[0]);
        this.inputRange = (short)8;
        this.outputRange = 0;
        this.maxSuppliers = 1;
        this.capacity = 60.0f;
        this.laserRequirement = 0.0f;
        this.laserMaxEfficiency = 1.0f;
        this.laserOverpowerScale = 1.0f;
        this.laserOutput = 0.0f;
        this.drawInputs = false;
        this.drawOutputs = true;
        this.elevation = -1.0f;
        this.heatColor = Color.red;
        this.recoilTime = 30.0f;
        this.cooldownTime = 20.0f;
        this.recoil = 5.0f;
        this.recoilPow = 1.0f;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        ResistTurret.select((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, 8 * (this.size + this.spacing), this.size, Pal.placing);
        if (valid) {
            this.drawLinks((Block)this, x, y, rotation, this.drawInputs, this.drawOutputs);
        }
    }

    @Override
    public short inputRange() {
        return this.inputRange;
    }

    @Override
    public short outputRange() {
        return this.outputRange;
    }

    @Override
    public byte maxSuppliers() {
        return this.maxSuppliers;
    }

    @Override
    public IntSeq inputs() {
        return this.inputs;
    }

    @Override
    public IntSeq outputs() {
        return this.outputs;
    }

    public void load() {
        super.load();
        this.ringRegion = Core.atlas.find(this.name + "ring", "subvoyage-tesla-ring");
        this.ringSparkRegion = Core.atlas.find(this.name + "ring-spark", "subvoyage-tesla-ring-star");
        this.drawer.load((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)OrderedMap.of((Object[])new Object[]{this, this.bulletType})));
        if (this.laserOutput != 0.0f) {
            this.stats.add(SvStat.laserOutput, this.laserOutput, SvStat.laserPower);
        }
        if (this.laserRequirement > 0.0f) {
            this.stats.add(SvStat.laserUse, this.laserRequirement, SvStat.laserPower);
        }
        if (this.laserMaxEfficiency > 0.0f) {
            this.stats.add(Stat.maxEfficiency, this.laserMaxEfficiency * 100.0f, StatUnit.percent);
        }
        this.stats.add(SvStat.laserCapacity, this.capacity, SvStat.laserPower);
    }

    public void setBars() {
        super.setBars();
        this.addBar("laser", entity -> {
            if (entity instanceof PowerRingTurretBuild) {
                PowerRingTurretBuild lb = (PowerRingTurretBuild)entity;
                return new Bar(() -> Core.bundle.format("bar.laserpercent", new Object[]{(int)(lb.rawLaser() + 0.01f), (int)(lb.laserEfficiency() * 100.0f + 0.01f)}), () -> LaserUtil.getLaserColor(lb.rawLaser()), () -> lb.laser() / lb.laserRequirement());
            }
            return new Bar();
        });
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    public void init() {
        super.init();
        this.clipSize = (float)(this.size * 2) + this.range * 4.0f;
    }

    public static void select(float x, float y, float radius, float size, Color color) {
        Lines.stroke((float)size, (Color)color);
        Lines.square((float)x, (float)y, (float)(radius - 14.0f));
        Draw.reset();
    }

    public boolean intersectsSpacing(int sx, int sy, int ox, int oy, int ext) {
        if (this.spacing < 1) {
            return true;
        }
        int sizeOffset = 1 - (this.size & 1);
        int spacingOffset = this.spacing + ext;
        return ox >= sx + sizeOffset - spacingOffset && ox <= sx + spacingOffset && oy >= sy + sizeOffset - spacingOffset && oy <= sy + spacingOffset;
    }

    public boolean intersectsSpacing(Tile self, Tile other) {
        return this.intersectsSpacing(self.x, self.y, other.x, other.y, 0);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        int off = 1 - this.size % 2;
        for (int x = tile.x - this.spacing + off; x <= tile.x + this.spacing; ++x) {
            for (int y = tile.y - this.spacing + off; y <= tile.y + this.spacing; ++y) {
                ResistTurret turbine;
                Block block;
                Tile other = Vars.world.tile(x, y);
                if (other != null && other.build != null && other.build.team != team || other == null || !((block = other.block()) instanceof ResistTurret) || (turbine = (ResistTurret)block) != this && !turbine.intersectsSpacing(other.build.tile, tile)) continue;
                return false;
            }
        }
        return true;
    }

    public class PowerRingTurretBuild
    extends BaseTurret.BaseTurretBuild
    implements LaserBuild {
        public Vec2 recoilOffset;
        List<ResistRing> rings;
        public float curRecoil;
        public float heat;
        public float smoothWarmup;
        LaserGraph graph;
        public final Rand rand;

        public PowerRingTurretBuild() {
            super((BaseTurret)ResistTurret.this);
            this.recoilOffset = new Vec2();
            this.rings = new ArrayList<ResistRing>();
            this.smoothWarmup = 0.0f;
            this.rand = new Rand();
        }

        public void updateEfficiencyMultiplier() {
            this.efficiency *= this.laserEfficiency();
        }

        public float laserEfficiency() {
            if (this.laserRequirement() > 0.0f) {
                float over = Math.max(this.laser() - this.laserRequirement(), 0.0f);
                return Math.min(Mathf.clamp((float)(this.laser() / this.laserRequirement())) + over / this.laserRequirement() * ResistTurret.this.laserOverpowerScale, ResistTurret.this.laserMaxEfficiency);
            }
            return 1.0f;
        }

        public void onRemoved() {
            this.clearLaser((Building)this);
        }

        public void onDestroyed() {
            this.clearLaser((Building)this);
        }

        public void created() {
            this.graph = new LaserGraph();
        }

        @Override
        public float laser() {
            return this.graph().broken() ? 0.0f : this.inputLaser((Building)this) + ResistTurret.this.laserOutput * this.efficiency;
        }

        @Override
        public float rawLaser() {
            return this.inputLaser((Building)this) + ResistTurret.this.laserOutput * this.efficiency;
        }

        @Override
        public float laserRequirement() {
            return ResistTurret.this.laserRequirement;
        }

        @Override
        public float maxPower() {
            return ResistTurret.this.capacity;
        }

        @Override
        public boolean consumer() {
            return true;
        }

        @Override
        public boolean supplier() {
            return false;
        }

        @Override
        public LaserGraph graph() {
            return this.graph;
        }

        public void updateTile() {
            super.updateTile();
            this.updateLaser((Building)this);
            this.wasVisible = true;
            int estDefRingCount = (int)Mathf.lerp((float)0.0f, (float)ResistTurret.this.minRingCount, (float)Mathf.clamp((float)this.efficiency));
            int estimatedRingCount = (int)Mathf.lerp((float)estDefRingCount, (float)(estDefRingCount + ResistTurret.this.boostRingCount), (float)(this.boost() * this.efficiency));
            this.smoothWarmup = Mathf.lerp((float)this.smoothWarmup, (float)((float)estimatedRingCount / (float)(ResistTurret.this.minRingCount + ResistTurret.this.boostRingCount)), (float)(Time.delta / 40.0f));
            final float rr = ResistTurret.this.ringRadius * 1.5f;
            if (this.rings.size() > estimatedRingCount) {
                this.rings = this.rings.subList(0, estimatedRingCount);
            }
            if (this.rings.size() < estimatedRingCount) {
                this.rings.add(new ResistRing(){
                    {
                        this.x = PowerRingTurretBuild.this.x + (PowerRingTurretBuild.this.rand.nextFloat() * rr * 2.0f - rr);
                        this.y = PowerRingTurretBuild.this.y + (PowerRingTurretBuild.this.rand.nextFloat() * rr * 2.0f - rr);
                    }
                });
            }
            float ringAccuracy = ((ResistTurret)this.block).ringAccuracy * (1.0f + this.boost());
            this.curRecoil = Mathf.approachDelta((float)this.curRecoil, (float)0.0f, (float)(1.0f / ResistTurret.this.recoilTime));
            this.heat = Mathf.approachDelta((float)this.heat, (float)0.0f, (float)(1.0f / ResistTurret.this.cooldownTime));
            float targetRingX = 0.0f;
            float targetRingY = 0.0f;
            boolean targetRingHas = false;
            for (ResistRing ring : this.rings) {
                if (!Mathf.within((float)ring.x, (float)ring.y, (float)this.x, (float)this.y, (float)(ResistTurret.this.range + rr))) {
                    ring.x = this.x;
                    ring.y = this.y;
                    ring.targetX = 0.0f;
                    ring.targetY = 0.0f;
                    ring.hasTarget = false;
                    continue;
                }
                for (ResistRing otherRing : this.rings) {
                    float angle;
                    if (otherRing == ring || !Mathf.within((float)ring.x, (float)ring.y, (float)otherRing.x, (float)otherRing.y, (float)(ResistTurret.this.ringRadius * 1.25f))) continue;
                    otherRing.angle = angle = Angles.angle((float)ring.x, (float)ring.y, (float)otherRing.x, (float)otherRing.y);
                    break;
                }
                if (!ring.hasTarget) continue;
                targetRingX += ring.x;
                targetRingY += ring.y;
                targetRingHas = true;
                if (!Mathf.within((float)ring.targetX, (float)ring.targetY, (float)this.x, (float)this.y, (float)(ResistTurret.this.range * 2.0f))) {
                    ring.hasTarget = false;
                    continue;
                }
                ring.lifetime += Time.delta;
                Tmp.v1.setZero();
                Tmp.v1.trns(ring.angle, ResistTurret.this.ringMovementSpeed * this.laserEfficiency() * this.delta());
                ring.x += Tmp.v1.x;
                ring.y += Tmp.v1.y;
                if (Mathf.within((float)ring.x, (float)ring.y, (float)ring.targetX, (float)ring.targetY, (float)rr)) {
                    ring.charge += this.delta() / ResistTurret.this.ringChargeTime;
                } else {
                    float targetAngle = Mathf.round((float)Mathf.angleExact((float)(ring.targetX - ring.x), (float)(ring.targetY - ring.y)));
                    ring.angle = Angles.moveToward((float)ring.angle, (float)targetAngle, (float)(ResistTurret.this.rotateSpeed * ringAccuracy * this.delta() * this.potentialEfficiency));
                    ring.charge -= this.delta() / ResistTurret.this.ringChargeTime / 2.0f;
                }
                ring.charge = Mathf.clamp((float)ring.charge);
                if (!(ring.charge >= 1.0f)) continue;
                ring.charge %= 1.0f;
                this.consume();
                ring.shoot(this);
                this.curRecoil = 2.0f;
                this.heat = 1.0f;
            }
            Consume consume = ResistTurret.this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster);
            if (consume instanceof ConsumeLiquidBase) {
                ConsumeLiquidBase consBase = (ConsumeLiquidBase)consume;
                consBase.update((Building)this);
            }
            this.recoilOffset.trns(this.rotation, -Mathf.pow((float)this.curRecoil, (float)ResistTurret.this.recoilPow) * ResistTurret.this.recoil);
            if (this.timer(ResistTurret.this.timerTarget, ResistTurret.this.targetInterval)) {
                this.findTargets();
            }
            if (targetRingHas) {
                float targetAngle = Angles.angle((float)this.x, (float)this.y, (float)(targetRingX /= (float)this.rings.size()), (float)(targetRingY /= (float)this.rings.size()));
                this.rotation = Angles.moveToward((float)this.rotation, (float)targetAngle, (float)(10.0f / Time.delta));
            }
        }

        public void findTargets() {
            float range = this.range();
            Seq existingTargets = Seq.with((Object[])new Posc[0]);
            for (ResistRing ring : this.rings) {
                Teamc target = Units.bestTarget((Team)this.team, (float)this.x, (float)this.y, (float)range, e -> !e.dead() && !existingTargets.contains(e) && Mathf.within((float)e.x, (float)e.y, (float)this.x, (float)this.y, (float)(range * 2.0f)), b -> !existingTargets.contains(b) && Mathf.within((float)b.x, (float)b.y, (float)this.x, (float)this.y, (float)(range * 2.0f)), (Units.Sortf)UnitSorts.closest);
                if (target == null) {
                    target = Units.bestTarget((Team)this.team, (float)this.x, (float)this.y, (float)range, e -> !e.dead() && Mathf.within((float)e.x, (float)e.y, (float)this.x, (float)this.y, (float)(range * 2.0f)), b -> Mathf.within((float)b.x, (float)b.y, (float)this.x, (float)this.y, (float)(range * 2.0f)), (Units.Sortf)UnitSorts.closest);
                }
                if (target == null) continue;
                existingTargets.add((Object)target);
                ring.targetX = target.x();
                ring.targetY = target.y();
                ring.hasTarget = true;
            }
            existingTargets.clear();
        }

        public void draw() {
            this.drawStatus((Building)this);
            ResistTurret.this.drawer.draw((Building)this);
            Draw.z((float)110.0f);
            for (ResistRing ring : this.rings) {
                float pulse = Mathf.sin((float)1.0f, (float)1.0f) * 0.05f;
                Lines.stroke((float)(5.0f + ring.charge * 3.0f), (Color)Color.white);
                float v = Mathf.clamp((float)(ring.lifetime / 10.0f));
                Draw.alpha((float)((0.75f + ring.charge * 0.25f) * v));
                Draw.scl((float)(((Mathf.sinDeg((float)(Time.time * 6.0f)) + 1.0f) / 8.0f + 0.88f - ring.charge * 0.3f + pulse) * v));
                Draw.rect((TextureRegion)ResistTurret.this.ringSparkRegion, (float)ring.x, (float)ring.y, (float)(Vars.state.isPaused() ? 0.0f : this.rand.nextFloat() * 360.0f));
                Draw.scl((float)((1.0f - ring.charge * 0.5f + pulse) * v));
                Draw.rect((TextureRegion)ResistTurret.this.ringRegion, (float)ring.x, (float)ring.y, (float)(Vars.state.isPaused() ? 0.0f : this.rand.nextFloat() * 360.0f));
            }
            Draw.reset();
        }

        public float warmup() {
            int estDefRingCount = (int)Mathf.lerp((float)0.0f, (float)ResistTurret.this.minRingCount, (float)this.efficiency);
            int estimatedRingCount = (int)Mathf.lerp((float)estDefRingCount, (float)(estDefRingCount + ResistTurret.this.boostRingCount), (float)(this.boost() * this.efficiency));
            return this.smoothWarmup;
        }

        public float boost() {
            Consume consume = ResistTurret.this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster);
            if (consume instanceof ConsumeLiquidBase) {
                ConsumeLiquidBase consBase = (ConsumeLiquidBase)consume;
                return Mathf.clamp((float)consBase.efficiency((Building)this));
            }
            return 1.0f;
        }

        public BulletType getBullet() {
            return ResistTurret.this.bulletType;
        }
    }
}

