/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.part.DrawPart;
import mindustry.gen.Bullet;
import mindustry.graphics.Trail;
import subvoyage.core.draw.SvDraw;

public class BallisticBulletType
extends BasicBulletType {
    public BallisticBulletType(float speed, float damage) {
        super(speed, damage);
    }

    public void updateTrail(Bullet b) {
        float camHeight = new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
        float camSize = 1.0f + new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
        float x = SvDraw._3D.xHeight(b.x, camHeight);
        float y = SvDraw._3D.yHeight(b.y, camHeight);
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            b.trail.update(x, y, this.trailInterp.apply(b.fin()) * camSize * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
        }
    }

    public void drawParts(Bullet b) {
        if (this.parts.size > 0) {
            float camHeight = new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
            float camSize = 1.0f + new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
            float x = SvDraw._3D.xHeight(b.x, camHeight);
            float y = SvDraw._3D.yHeight(b.y, camHeight);
            DrawPart.params.set(b.fin(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, x, y, b.rotation());
            DrawPart.params.life = b.fin();
            for (int i = 0; i < this.parts.size; ++i) {
                ((DrawPart)this.parts.get(i)).draw(DrawPart.params);
            }
        }
    }

    public void draw(Bullet b) {
        float camHeight = new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
        float camSize = 1.0f + new Interp.PowOut(2).apply(Interp.slope.apply(b.fin())) * (1.0f / b.type.speed * (b.lifetime / 60.0f));
        float x = SvDraw._3D.xHeight(b.x, camHeight);
        float y = SvDraw._3D.yHeight(b.y, camHeight);
        this.drawTrail(b);
        this.drawParts(b);
        float shrink = this.shrinkInterp.apply(b.fout());
        float height = this.height * (1.0f - this.shrinkY + this.shrinkY * shrink) * camSize;
        float width = this.width * (1.0f - this.shrinkX + this.shrinkX * shrink) * camSize;
        float offset = -90.0f + (this.spin != 0.0f ? Mathf.randomSeed((long)b.id, (float)360.0f) + b.time * this.spin : 0.0f) + this.rotationOffset;
        Color mix = Tmp.c1.set(this.mixColorFrom).lerp(this.mixColorTo, b.fin());
        Draw.mixcol((Color)mix, (float)mix.a);
        if (this.backRegion.found()) {
            Draw.color((Color)this.backColor);
            Draw.rect((TextureRegion)this.backRegion, (float)x, (float)y, (float)width, (float)height, (float)(b.rotation() + offset));
        }
        Draw.color((Color)this.frontColor);
        Draw.rect((TextureRegion)this.frontRegion, (float)x, (float)y, (float)width, (float)height, (float)(b.rotation() + offset));
        Draw.reset();
    }
}

