/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ability;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.Time;
import arc.util.Tmp;
import java.util.ArrayList;
import java.util.Arrays;
import mindustry.content.StatusEffects;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import subvoyage.content.other.SvEffects;

public class LegionfieldAbility
extends Ability {
    public float radius = 2.0f;
    public static ObjectMap<Team, Float> lastRadius = new ObjectMap();
    public static ObjectMap<Team, Float> lastCount = new ObjectMap();
    public static ObjectMap<Team, Vec2> point = new ObjectMap();
    public static ObjectMap<Team, Float> pointRad = new ObjectMap();

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + Stat.range.localized() + ": [white]" + Math.round(this.radius) + " " + StatUnit.blocks.localized()));
        t.row();
    }

    public void displayBars(Unit unit, Table bars) {
        bars.add((Element)new Bar(Core.bundle.get("stat.fieldpower"), Pal.accent, () -> {
            float mult = Mathf.clamp((float)(LegionfieldAbility.radius(unit.team) / this.radius), (float)0.0f, (float)3.0f);
            if (!Mathf.within((float)unit.x, (float)unit.y, (float)LegionfieldAbility.point((Team)unit.team).x, (float)LegionfieldAbility.point((Team)unit.team).y, (float)(8.0f + 8.0f * LegionfieldAbility.radius(unit.team)))) {
                mult = 0.0f;
            }
            return mult / 3.0f;
        })).row();
    }

    public static int count(Team team) {
        return (int)((Float)lastCount.get((Object)team, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static void update() {
        ArrayList<Team> teams = new ArrayList<Team>();
        for (Unit unit : Groups.unit) {
            if (teams.contains(unit.team)) continue;
            teams.add(unit.team);
        }
        for (Team team : teams) {
            float count = 0.0f;
            float rad = 0.0f;
            Vec2 point = new Vec2();
            for (Unit u : Groups.unit) {
                if (Arrays.stream(u.abilities).noneMatch(a -> a instanceof LegionfieldAbility) || u.team != team) continue;
                LegionfieldAbility abil = (LegionfieldAbility)Arrays.stream(u.abilities).filter(a -> a instanceof LegionfieldAbility).findFirst().get();
                point.add(u.x, u.y);
                rad += abil.radius / (count / 2.0f + 1.0f);
                count += 1.0f;
            }
            point.div(new Vec2(count, count));
            float lastRad = Math.abs(rad);
            Vec2 lastPoint = point.cpy();
            for (Unit u : Groups.unit) {
                if (Arrays.stream(u.abilities).noneMatch(a -> a instanceof LegionfieldAbility) || u.team != team) continue;
                LegionfieldAbility abil = (LegionfieldAbility)Arrays.stream(u.abilities).filter(a -> a instanceof LegionfieldAbility).findFirst().get();
                if (Mathf.within((float)u.x, (float)u.y, (float)lastPoint.x, (float)lastPoint.y, (float)(lastRad * 2.0f + 8.0f))) continue;
                rad -= abil.radius / (count / 2.0f + 1.0f);
                count -= 1.0f;
            }
            lastCount.put((Object)team, (Object)Float.valueOf(count));
            LegionfieldAbility.point.put((Object)team, (Object)point);
            pointRad.put((Object)team, (Object)Float.valueOf(rad));
            lastRadius.put((Object)team, (Object)Float.valueOf(Mathf.lerp((float)LegionfieldAbility.lastRadius(team), (float)rad, (float)(Time.delta / 30.0f))));
        }
    }

    public static float lastRadius(Team team) {
        return ((Float)lastRadius.get((Object)team, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static float radius(Team team) {
        return ((Float)pointRad.get((Object)team, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static Vec2 point(Team team) {
        return (Vec2)point.get((Object)team, (Object)new Vec2());
    }

    public void update(Unit unit) {
        if (Mathf.within((float)unit.x, (float)unit.y, (float)LegionfieldAbility.point((Team)unit.team).x, (float)LegionfieldAbility.point((Team)unit.team).y, (float)LegionfieldAbility.radius(unit.team))) {
            float mult = Mathf.clamp((float)(LegionfieldAbility.radius(unit.team) / this.radius), (float)1.0f, (float)3.0f);
            unit.speedMultiplier(Mathf.clamp((float)(LegionfieldAbility.radius(unit.team) / this.radius), (float)1.0f, (float)3.0f));
            if (LegionfieldAbility.radius(unit.team) > this.radius) {
                unit.apply(StatusEffects.shielded);
            }
            if (mult >= 3.0f) {
                unit.unapply(SvEffects.buff);
                unit.apply(SvEffects.overpower);
            } else if (mult >= 1.5f) {
                unit.unapply(SvEffects.overpower);
                unit.apply(SvEffects.buff);
            }
        } else {
            unit.speedMultiplier(1.0f);
            unit.unapply(StatusEffects.shielded);
            unit.unapply(SvEffects.buff);
            unit.unapply(SvEffects.overpower);
        }
    }

    public void draw(Unit unit) {
        if (Mathf.within((float)unit.x, (float)unit.y, (float)LegionfieldAbility.point((Team)unit.team).x, (float)LegionfieldAbility.point((Team)unit.team).y, (float)(4.0f * LegionfieldAbility.radius(unit.team) + 8.0f))) {
            float z = Draw.z();
            float x = LegionfieldAbility.point((Team)unit.team).x;
            float y = LegionfieldAbility.point((Team)unit.team).y;
            float rad = 8.0f * LegionfieldAbility.lastRadius(unit.team);
            Color teamColor = Tmp.c2.set(unit.team.color).mul(1.1f);
            Color teamColor2 = Tmp.c3.set(unit.team.color).mul(1.1f);
            Draw.z((float)29.3f);
            LegionfieldAbility.lightInner(x, y, 6, rad * 0.9f, rad, 0.0f, teamColor.a(0.0f), teamColor2.a(1.0f / (float)LegionfieldAbility.count(unit.team)));
            LegionfieldAbility.lightInner(x, y, 6, rad * 0.9f, 0.0f, 0.0f, teamColor.mul(1.25f).a(0.0f), teamColor2.mul(1.25f).a(0.5f / (float)LegionfieldAbility.count(unit.team)));
            LegionfieldAbility.lightInner(x, y, 6, rad * 1.05f, rad, 0.0f, teamColor.mul(0.2f).a(0.0f), teamColor2.mul(0.2f).a(1.0f / (float)LegionfieldAbility.count(unit.team)));
            Draw.z((float)z);
            Draw.reset();
        } else if (!Mathf.within((float)unit.x, (float)unit.y, (float)LegionfieldAbility.point((Team)unit.team).x, (float)LegionfieldAbility.point((Team)unit.team).y, (float)(4.0f * LegionfieldAbility.radius(unit.team) + 8.0f))) {
            float z = Draw.z();
            float x = unit.x;
            float y = unit.y;
            float rad = 8.0f + 8.0f * this.radius;
            Color teamColor = Tmp.c2.set(unit.team.color).saturation(0.0f).mul(0.75f);
            Color teamColor2 = Tmp.c3.set(unit.team.color).saturation(0.0f).mul(0.75f);
            Draw.z((float)29.3f);
            LegionfieldAbility.lightInner(x, y, 6, rad * 0.9f, rad, 0.0f, teamColor.a(0.0f), teamColor2.a(0.5f));
            LegionfieldAbility.lightInner(x, y, 6, rad * 0.9f, 0.0f, 0.0f, teamColor.mul(1.25f).a(0.0f), teamColor2.mul(1.25f).a(0.25f));
            LegionfieldAbility.lightInner(x, y, 6, rad * 1.05f, rad, 0.0f, teamColor.mul(0.2f).a(0.0f), teamColor2.mul(0.2f).a(0.5f));
            Draw.z((float)z);
            Draw.reset();
        }
    }

    public static void lightInner(float x, float y, int sides, float innerRadius, float radius, float rotation, Color center, Color edge) {
        float centerf = center.toFloatBits();
        float edgef = edge.toFloatBits();
        float space = 360.0f / (float)sides;
        for (int i = 0; i < sides; ++i) {
            float px = Angles.trnsx((float)(space * (float)i + rotation), (float)radius);
            float py = Angles.trnsy((float)(space * (float)i + rotation), (float)radius);
            float px2 = Angles.trnsx((float)(space * (float)(i + 1) + rotation), (float)radius);
            float py2 = Angles.trnsy((float)(space * (float)(i + 1) + rotation), (float)radius);
            Fill.quad((float)(x + Angles.trnsx((float)(space * (float)i + rotation), (float)innerRadius)), (float)(y + Angles.trnsy((float)(space * (float)i + rotation), (float)innerRadius)), (float)centerf, (float)(x + px), (float)(y + py), (float)edgef, (float)(x + px2), (float)(y + py2), (float)edgef, (float)(x + Angles.trnsx((float)(space * (float)(i + 1) + rotation), (float)innerRadius)), (float)(y + Angles.trnsy((float)(space * (float)(i + 1) + rotation), (float)innerRadius)), (float)centerf);
        }
    }
}

