/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ai;

import arc.func.Boolf;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.ai.types.DefenderAI;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;
import mindustry.world.meta.BlockFlag;

public class DefenderDroneAI
extends DefenderAI {
    public Boolf<Unit> filter = u -> true;
    public float maxOwnerDistance = 160.0f;
    public Teamc enemyTarget = null;
    public float noTargetTime = 0.0f;
    public float aliveTime = 1200.0f;

    public void updateMovement() {
        this.unloadPayloads();
        if (this.enemyTarget != null && this.target != null && Mathf.dst((float)this.unit.x, (float)this.unit.y, (float)this.target.x(), (float)this.target.y()) >= this.maxOwnerDistance) {
            this.enemyTarget = null;
        }
        if (this.enemyTarget != null && this.target != null && Mathf.dst((float)this.unit.x, (float)this.unit.y, (float)this.target.x(), (float)this.target.y()) < this.maxOwnerDistance) {
            float f;
            Teamc teamc = this.enemyTarget;
            if (teamc instanceof Sized) {
                Sized s = (Sized)teamc;
                f = s.hitSize() / 2.0f * 1.1f;
            } else {
                f = 0.0f;
            }
            this.moveTo((Position)this.enemyTarget, f + this.unit.hitSize / 2.0f + 15.0f, 50.0f);
            this.unit.lookAt((Position)this.enemyTarget);
        } else if (this.target != null) {
            float f;
            Teamc teamc = this.target;
            if (teamc instanceof Sized) {
                Sized s = (Sized)teamc;
                f = s.hitSize() / 2.0f * 1.1f;
            } else {
                f = 0.0f;
            }
            this.moveTo((Position)this.target, f + this.unit.hitSize / 2.0f + 15.0f, 50.0f);
            this.unit.lookAt((Position)this.target);
            this.noTargetTime = 0.0f;
        } else {
            this.noTargetTime += Time.delta;
        }
        if (this.noTargetTime >= 300.0f) {
            this.unit.kill();
        }
    }

    public void updateUnit() {
        super.updateUnit();
        this.unit.health -= this.unit.type.health / this.aliveTime * Time.delta;
    }

    public void updateTargeting() {
        if (this.retarget()) {
            this.target = this.findTarget(this.unit.x, this.unit.y, this.unit.range(), true, true);
            this.enemyTarget = this.findEnemyTarget();
        }
        this.updateWeapons();
    }

    public void updateWeapons() {
        float rotation = this.unit.rotation - 90.0f;
        Teamc target = this.enemyTarget;
        this.noTargetTime += Time.delta;
        if (this.invalid(target)) {
            target = null;
        } else {
            this.noTargetTime = 0.0f;
        }
        this.unit.isShooting = false;
        for (WeaponMount mount : this.unit.mounts) {
            Weapon weapon = mount.weapon;
            float wrange = weapon.range();
            if (!weapon.controllable || weapon.noAttack) continue;
            if (!weapon.aiControllable) {
                mount.rotate = false;
                continue;
            }
            float mountX = this.unit.x + Angles.trnsx((float)rotation, (float)weapon.x, (float)weapon.y);
            float mountY = this.unit.y + Angles.trnsy((float)rotation, (float)weapon.x, (float)weapon.y);
            if (this.unit.type.singleTarget) {
                mount.target = target;
            } else if (this.checkTarget(mount.target, mountX, mountY, wrange)) {
                mount.target = null;
            }
            boolean shoot = false;
            if (mount.target != null) {
                float f;
                Teamc teamc;
                Teamc teamc2 = teamc = mount.target;
                if (teamc instanceof Sized) {
                    Sized s = (Sized)teamc;
                    f = s.hitSize() / 2.0f;
                } else {
                    f = 0.0f;
                }
                shoot = teamc2.within(mountX, mountY, wrange + f) && this.shouldShoot();
                Vec2 to = Predict.intercept((Position)this.unit, (Position)mount.target, (float)weapon.bullet.speed);
                mount.aimX = to.x;
                mount.aimY = to.y;
            }
            mount.shoot = mount.rotate = shoot;
            this.unit.isShooting |= mount.rotate;
            if (mount.target == null && !shoot && !Angles.within((float)mount.rotation, (float)mount.weapon.baseRotation, (float)0.01f) && this.noTargetTime >= 300.0f) {
                mount.rotate = true;
                Tmp.v1.trns(this.unit.rotation + mount.weapon.baseRotation, 5.0f);
                mount.aimX = mountX + Tmp.v1.x;
                mount.aimY = mountY + Tmp.v1.y;
            }
            if (!shoot) continue;
            this.unit.aimX = mount.aimX;
            this.unit.aimY = mount.aimY;
        }
    }

    public Teamc findEnemyTarget() {
        if (this.target == null) {
            return null;
        }
        Unit result = Units.closestEnemy((Team)this.unit.team, (float)this.target.x(), (float)this.target.y(), (float)this.maxOwnerDistance, u -> !u.dead() && u.type != this.unit.type && u.targetable(this.unit.team) && u.type.playerControllable);
        if (result != null) {
            return result;
        }
        for (BlockFlag flag : this.unit.type.targetFlags) {
            Teamc res = this.targetFlag(this.target.x(), this.target.y(), flag, true);
            if (res == null || !(Mathf.dst((float)res.x(), (float)res.y(), (float)this.target.x(), (float)this.target.y()) < this.maxOwnerDistance)) continue;
            return res;
        }
        return result;
    }

    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        return this.enemyTarget;
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Unit result = Units.closest((Team)this.unit.team, (float)x, (float)y, (float)this.maxOwnerDistance, u -> this.filter.get(u) && !u.dead() && u.type != this.unit.type && u.targetable(this.unit.team) && u.type.playerControllable, (u, tx, ty) -> -u.maxHealth + Mathf.dst2((float)u.x, (float)u.y, (float)tx, (float)ty) / 6400.0f);
        return result;
    }
}

