/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ai;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.entities.Units;
import mindustry.entities.units.UnitController;
import mindustry.game.Team;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.BlockFlag;
import subvoyage.type.unit.entity.HelicopterUnitEntity;

public class HelicopterAI
extends FlyingAI {
    public boolean keepFlying = true;
    public Unit troop = null;
    public Unit head = null;
    public float groundCooldown = 0.0f;

    public void updateMovement() {
        this.unloadPayloads();
        Unit unit = this.unit;
        if (!(unit instanceof HelicopterUnitEntity)) {
            return;
        }
        HelicopterUnitEntity heli = (HelicopterUnitEntity)unit;
        if (this.target != null && this.unit.hasWeapons()) {
            if (this.unit.type.circleTarget) {
                this.circleAttack(120.0f);
            } else {
                this.moveTo((Position)this.target, this.unit.type.range * 0.8f);
                this.unit.lookAt((Position)this.target);
            }
        }
        if (this.unit.hitTime() > 0.0f && this.head != null) {
            this.moveTo((Position)this.head, this.head.hitSize, 1000.0f);
        }
        if (this.target == null && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
            this.moveTo((Position)this.getClosestSpawner(), Vars.state.rules.dropZoneRadius + 130.0f);
        }
        if (this.groundCooldown > 300.0f) {
            this.groundCooldown = -300.0f;
        }
        if (this.keepFlying || this.groundCooldown > 0.0f) {
            heli.updateBoosting(true);
        }
        if (!this.keepFlying) {
            this.groundCooldown += Time.delta;
        }
        if (this.troop != null) {
            this.moveTo((Position)this.troop, Math.max(this.troop.hitSize + 4.0f, this.unit.hitSize + 4.0f), 100.0f);
        }
        if (this.head != null) {
            Teamc teamc;
            UnitController unitController = this.head.controller();
            if (unitController instanceof HelicopterAI) {
                HelicopterAI ai = (HelicopterAI)unitController;
                teamc = ai.target == null ? this.target : ai.target;
            } else {
                teamc = null;
            }
            this.target = teamc;
        }
    }

    public HelicopterAI getHeadAi() {
        HelicopterAI ai;
        UnitController unitController = this.head.controller();
        return unitController instanceof HelicopterAI ? (ai = (HelicopterAI)unitController) : null;
    }

    public void updateTargeting() {
        super.updateTargeting();
        boolean groundTurret = this.targetGroundTurret(this.unit.getX(), this.unit.getY(), this.unit.type.fogRadius * 8.0f * 1.5f) != null;
        boolean airTurret = this.targetAirTurret(this.unit.getX(), this.unit.getY(), this.unit.type.fogRadius * 8.0f * 2.0f) != null;
        this.keepFlying = true;
        if (groundTurret && !airTurret) {
            this.keepFlying = true;
        }
        if (airTurret && !groundTurret) {
            this.keepFlying = false;
        }
        if (this.troop == null || Mathf.dst((float)this.troop.x(), (float)this.troop.y(), (float)this.unit.x(), (float)this.unit.y()) < this.unit().hitSize * 1.2f) {
            this.troop = this.findTroop(this.unit.getX(), this.unit.getY(), this.unit.type.fogRadius * 8.0f * 1.2f, this.unit().hitSize * 1.2f);
        }
        Unit newHead = this.findMain(this.unit.getX(), this.unit.getY(), this.unit.type.fogRadius * 8.0f);
        if (this.head == null || this.head.maxHealth < newHead.health || this.head.hitSize < newHead.hitSize || this.head.maxHealth < newHead.health && this.head.health < newHead.health) {
            this.head = newHead;
        }
        if (this.head != null && this.getHeadAi() != null && this.getHeadAi().head != null) {
            this.head = this.getHeadAi().head;
        }
        if (this.head != null && (this.head.maxHealth == this.unit.maxHealth || this.head.hitSize == this.unit.hitSize)) {
            this.head = null;
        }
        if (this.head != null && this.getHeadAi() != null && this.getHeadAi().head == this.unit) {
            this.head = null;
        }
    }

    public Unit findMain(float x, float y, float range) {
        return Units.closest((Team)this.unit.team, (float)x, (float)y, (float)range, u -> u instanceof HelicopterUnitEntity, (u, xo, yo) -> -u.hitSize - u.health);
    }

    public Unit findTroop(float x, float y, float range, float minRange) {
        return Units.closest((Team)this.unit.team, (float)x, (float)y, (float)range, u -> u instanceof HelicopterUnitEntity && Mathf.dst((float)x, (float)y, (float)u.getX(), (float)u.getY()) > minRange, (u, xo, yo) -> -u.hitSize - u.health);
    }

    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc core = this.targetFlag(x, y, BlockFlag.core, true);
        if (core != null && Mathf.within((float)x, (float)y, (float)core.getX(), (float)core.getY(), (float)range)) {
            return core;
        }
        Teamc result = this.target(x, y, range, !this.keepFlying && air, this.keepFlying && ground);
        if (result != null) {
            return result;
        }
        result = this.target(x, y, range, air, ground);
        if (result != null) {
            return result;
        }
        return core;
    }

    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget((Team)this.unit.team, (float)x, (float)y, (float)range, u -> u.checkTarget(air, ground), t -> ground);
    }

    public Teamc targetGroundTurret(float x, float y, float range) {
        return Units.closestTarget((Team)this.unit.team, (float)x, (float)y, (float)range, u -> false, t -> {
            Block patt4861$temp = t.block;
            if (!(patt4861$temp instanceof Turret)) return false;
            Turret b = (Turret)patt4861$temp;
            if (!t.isValid()) return false;
            if (!t.isAdded()) return false;
            if (!b.targetGround) return false;
            if (b.targetAir) return false;
            return true;
        });
    }

    public Teamc targetAirTurret(float x, float y, float range) {
        return Units.closestTarget((Team)this.unit.team, (float)x, (float)y, (float)range, u -> false, t -> {
            Block patt5103$temp = t.block;
            if (!(patt5103$temp instanceof Turret)) return false;
            Turret b = (Turret)patt5103$temp;
            if (!t.isValid()) return false;
            if (!t.isAdded()) return false;
            if (!b.targetAir) return false;
            if (b.targetGround) return false;
            return true;
        });
    }
}

