/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ai;

import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;
import arc.util.Time;
import mindustry.ai.types.BoostAI;
import mindustry.ai.types.CommandAI;
import mindustry.entities.units.UnitController;
import mindustry.gen.Unit;
import subvoyage.type.unit.entity.HelicopterUnitEntity;

public class HelicopterBoostAI
extends BoostAI {
    public void updateUnit() {
        UnitController unitController = this.unit.controller();
        if (unitController instanceof CommandAI) {
            CommandAI ai = (CommandAI)unitController;
            ai.defaultBehavior();
            this.unit.updateBoosting(true);
        }
    }

    public void updateMovement() {
        super.updateMovement();
        Unit unit = this.unit;
        if (!(unit instanceof HelicopterUnitEntity)) {
            return;
        }
        HelicopterUnitEntity heli = (HelicopterUnitEntity)unit;
        if (heli.vel.len() < 0.3f) {
            float steerX = Mathf.sinDeg((float)Time.time) * 12.0f;
            float steerY = Mathf.cosDeg((float)Time.time) * 12.0f;
            float len = 1.0f - Mathf.clamp((float)heli.vel.len(), (float)0.0f, (float)0.3f) / 0.3f;
            heli.movePref((Vec2)new Vec2(steerX, steerY).times((Vector)new Vec2(len, len)));
        }
    }
}

