/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ai;

import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.types.CommandAI;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.BuildVisibility;

public class HelicopterCommandAI
extends CommandAI {
    public HelicopterCommandAI() {
        this.stopAtTarget = false;
        this.stopWhenInRange = false;
    }

    public void defaultBehavior() {
        boolean withinAttackRange;
        Unit unit;
        if (!Vars.net.client() && (unit = this.unit) instanceof Payloadc) {
            Building build;
            Payloadc pay = (Payloadc)unit;
            this.payloadPickupCooldown -= Time.delta;
            if (this.command == UnitCommand.unloadPayloadCommand && pay.hasPayload()) {
                Call.payloadDropped((Unit)this.unit, (float)this.unit.x, (float)this.unit.y);
            }
            if (this.command == UnitCommand.loadUnitsCommand) {
                this.tryPickupUnit(pay);
            }
            if (this.command == UnitCommand.loadBlocksCommand && (this.targetPos == null || this.unit.within((Position)this.targetPos, 1.0f)) && (build = Vars.world.buildWorld(this.unit.x, this.unit.y)) != null && Vars.state.teams.canInteract(this.unit.team, build.team)) {
                Payload current = build.getPayload();
                if (current != null && pay.canPickupPayload(current)) {
                    Call.pickedBuildPayload((Unit)this.unit, (Building)build, (boolean)false);
                } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                    Call.pickedBuildPayload((Unit)this.unit, (Building)build, (boolean)true);
                }
            }
        }
        if (!Vars.net.client() && this.command == UnitCommand.enterPayloadCommand && this.unit.buildOn() != null && (this.targetPos == null || Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) != null && Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) == this.unit.buildOn())) {
            Building build = this.unit.buildOn();
            HelicopterCommandAI.tmpPayload.unit = this.unit;
            if (build.team == this.unit.team && build.acceptPayload(build, (Payload)tmpPayload)) {
                Call.unitEnteredPayload((Unit)this.unit, (Building)build);
                return;
            }
        }
        this.updateVisuals();
        this.updateTargeting();
        if (this.attackTarget != null && this.invalid(this.attackTarget)) {
            this.attackTarget = null;
            this.targetPos = null;
        }
        if (this.attackTarget == null && this.targetPos == null) {
            this.finishPath();
        }
        if (this.attackTarget != null) {
            if (this.targetPos == null) {
                this.lastTargetPos = this.targetPos = new Vec2();
            }
            this.targetPos.set((Position)this.attackTarget);
        }
        boolean alwaysArrive = false;
        float engageRange = this.unit.type.range - 10.0f;
        boolean bl = withinAttackRange = this.attackTarget != null && this.unit.within((Position)this.attackTarget, engageRange) && this.stance != UnitStance.ram;
        if (this.targetPos != null) {
            boolean move = true;
            boolean isFinalPoint = this.commandQueue.size == 0;
            vecOut.set(this.targetPos);
            vecMovePos.set(this.targetPos);
            if (this.group != null && this.group.valid && this.groupIndex < this.group.units.size && this.command != UnitCommand.enterPayloadCommand) {
                vecMovePos.add(this.group.positions[this.groupIndex * 2], this.group.positions[this.groupIndex * 2 + 1]);
            }
            Building targetBuild = Vars.world.buildWorld(this.targetPos.x, this.targetPos.y);
            if (this.stance == UnitStance.patrol && this.target != null && this.unit.within((Position)this.target, this.unit.type.range - 2.0f) && !this.unit.type.circleTarget || this.command == UnitCommand.enterPayloadCommand && this.unit.within((Position)this.targetPos, 4.0f) || targetBuild != null && this.unit.within((Position)targetBuild, (float)(targetBuild.block.size * 8) / 2.0f * 0.9f) || this.command != UnitCommand.loopPayloadCommand || this.unit.within((Position)this.targetPos, 10.0f)) {
                // empty if block
            }
            vecOut.set(vecMovePos);
            if (move) {
                if (this.unit.type.circleTarget && this.attackTarget != null) {
                    this.target = this.attackTarget;
                    this.circleAttack(80.0f);
                } else {
                    this.moveTo((Position)vecOut, withinAttackRange ? engageRange : (this.attackTarget != null && this.stance != UnitStance.ram ? engageRange : 0.0f), this.unit.isFlying() ? 40.0f : 100.0f, true, null, isFinalPoint || alwaysArrive);
                }
            }
            if (this.attackTarget != null && this.stopAtTarget && this.unit.within((Position)this.attackTarget, engageRange - 1.0f)) {
                this.attackTarget = null;
            }
            if (move && (this.attackTarget == null || !this.unit.within((Position)this.attackTarget, this.unit.type.range))) {
                this.unit.lookAt((Position)vecMovePos);
            } else {
                this.faceTarget();
            }
            if (this.attackTarget == null && this.unit.within((Position)vecMovePos, this.command.exactArrival && this.commandQueue.size == 0 ? 1.0f : Math.max(5.0f, this.unit.hitSize / 2.0f))) {
                this.finishPath();
            }
            if (this.stopWhenInRange && this.targetPos != null && this.unit.within((Position)vecMovePos, engageRange * 0.9f)) {
                this.finishPath();
                this.stopWhenInRange = false;
            }
        } else if (this.target != null) {
            this.faceTarget();
        }
    }

    void finishPath() {
        Unit unit;
        if (this.command == UnitCommand.enterPayloadCommand && this.commandQueue.size == 0 && this.targetPos != null && Vars.world.buildWorld(this.targetPos.x, this.targetPos.y) != null && Vars.world.buildWorld((float)this.targetPos.x, (float)this.targetPos.y).block.acceptsUnitPayloads) {
            return;
        }
        if (!Vars.net.client() && this.command == UnitCommand.loopPayloadCommand && (unit = this.unit) instanceof Payloadc) {
            Payloadc pay = (Payloadc)unit;
            if (this.transferState == 0) {
                int n = this.transferState = pay.hasPayload() ? 2 : 1;
            }
            if (this.payloadPickupCooldown > 0.0f) {
                return;
            }
            if (this.transferState == 2) {
                int prev = -1;
                while (pay.hasPayload() && prev != pay.payloads().size) {
                    prev = pay.payloads().size;
                    Call.payloadDropped((Unit)this.unit, (float)this.unit.x, (float)this.unit.y);
                }
                if (pay.hasPayload()) {
                    return;
                }
                this.payloadPickupCooldown = 60.0f;
            } else if (this.transferState == 1) {
                int prev = -1;
                while (prev != pay.payloads().size) {
                    prev = pay.payloads().size;
                    this.tryPickupUnit(pay);
                }
                if (!pay.hasPayload()) {
                    return;
                }
                this.payloadPickupCooldown = 60.0f;
            }
            if (this.commandQueue.size == 0) {
                return;
            }
        }
        this.transferState = 0;
        Vec2 prev = this.targetPos;
        this.targetPos = null;
        if (this.commandQueue.size > 0) {
            Position next = (Position)this.commandQueue.remove(0);
            if (next instanceof Teamc) {
                Teamc target = (Teamc)next;
                this.commandTarget(target, this.stopAtTarget);
            } else if (next instanceof Vec2) {
                Vec2 position = (Vec2)next;
                this.commandPosition(position);
            }
            if (prev != null && (this.stance == UnitStance.patrol || this.command == UnitCommand.loopPayloadCommand)) {
                this.commandQueue.add((Object)prev.cpy());
            }
            if (this.group != null) {
                Vec2 position;
                this.group.updateRaycast(this.groupIndex, next instanceof Vec2 ? (position = (Vec2)next) : Tmp.v3.set(next));
            }
        } else if (this.group != null) {
            this.group = null;
        }
    }

    void tryPickupUnit(Payloadc pay) {
        Unit target = Units.closest((Team)this.unit.team, (float)this.unit.x, (float)this.unit.y, (float)(this.unit.type.hitSize * 2.0f), u -> u.isAI() && u != this.unit && u.isGrounded() && pay.canPickup(u) && u.within((Position)this.unit, u.hitSize + this.unit.hitSize));
        if (target != null) {
            Call.pickedUnitPayload((Unit)this.unit, (Unit)target);
        }
    }
}

