/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.entity;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.StatusEntry;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.payloads.Payload;
import subvoyage.content.SvUnits;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.unit.type.HelicopterUnitType;

public class HelicopterUnitEntity
extends PayloadUnit {
    public float localAcceleration = 0.0f;
    public boolean isAccelerating = false;
    public float lastAccel = 0.0f;
    public boolean reachedFullAltitude = false;
    public float accelSmooth = 0.0f;
    public transient BulletType expl = null;

    public int classId() {
        return SvUnits.mapHelicopter;
    }

    public void draw() {
        this.drawBuilding();
        if (this.mining()) {
            float focusLen = this.hitSize / 2.0f + Mathf.absin((float)Time.time, (float)1.1f, (float)0.5f);
            float swingScl = 12.0f;
            float swingMag = 1.0f;
            float flashScl = 0.3f;
            float px = this.x + Angles.trnsx((float)this.rotation, (float)focusLen);
            float py = this.y + Angles.trnsy((float)this.rotation, (float)focusLen);
            float ex = this.mineTile.worldx() + Mathf.sin((float)(Time.time + 48.0f), (float)swingScl, (float)swingMag);
            float ey = this.mineTile.worldy() + Mathf.sin((float)(Time.time + 48.0f), (float)(swingScl + 2.0f), (float)swingMag);
            Draw.z((float)115.1f);
            Draw.color((Color)Color.lightGray, (Color)Color.white, (float)(1.0f - flashScl + Mathf.absin((float)Time.time, (float)0.5f, (float)flashScl)));
            Drawf.laser((TextureRegion)Core.atlas.find("minelaser"), (TextureRegion)Core.atlas.find("minelaser-end"), (float)px, (float)py, (float)ex, (float)ey, (float)0.75f);
            if (this.isLocal()) {
                Lines.stroke((float)1.0f, (Color)Pal.accent);
                Lines.poly((float)this.mineTile.worldx(), (float)this.mineTile.worldy(), (int)4, (float)(4.0f * Mathf.sqrt2), (float)Time.time);
            }
            Draw.color();
        }
        for (StatusEntry e : this.statuses) {
            e.effect.draw((Unit)this, e.time);
        }
        this.type.draw((Unit)this);
    }

    public float accel() {
        return this.accelSmooth;
    }

    public float shadowAlpha() {
        return this.accel();
    }

    public float elevation() {
        return this.accel();
    }

    public static HelicopterUnitEntity create() {
        return new HelicopterUnitEntity();
    }

    public void moveAt(Vec2 vector, float acceleration) {
        Vec2 t = tmp1.set(vector);
        tmp2.set(t).sub(this.vel).limit(acceleration * vector.len() * Time.delta);
        if (t.len() > 0.2f) {
            this.localAcceleration += Time.delta / 60.0f * (this.localAcceleration + 0.1f);
        }
        if (t.len() > 0.2f) {
            this.isAccelerating = true;
        }
        this.localAcceleration = Mathf.clamp((float)this.localAcceleration, (float)0.0f, (float)1.0f);
        this.vel.add((Vec2)tmp2.times((Vector)new Vec2(this.localAcceleration, this.localAcceleration)));
    }

    public void movePref(Vec2 movement) {
        if (this.type.omniMovement) {
            this.moveAt(movement, this.type.accel);
        } else {
            this.rotateMove(movement);
        }
    }

    public void wobble() {
        this.x += Mathf.sin((float)(Time.time + (float)(this.id() % 10 * 12)), (float)25.0f, (float)0.05f) * Time.delta * this.elevation * this.accel();
        this.y += Mathf.cos((float)(Time.time + (float)(this.id() % 10 * 12)), (float)25.0f, (float)0.05f) * Time.delta * this.elevation * this.accel();
    }

    public void updateBoosting(boolean boost) {
        if (this.type.canBoost && !this.dead) {
            boolean shouldBoost;
            boolean bl = shouldBoost = boost || this.isFlying() && !this.canLand() || this.isFlying() && this.onSolid();
            if (shouldBoost) {
                this.accelSmooth = Mathf.lerpDelta((float)this.accelSmooth, (float)Math.max(this.accelSmooth, 0.75f), (float)0.033333335f);
            }
        }
    }

    public boolean canShoot() {
        return !this.disarmed;
    }

    public void steer() {
        float steerX = Mathf.sinDeg((float)Time.time) * 12.0f;
        float steerY = Mathf.cosDeg((float)Time.time) * 12.0f;
        float len = 1.0f - Mathf.clamp((float)this.vel.len(), (float)0.0f, (float)0.3f) / 0.3f;
        this.moveAt((Vec2)new Vec2(steerX, steerY).times((Vector)new Vec2(len, len)));
    }

    public boolean canLand() {
        return Units.count((float)this.x, (float)this.y, (float)this.physicSize(), f -> f != this && f.isGrounded()) == 0;
    }

    public void update() {
        super.update();
        if (this.dead()) {
            for (int i = 0; i < this.payloads.size; ++i) {
                Payload load = (Payload)this.payloads.peek();
                if (!this.tryDropPayload(load)) continue;
                this.payloads.pop();
            }
        }
        this.accelSmooth = Mathf.lerp((float)this.accelSmooth, (float)(this.vel.len() / this.type.speed), (float)(Time.delta / 10.0f));
        if (!this.isAccelerating) {
            this.localAcceleration -= Time.delta / 30.0f;
            this.localAcceleration = Mathf.clamp((float)this.localAcceleration, (float)0.0f, (float)1.0f);
        } else {
            this.isAccelerating = false;
        }
        UnitType unitType = this.type;
        if (unitType instanceof HelicopterUnitType) {
            HelicopterUnitType hType = (HelicopterUnitType)unitType;
            hType.onUpdate.accept(this);
        }
        if (this.accel() > 0.7f) {
            this.reachedFullAltitude = true;
        }
        if ((double)this.lastAccel > 0.1 && (double)this.accel() <= 0.1 && this.accel() - this.lastAccel < 0.0f && this.reachedFullAltitude) {
            Effect.shake((float)this.type.stepShake, (float)this.type.stepShake, (Position)new Vec2(this.x, this.y));
            this.reachedFullAltitude = false;
        }
        this.lastAccel = this.accel();
        if (this.dead) {
            this.accelSmooth = Mathf.approachDelta((float)this.accelSmooth, (float)0.0f, (float)0.016666668f);
            if (!Vars.state.isPaused()) {
                this.rotation += Time.delta / this.hitSize * 80.0f * this.accel();
            }
        }
    }

    public boolean canPass(int tileX, int tileY) {
        return true;
    }

    public CommandAI command() {
        return super.command();
    }

    public boolean isPathImpassable(int tileX, int tileY) {
        return Vars.world.tiles.in(tileX, tileY);
    }

    public void collision(Hitboxc other, float x, float y) {
        Bullet b;
        Entityc entityc;
        super.collision(other, x, y);
        if (other instanceof Bullet && (entityc = (b = (Bullet)other).owner()) instanceof Turret.TurretBuild) {
            Turret.TurretBuild tb = (Turret.TurretBuild)entityc;
            entityc = tb.block;
            if (entityc instanceof Turret) {
                Turret t = (Turret)entityc;
                if (!t.targetGround && this.isGrounded()) {
                    Advancement.helicopter_tricked.unlock();
                }
            }
        }
    }

    public boolean isGrounded() {
        return this.accel() < 0.1f;
    }

    public boolean isFlying() {
        return this.accel() > 0.1f;
    }
}

