/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.type;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import java.util.function.Consumer;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.entities.abilities.Ability;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Crawlc;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Tankc;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.blocks.environment.Floor;
import subvoyage.content.SvUnits;
import subvoyage.type.unit.ai.HelicopterAI;
import subvoyage.type.unit.ai.HelicopterCommandAI;
import subvoyage.type.unit.entity.HelicopterUnitEntity;
import subvoyage.type.unit.type.AtlacianUnitType;
import subvoyage.type.unit.weapon.HydromechWeapon;

public class HelicopterUnitType
extends AtlacianUnitType {
    public Consumer<HelicopterUnitEntity> onUpdate = e -> {};
    static final int impassable = -1;

    public HelicopterUnitType(String name) {
        super(name);
        this.flying = true;
        this.lowAltitude = true;
        this.rotateMoveFirst = false;
        this.drag = 0.15f;
        this.strafePenalty = 1.0f;
        this.pathCost = (team, tile) -> 0;
        this.aiController = HelicopterAI::new;
        this.canBoost = true;
        this.controller = u -> !this.playerControllable || u.team.isAI() && !u.team.rules().rtsAi ? (UnitController)this.aiController.get() : new HelicopterCommandAI();
    }

    public void init() {
        super.init();
        this.payloadCapacity = this.hitSize * this.hitSize * 0.85f;
        this.commands.remove((Object)UnitCommand.boostCommand);
        this.commands.add((Object)SvUnits.boostCommand);
    }

    public void draw(Unit unit) {
        float z;
        Mechc mech;
        float f;
        if (unit.inFogTo(Vars.player.team())) {
            return;
        }
        if (unit instanceof HelicopterUnitEntity) {
            HelicopterUnitEntity h = (HelicopterUnitEntity)unit;
            f = h.accel() * 0.1f + 0.9f;
        } else {
            f = 1.0f;
        }
        float scale = f;
        boolean isPayload = !unit.isAdded();
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)unit : null;
        float f2 = isPayload ? Draw.z() : (unit.isGrounded() ? 75.0f : (z = this.lowAltitude ? 90.0f : 115.0f));
        if (!isPayload && (unit.isFlying() || this.shadowElevation > 0.0f)) {
            Draw.z((float)Math.min(80.0f, z - 2.0f));
            this.drawShadow(unit);
        }
        Draw.z((float)(z - 0.02f));
        if (unit instanceof Tankc) {
            this.drawTank((Unit)((Tankc)unit));
        }
        if (unit instanceof Legsc && !isPayload) {
            this.drawLegs((Unit)((Legsc)unit));
        }
        Draw.z((float)Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Payloadc)unit));
        }
        this.drawSoftShadow(unit);
        Draw.z((float)z);
        if (unit instanceof Crawlc) {
            Crawlc c = (Crawlc)unit;
            this.drawCrawl(c);
        }
        if (this.drawBody) {
            this.drawOutline(unit);
        }
        this.drawWeaponOutlines(unit);
        if (this.engineLayer > 0.0f) {
            Draw.z((float)this.engineLayer);
        }
        if (!(this.trailLength <= 0 || this.naval || !unit.isFlying() && this.useEngineElevation)) {
            this.drawTrail(unit);
        }
        if (this.engines.size > 0) {
            this.drawEngines(unit);
        }
        Draw.z((float)z);
        if (this.drawBody) {
            this.drawBody(unit);
        }
        if (this.drawCell) {
            this.drawCell(unit);
        }
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        this.drawLight(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                float warm;
                float f3;
                WeaponMount first;
                DrawPart part = (DrawPart)this.parts.get(i);
                WeaponMount weaponMount = first = unit.mounts.length > part.weaponIndex ? unit.mounts[part.weaponIndex] : null;
                if (unit instanceof HelicopterUnitEntity) {
                    HelicopterUnitEntity heli = (HelicopterUnitEntity)unit;
                    f3 = heli.accel();
                } else {
                    f3 = warm = unit.vel.len() / unit.speed();
                }
                if (first != null) {
                    DrawPart.params.set(warm, first.reload / ((Weapon)this.weapons.first()).reload, first.smoothReload, first.heat, first.recoil, first.charge, unit.x, unit.y, unit.rotation);
                } else {
                    DrawPart.params.set(warm, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, unit.x, unit.y, unit.rotation);
                }
                if (unit instanceof Scaled) {
                    Scaled s = (Scaled)unit;
                    DrawPart.params.life = s.fin();
                }
                part.draw(DrawPart.params);
            }
        }
        if (!isPayload) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
        }
        Draw.reset();
    }

    @Override
    public void drawBody(Unit unit) {
        this.applyColor(unit);
        Draw.rect((TextureRegion)this.region, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
        Draw.reset();
        if (this.bodyHeat && this.regionHeat != null && this.regionHeat.found()) {
            float warmup = 0.0f;
            for (WeaponMount mount : unit.mounts) {
                HydromechWeapon hw;
                Weapon weapon = mount.weapon;
                if (weapon instanceof HydromechWeapon) {
                    hw = (HydromechWeapon)weapon;
                    if (!hw.hasHeat) continue;
                }
                if ((weapon = mount.weapon) instanceof HydromechWeapon) {
                    hw = (HydromechWeapon)weapon;
                    warmup = Math.max(warmup, hw.warmupToHeat ? mount.warmup : mount.heat);
                    continue;
                }
                warmup = Math.max(warmup, mount.heat);
            }
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)this.heatColor, (float)warmup);
            Draw.scl((float)this.bodyScale);
            Draw.rect((TextureRegion)this.regionHeat, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
            Draw.blend((Blending)Blending.normal);
        }
        Draw.scl();
    }

    @Override
    public void drawCell(Unit unit) {
        this.applyColor(unit);
        Draw.color((Color)this.cellColor(unit));
        Draw.rect((TextureRegion)this.cellRegion, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
        Draw.reset();
    }

    public void drawShadow(Unit unit) {
        float f;
        float e = Mathf.clamp((float)unit.elevation, (float)this.shadowElevation, (float)1.0f) * this.shadowElevationScl * (1.0f - unit.drownTime);
        if (unit instanceof HelicopterUnitEntity) {
            HelicopterUnitEntity h = (HelicopterUnitEntity)unit;
            f = h.accel();
        } else {
            f = 1.0f;
        }
        float x = unit.x + -12.0f * (e *= f);
        float y = unit.y + -13.0f * e;
        Floor floor = Vars.world.floorWorld(x, y);
        float dest = floor.canShadow ? 1.0f : 0.0f;
        unit.shadowAlpha = unit.shadowAlpha < 0.0f ? dest : Mathf.approachDelta((float)unit.shadowAlpha, (float)dest, (float)0.11f);
        Draw.color((Color)Pal.shadow, (float)(Pal.shadow.a * unit.shadowAlpha));
        Draw.rect((TextureRegion)this.shadowRegion, (float)(unit.x + -12.0f * e), (float)(unit.y + -13.0f * e), (float)(unit.rotation - 90.0f));
        Draw.color();
    }

    public Unit spawn(Position pos) {
        return super.spawn(pos);
    }

    @Override
    public void update(Unit unit) {
        super.update(unit);
    }

    public Unit create(Team team) {
        Unit unit = (Unit)this.constructor.get();
        unit.team = team;
        unit.setType((UnitType)this);
        unit.ammo = this.ammoCapacity;
        unit.elevation = this.flying ? 1.0f : 0.0f;
        unit.heal();
        if (unit instanceof HelicopterUnitEntity) {
            HelicopterUnitEntity e = (HelicopterUnitEntity)unit;
            e.localAcceleration = 0.0f;
            e.isAccelerating = false;
        }
        if (unit instanceof TimedKillc) {
            TimedKillc u = (TimedKillc)unit;
            u.lifetime(this.lifetime);
        }
        return unit;
    }

    public Unit spawn(Position pos, Team team) {
        return super.spawn(pos, team);
    }
}

