/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.type;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import java.util.HashMap;
import java.util.function.Consumer;
import mindustry.Vars;
import mindustry.entities.Leg;
import mindustry.entities.abilities.Ability;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Crawlc;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Tankc;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import subvoyage.type.unit.custom.HydromechState;
import subvoyage.type.unit.custom.HydromechStateStats;
import subvoyage.type.unit.entity.HydromechUnitEntity;
import subvoyage.type.unit.type.AtlacianUnitType;
import subvoyage.type.unit.weapon.HydromechWeapon;

public class HydromechUnitType
extends AtlacianUnitType {
    public Consumer<HydromechUnitEntity> onDraw = e -> {};
    public HashMap<HydromechState, HydromechStateStats> states = new HashMap();
    private static final Vec2 legOffset = new Vec2();

    public <A> void withStates(A ... elements) {
        HashMap<HydromechState, HydromechStateStats> map = new HashMap<HydromechState, HydromechStateStats>();
        for (int i = 0; i < elements.length; i += 2) {
            HydromechState state = (HydromechState)((Object)elements[i]);
            HydromechStateStats stat = (HydromechStateStats)elements[i + 1];
            map.put(state, stat);
        }
        this.states = map;
    }

    public HydromechUnitType(String name) {
        super(name);
        this.canDrown = false;
        this.flying = false;
        this.hovering = true;
        this.trailScl = 8.0f;
        this.trailLength = 20;
        this.waveTrailX = 4.0f;
        this.waveTrailY = -3.0f;
    }

    public Unit spawn(Position pos) {
        return super.spawn(pos);
    }

    @Override
    public void update(Unit unit) {
        super.update(unit);
    }

    public void draw(Unit unit) {
        float z;
        Mechc mech;
        if (unit instanceof HydromechUnitEntity) {
            HydromechUnitEntity h = (HydromechUnitEntity)unit;
            this.onDraw.accept(h);
        }
        if (unit.inFogTo(Vars.player.team())) {
            return;
        }
        boolean isPayload = !unit.isAdded();
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)unit : null;
        float f = isPayload ? Draw.z() : (unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : (z = this.groundLayer + Mathf.clamp((float)(this.hitSize / 4000.0f), (float)0.0f, (float)0.01f)));
        if (!isPayload && (unit.isFlying() || this.shadowElevation > 0.0f)) {
            Draw.z((float)Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
        }
        Draw.z((float)(z - 0.02f));
        if (unit instanceof Tankc) {
            this.drawTank((Unit)((Tankc)unit));
        }
        if (unit instanceof Legsc && !isPayload) {
            this.drawLegs((Unit)((Legsc)unit));
        }
        Draw.z((float)Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Payloadc)unit));
        }
        this.drawSoftShadow(unit);
        Draw.z((float)z);
        if (unit instanceof Crawlc) {
            Crawlc c = (Crawlc)unit;
            this.drawCrawl(c);
        }
        if (this.drawBody) {
            this.drawOutline(unit);
        }
        this.drawWeaponOutlines(unit);
        if (this.engineLayer > 0.0f) {
            Draw.z((float)this.engineLayer);
        }
        if (!(this.trailLength <= 0 || this.naval || !unit.isFlying() && this.useEngineElevation)) {
            this.drawTrail(unit);
        }
        if (this.engines.size > 0) {
            this.drawEngines(unit);
        }
        Draw.z((float)z);
        if (this.drawBody) {
            this.drawBody(unit);
        }
        if (this.drawCell) {
            this.drawCell(unit);
        }
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        this.drawLight(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                WeaponMount first;
                DrawPart part = (DrawPart)this.parts.get(i);
                float warmup = 0.0f;
                for (WeaponMount mount : unit.mounts) {
                    Weapon weapon = mount.weapon;
                    if (weapon instanceof HydromechWeapon) {
                        HydromechWeapon hw = (HydromechWeapon)weapon;
                        if (!hw.hasHeat) continue;
                    }
                    warmup = Math.max(warmup, mount.heat);
                }
                WeaponMount weaponMount = first = unit.mounts.length > part.weaponIndex ? unit.mounts[part.weaponIndex] : null;
                if (first != null) {
                    DrawPart.params.set(first.warmup, first.reload / ((Weapon)this.weapons.first()).reload, first.smoothReload, warmup, first.recoil, first.charge, unit.x, unit.y, unit.rotation);
                } else {
                    DrawPart.params.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, unit.x, unit.y, unit.rotation);
                }
                if (unit instanceof Scaled) {
                    Scaled s = (Scaled)unit;
                    DrawPart.params.life = s.fin();
                }
                part.draw(DrawPart.params);
            }
        }
        if (!isPayload) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
        }
        Draw.reset();
    }

    public Unit create(Team team) {
        Unit unit = (Unit)this.constructor.get();
        unit.team = team;
        unit.setType((UnitType)this);
        unit.ammo = this.ammoCapacity;
        unit.elevation = this.flying ? 1.0f : 0.0f;
        unit.heal();
        if (unit instanceof TimedKillc) {
            TimedKillc u = (TimedKillc)unit;
            u.lifetime(this.lifetime);
        }
        return unit;
    }

    public <T extends Unit> void drawLegs(T unit) {
        int j;
        float f;
        if (unit instanceof HydromechUnitEntity) {
            HydromechUnitEntity hm = (HydromechUnitEntity)unit;
            f = hm.liquidedSmooth();
        } else {
            f = 0.0f;
        }
        float v = f;
        float sc = 1.0f - v;
        Draw.scl((float)(1.0f - v));
        Draw.alpha((float)(1.0f - v));
        this.applyColor(unit);
        Tmp.c3.set(Draw.getMixColor());
        Leg[] legs = ((Legsc)unit).legs();
        float ssize = (float)this.footRegion.width * this.footRegion.scl() * 1.5f;
        float rotation = ((Legsc)unit).baseRotation();
        float invDrown = 1.0f - unit.drownTime;
        if (this.footRegion.found()) {
            for (Leg leg : legs) {
                Drawf.shadow((float)Mathf.lerp((float)leg.base.x, (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.base.y, (float)unit.y, (float)(1.0f - sc)), (float)ssize, (float)invDrown);
            }
        }
        for (j = legs.length - 1; j >= 0; --j) {
            int i = j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2;
            Leg leg = legs[i];
            boolean flip = (float)i >= (float)legs.length / 2.0f;
            int flips = Mathf.sign((boolean)flip);
            Vec2 position = ((Legsc)unit).legOffset(legOffset, i).add(unit);
            Tmp.v1.set(leg.base).sub(leg.joint).inv().setLength(this.legExtension * sc);
            if (this.footRegion.found() && leg.moving && this.shadowElevation > 0.0f) {
                float scl = this.shadowElevation * invDrown;
                float elev = Mathf.slope((float)(1.0f - leg.stage)) * scl * sc;
                Draw.color((Color)Pal.shadow);
                Draw.rect((TextureRegion)this.footRegion, (float)Mathf.lerp((float)(leg.base.x + -12.0f * elev), (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)(leg.base.y + -13.0f * elev), (float)unit.y, (float)(1.0f - sc)), (float)position.angleTo((Position)leg.base));
                Draw.color();
            }
            Draw.mixcol((Color)Tmp.c3, (float)Tmp.c3.a);
            if (this.footRegion.found()) {
                Draw.rect((TextureRegion)this.footRegion, (float)Mathf.lerp((float)leg.base.x, (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.base.y, (float)unit.y, (float)(1.0f - sc)), (float)position.angleTo((Position)leg.base));
            }
            Lines.stroke((float)((float)this.legRegion.height * this.legRegion.scl() * (float)flips));
            Lines.line((TextureRegion)this.legRegion, (float)Mathf.lerp((float)position.x, (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)position.y, (float)unit.y, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.joint.x, (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.joint.y, (float)unit.y, (float)(1.0f - sc)), (boolean)false);
            Lines.stroke((float)((float)this.legBaseRegion.height * this.legRegion.scl() * (float)flips));
            Lines.line((TextureRegion)this.legBaseRegion, (float)Mathf.lerp((float)(leg.joint.x + Tmp.v1.x), (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)(leg.joint.y + Tmp.v1.y), (float)unit.y, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.base.x, (float)unit.x, (float)(1.0f - sc)), (float)Mathf.lerp((float)leg.base.y, (float)unit.y, (float)(1.0f - sc)), (boolean)false);
            if (!this.jointRegion.found()) continue;
            Draw.rect((TextureRegion)this.jointRegion, (float)leg.joint.x, (float)leg.joint.y);
        }
        if (this.baseJointRegion.found()) {
            for (j = legs.length - 1; j >= 0; --j) {
                Vec2 position = ((Legsc)unit).legOffset(legOffset, j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2).add(unit);
                Draw.rect((TextureRegion)this.baseJointRegion, (float)position.x, (float)position.y, (float)rotation);
            }
        }
        if (this.baseRegion.found()) {
            Draw.rect((TextureRegion)this.baseRegion, (float)unit.x, (float)unit.y, (float)(rotation - 90.0f));
        }
        Draw.reset();
    }

    public void init() {
        super.init();
        this.naval = true;
    }

    public Unit spawn(Position pos, Team team) {
        return super.spawn(pos, team);
    }
}

