/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.util.Interval;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.world.Tile;
import subvoyage.content.other.SvAttribute;

public class AtlacianMapControl {
    private float[] map;
    public int w;
    public int h;
    public int blurAmount = 1;
    public Texture textureMap;
    @Nullable
    private Thread heatMapThread;
    public boolean recalculate;
    public transient Interval timer = new Interval(1);
    private static final Object notifyThread = new Object();

    public float getWater(Tile tile) {
        float v = tile.floor().attributes.get(SvAttribute.sodilate);
        if (!tile.block().isAir()) {
            v = 0.0f;
        }
        return v;
    }

    public void update() {
        if (this.recalculate && this.timer.get(0, 5.0f)) {
            this.recalcInner();
        }
    }

    public void recalc() {
        this.recalculate = true;
    }

    void recalcInner() {
        int i = 0;
        this.w = Vars.world.width();
        this.h = Vars.world.height();
        this.map = new float[this.w * this.h];
        for (Tile tile : Vars.world.tiles) {
            this.map[i] = this.getWater(tile);
            ++i;
        }
        this.textureMap = null;
        this.blur(this.blurAmount);
        this.add();
        this.recalculate = false;
    }

    private void add() {
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = this.map[i] * 2.0f;
        }
    }

    private void blur(int iterations) {
        for (int i = 0; i < iterations; ++i) {
            this.blur();
        }
    }

    private void blur() {
        float[] result = new float[this.map.length];
        for (int y = 0; y < this.h; ++y) {
            for (int x = 0; x < this.w; ++x) {
                float sum = 0.0f;
                int count = 0;
                for (int dy = -3; dy <= 3; ++dy) {
                    for (int dx = -3; dx <= 3; ++dx) {
                        int nx = x + dx;
                        int ny = y + dy;
                        if (nx < 0 || nx >= this.w || ny < 0 || ny >= this.h) continue;
                        sum += this.map[ny * this.w + nx];
                        ++count;
                    }
                }
                result[y * this.w + x] = sum / (float)count;
            }
        }
        this.map = result;
    }

    public void stop() {
        this.map = null;
        this.textureMap = null;
        if (this.heatMapThread != null) {
            this.heatMapThread.interrupt();
            this.heatMapThread = null;
        }
    }

    public float at(int x, int y) {
        if (this.map == null) {
            return 0.0f;
        }
        if (this.map.length < y * this.w + x || y * this.w * x < 0) {
            return 0.0f;
        }
        return this.map[y * this.w + x];
    }

    public Texture toTexture() {
        if (this.textureMap != null) {
            return this.textureMap;
        }
        if (this.map == null) {
            return new Texture(this.w, this.h);
        }
        Pixmap pixmap = new Pixmap(this.w, this.h);
        int i = 0;
        for (float v : this.map) {
            int x = i % this.w;
            int y = i / this.w;
            pixmap.set(x, y, new Color(v, 0.0f, -v, Math.abs(v)));
            ++i;
        }
        this.textureMap = new Texture(Pixmaps.scale((Pixmap)pixmap, (int)(pixmap.width * 8), (int)(pixmap.height * 8), (boolean)true));
        return this.textureMap;
    }

    class HeatThread
    extends Thread {
        HeatThread() {
            super("HeatThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = notifyThread;
                        synchronized (object) {
                            try {
                                notifyThread.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        AtlacianMapControl.this.recalcInner();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

