/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.Structs;
import arc.util.Tmp;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.game.Schematics;
import mindustry.game.SpawnGroup;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.SteamVent;
import subvoyage.content.block.SvEnvironment;
import subvoyage.content.other.SvLoadouts;
import subvoyage.core.draw.SvPal;
import subvoyage.type.world.AtlacianWaves;

public class AtlacianPlanetGeneratorOld
extends PlanetGenerator {
    float oceanLevel = 0.4f;
    float sodilateBiomeWeight = 0.3f;
    float archalyteBiomeWeight = 0.4f;

    public AtlacianPlanetGeneratorOld() {
        this.defaultLoadout = SvLoadouts.corePuffer;
        this.baseSeed = 1;
    }

    public void generateSector(Sector sector) {
    }

    public float getHeight(Vec3 position) {
        float noise = Simplex.noise3d((int)(this.seed + 10), (double)4.0, (double)0.9, (double)1.0, (double)(position.z / 10.0f), (double)position.y, (double)(position.x / 2.0f));
        float puddleNoise = Simplex.noise3d((int)(this.seed + 12), (double)2.0, (double)0.9, (double)1.0, (double)(position.x / 12.0f), (double)(position.y / 12.0f), (double)(position.z / 12.0f));
        float waveNoise = Ridged.noise3d((int)(this.seed + 10), (double)(position.y / 2.0f + noise * 4.0f), (double)0.0, (double)0.0, (float)0.25f);
        float actualNoise = noise * 1.2f;
        if (waveNoise > 0.7f || puddleNoise > 0.7f) {
            return this.oceanLevel;
        }
        return Math.max(actualNoise, this.oceanLevel);
    }

    public Color getColor(Vec3 position) {
        float biomeMask = Simplex.noise3d((int)this.seed, (double)3.0, (double)0.4, (double)1.0, (double)position.z, (double)position.y, (double)position.x);
        float patternMask = Simplex.noise3d((int)this.seed, (double)1.0, (double)0.6, (double)2.0, (double)position.z, (double)position.y, (double)position.x);
        if (this.getHeight(position) <= this.oceanLevel) {
            return SvPal.atlacianOcean;
        }
        if ((double)biomeMask > 0.6 && patternMask < 0.6f) {
            return SvPal.agaryte;
        }
        if ((double)biomeMask > 0.5) {
            return SvPal.legartyteLightish;
        }
        if (biomeMask > 0.4f && patternMask < 0.3f) {
            return SvEnvironment.sodilateStone.mapColor;
        }
        if ((double)biomeMask > 0.2) {
            return SvPal.legartyte;
        }
        return Liquids.arkycite.color;
    }

    private Seq<Block> getOres() {
        Seq ores = Seq.with((Object[])new Block[]{SvEnvironment.oreSpaclanium, SvEnvironment.oreCorallite});
        float poles = Math.abs(this.sector.tile.v.y);
        float nmag = 0.5f;
        float scl = 1.0f;
        float addscl = 1.3f;
        if (Simplex.noise3d((int)this.seed, (double)2.0, (double)0.5, (double)scl, (double)this.sector.tile.v.x, (double)this.sector.tile.v.y, (double)this.sector.tile.v.z) * nmag + poles > 0.25f * addscl) {
            ores.add((Object)SvEnvironment.oreSulfur);
        }
        if (Simplex.noise3d((int)this.seed, (double)2.0, (double)0.5, (double)scl, (double)(this.sector.tile.v.x + 1.0f), (double)this.sector.tile.v.y, (double)this.sector.tile.v.z) * nmag + poles > 0.35f * addscl) {
            ores.add((Object)SvEnvironment.oreIridium);
        }
        if (Simplex.noise3d((int)this.seed, (double)2.0, (double)0.5, (double)scl, (double)(this.sector.tile.v.x + 1.0f), (double)this.sector.tile.v.y, (double)this.sector.tile.v.z) * nmag + poles > 0.45f * addscl) {
            ores.add((Object)SvEnvironment.oreChromium);
        }
        return ores;
    }

    protected void genTile(Vec3 position, TileGen tile) {
        super.genTile(position, tile);
    }

    protected void generate() {
        Seq<SpawnGroup> spawns;
        float spawnDegree = this.rand.random(360.0f);
        float length = (float)this.width / 3.0f;
        Vec2 trns = Tmp.v1.trns(spawnDegree, length);
        Seq<Block> ores = this.getOres();
        FloatSeq frequencies = new FloatSeq();
        float poles = Math.abs(this.sector.tile.v.y);
        for (int i = 0; i < ores.size; ++i) {
            frequencies.add(this.rand.random(-0.1f, 0.01f) + (float)i * 0.01f + poles * 0.04f);
        }
        int spawnX = (int)(trns.x + (float)this.width / 2.0f);
        int spawnY = (int)(trns.y + (float)this.height / 2.0f);
        int endX = (int)(-trns.x + (float)this.width / 2.0f);
        int endY = (int)(-trns.y + (float)this.height / 2.0f);
        float maxd = Mathf.dst((float)((float)this.width / 2.0f), (float)((float)this.height / 2.0f));
        this.pass((x, y) -> {
            this.floor = SvEnvironment.legartyteStone;
        });
        this.cells(16);
        this.terrain(SvEnvironment.agaryteWall, 40.0f, 0.5f, 0.95f);
        this.terrain(SvEnvironment.legartyteWall, 31.0f, 1.3f, 0.8f);
        this.distort(1.1f, 0.5f);
        this.terrain(SvEnvironment.agaryteWall, 40.0f, 1.3f, 0.9f);
        this.noiseReplace(SvEnvironment.legartyteStone, Blocks.water, 2, 0.2f, 60.0f, 0.6f);
        this.rnoiseReplace(SvEnvironment.legartyteStone, Blocks.water, 2, 0.2f, 50.0f, 0.1f, 1.0f);
        Seq path = this.pathfind(spawnX, spawnY, endX, endY, tile -> (tile.solid() ? 300.0f : 0.0f) + (float)this.rand.random(-200, 200) + maxd - tile.dst((float)this.width / 2.0f, (float)this.height / 2.0f) / 10.0f, Astar.manhattan);
        this.erase(spawnX, spawnY, 30);
        this.brush(path, 10);
        this.brushWithBlock((Seq<Tile>)path, 8, Blocks.water);
        this.erase(endX, endY, 12);
        this.inverseFloodFill(this.tiles.get(spawnX, spawnY));
        this.distort(10.0f, 2.0f);
        this.rnoiseReplace(Blocks.water, SvEnvironment.legartyteStone, 2, 0.2f, 100.0f, 0.2f, 1.0f);
        this.rnoiseReplace(Blocks.water, Blocks.deepwater, 1, 0.5f, 20.0f, 0.0f, 1.0f);
        this.blend(Blocks.water, Blocks.deepwater, Blocks.darksandWater, 4.0f);
        this.blend(SvEnvironment.legartyteStone, SvEnvironment.darkLegartyteStone, 2.0f);
        this.pass((x, y) -> {
            float firstNoise = this.noise(x, y, 5.0, 0.6f, 80.0, 1.0);
            float secondNoise = this.noise(x, y, 4.0, 0.4f, 100.0, 0.95f);
            float darkNoise = this.rnoise(x, y, 1, 39.0f, 0.5f, 1.0f);
            if (secondNoise < this.sodilateBiomeWeight) {
                if (!this.floor.asFloor().isLiquid) {
                    this.floor = darkNoise > 0.0f ? SvEnvironment.darkSodilateFloor : SvEnvironment.sodilateStone;
                } else {
                    if (this.floor == Blocks.water) {
                        this.floor = SvEnvironment.hardWater;
                    }
                    if (this.floor == Blocks.deepwater || this.floor == Blocks.darksandWater) {
                        this.floor = SvEnvironment.darkHardWater;
                    }
                }
                if (this.block.solid) {
                    this.block = SvEnvironment.sodilateWall;
                }
                return;
            }
            if (firstNoise < this.archalyteBiomeWeight) {
                if (!this.floor.asFloor().isLiquid) {
                    Block block = this.floor = darkNoise > 0.0f ? SvEnvironment.darkArchalyteStone : SvEnvironment.archalyteStone;
                }
                if (this.block.solid) {
                    this.block = SvEnvironment.archalyteWall;
                }
                return;
            }
        });
        this.blend(SvEnvironment.archalyteStone, SvEnvironment.darkArchalyteStone, 2.0f);
        this.blend(SvEnvironment.archalyteStone, SvEnvironment.darkSodilateFloor, 2.0f);
        for (Tile tile2 : this.tiles) {
            if (!this.rand.chance((double)1.0E-4f)) continue;
            int rad = this.rand.random(7, 16);
            Geometry.circle((int)tile2.x, (int)tile2.y, (int)rad, (x, y) -> {
                Tile puddleTile = this.tiles.get(x, y);
                if (puddleTile == null) {
                    return;
                }
                if (puddleTile.floor() != Blocks.water || puddleTile.block().solid) {
                    puddleTile.setFloor((Floor)Blocks.darksandWater);
                }
                puddleTile.setBlock(Blocks.air);
            });
            Geometry.circle((int)tile2.x, (int)tile2.y, (int)(rad - 2), (x, y) -> {
                Tile puddleTile = this.tiles.get(x, y);
                if (puddleTile == null) {
                    return;
                }
                puddleTile.setFloor((Floor)Blocks.water);
                puddleTile.setBlock(Blocks.air);
            });
            if (rad <= 10) continue;
            Geometry.circle((int)tile2.x, (int)tile2.y, (int)(rad - 5), (x, y) -> {
                Tile puddleTile = this.tiles.get(x, y);
                if (puddleTile == null) {
                    return;
                }
                puddleTile.setFloor((Floor)Blocks.deepwater);
                puddleTile.setBlock(Blocks.air);
            });
        }
        this.distort(10.0f, 1.0f);
        this.median(4, 0.7f);
        this.scatterBlock(Blocks.water, Blocks.yellowCoral, 0.001f);
        this.scatterBlock(SvEnvironment.legartyteStone, SvEnvironment.hauntedTree, 0.0016666666f);
        this.scatterBlock(SvEnvironment.darkLegartyteStone, SvEnvironment.hauntedTree, 0.0016666666f);
        this.pass((x, y) -> {
            if (this.block == SvEnvironment.agaryteWall && this.rand.chance(0.23) && this.nearAir(x, y) && !this.near(x, y, 3, SvEnvironment.agaryteBlocks)) {
                this.block = SvEnvironment.agaryteBlocks;
                this.ore = Blocks.air;
            }
            if (this.block == SvEnvironment.sodilateWall && this.rand.chance(0.42) && this.nearAir(x, y) && !this.near(x, y, 3, SvEnvironment.sodilateBlocks)) {
                this.block = SvEnvironment.sodilateBlocks;
                this.ore = Blocks.air;
            }
            if (this.block == SvEnvironment.archalyteWall && this.rand.chance(0.33) && this.nearAir(x, y)) {
                this.block = SvEnvironment.archalyteSpikes;
                this.ore = Blocks.air;
            }
        });
        this.pass((x, y) -> {
            int offsetX = x - 4;
            int offsetY = y + 23;
            for (int i = ores.size - 1; i >= 0; --i) {
                Block entry = (Block)ores.get(i);
                float freq = frequencies.get(i);
                if (this.block != Blocks.air || !((double)Math.abs(0.5f - this.noise(offsetX, offsetY + i * 888, 2.0, 0.7f, 10 + i * 2, 1.0)) > (double)0.24f + (double)i * 0.01) || !(Math.abs(0.5f - this.noise(offsetX, offsetY - i * 888, 1.0, 1.0, 15 + i * 4, 1.0)) > 0.37f + freq)) continue;
                this.ore = entry;
                break;
            }
        });
        this.pass((x, y) -> {
            if (this.block == SvEnvironment.sodilateWall) {
                if (!this.nearAir(x, y)) {
                    return;
                }
                for (int i = 0; i < ores.size; ++i) {
                    Block entry = (Block)ores.get(i);
                    if (!SvEnvironment.floorToWallOre.containsKey(entry) || this.noise((float)x / 10.0f, (float)y / 10.0f, 2.0, 0.3f, 1.0, 1.0) > 0.5f + 0.1f * (float)i) continue;
                    this.ore = SvEnvironment.floorToWallOre.getOrDefault(entry, entry);
                    break;
                }
            }
        });
        block2: for (Tile tile2 : this.tiles) {
            Floor floor = tile2.floor();
            if (floor != SvEnvironment.legartyteStone || !this.rand.chance((double)0.005f)) continue;
            int radius = 2;
            for (int x2 = -radius; x2 <= radius; ++x2) {
                for (int y2 = -radius; y2 <= radius; ++y2) {
                    Tile other = this.tiles.get(x2 + tile2.x, y2 + tile2.y);
                    if (other == null || other.floor() != SvEnvironment.legartyteStone || other.block().solid) continue block2;
                }
            }
            for (Point2 pos : SteamVent.offsets) {
                Tile other = this.tiles.get(pos.x + tile2.x + 1, pos.y + tile2.y + 1);
                other.setFloor(SvEnvironment.crudesQuarry.asFloor());
            }
        }
        this.decoration(0.017f);
        Schematics.placeLaunchLoadout((int)spawnX, (int)spawnY);
        this.tiles.get(endX, endY).setOverlay(Blocks.spawn);
        Geometry.circle((int)spawnX, (int)spawnY, (int)6, (x, y) -> {
            if (this.tiles.get(x, y) != this.tiles.get(spawnX, spawnY) && this.rand.chance((double)0.3f)) {
                this.tiles.get(x, y).setOverlay(SvEnvironment.oreSpaclanium);
            }
        });
        Vars.state.rules.spawns = spawns = AtlacianWaves.generate(this.sector.threat * 1.3f, new Rand((long)this.sector.id), Vars.state.rules.attackMode, this.rand.chance((double)0.3f));
        Vars.state.rules.waves = true;
        Vars.state.rules.winWave = this.sector.info.winWave = 10 + 5 * (int)Math.max(this.sector.threat * 10.0f, 1.0f);
        Vars.state.rules.waveSpacing = Mathf.lerp((float)7800.0f, (float)2880.0f, (float)Math.max(this.sector.threat, 0.0f));
        this.sector.generateEnemyBase = false;
        Vars.state.rules.attackMode = false;
    }

    public void brushWithBlock(Seq<Tile> path, int rad, Block block) {
        path.each(tile -> this.eraseWithBlock(tile.x, tile.y, rad, block));
    }

    public void eraseWithBlock(int cx, int cy, int rad, Block block) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds((int)wx, (int)wy, (int)this.width, (int)this.height) || !Mathf.within((float)x, (float)y, (float)rad)) continue;
                Tile other = this.tiles.getn(wx, wy);
                if (block == Blocks.water || block.isFloor()) {
                    other.setFloor(block.asFloor());
                    continue;
                }
                other.setBlock(block);
            }
        }
    }

    public void scatterBlock(Block target, Block dst, float chance) {
        this.pass((x, y) -> {
            if (!Mathf.chance((double)chance)) {
                return;
            }
            if (this.floor == target && !this.block.solid) {
                this.block = dst;
            }
        });
    }

    public void blendRand(Block floor, Block around, float radius, float chance) {
        float r2 = radius * radius;
        int cap = Mathf.ceil((float)radius);
        int max = this.tiles.width * this.tiles.height;
        Block dest = around;
        for (int i = 0; i < max; ++i) {
            Tile tile = this.tiles.geti(i);
            if (tile.floor() != floor && tile.block() != floor) continue;
            for (int cx = -cap; cx <= cap; ++cx) {
                for (int cy = -cap; cy <= cap; ++cy) {
                    Tile other;
                    if (!((float)(cx * cx + cy * cy) <= r2) || (other = this.tiles.get(tile.x + cx, tile.y + cy)) == null || other.block() == floor || !(this.noise(tile.x, tile.y, 2.0, 0.5, 10.0, 1.0) < chance)) continue;
                    other.setBlock(dest);
                }
            }
        }
    }

    public void blend(Block floor, Block secondaryFloor, Block around, float radius) {
        float r2 = radius * radius;
        int cap = Mathf.ceil((float)radius);
        int max = this.tiles.width * this.tiles.height;
        Floor dest = around.asFloor();
        for (int i = 0; i < max; ++i) {
            Tile tile = this.tiles.geti(i);
            if (tile.floor() != floor && tile.block() != floor && tile.floor() != secondaryFloor && tile.block() != secondaryFloor) continue;
            for (int cx = -cap; cx <= cap; ++cx) {
                for (int cy = -cap; cy <= cap; ++cy) {
                    Tile other;
                    if (!((float)(cx * cx + cy * cy) <= r2) || (other = this.tiles.get(tile.x + cx, tile.y + cy)) == null || other.floor() == floor || other.floor() == secondaryFloor) continue;
                    other.setFloor(dest);
                }
            }
        }
    }

    protected float rnoise(float x, float y, int octaves, float scl, float falloff, float mag) {
        return Ridged.noise2d((int)(this.seed + 18), (double)((int)x), (double)((int)y), (int)octaves, (double)falloff, (double)(1.0f / scl)) * mag;
    }

    protected float noise(float x, float y, double octaves, double falloff, double scl, double mag) {
        Vec3 v = this.sector.rect.project(x, y);
        return Simplex.noise3d((int)(this.seed + 16), (double)octaves, (double)falloff, (double)(1.0 / scl), (double)(x / 3.0f), (double)(y / 3.0f), (double)(v.z / 2.0f)) * (float)mag;
    }

    public void rnoiseReplace(Block target, Block block, int octaves, float falloff, float scl, float threshold, float mag) {
        this.pass((x, y) -> {
            if (this.rnoise(x, y, octaves, scl, falloff, mag) > threshold) {
                boolean is;
                Tile tile = this.tiles.getn(x, y);
                boolean bl = is = target.isFloor() && tile.floor() == target.asFloor();
                if (!target.isFloor() && tile.block() == target) {
                    is = true;
                }
                if (is) {
                    if (block.isFloor()) {
                        this.floor = block;
                    } else {
                        this.block = block;
                    }
                }
            }
        });
    }

    public void noiseReplace(Block target, Block block, int octaves, float falloff, float scl, float threshold) {
        this.pass((x, y) -> {
            if (this.noise(x, y, octaves, falloff, scl) > threshold) {
                boolean is;
                Tile tile = this.tiles.getn(x, y);
                boolean bl = is = target.isFloor() && tile.floor() == target.asFloor();
                if (!target.isFloor() && tile.block() == target) {
                    is = true;
                }
                if (is) {
                    if (block.isFloor()) {
                        this.floor = block;
                    } else {
                        this.block = block;
                    }
                }
            }
        });
    }
}

