/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.func.Prov;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.g3d.Camera3D;
import arc.graphics.g3d.VertexBatch3D;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.util.Tmp;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import mindustry.type.Sector;

public class AtlacianPlanetType
extends Planet {
    public Prov<GenericMesh> atmosphereMesh;
    public GenericMesh atmMesh;
    public final Mat3D mat = new Mat3D();
    PlanetParams params;

    public AtlacianPlanetType(String name, Planet parent, float radius, int i) {
        super(name, parent, radius, i);
    }

    public void load() {
        super.load();
        this.atmMesh = (GenericMesh)this.atmosphereMesh.get();
    }

    public void updateBaseCoverage() {
        for (Sector sector : this.sectors) {
            float sum = 1.0f;
            for (Sector other : sector.near()) {
                if (!other.generateEnemyBase && !other.info.attack) continue;
                sum += 0.9f;
            }
            if (sector.hasEnemyBase() || sector.info.attack) {
                sum += 0.88f;
            }
            sector.threat = sector.preset == null ? Math.min(sum / 5.0f, 1.2f) : Mathf.clamp((float)(sector.preset.difficulty / 10.0f));
        }
    }

    public void draw(PlanetParams params, Mat3D projection, Mat3D transform) {
        this.params = params;
        super.draw(params, projection, transform);
    }

    public void drawAtmosphere(Mesh atmosphere, Camera3D cam) {
        Gl.depthMask((boolean)false);
        Blending.additive.apply();
        Shaders.atmosphere.camera = cam;
        Shaders.atmosphere.planet = this;
        Shaders.atmosphere.bind();
        Shaders.atmosphere.apply();
        atmosphere.render((Shader)Shaders.atmosphere, 4);
        this.atmMesh.render(this.params, cam.combined, this.getTransform(this.mat));
        Blending.normal.apply();
        Gl.depthMask((boolean)true);
    }

    public void fill(VertexBatch3D batch, Sector sector, Color color, float offset) {
        float rr = 1.17f * this.radius + offset;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner c = sector.tile.corners[i];
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            batch.tri(Tmp.v31.set(c.v).setLength(rr), Tmp.v32.set(next.v).setLength(rr), Tmp.v33.set(sector.tile.v).setLength(rr), color.cpy().a(0.2f));
        }
    }
}

