/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.Events;
import arc.func.Cons;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.world.Block;
import mindustry.world.Tile;

public class SvSectorPreset
extends SectorPreset {
    public static ObjectMap<Sector, Cons<GameState>> scripts = new ObjectMap();

    public SvSectorPreset(String name, Planet planet, int sector, Cons<GameState> run) {
        super(name, planet, sector);
    }

    public SvSectorPreset(String name, Planet planet, int sector) {
        super(name, planet, sector);
    }

    public static boolean getFlag(String flag, boolean remove) {
        if (Vars.state.rules.objectiveFlags.isEmpty()) {
            return false;
        }
        if (remove) {
            return Vars.state.rules.objectiveFlags.remove((Object)flag);
        }
        return Vars.state.rules.objectiveFlags.contains((Object)flag);
    }

    public static void setLimit() {
        Vars.state.rules.limitMapArea = false;
    }

    public static void setLimit(int x, int y, int x2, int y2) {
        Vars.state.rules.limitMapArea = true;
        Vars.state.rules.limitX = x;
        Vars.state.rules.limitY = y;
        Vars.state.rules.limitWidth = x2 - x;
        Vars.state.rules.limitHeight = y2 - y;
    }

    public static void buildWithEffect(int x, int y, Block block) {
        SvSectorPreset.buildWithEffect(x, y, block, Vars.player.team(), 0);
    }

    public static void buildWithEffect(int x, int y, Block block, Team team) {
        SvSectorPreset.buildWithEffect(x, y, block, team, 0);
    }

    public static void buildWithEffect(int x, int y, Block block, int rotation) {
        SvSectorPreset.buildWithEffect(x, y, block, Vars.player.team(), rotation);
    }

    public static void buildWithEffect(int x, int y, Block block, Team team, int rotation) {
        block.placeEffect.at((float)(x * 8), (float)(y * 8), (float)block.size);
        Tile tile = Vars.world.tile(x, y);
        if (!(block.isFloor() && block != Blocks.air || tile.block() == block && tile.team() == team)) {
            tile.setNet(block, team, Mathf.clamp((int)rotation, (int)0, (int)3));
        }
    }

    static {
        Events.run((Object)EventType.Trigger.update, () -> {
            if (Vars.state.getSector() != null) {
                ((Cons)scripts.get((Object)Vars.state.getSector(), a -> {})).get((Object)Vars.state);
            }
        });
    }
}

