/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.api;

import com.Nxer.TwistSpaceTechnology.common.api.IAlternativeItem;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AlternativeItem
implements IAlternativeItem {
    public final String name;
    private final Set<TST_ItemID> containedItems = new HashSet<TST_ItemID>();

    public AlternativeItem(@NotNull String name, ItemStack ... itemStacks) {
        this.name = name;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == null) continue;
            this.containedItems.add(TST_ItemID.create(itemStack));
        }
    }

    @Override
    public boolean containsItem(TST_ItemID itemID) {
        return this.containedItems.contains((Object)itemID);
    }

    @Override
    public boolean hasSameMember(IAlternativeItem another) {
        for (TST_ItemID itemID : this.containedItems) {
            if (!another.containsItem(itemID)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean addMember(TST_ItemID itemID) {
        return this.containedItems.add(itemID);
    }

    public boolean addMember(ItemStack itemStack) {
        return this.addMember(TST_ItemID.create(itemStack));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlternativeItem)) {
            return false;
        }
        AlternativeItem that = (AlternativeItem)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.containedItems, that.containedItems);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.containedItems);
    }
}

