/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.api;

import com.Nxer.TwistSpaceTechnology.common.api.IAlternativeItem;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class OreDictItem
implements IAlternativeItem {
    public static final Map<String, OreDictItem> UsedOreDictItems = new HashMap<String, OreDictItem>();
    public final String oreDictName;
    private final Set<TST_ItemID> containedItems = new HashSet<TST_ItemID>();

    public static OreDictItem getOreDictItems(String oreDictName) {
        if (UsedOreDictItems.containsKey(oreDictName)) {
            return UsedOreDictItems.get(oreDictName);
        }
        OreDictItem o = new OreDictItem(oreDictName);
        UsedOreDictItems.put(oreDictName, o);
        return o;
    }

    public OreDictItem(@NotNull String oreDictName) {
        this.oreDictName = oreDictName;
        for (ItemStack itemStack : OreDictionary.getOres((String)oreDictName)) {
            if (itemStack == null) continue;
            this.containedItems.add(TST_ItemID.createNoNBT(itemStack));
        }
    }

    @Override
    public boolean containsItem(ItemStack itemStack) {
        return this.containedItems.contains((Object)TST_ItemID.createNoNBT(itemStack)) || this.containedItems.contains((Object)TST_ItemID.createAsWildcard(itemStack));
    }

    @Override
    @NotNull
    public String getName() {
        return this.oreDictName;
    }

    @Override
    public boolean containsItem(TST_ItemID itemID) {
        return this.containedItems.contains((Object)itemID);
    }

    @Override
    public boolean hasSameMember(IAlternativeItem another) {
        for (TST_ItemID itemID : this.containedItems) {
            if (!another.containsItem(itemID)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OreDictItem)) {
            return false;
        }
        OreDictItem that = (OreDictItem)o;
        return Objects.equals(this.oreDictName, that.oreDictName);
    }

    public int hashCode() {
        return Objects.hash(this.oreDictName);
    }
}

