/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings8;
import gtPlusPlus.core.block.ModBlocks;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;

public class GT_TileEntity_HolySeparator
extends GTCM_MultiMachineBase<GT_TileEntity_HolySeparator> {
    private int piece = 1;
    private static final String STRUCTURE_PIECE_MAIN = "mainHolySeparator";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleHolySeparator";
    private static final String STRUCTURE_PIECE_END = "endHolySeparator";
    private final int horizontalOffSet = 7;
    private final int verticalOffSet = 2;
    private final int depthOffSet = 0;
    private static IStructureDefinition<GT_TileEntity_HolySeparator> STRUCTURE_DEFINITION = null;
    private final String[][] shapeMain = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "       G       ", "      GFG      ", "       G       ", "               ", "               ", "               ", "               ", "               ", "               "}, {"      AAA      ", "      AAA      ", "    AABBBAA    ", "   ABBBBBBBA   ", "  ABBBBBBBBBA  ", "  ABBBBBBBBBA  ", "AABBBBDDDBBBBAA", "AABBBBDDDBBBBAA", "AABBBBDDDBBBBAA", "  ABBBBBBBBBA  ", "  ABBBBBBBBBA  ", "   ABBBBBBBA   ", "    AABBBAA    ", "      AAA      ", "      AAA      "}, {"      A~A      ", "      AAA      ", "    AABBBAA    ", "   ABBBBBBBA   ", "  ABBBBBBBBBA  ", "  ABBBBBBBBBA  ", "AABBBBBBBBBBBAA", "AABBBBBBBBBBBAA", "AABBBBBBBBBBBAA", "  ABBBBBBBBBA  ", "  ABBBBBBBBBA  ", "   ABBBBBBBA   ", "    AABBBAA    ", "      AAA      ", "      AAA      "}, {"      AAA      ", "    AAAAAAA    ", "   AAABBBAAA   ", "  AABBBBBBBAA  ", " AABBBBBBBBBAA ", " AABBBBBBBBBAA ", "AABBBBBBBBBBBAA", "AABBBBBBBBBBBAA", "AABBBBBBBBBBBAA", " AABBBBBBBBBAA ", " AABBBBBBBBBAA ", "  AABBBBBBBAA  ", "   AAABBBAAA   ", "    AAAAAAA    ", "      AAA      "}};
    private final String[][] shapeMiddle = new String[][]{{"       E       ", "     AAAAA     ", "               ", "               ", "               ", " A           A ", " A     G     A ", "EA    GFG    AE", " A     G     A ", " A           A ", "               ", "               ", "               ", "     AAAAA     ", "       E       "}, {"      ECE      ", "    AAACAAA    ", "       C       ", "       C       ", " A           A ", " A           A ", "EA     G     AE", "CCCC  GFG  CCCC", "EA     G     AE", " A           A ", " A           A ", "       C       ", "       C       ", "    AAACAAA    ", "      ECE      "}, {"       E       ", "     AAAAA     ", "               ", "               ", "               ", " A           A ", " A     G     A ", "EA    GFG    AE", " A     G     A ", " A           A ", "               ", "               ", "               ", "     AAAAA     ", "       E       "}, {"               ", "               ", "               ", "               ", "               ", "               ", "       G       ", "      GFG      ", "       G       ", "               ", "               ", "               ", "               ", "               ", "               "}};
    private final String[][] shapeEnd = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "      CCC      ", "    CCDDDCC    ", "   CDDDDDDDC   ", "  CDDDDDDDDDC  ", "  CDDDDDDDDDC  ", " CDDDDDEDDDDDC ", " CDDDDEEEDDDDC ", " CDDDDDEDDDDDC ", "  CDDDDDDDDDC  ", "  CDDDDDDDDDC  ", "   CDDDDDDDC   ", "    CCDDDCC    ", "      CCC      ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "       G       ", "      GFG      ", "       G       ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "       G       ", "      GFG      ", "       G       ", "               ", "               ", "               ", "               ", "               ", "               "}};

    public GT_TileEntity_HolySeparator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_HolySeparator(String aName) {
        super(aName);
    }

    @Override
    public int totalMachineMode() {
        return 3;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_CUTTING);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SLICING);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SINGULARITY);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("HolySeparator.modeMsg." + mode));
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                this.setSpeedBonus(GT_TileEntity_HolySeparator.this.getSpeedBonus());
                this.setOverclockType(GT_TileEntity_HolySeparator.this.piece >= ValueEnum.Piece_EnablePerfectOverclock_HolySeparator ? OverclockType.PerfectOverclock : OverclockType.NormalOverclock);
                return super.process();
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return this.piece >= ValueEnum.Piece_EnablePerfectOverclock_HolySeparator;
    }

    public RecipeMap<?> getRecipeMap() {
        switch (this.machineMode) {
            case 1: {
                return RecipeMaps.slicerRecipes;
            }
            case 2: {
                return RecipeMaps.latheRecipes;
            }
        }
        return RecipeMaps.cutterRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.slicerRecipes, RecipeMaps.latheRecipes, RecipeMaps.cutterRecipes);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.piece = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 2, 0)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 7, 2 + (this.piece + 1) * 4, 0)) {
            ++this.piece;
        }
        if (this.piece < 1) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_END, 7, 2 + (this.piece + 1) * 4, 0)) {
            return false;
        }
        this.speedBonus = (float)Math.pow(ValueEnum.SpeedBonus_MultiplyPerTier_HolySeparator, this.getTotalPowerTier());
        this.maxParallel = ValueEnum.ParallelPerPiece_HolySeparator * this.piece;
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 2, 0);
        int piece = stackSize.field_77994_a;
        for (int i = 1; i <= piece; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 7, 2 + i * 4, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 7, 2 + piece * 4 + 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int[] built = new int[stackSize.field_77994_a + 2];
        built[0] = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 2, 0, elementBudget, env, false, true);
        int piece = stackSize.field_77994_a;
        for (int i = 1; i <= piece; ++i) {
            built[i] = this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 7, 2 + i * 4, 0, elementBudget, env, false, true);
        }
        int n = stackSize.field_77994_a + 1;
        built[n] = built[n] + this.survivialBuildPiece(STRUCTURE_PIECE_END, stackSize, 7, 2 + piece * 4 + 4, 0, elementBudget, env, false, true);
        return TstUtils.multiBuildPiece(built);
    }

    public IStructureDefinition<GT_TileEntity_HolySeparator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])this.shapeMain)).addShape(STRUCTURE_PIECE_MIDDLE, StructureUtility.transpose((String[][])this.shapeMiddle)).addShape(STRUCTURE_PIECE_END, StructureUtility.transpose((String[][])this.shapeEnd)).addElement('A', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GT_TileEntity_HolySeparator::addToMachineList).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(7)).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4)).addElement('E', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)6)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)8)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 3];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + "Parallels: " + EnumChatFormatting.GOLD + this.getMaxParallelRecipes();
        ret[origin.length + 1] = EnumChatFormatting.AQUA + "Speed multiplier: " + EnumChatFormatting.GOLD + this.getSpeedBonus();
        ret[origin.length + 2] = EnumChatFormatting.AQUA + "Pieces: " + EnumChatFormatting.GOLD + this.piece;
        return ret;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("piece", this.piece);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.piece = aNBT.func_74762_e("piece");
        this.machineMode = aNBT.func_74771_c("mode");
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_HolySeparator_MachineType).addInfo(TextLocalization.Tooltip_HolySeparator_00).addInfo(TextLocalization.Tooltip_HolySeparator_01).addInfo(TextLocalization.Tooltip_HolySeparator_02).addInfo(TextLocalization.Tooltip_HolySeparator_03).addInfo(TextLocalization.Tooltip_HolySeparator_04).addInfo(TextLocalization.Tooltip_HolySeparator_05).addInfo(TextLocalization.textScrewdriverChangeMode).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addInputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_HolySeparator(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183)};
    }
}

