/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bartworks.API.BorosilicateGlass;
import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;

public class GT_TileEntity_MoleculeDeconstructor
extends GTCM_MultiMachineBase<GT_TileEntity_MoleculeDeconstructor>
implements IConstructable,
ISurvivalConstructable {
    private byte glassTier = 0;
    private int piece = 1;
    private static final String STRUCTURE_PIECE_MAIN = "mainMoleculeDeconstructor";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleMoleculeDeconstructor";
    private static final String STRUCTURE_PIECE_END = "endMoleculeDeconstructor";
    private final int horizontalOffSet = 7;
    private final int verticalOffSet = 9;
    private final int depthOffSet = 0;
    private static IStructureDefinition<GT_TileEntity_MoleculeDeconstructor> STRUCTURE_DEFINITION = null;
    private final String[][] shapeMain = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "      HHH      ", "      HHH      ", "      HHH      ", "      G~G      "}, {"IIIIIIIIIIIIIII", "I     FFF     I", "I     DDD     I", "I             I", "I             I", "I             I", "IFD   AAA   DFI", "IFD   A A   DFI", "IFD   CCC   DFI", "CCD         DCC"}, {"               ", "      FFF      ", "      DED      ", "       B       ", "       B       ", "       B       ", " FD   AEA   DF ", " FEBBBE EBBBEF ", " FD   CCC   DF ", "CCD         DCC"}, {"IIIIIIIIIIIIIII", "I     FFF     I", "I     DDD     I", "I             I", "I             I", "I             I", "IFD   AAA   DFI", "IFD   A A   DFI", "IFD   CCC   DFI", "CCD         DCC"}};
    private final String[][] shapeMiddle = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "      AAA      ", "      A A      ", "      CCC      ", "               "}, {"IIIIIIIIIIIIIII", "I     FFF     I", "I     DDD     I", "I             I", "I             I", "I             I", "IFD   AAA   DFI", "IFD   A A   DFI", "IFD   CCC   DFI", "CCD         DCC"}, {"               ", "      FFF      ", "      DED      ", "       B       ", "       B       ", "       B       ", " FD   AEA   DF ", " FEBBBE EBBBEF ", " FD   CCC   DF ", "CCD         DCC"}, {"IIIIIIIIIIIIIII", "I     FFF     I", "I     DDD     I", "I             I", "I             I", "I             I", "IFD   AAA   DFI", "IFD   A A   DFI", "IFD   CCC   DFI", "CCD         DCC"}};
    private final String[][] shapeEnd = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "      FFF      ", "      FFF      ", "      FFF      ", "      GGG      "}};

    public GT_TileEntity_MoleculeDeconstructor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MoleculeDeconstructor(String aName) {
        super(aName);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_CHEMBATH);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SEPARATOR);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("MoleculeDeconstructor.modeMsg." + mode));
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return this.piece >= ValueEnum.PieceAmount_EnablePerfectOverclock_MoleculeDeconstructor;
    }

    @Override
    public int getMaxParallelRecipes() {
        return ValueEnum.Parallel_PerPiece_MoleculeDeconstructor * this.piece;
    }

    @Override
    protected float getSpeedBonus() {
        return this.speedBonus;
    }

    public RecipeMap<?> getRecipeMap() {
        switch (this.machineMode) {
            case 1: {
                return GTPPRecipeMaps.centrifugeNonCellRecipes;
            }
        }
        return GTPPRecipeMaps.electrolyzerNonCellRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTPPRecipeMaps.centrifugeNonCellRecipes, GTPPRecipeMaps.electrolyzerNonCellRecipes);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.glassTier = 0;
        this.piece = 1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 9, 0)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 7, 9, 0 - this.piece * 4)) {
            ++this.piece;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_END, 7, 9, 0 - this.piece * 4)) {
            return false;
        }
        if (this.glassTier <= 0) {
            return false;
        }
        if (this.glassTier < 12) {
            for (MTEHatch hatch : this.mExoticEnergyHatches) {
                if (this.glassTier >= hatch.mTier) continue;
                return false;
            }
        }
        this.speedBonus = (float)Math.pow(ValueEnum.SpeedBonus_MultiplyPerTier_MoleculeDeconstructor, this.getTotalPowerTier());
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 9, 0);
        int piece = stackSize.field_77994_a;
        for (int i = 1; i < piece; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 7, 9, 0 - i * 4);
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 7, 9, 0 - piece * 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int[] built = new int[stackSize.field_77994_a + 2];
        built[0] = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 9, 0, elementBudget, env, false, true);
        int piece = stackSize.field_77994_a;
        if (piece > 1) {
            for (int i = 1; i < piece; ++i) {
                built[i] = this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 7, 9, 0 - i * 4, elementBudget, env, false, true);
            }
        }
        int n = piece + 1;
        built[n] = built[n] + this.survivialBuildPiece(STRUCTURE_PIECE_END, stackSize, 7, 9, 0 - piece * 4, elementBudget, env, false, true);
        return TstUtils.multiBuildPiece(built);
    }

    public IStructureDefinition<GT_TileEntity_MoleculeDeconstructor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, this.shapeMain).addShape(STRUCTURE_PIECE_MIDDLE, this.shapeMiddle).addShape(STRUCTURE_PIECE_END, this.shapeEnd).addElement('A', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
                te.glassTier = t;
            }, te -> te.glassTier))).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)14)).addElement('D', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GT_TileEntity_MoleculeDeconstructor::addToMachineList).dot(1).casingIndex(1024).buildAndChain(TTCasingsContainer.sBlockCasingsTT, 0)).addElement('E', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)8)).addElement('F', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.OutputHatch}).adder(GT_TileEntity_MoleculeDeconstructor::addToMachineList).dot(2).casingIndex(62).buildAndChain(GregTechAPI.sBlockCasings4, 14)).addElement('G', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Maintenance}).adder(GT_TileEntity_MoleculeDeconstructor::addToMachineList).dot(3).casingIndex(62).buildAndChain(GregTechAPI.sBlockCasings4, 14)).addElement('H', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch}).adder(GT_TileEntity_MoleculeDeconstructor::addToMachineList).dot(4).casingIndex(62).buildAndChain(GregTechAPI.sBlockCasings4, 14)).addElement('I', GTStructureUtility.ofFrame((Materials)Materials.CosmicNeutronium)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 3];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + "Parallels: " + EnumChatFormatting.GOLD + this.getMaxParallelRecipes();
        ret[origin.length + 1] = EnumChatFormatting.AQUA + "Speed multiplier: " + EnumChatFormatting.GOLD + this.getSpeedBonus();
        ret[origin.length + 2] = EnumChatFormatting.AQUA + "Pieces: " + EnumChatFormatting.GOLD + this.piece;
        return ret;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("piece", this.piece);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.piece = aNBT.func_74762_e("piece");
        this.machineMode = aNBT.func_74771_c("mode");
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_MoleculeDeconstructor_MachineType).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_00).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_01).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_02).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_03).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_04).addInfo(TextLocalization.Tooltip_MoleculeDeconstructor_05).addInfo(TextLocalization.textScrewdriverChangeMode).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addController(TextLocalization.textFrontBottom).addInputHatch(TextLocalization.textUseBlueprint, new int[]{4}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{2}).addInputBus(TextLocalization.textUseBlueprint, new int[]{4}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{2}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MoleculeDeconstructor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)62), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)62), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)62)};
    }
}

