/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.WirelessEnergyMultiMachineBase;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings8;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TileEntity_Silksong
extends WirelessEnergyMultiMachineBase<GT_TileEntity_Silksong> {
    private int piece = 1;
    private HeatingCoilLevel coilLevel;
    private static final String STRUCTURE_PIECE_MAIN = "mainSilksong";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleSilksong";
    private static final String STRUCTURE_PIECE_END = "endSilksong";
    private final int horizontalOffSet = 3;
    private final int verticalOffSet = 5;
    private final int depthOffSet = 0;
    private static IStructureDefinition<GT_TileEntity_Silksong> STRUCTURE_DEFINITION = null;
    private final String[][] shapeMain = new String[][]{{"       ", "       ", "       ", "       ", "  DDD  ", "  D~D  ", "  DDD  "}, {"       ", "  III  ", "  III  ", "  III  ", "  DDD  ", "  DDD  ", "  DDD  "}};
    private final String[][] shapeMiddle = new String[][]{{"       ", "  CCC  ", "  CBC  ", "  CCC  ", "       ", "       ", "DDDDDDD"}, {"  AAA  ", " ACCCA ", " ACBCA ", " ACCCA ", " HAAAH ", " H   H ", "DDDDDDD"}};
    private final String[][] shapeEnd = new String[][]{{"  EEE  ", " EFFFE ", " EFBFE ", " EFFFE ", "  EEE  ", "       ", "DDDDDDD"}, {"  EEE  ", " EFFFE ", " EFBFE ", " EFFFE ", "  EEE  ", "       ", "  DDD  "}, {"  EEE  ", " EFFFE ", " EFBFE ", " EFFFE ", "  EEE  ", "       ", "  DDD  "}, {"       ", "  GGG  ", "  GBG  ", "  GGG  ", "  DDD  ", "  DDD  ", "  DDD  "}, {"       ", "  GGG  ", "  GGG  ", "  GGG  ", "       ", "  DDD  ", "  DDD  "}};

    public GT_TileEntity_Silksong(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_Silksong(String aName) {
        super(aName);
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    public void setCoilLevel(HeatingCoilLevel coilLevel) {
        this.coilLevel = coilLevel;
    }

    public int getCoilTier() {
        return TstUtils.getVoltageForCoil(this.coilLevel);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("piece", this.piece);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.piece = aNBT.func_74762_e("piece");
    }

    @Override
    public int getWirelessModeProcessingTime() {
        return 188;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.wiremillRecipes;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.coilLevel = HeatingCoilLevel.None;
        this.piece = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 5, 0)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 3, 5, 0 - this.piece * 2 - 2)) {
            ++this.piece;
        }
        if (this.piece < 1 || !this.checkPiece(STRUCTURE_PIECE_END, 3, 5, 0 - this.piece * 2 - 2)) {
            return false;
        }
        this.maxParallel = (int)Math.min((long)this.piece * (long)this.getCoilTier() * (long)Config.Parallel_PerPiece_Silksong, Integer.MAX_VALUE);
        this.speedBonus = (float)(Math.pow(Config.SpeedBonus_MultiplyPerVoltageTier_Silksong, this.getTotalPowerTier()) / (double)((float)this.getCoilTier() * Config.SpeedMultiplier_CoilTier_Silksong));
        if (this.piece >= 94) {
            this.enablePerfectOverclock = true;
            this.wirelessMode = this.mEnergyHatches.isEmpty() && this.mExoticEnergyHatches.isEmpty();
        } else {
            this.enablePerfectOverclock = false;
            this.wirelessMode = false;
        }
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int piece = stackSize.field_77994_a;
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 5, 0);
        for (int pointer = 1; pointer <= piece; ++pointer) {
            this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 3, 5, 0 - pointer * 2);
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 3, 5, 0 - piece * 2 - 2);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int[] built = new int[stackSize.field_77994_a + 2];
        built[0] = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 5, 0, elementBudget, env, false, true);
        int piece = stackSize.field_77994_a;
        for (int pointer = 1; pointer <= piece; ++pointer) {
            built[pointer] = this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 3, 5, 0 - pointer * 2, elementBudget, env, false, true);
        }
        built[built.length - 1] = this.survivialBuildPiece(STRUCTURE_PIECE_END, stackSize, 3, 5, 0 - piece * 2 - 2, elementBudget, env, false, true);
        return TstUtils.multiBuildPiece(built);
    }

    public IStructureDefinition<GT_TileEntity_Silksong> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, this.shapeMain).addShape(STRUCTURE_PIECE_MIDDLE, this.shapeMiddle).addShape(STRUCTURE_PIECE_END, this.shapeEnd).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('C', StructureUtility.withChannel((String)"coil", (IStructureElement)GTStructureUtility.ofCoil(GT_TileEntity_Silksong::setCoilLevel, GT_TileEntity_Silksong::getCoilLevel))).addElement('D', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GT_TileEntity_Silksong::addToMachineList).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(2)).buildAndChain(GregTechAPI.sBlockCasings8, 2)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('F', StructureUtility.ofBlock((Block)Loaders.pressureResistantWalls, (int)0)).addElement('G', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.OutputHatch}).adder(GT_TileEntity_Silksong::addToMachineList).dot(2).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(7)).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('H', GTStructureUtility.ofFrame((Materials)Materials.Neutronium)).addElement('I', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch}).adder(GT_TileEntity_Silksong::addToMachineList).dot(3).casingIndex(((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(11)).buildAndChain(GregTechAPI.sBlockCasings1, 11)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_Silksong_MachineType).addInfo(TextLocalization.Tooltip_Silksong_00).addInfo(TextLocalization.Tooltip_Silksong_01).addInfo(TextLocalization.Tooltip_Silksong_02).addInfo(TextLocalization.Tooltip_Silksong_03).addInfo(TextLocalization.Tooltip_Silksong_04).addInfo(TextLocalization.Tooltip_Silksong_05).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInputHatch(TextLocalization.textUseBlueprint, new int[]{3}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{3}).addInputBus(TextLocalization.textUseBlueprint, new int[]{3}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{2}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).addStructureInfo(TextEnums.tr("Tooltip_Silksong_SilksongReleaseDate")).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_Silksong(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2))};
    }
}

