/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.CircuitGeneration.BWMetaItems;
import bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import bartworks.util.BWUtil;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch.TST_CircuitImprintHatch;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class TST_AdvCircuitAssemblyLine
extends GTCM_MultiMachineBase<TST_AdvCircuitAssemblyLine> {
    private static final int baseHorizontalOffSet = 0;
    private static final int baseVerticalOffSet = 1;
    private static final int baseDepthOffSet = 0;
    private static final String STRUCTURE_PIECE_MAIN = "mainAdvCAL";
    private static final String[][] shapeMain = new String[][]{{"       ", "DDDDDDD", "       "}, {"~GFFFFF", "EEEEEEE", "FFFFFFF"}, {"AAAAAAA", "CCCCCCC", "AAAAAAA"}, {"BBBBBBB", "BBBBBBB", "BBBBBBB"}};
    private static IStructureDefinition<TST_AdvCircuitAssemblyLine> STRUCTURE_DEFINITION;
    private static ItemStack circuitImprint;
    protected long maxVoltageAllow = 0L;
    ArrayList<TST_CircuitImprintHatch> mCircuitImprintHatches = new ArrayList();
    HashSet<NBTTagCompound> circuitType = new HashSet();

    public TST_AdvCircuitAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_AdvCircuitAssemblyLine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_AdvCircuitAssemblyLine(this.mName);
    }

    public IStructureDefinition<TST_AdvCircuitAssemblyLine> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shapeMain)).addElement('A', BWUtil.ofGlassTieredMixed((byte)4, (byte)127, (int)5)).addElement('B', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_AdvCircuitAssemblyLine.class).atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch}).adder(TST_AdvCircuitAssemblyLine::addToMachineList).casingIndex(16).dot(1).buildAndChain(GregTechAPI.sBlockCasings2, 0)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('D', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_AdvCircuitAssemblyLine.class).atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).casingIndex(16).dot(2).buildAndChain(GregTechAPI.sBlockCasings2, 6)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)9)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('G', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_AdvCircuitAssemblyLine.class).atLeast(new IHatchElement[]{CircuitImprintHatchElement.CircuitAccess}).dot(3).casingIndex(42).buildAndChain(GregTechAPI.sBlockCasings3, 10)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 0, 1, 0, elementBudget, env, false, true);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 0, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.mCircuitImprintHatches.clear();
        this.maxVoltageAllow = 0L;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 0, 1, 0)) {
            return false;
        }
        if (this.mCircuitImprintHatches.size() > 1) {
            return false;
        }
        if (!this.mExoticEnergyHatches.isEmpty()) {
            if (!this.mEnergyHatches.isEmpty()) {
                return false;
            }
            if (this.mExoticEnergyHatches.size() > 1) {
                return false;
            }
            if (((MTEHatch)this.mExoticEnergyHatches.get(0)).maxWorkingAmperesIn() > 64L) {
                return false;
            }
        } else if (this.mEnergyHatches.size() > 1) {
            return false;
        }
        this.maxVoltageAllow = this.getMaxInputVoltage();
        return this.maxVoltageAllow > 0L;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (circuitImprint == null) {
            circuitImprint = BWMetaItems.getCircuitParts().getStack(0, 0);
        }
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16;
    }

    public RecipeMap<?> getRecipeMap() {
        return GTCMRecipe.advCircuitAssemblyLineRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(BartWorksRecipeMaps.circuitAssemblyLineRecipes, GTCMRecipe.advCircuitAssemblyLineRecipes);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("maxVoltageAllow", this.maxVoltageAllow);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.maxVoltageAllow = aNBT.func_74763_f("maxVoltageAllow");
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addCircuitImprintHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof TST_CircuitImprintHatch) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mCircuitImprintHatches.add((TST_CircuitImprintHatch)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    public boolean isInputSeparationEnabled() {
        return false;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if ((long)recipe.mEUt > TST_AdvCircuitAssemblyLine.this.maxVoltageAllow) {
                    return CheckRecipeResultRegistry.insufficientPower((long)recipe.mEUt);
                }
                NBTTagCompound outputTag = CircuitImprintLoader.getTagFromStack((ItemStack)recipe.mOutputs[0]);
                ItemStack controllerStack = TST_AdvCircuitAssemblyLine.this.getControllerSlot();
                if (controllerStack != null && controllerStack.func_77969_a(circuitImprint) && controllerStack.field_77990_d.equals((Object)outputTag)) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                TST_AdvCircuitAssemblyLine.this.mCircuitImprintHatches.get(0).refreshImprint();
                TST_AdvCircuitAssemblyLine.this.circuitType = TST_AdvCircuitAssemblyLine.this.mCircuitImprintHatches.get(0).getStoredCircuitImprints();
                if (TST_AdvCircuitAssemblyLine.this.circuitType.contains(outputTag)) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
        }.enablePerfectOverclock().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    public boolean onRunningTick(ItemStack aStack) {
        for (TST_CircuitImprintHatch hatch_circuitImprint : this.mCircuitImprintHatches) {
            hatch_circuitImprint.setActive(true);
        }
        return super.onRunningTick(aStack);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine_MachineType")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine_Controller")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.1")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.2")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.3")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.4")).addInfo(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.5")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{2}).addInputBus(TextLocalization.textUseBlueprint, new int[]{1}).addInputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textEndSides, new int[]{1}).addOtherStructurePart(TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.6"), TextEnums.tr("Tooltip_AdvCircuitAssemblyLine.7"), new int[]{3}).addStructureInfo(TextLocalization.Text_SeparatingLine).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    private static enum CircuitImprintHatchElement implements IHatchElement<TST_AdvCircuitAssemblyLine>
    {
        CircuitAccess;


        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(TST_CircuitImprintHatch.class);
        }

        public IGTHatchAdder<TST_AdvCircuitAssemblyLine> adder() {
            return TST_AdvCircuitAssemblyLine::addCircuitImprintHatchToMachineList;
        }

        public long count(TST_AdvCircuitAssemblyLine t) {
            return t.mCircuitImprintHatches.size();
        }
    }
}

