/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TST_BeeEngineer
extends GTCM_MultiMachineBase<TST_BeeEngineer> {
    private static FluidStack HONEY;
    private static FluidStack UUM;
    private static final String STRUCTURE_PIECE_MAIN = "STRUCTURE_PIECE_MAIN_BE";
    private final int hOffset = 1;
    private final int vOffset = 1;
    private final int dOffset = 0;
    private static final int CASING_INDEX = 10;
    private static IStructureDefinition<TST_BeeEngineer> STRUCTURE_DEF;
    protected final String[][] STRUCTURE = new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C C", "CCC"}, {"CCC", "CCC", "CCC"}};

    public TST_BeeEngineer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_BeeEngineer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_BeeEngineer(this.mName);
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (HONEY == null) {
            HONEY = Materials.Honey.getFluid(1L);
        }
        if (UUM == null) {
            UUM = Materials.UUMatter.getFluid(1L);
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList inputStacks = this.getStoredInputs();
        ArrayList inputFluid = this.getStoredFluids();
        if (inputStacks.isEmpty() || inputFluid.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        ArrayList<FluidStack> honeyStacks = new ArrayList<FluidStack>();
        boolean honeyEnough = false;
        ArrayList<FluidStack> uuStacks = new ArrayList<FluidStack>();
        boolean uuProvided = false;
        long honeyAmount = 0L;
        long uuAmount = 0L;
        for (FluidStack fluidStack : inputFluid) {
            if (fluidStack == null || fluidStack.amount < 1) continue;
            if (!honeyEnough && fluidStack.isFluidEqual(HONEY)) {
                honeyStacks.add(fluidStack);
                if ((honeyAmount += (long)fluidStack.amount) >= (long)ValueEnum.BE_pHoneyCost) {
                    honeyEnough = true;
                }
            }
            if (!uuProvided && fluidStack.isFluidEqual(UUM)) {
                uuStacks.add(fluidStack);
                if ((uuAmount += (long)fluidStack.amount) >= (long)ValueEnum.BE_pUUMCost) {
                    uuProvided = true;
                }
            }
            if (!honeyEnough || !uuProvided) continue;
            break;
        }
        if (!honeyEnough) {
            if (honeyAmount == 0L) {
                return CheckRecipeResultRegistry.NO_FUEL_FOUND;
            }
            return CheckRecipeResultRegistry.insufficientStartupPower((int)((int)((long)ValueEnum.BE_pHoneyCost - honeyAmount)));
        }
        for (ItemStack itemStack : inputStacks) {
            if (itemStack == null || itemStack.field_77994_a < 1 || BeeManager.beeRoot.getType(itemStack) != EnumBeeType.DRONE) continue;
            int needHoney = ValueEnum.BE_pHoneyCost;
            for (FluidStack honeyStack : honeyStacks) {
                if (honeyStack.amount >= needHoney) {
                    honeyStack.amount -= needHoney;
                    needHoney = 0;
                    break;
                }
                if (honeyStack.amount <= 0) continue;
                needHoney -= honeyStack.amount;
                honeyStack.amount = 0;
            }
            if (needHoney > 0) {
                return CheckRecipeResultRegistry.INTERNAL_ERROR;
            }
            double successRate = ValueEnum.BE_pChance;
            if (uuProvided) {
                int needUU = ValueEnum.BE_pUUMCost;
                for (FluidStack uuStack : uuStacks) {
                    if (uuStack.amount >= needUU) {
                        uuStack.amount -= needUU;
                        needUU = 0;
                        break;
                    }
                    if (uuStack.amount <= 0) continue;
                    needUU -= uuStack.amount;
                    uuStack.amount = 0;
                }
                if (needUU == 0) {
                    successRate = ValueEnum.BE_pChanceEnhanced;
                }
            }
            --itemStack.field_77994_a;
            if (Math.random() <= successRate) {
                IBee bee = BeeManager.beeRoot.getMember(itemStack);
                this.mOutputItems = new ItemStack[]{BeeManager.beeRoot.getMemberStack(bee.copy(), EnumBeeType.PRINCESS.ordinal())};
            }
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = ValueEnum.BE_pEachProcessTime;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    public IStructureDefinition<TST_BeeEngineer> getStructureDefinition() {
        if (STRUCTURE_DEF == null) {
            STRUCTURE_DEF = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])this.STRUCTURE)).addElement('C', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(10).buildAndChain(GregTechAPI.sBlockCasings1, 10)).build();
        }
        return STRUCTURE_DEF;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_BeeEngineer_Type).addInfo(TextLocalization.Tooltip_BeeEngineer_Controller).addInfo(TextLocalization.Tooltip_BeeEngineer_01).addInfo(TextLocalization.Tooltip_BeeEngineer_02).addInfo(TextLocalization.Tooltip_BeeEngineer_03).addInfo(TextLocalization.Tooltip_BeeEngineer_04).addInfo(TextLocalization.Tooltip_BeeEngineer_05).addInfo(TextLocalization.Tooltip_BeeEngineer_06).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInputBus(TextLocalization.BLUE_PRINT_INFO).addInputHatch(TextLocalization.BLUE_PRINT_INFO).addOutputBus(TextLocalization.BLUE_PRINT_INFO).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10)};
    }

    static {
        STRUCTURE_DEF = null;
    }
}

