/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import advsolar.common.AdvancedSolarPanel;
import advsolar.common.tiles.TileEntitySolarPanel;
import bartworks.API.BorosilicateGlass;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.network.TST_Network;
import com.Nxer.TwistSpaceTechnology.util.MathUtils;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.dreammaster.item.NHItemList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.supsolpans.MainSSP;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.block.BlockSolars;
import emt.tile.solar.Solars;
import emt.tile.solar.TileEntitySolarBase;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.recipe.Scanning;
import gregtech.common.blocks.BlockCasingsAbstract;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.basic.MTEMassfabricator;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.recipe.TTRecipeAdder;
import tectech.thing.CustomItemList;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class TST_BigBroArray
extends TT_MultiMachineBase_EM
implements ISurvivalConstructable {
    private ItemStack machines;
    private long maxParallelism = 256L;
    private long actualParallelism = 256L;
    private int machineCountForMaxParallelism = 256;
    private String machineType = null;
    private int machineTier = -1;
    private int glassTier = -2;
    private int frameTier = -1;
    private HeatingCoilLevel coilTier = HeatingCoilLevel.None;
    private int parallelismTier = 0;
    private int casingTier = -1;
    private int addonCount = 0;
    private String mode;
    private static final String MODE_GENERATOR = "generator";
    private static final String MODE_PROCESSOR = "processor";
    private TileEntity generatorTE;
    private UUID ownerUUID;
    private boolean isWirelessMode = false;
    private BigInteger output = BigInteger.valueOf(0L);
    private BigInteger outEUt = BigInteger.valueOf(0L);
    private int casingMultiplier;
    private static String[] tierNames = new String[]{"LV", "MV", "HV", "EV", "IV", "LuV", "ZPM", "UV", "UHV", "UEV", "UIV", "UMV", "UXV", "MAX"};
    private static String[] tierNamesCasing = new String[]{"LV", "MV", "HV", "EV", "IV", "LuV", "ZPM", "UV", "MAX", "UEV", "UIV", "UMV", "UXV"};
    @SideOnly(value=Side.CLIENT)
    public static ITexture[] DEFAULT_FRONT_ACTIVE;
    @SideOnly(value=Side.CLIENT)
    public static ITexture[] DEFAULT_FRONT_IDLE;
    @SideOnly(value=Side.CLIENT)
    private static ITexture[] DEFAULT_CASING_TEXTURE;
    public static final String[][] PROCESSING_MACHINE_LIST;
    private static final DecimalFormat Out_Format;
    private static final String[][] PATTERN_CORE;
    private static final String[][] PATTERN_ADDON;
    private static final String[][] PATTERN_ADDON_90_CW;
    private static final String[][] PATTERN_ADDON_90_CCW;
    private static final String[][] PATTERN_ADDON_180;
    public static final Map<String, String> overlayMapping;
    public static final Map<String, Field> recipeBackendRefMapping;
    public static final Map<String, ItemStack[]> GENERATORS;
    public static final String[] GENERATOR_TYPES;
    private static final Map<String, float[]> GENERATOR_EFFICIENCY;
    private static List<Pair<Block, Integer>> FRAMES;
    private static List<Pair<Block, Integer>> PARALLELISM_CASINGS;
    private static List<Pair<Block, Integer>> MACHINE_CASINGS;
    private static IStructureDefinition<TST_BigBroArray> STRUCTURE_DEFINITION;
    @SideOnly(value=Side.CLIENT)
    private ITexture[] activeTextures;
    @SideOnly(value=Side.CLIENT)
    private ITexture[] idleTextures;

    public static void initializeMaterials() {
        MACHINE_CASINGS = IntStream.range(0, tierNamesCasing.length).mapToObj(i -> Pair.of((Object)i, (Object)tierNamesCasing[i])).map(pair -> {
            String name = "Casing_" + (String)pair.getValue();
            try {
                ItemStack itemStack = ItemList.valueOf((String)name).get(1L, new Object[0]);
                int level = itemStack.func_77960_j();
                return Pair.of((Object)Block.func_149634_a((Item)itemStack.func_77973_b()), (Object)level);
            }
            catch (Exception ex) {
                ItemStack itemStack = com.dreammaster.gthandler.CustomItemList.valueOf((String)name).get(1L, new Object[0]);
                int level = itemStack.func_77960_j();
                return Pair.of((Object)Block.func_149634_a((Item)itemStack.func_77973_b()), (Object)level);
            }
            catch (IllegalAccessError error) {
                TwistSpaceTechnology.LOG.warn("TST BigBroArray An error has occurred: {}", new Object[]{error.getMessage()});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        FRAMES = Arrays.asList(Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.ARCANITE.getFrameBox(1).func_77973_b()), (Object)0), Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.ZERON_100.getFrameBox(1).func_77973_b()), (Object)0), Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.PIKYONIUM.getFrameBox(1).func_77973_b()), (Object)0), Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.BOTMIUM.getFrameBox(1).func_77973_b()), (Object)0), Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.ABYSSAL.getFrameBox(1).func_77973_b()), (Object)0), Pair.of((Object)Block.func_149634_a((Item)MaterialsAlloy.QUANTUM.getFrameBox(1).func_77973_b()), (Object)0));
        PARALLELISM_CASINGS = Arrays.asList(Pair.of((Object)Block.func_149634_a((Item)GTCMItemList.ParallelismCasing0.get(1, new Object[0]).func_77973_b()), (Object)3), Pair.of((Object)Block.func_149634_a((Item)GTCMItemList.ParallelismCasing1.get(1, new Object[0]).func_77973_b()), (Object)4), Pair.of((Object)Block.func_149634_a((Item)GTCMItemList.ParallelismCasing2.get(1, new Object[0]).func_77973_b()), (Object)5), Pair.of((Object)Block.func_149634_a((Item)GTCMItemList.ParallelismCasing3.get(1, new Object[0]).func_77973_b()), (Object)6), Pair.of((Object)Block.func_149634_a((Item)GTCMItemList.ParallelismCasing4.get(1, new Object[0]).func_77973_b()), (Object)7));
    }

    public static void registerUUForArray() {
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)24)}).fluidOutputs(new FluidStack[]{Materials.UUMatter.getFluid(1L)}).eut(MTEMassfabricator.BASE_EUT).duration(MTEMassfabricator.sDurationMultiplier).addTo((IRecipeMap)RecipeMaps.massFabFakeRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)23)}).fluidInputs(new FluidStack[]{Materials.UUAmplifier.getFluid((long)MTEMassfabricator.sUUAperUUM)}).fluidOutputs(new FluidStack[]{Materials.UUMatter.getFluid(1L)}).eut(MTEMassfabricator.BASE_EUT).duration(MTEMassfabricator.sDurationMultiplier / MTEMassfabricator.sUUASpeedBonus).addTo((IRecipeMap)RecipeMaps.massFabFakeRecipes);
    }

    public static void getGeneratorsForArray() {
        GENERATORS.put("Diesel", new ItemStack[]{ItemList.Generator_Diesel_LV.get(1L, new Object[0]), ItemList.Generator_Diesel_MV.get(1L, new Object[0]), ItemList.Generator_Diesel_HV.get(1L, new Object[0]), Loaders.Generator_Diesel[0], Loaders.Generator_Diesel[1]});
        GENERATORS.put("Steam_Turbine", new ItemStack[]{ItemList.Generator_Steam_Turbine_LV.get(1L, new Object[0]), ItemList.Generator_Steam_Turbine_MV.get(1L, new Object[0]), ItemList.Generator_Steam_Turbine_HV.get(1L, new Object[0])});
        GENERATORS.put("Gas_Turbine", new ItemStack[]{ItemList.Generator_Gas_Turbine_LV.get(1L, new Object[0]), ItemList.Generator_Gas_Turbine_MV.get(1L, new Object[0]), ItemList.Generator_Gas_Turbine_HV.get(1L, new Object[0]), ItemList.Generator_Gas_Turbine_EV.get(1L, new Object[0]), ItemList.Generator_Gas_Turbine_IV.get(1L, new Object[0])});
        GENERATORS.put("Semi_Fluid", new ItemStack[]{GregtechItemList.Generator_SemiFluid_LV.get(1L, new Object[0]), GregtechItemList.Generator_SemiFluid_MV.get(1L, new Object[0]), GregtechItemList.Generator_SemiFluid_HV.get(1L, new Object[0]), GregtechItemList.Generator_SemiFluid_EV.get(1L, new Object[0]), GregtechItemList.Generator_SemiFluid_IV.get(1L, new Object[0])});
        GENERATORS.put("Naquadah", new ItemStack[]{ItemList.Generator_Naquadah_Mark_I.get(1L, new Object[0]), ItemList.Generator_Naquadah_Mark_II.get(1L, new Object[0]), ItemList.Generator_Naquadah_Mark_III.get(1L, new Object[0]), ItemList.Generator_Naquadah_Mark_IV.get(1L, new Object[0]), ItemList.Generator_Naquadah_Mark_V.get(1L, new Object[0])});
        GENERATORS.put("ASP_Solar", new ItemStack[]{new ItemStack(ItemBlock.func_150898_a((Block)AdvancedSolarPanel.blockAdvSolarPanel), 1), new ItemStack(ItemBlock.func_150898_a((Block)AdvancedSolarPanel.blockAdvSolarPanel), 1, 1), new ItemStack(ItemBlock.func_150898_a((Block)AdvancedSolarPanel.blockAdvSolarPanel), 1, 2), new ItemStack(ItemBlock.func_150898_a((Block)AdvancedSolarPanel.blockAdvSolarPanel), 1, 3), new ItemStack(MainSSP.BlockSpectralSP, 1), new ItemStack(MainSSP.BlockSingularSP, 1), new ItemStack(MainSSP.BlockAdminSP, 1), new ItemStack(MainSSP.BlockPhotonSP, 1)});
        ArrayList<ItemStack> EMTSolars = new ArrayList<ItemStack>();
        for (int i = 0; i < Solars.getCountOfInstances(); ++i) {
            BlockSolars emtSolars = i == 0 ? (BlockSolars)GameRegistry.findBlock((String)"EMT", (String)"EMTSolars") : (BlockSolars)GameRegistry.findBlock((String)"EMT", (String)("EMTSolars" + (i + 1)));
            for (int meta = 0; meta < emtSolars.countOfMetas; ++meta) {
                EMTSolars.add(new ItemStack((Block)emtSolars, 1, meta));
            }
        }
        GENERATORS.put("EMT_Solar", EMTSolars.toArray(new ItemStack[0]));
    }

    public static int getFrameTier(Block block, int meta) {
        for (int i = 0; i < FRAMES.size(); ++i) {
            if (block != FRAMES.get(i).getKey()) continue;
            return i + 1;
        }
        return 0;
    }

    public static Integer getParallelismCasingTier(Block block, int meta) {
        if (block == GTCMItemList.ParallelismCasing0.getBlock()) {
            return meta - 2;
        }
        return null;
    }

    public void setCoilTier(HeatingCoilLevel level) {
        this.coilTier = this.coilTier != HeatingCoilLevel.None ? (level.getTier() < this.coilTier.getTier() ? level : this.coilTier) : level;
    }

    public HeatingCoilLevel getCoilTier() {
        return this.coilTier;
    }

    public void setCasingTier(int casingTier) {
        this.casingTier = this.casingTier >= 0 ? Math.min(casingTier, this.casingTier) : casingTier;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public static void initializeStructure() {
        int j;
        int i;
        for (i = 0; i < PATTERN_ADDON.length; ++i) {
            for (j = 0; j < PATTERN_ADDON[i].length; ++j) {
                TST_BigBroArray.PATTERN_ADDON[i][j] = PATTERN_ADDON[i][j].replace('A', 'G').replace('B', 'H').replace('C', 'I').replace('D', 'J').replace('E', 'K').replace('F', 'L');
            }
        }
        for (i = 0; i < PATTERN_ADDON.length; ++i) {
            for (j = 0; j < PATTERN_ADDON[0].length; ++j) {
                TST_BigBroArray.PATTERN_ADDON_180[i][j] = StringUtils.reverse((String)PATTERN_ADDON[i][j]);
            }
        }
        for (i = 0; i < PATTERN_ADDON.length; ++i) {
            for (int k = 0; k < PATTERN_ADDON[0][0].length(); ++k) {
                String rotated = "";
                for (int j2 = 0; j2 < PATTERN_ADDON[0].length; ++j2) {
                    rotated = rotated + PATTERN_ADDON[i][j2].charAt(k);
                }
                TST_BigBroArray.PATTERN_ADDON_90_CW[i][k] = rotated;
            }
        }
        for (i = 0; i < PATTERN_ADDON_90_CW.length; ++i) {
            for (j = 0; j <= PATTERN_ADDON_90_CW.length / 2; ++j) {
                TST_BigBroArray.PATTERN_ADDON_90_CCW[i][j] = PATTERN_ADDON_90_CW[i][PATTERN_ADDON_90_CW[0].length - 1 - j];
                TST_BigBroArray.PATTERN_ADDON_90_CCW[i][TST_BigBroArray.PATTERN_ADDON_90_CW[0].length - 1 - j] = PATTERN_ADDON_90_CW[i][j];
            }
        }
        StructureDefinition.Builder builder = StructureDefinition.builder().addShape("core", StructureUtility.transpose((String[][])PATTERN_CORE)).addElement('D', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Maintenance, HatchElement.InputBus.or((IHatchElement)HatchElement.InputHatch), HatchElement.OutputBus.or((IHatchElement)HatchElement.OutputHatch), HatchElement.Muffler}).adder(TTMultiblockBase::addToMachineList).dot(1).casingIndex(((BlockCasingsAbstract)GregTechAPI.sBlockCasings4).getTextureIndex(0)).buildAndChain(GregTechAPI.sBlockCasings4, 0)).addElement('A', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-2, (te, tier) -> {
            te.glassTier = te.glassTier >= 0 ? Math.min(tier.byteValue(), te.glassTier) : tier;
        }, te -> (byte)te.glassTier))).addElement('B', StructureUtility.withChannel((String)"frame", (IStructureElement)StructureUtility.ofBlocksTiered(TST_BigBroArray::getFrameTier, FRAMES, (Object)-1, (te, tier) -> {
            te.frameTier = te.frameTier >= 0 ? Math.min(tier, te.frameTier) : tier;
        }, te -> te.frameTier))).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('F', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{TTMultiblockBase.HatchElement.DynamoMulti.or((IHatchElement)HatchElement.ExoticEnergy).or((IHatchElement)HatchElement.Dynamo)}).adder(TTMultiblockBase::addToMachineList).dot(2).casingIndex(((BlockCasingsAbstract)GregTechAPI.sBlockCasings4).getTextureIndex(1)).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('C', StructureUtility.withChannel((String)"casing", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> meta, MACHINE_CASINGS, (Object)-1, TST_BigBroArray::setCasingTier, TST_BigBroArray::getCasingTier)));
        List strings = Arrays.asList(new String[][][]{PATTERN_ADDON, PATTERN_ADDON_90_CW, PATTERN_ADDON_180, PATTERN_ADDON_90_CCW});
        for (int i2 = 0; i2 < strings.size(); ++i2) {
            String[][] pattern = (String[][])strings.get(i2);
            builder = builder.addShape("addon" + i2, StructureUtility.transpose((String[][])pattern)).addElement('I', StructureUtility.withChannel((String)"coil", (IStructureElement)GTStructureUtility.ofCoil(TST_BigBroArray::setCoilTier, TST_BigBroArray::getCoilTier))).addElement('H', StructureUtility.withChannel((String)"frame", (IStructureElement)StructureUtility.ofBlocksTiered(TST_BigBroArray::getFrameTier, FRAMES, (Object)-1, (te, tier) -> {
                te.frameTier = te.frameTier >= 0 ? Math.min(tier, te.frameTier) : tier;
            }, te -> te.frameTier))).addElement('K', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)-1, (te, tier) -> {
                te.glassTier = te.glassTier >= 0 ? Math.min(tier.byteValue(), te.glassTier) : tier;
            }, te -> (byte)te.glassTier))).addElement('G', StructureUtility.withChannel((String)"parallelism", (IStructureElement)StructureUtility.ofBlocksTiered(TST_BigBroArray::getParallelismCasingTier, PARALLELISM_CASINGS, (Object)0, (te, tier) -> {
                te.parallelismTier = Math.max(tier, te.parallelismTier);
            }, te -> te.parallelismTier))).addElement('L', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('J', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5));
        }
        STRUCTURE_DEFINITION = builder.build();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initializeDefaultTextures() {
        DEFAULT_FRONT_ACTIVE = new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings4, (int)0)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
        DEFAULT_FRONT_IDLE = new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings4, (int)0)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        DEFAULT_CASING_TEXTURE = new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings4, (int)0))};
    }

    @SideOnly(value=Side.CLIENT)
    private ITexture[] getActiveTextures(String machineType) {
        if (StringUtils.isEmpty((CharSequence)machineType)) {
            return DEFAULT_FRONT_ACTIVE;
        }
        String overlay = overlayMapping.get(machineType);
        if (overlay == null) {
            return DEFAULT_FRONT_ACTIVE;
        }
        String front = String.format("basicmachines/%s/OVERLAY_FRONT_ACTIVE", overlay);
        String frontGlow = String.format("basicmachines/%s/OVERLAY_FRONT_ACTIVE_GLOW", overlay);
        Textures.BlockIcons.CustomIcon frontIcon = new Textures.BlockIcons.CustomIcon(front);
        frontIcon.run();
        Textures.BlockIcons.CustomIcon frontGlowIcon = new Textures.BlockIcons.CustomIcon(frontGlow);
        frontGlowIcon.run();
        return new ITexture[]{TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_ROBUST_TUNGSTENSTEEL).build(), TextureFactory.builder().addIcon((IIconContainer)frontIcon).build(), TextureFactory.builder().addIcon((IIconContainer)frontGlowIcon).glow().build()};
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick_EM(aBaseMetaTileEntity);
        this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
    }

    @SideOnly(value=Side.CLIENT)
    private ITexture[] getIdleTextures(String machineType) {
        if (StringUtils.isEmpty((CharSequence)machineType)) {
            return DEFAULT_FRONT_IDLE;
        }
        String overlay = overlayMapping.get(machineType);
        if (overlay == null) {
            return DEFAULT_FRONT_IDLE;
        }
        String front = String.format("basicmachines/%s/OVERLAY_FRONT", overlay);
        String frontGlow = String.format("basicmachines/%s/OVERLAY_FRONT_GLOW", overlay);
        Textures.BlockIcons.CustomIcon frontIcon = new Textures.BlockIcons.CustomIcon(front);
        frontIcon.run();
        Textures.BlockIcons.CustomIcon frontGlowIcon = new Textures.BlockIcons.CustomIcon(frontGlow);
        frontGlowIcon.run();
        return new ITexture[]{TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_ROBUST_TUNGSTENSTEEL).build(), TextureFactory.builder().addIcon((IIconContainer)frontIcon).build(), TextureFactory.builder().addIcon((IIconContainer)frontGlowIcon).glow().build()};
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.machineType != null) {
            aNBT.func_74778_a("machineType", this.machineType);
        }
        aNBT.func_74768_a("tier", this.machineTier);
        aNBT.func_74772_a("maxParallelism", this.maxParallelism);
        aNBT.func_74772_a("actualParallelism", this.actualParallelism);
        if (this.mode != null) {
            aNBT.func_74778_a("mode", this.mode);
        }
        if (this.generatorTE != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.generatorTE.func_145841_b(compound);
            aNBT.func_74782_a("solarTE", (NBTBase)compound);
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        if (this.machines != null) {
            nbtTagCompound.func_74777_a("id", (short)Item.func_150891_b((Item)this.machines.func_77973_b()));
            nbtTagCompound.func_74768_a("Count", this.machines.field_77994_a);
            nbtTagCompound.func_74777_a("Damage", (short)this.machines.func_77960_j());
            if (this.machines.func_77978_p() != null) {
                nbtTagCompound.func_74782_a("tag", (NBTBase)this.machines.func_77978_p());
            }
        }
        if (this.ownerUUID != null) {
            aNBT.func_74778_a("owner", this.ownerUUID.toString());
        }
        aNBT.func_74782_a("machines", (NBTBase)nbtTagCompound);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        NBTTagCompound compound;
        super.loadNBTData(aNBT);
        this.machineType = aNBT.func_74779_i("machineType");
        this.mode = aNBT.func_74779_i("mode");
        this.machineTier = aNBT.func_74762_e("tier");
        this.maxParallelism = aNBT.func_74763_f("maxParallelism");
        this.actualParallelism = aNBT.func_74763_f("actualParallelism");
        if (aNBT.func_74764_b("machines")) {
            compound = aNBT.func_74775_l("machines");
            ItemStack itemStack = new ItemStack(Item.func_150899_d((int)compound.func_74765_d("id")));
            itemStack.field_77994_a = compound.func_74762_e("Count");
            itemStack.func_77964_b((int)compound.func_74765_d("Damage"));
            if (compound.func_74764_b("tag")) {
                itemStack.func_77982_d(compound.func_74775_l("tag"));
            }
            this.machines = itemStack;
        }
        if (aNBT.func_74764_b("solarTE")) {
            compound = aNBT.func_74775_l("solarTE");
            this.generatorTE = Block.func_149634_a((Item)this.machines.func_77973_b()).createTileEntity(null, this.machines.func_77960_j());
            this.generatorTE.func_145839_a(compound);
        }
        if (aNBT.func_74764_b("owner")) {
            this.ownerUUID = UUID.fromString(aNBT.func_74779_i("owner"));
        }
    }

    public TST_BigBroArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.useLongPower = true;
    }

    public TST_BigBroArray(String aName) {
        super(aName);
        this.useLongPower = true;
    }

    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    protected ProcessingLogic createProcessingLogic() {
        TstProcessingLogic gtcm_processingLogic = new TstProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                return (double)recipe.mEUt <= 8.0 * Math.pow(4.0, TST_BigBroArray.this.machineTier) ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientMachineTier((int)((int)(Math.log(recipe.mEUt) / Math.log(4.0))));
            }
        };
        gtcm_processingLogic.setMaxParallelSupplier(() -> this.machines != null ? (int)Math.min((double)this.machines.field_77994_a * Math.pow(2.0, this.parallelismTier), (double)this.maxParallelism) : 1);
        return gtcm_processingLogic;
    }

    private long getDieselFuelValue(FluidStack stack) {
        RecipeMapBackend recipeMapBackend;
        RecipeMap<?> tRecipes = this.getRecipeMap();
        if (stack == null || !((recipeMapBackend = tRecipes.getBackend()) instanceof FuelBackend)) {
            return 0L;
        }
        FuelBackend tFuels = (FuelBackend)recipeMapBackend;
        GTRecipe tFuel = tFuels.findFuel(stack);
        if (tFuel == null) {
            return 0L;
        }
        return tFuel.mSpecialValue;
    }

    private GTRecipe getNaquadahFuelRecipe(ItemStack stack) {
        if (GTUtility.isStackInvalid((ItemStack)stack) || this.getRecipeMap() == null) {
            return null;
        }
        GTRecipe tFuel = this.getRecipeMap().findRecipeQuery().items(new ItemStack[]{stack}).fluids(new FluidStack[0]).specialSlot(null).voltage(Long.MAX_VALUE).cachedRecipe(null).notUnificated(false).dontCheckStackSizes(false).find();
        return tFuel;
    }

    void consumeFuel(String machineType, FluidStack storedFluid, long liquidFuelValue) {
        float effiency = GENERATOR_EFFICIENCY.get(machineType)[this.machineTier - 1];
        long expectedGeneration = (8L << (int)((long)this.machineTier * 2L)) * this.actualParallelism * 20L;
        long energyInFuel = (long)((float)((long)storedFluid.amount * liquidFuelValue) * effiency);
        long fuelConsumption = (long)((float)(expectedGeneration / liquidFuelValue) / effiency);
        this.output = BigInteger.valueOf(Math.min(energyInFuel, expectedGeneration));
        storedFluid.amount = (int)Math.max(0L, (long)storedFluid.amount - fuelConsumption);
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        CheckRecipeResult result;
        this.startRecipeProcessing();
        if (MODE_PROCESSOR.equals(this.mode)) {
            result = super.checkProcessing_EM();
        } else if (MODE_GENERATOR.equals(this.mode)) {
            this.mMaxProgresstime = 20;
            if ("ASP_Solar".equals(this.machineType) || "EMT_Solar".equals(this.machineType)) {
                BigDecimal eut;
                int xCoord = this.getBaseMetaTileEntity().getXCoord();
                int yCoord = this.getBaseMetaTileEntity().getYCoord() + 4;
                int zCoord = this.getBaseMetaTileEntity().getZCoord();
                this.generatorTE.field_145851_c = xCoord;
                this.generatorTE.field_145848_d = yCoord;
                this.generatorTE.field_145849_e = zCoord;
                if (!this.generatorTE.func_145830_o()) {
                    this.generatorTE.func_145834_a(this.getBaseMetaTileEntity().getWorld());
                }
                double parallelismBlockBoost = Math.pow(1.5, this.parallelismTier);
                double coilBoost = Math.pow(1.1, this.coilTier.getTier());
                TileEntity tileEntity = this.generatorTE;
                if (tileEntity instanceof TileEntitySolarPanel) {
                    TileEntitySolarPanel te = (TileEntitySolarPanel)tileEntity;
                    te.func_145845_h();
                    eut = BigDecimal.valueOf(te.storage);
                    te.storage = 0;
                } else {
                    tileEntity = this.generatorTE;
                    if (tileEntity instanceof TileEntitySolarBase) {
                        TileEntitySolarBase te = (TileEntitySolarBase)tileEntity;
                        te.checkConditions();
                        te.func_145845_h();
                        eut = BigDecimal.valueOf(te.generating);
                        te.energySource.drawEnergy((double)te.energySource.getEnergyStored());
                    } else {
                        this.endRecipeProcessing();
                        return CheckRecipeResultRegistry.NO_RECIPE;
                    }
                }
                this.output = eut.multiply(BigDecimal.valueOf(parallelismBlockBoost)).multiply(BigDecimal.valueOf(coilBoost)).multiply(BigDecimal.valueOf(this.actualParallelism)).multiply(BigDecimal.valueOf(20L)).toBigInteger();
                result = CheckRecipeResultRegistry.SUCCESSFUL;
            } else if ("Diesel".equals(this.machineType) || "Semi_Fluid".equals(this.machineType) || "Gas_Turbine".equals(this.machineType)) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                for (FluidStack storedFluid : this.getStoredFluids()) {
                    long liquidFuelValue = this.getDieselFuelValue(storedFluid);
                    if (liquidFuelValue <= 0L) continue;
                    this.consumeFuel(this.machineType, storedFluid, liquidFuelValue);
                    result = CheckRecipeResultRegistry.SUCCESSFUL;
                    break;
                }
            } else if ("Steam_Turbine".equals(this.machineType)) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                for (FluidStack storedFluid : this.getStoredFluids()) {
                    if (!GTModHandler.isAnySteam((FluidStack)storedFluid)) continue;
                    long liquidFuelValue = 3L;
                    this.consumeFuel(this.machineType, storedFluid, liquidFuelValue);
                    result = CheckRecipeResultRegistry.SUCCESSFUL;
                    break;
                }
            } else if ("Naquadah".equals(this.machineType)) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
                for (ItemStack storedInput : this.getStoredInputs()) {
                    GTRecipe recipe = this.getNaquadahFuelRecipe(storedInput);
                    if (recipe == null) continue;
                    long fuelValue = recipe.mSpecialValue * 1000;
                    for (ItemStack out : recipe.mOutputs) {
                        if (out == null) continue;
                        ItemStack stack = ItemStack.func_77944_b((ItemStack)out);
                        stack.field_77994_a = (int)Math.min(Math.min((long)storedInput.field_77994_a, this.actualParallelism), Integer.MAX_VALUE);
                        outputItems.add(stack);
                    }
                    float effiency = GENERATOR_EFFICIENCY.get("Naquadah")[this.machineTier - 4];
                    long machineEUt = (8L << (int)((long)this.machineTier * 2L)) * this.actualParallelism;
                    long expectedGeneration = (long)((float)fuelValue * effiency * (float)this.actualParallelism);
                    long energyInFuel = (long)((float)((long)storedInput.field_77994_a * fuelValue) * effiency);
                    long fuelConsumption = (long)((float)(expectedGeneration / fuelValue) / effiency);
                    this.output = BigInteger.valueOf(Math.min(energyInFuel, expectedGeneration));
                    this.mMaxProgresstime = MathUtils.bigToInt(this.output.divide(BigInteger.valueOf(machineEUt)));
                    storedInput.field_77994_a = (int)Math.max(0L, (long)storedInput.field_77994_a - fuelConsumption);
                    result = CheckRecipeResultRegistry.SUCCESSFUL;
                    break;
                }
                this.mOutputItems = outputItems.toArray(new ItemStack[0]);
            } else {
                result = CheckRecipeResultRegistry.NO_RECIPE;
            }
            if (result == CheckRecipeResultRegistry.SUCCESSFUL) {
                this.outEUt = this.output.divide(BigInteger.valueOf(this.mMaxProgresstime));
                if (this.isWirelessMode) {
                    if (this.ownerUUID == null) {
                        result = CheckRecipeResultRegistry.INTERNAL_ERROR;
                    } else {
                        this.lEUt = MathUtils.bigToLong(this.outEUt);
                        WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)this.output);
                    }
                } else {
                    long out = MathUtils.bigToLong(this.output);
                    this.lEUt = out / (long)this.mMaxProgresstime;
                    this.fillAllDynamos(out);
                }
            }
        } else {
            result = CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.endRecipeProcessing();
        return result;
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)screenElements.widget(new TextWidget(String.format("Generating: %sEU/t", Out_Format.format(this.outEUt))).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive() && MODE_GENERATOR.equals(this.mode)))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.mode, mode -> {
            this.mode = mode;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.outEUt.toString(), l -> {
            this.outEUt = new BigInteger((String)l);
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mMaxProgresstime, i -> {
            this.mMaxProgresstime = i;
        }));
        screenElements.widget(new TextWidget("Machine state: " + this.mode).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        ((Column)screenElements.widget(new TextWidget("Machine type:" + this.machineType).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.machineType, type -> {
            this.machineType = type;
        }));
        ((Column)screenElements.widget(new TextWidget("Machine tier:" + this.machineTier).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.machineTier, tier -> {
            this.machineTier = tier;
        }));
        ((Column)screenElements.widget(new TextWidget("Provided parallelism:" + this.actualParallelism).setDefaultColor(0xFFEF00).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.actualParallelism, p -> {
            this.actualParallelism = p;
        }));
        ((Column)screenElements.widget(new TextWidget("Speed boost:" + Math.pow(1.5, this.parallelismTier)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.parallelismTier, tier -> {
            this.parallelismTier = tier;
        }));
        ((Column)screenElements.widget(new TextWidget("Addons attached:" + this.addonCount).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.addonCount, ct -> {
            this.addonCount = ct;
        }));
    }

    private long fillAllDynamos(long energy) {
        long drain;
        for (MTEHatchDynamo dynamo : this.mDynamoHatches) {
            drain = Math.min(energy, dynamo.maxEUStore() - dynamo.getEUVar());
            energy -= drain;
            dynamo.setEUVar(dynamo.getEUVar() + drain);
        }
        for (MTEHatchDynamo dynamo : this.eDynamoMulti) {
            drain = Math.min(energy, dynamo.maxEUStore() - dynamo.getEUVar());
            energy -= drain;
            dynamo.setEUVar(dynamo.getEUVar() + drain);
        }
        return energy;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return super.getStructureDescription(stackSize);
    }

    protected MultiblockTooltipBuilder getTooltip() {
        MultiblockTooltipBuilder gt_multiblock_tooltip_builder = new MultiblockTooltipBuilder().addMachineType(TextEnums.BigBroArrayType.toString()).addInfo(TextEnums.BigBroArrayName.toString()).addInfo(TextEnums.BigBroArrayDesc1.toString()).addInfo(TextEnums.BigBroArrayDesc2.toString()).addInfo(TextEnums.BigBroArrayDesc3.toString()).addInfo(TextEnums.BigBroArrayDesc4.toString()).addInfo(TextEnums.BigBroArrayDesc5.toString()).addInfo(TextEnums.BigBroArrayDesc6.toString()).addInfo(TextEnums.BigBroArrayDesc7.toString()).addInfo(TextEnums.BigBroArrayDesc8.toString()).addInfo(TextEnums.BigBroArrayDesc9.toString()).addInfo(TextEnums.BigBroArrayDesc10.toString()).addInfo(TextEnums.BigBroArrayDesc11.toString()).addInfo(TextEnums.BigBroArrayDesc12.toString()).addInfo(TextEnums.StructureTooComplex.toString()).addInfo(TextLocalization.BLUE_PRINT_INFO);
        gt_multiblock_tooltip_builder.toolTipFinisher(new String[]{"Twist Space Technology"});
        return gt_multiblock_tooltip_builder;
    }

    public RecipeMap<?> getRecipeMap() {
        if (this.machines != null) {
            try {
                String key = "Naquadah".equals(this.machineType) ? this.machineType + "_" + (this.machineTier - 3) : this.machineType;
                Field field = recipeBackendRefMapping.get(key);
                if (field == null) {
                    return null;
                }
                RecipeMap o = (RecipeMap)field.get(null);
                return o;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.buildPiece("core", itemStack, hintsOnly, 5, 5, 4);
        int addonCount = Math.min(itemStack.field_77994_a - 1, 4);
        if (addonCount == 4) {
            this.buildPiece("addon3", itemStack, hintsOnly, 7, 23, 21);
            --addonCount;
        }
        if (addonCount == 3) {
            this.buildPiece("addon2", itemStack, hintsOnly, 22, 23, 6);
            --addonCount;
        }
        if (addonCount == 2) {
            this.buildPiece("addon1", itemStack, hintsOnly, 7, 23, -7);
            --addonCount;
        }
        if (addonCount == 1) {
            this.buildPiece("addon0", itemStack, hintsOnly, -6, 23, 6);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int blockPlacedCount = 0;
        if (!this.mMachine) {
            blockPlacedCount += this.survivialBuildPiece("core", stackSize, 5, 5, 4, elementBudget, env, true);
        } else {
            switch (this.addonCount) {
                case 0: {
                    blockPlacedCount += this.survivialBuildPiece("addon0", stackSize, -6, 23, 6, elementBudget, env, true);
                    break;
                }
                case 1: {
                    blockPlacedCount += this.survivialBuildPiece("addon1", stackSize, 7, 23, -7, elementBudget, env, true);
                    break;
                }
                case 2: {
                    blockPlacedCount += this.survivialBuildPiece("addon2", stackSize, 22, 23, 6, elementBudget, env, true);
                    break;
                }
                case 3: {
                    blockPlacedCount += this.survivialBuildPiece("addon2", stackSize, 7, 23, 21, elementBudget, env, true);
                    break;
                }
            }
        }
        return blockPlacedCount;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        return this.getTooltip();
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.repairMachine();
        this.casingTier = -1;
        this.glassTier = -2;
        this.coilTier = HeatingCoilLevel.None;
        this.frameTier = -1;
        boolean checkPiece = this.checkPiece("core", 5, 5, 4);
        if (!checkPiece) {
            return false;
        }
        if (this.mDynamoHatches.isEmpty() && this.eDynamoMulti.isEmpty() && this.casingTier >= 12) {
            this.isWirelessMode = true;
        } else {
            for (MTEHatchDynamo mDynamoHatch : this.mDynamoHatches) {
                if (this.casingTier >= 12 || mDynamoHatch.mTier <= this.casingTier) continue;
                return false;
            }
            for (MTEHatchDynamoMulti gt_metaTileEntity_hatch_dynamoMulti : this.eDynamoMulti) {
                if (this.casingTier >= 12 || gt_metaTileEntity_hatch_dynamoMulti.mTier <= this.casingTier && (!(gt_metaTileEntity_hatch_dynamoMulti instanceof MTEHatchDynamoTunnel) || this.casingTier >= 8)) continue;
                return false;
            }
        }
        for (MTEHatchEnergy mEnergyHatch : this.mEnergyHatches) {
            if (mEnergyHatch.mTier <= this.glassTier) continue;
            return false;
        }
        for (MTEHatchEnergyMulti gt_metaTileEntity_hatch_energyMulti : this.eEnergyMulti) {
            if (Math.min(gt_metaTileEntity_hatch_energyMulti.mTier, 12) <= this.glassTier && (!(gt_metaTileEntity_hatch_energyMulti instanceof MTEHatchEnergyTunnel) || this.glassTier >= 6)) continue;
            return false;
        }
        this.addonCount = 0;
        int p = 5;
        this.parallelismTier = 0;
        if (this.checkPiece("addon0", -6, 23, 6)) {
            ++this.addonCount;
            p = Math.min(this.parallelismTier, p);
        }
        this.parallelismTier = 0;
        if (this.checkPiece("addon1", 7, 23, -7)) {
            ++this.addonCount;
            p = Math.min(this.parallelismTier, p);
        }
        this.parallelismTier = 0;
        if (this.checkPiece("addon2", 22, 23, 6)) {
            ++this.addonCount;
            p = Math.min(this.parallelismTier, p);
        }
        this.parallelismTier = 0;
        if (this.checkPiece("addon3", 7, 23, 21)) {
            ++this.addonCount;
            p = Math.min(this.parallelismTier, p);
        }
        if (this.mMufflerHatches.size() <= 0) {
            return false;
        }
        this.parallelismTier = this.addonCount > 0 ? p : 0;
        this.maxParallelism = this.calculateMaxParallelismByAddonTier();
        this.casingMultiplier = this.parallelismTier > 3 ? this.parallelismTier + 6 : this.parallelismTier;
        this.machineCountForMaxParallelism = (int)(this.maxParallelism >> this.casingMultiplier);
        this.actualParallelism = this.calculateParallelismByAddonTier();
        this.processingLogic.setSpeedBonus((double)((float)Math.pow(0.66, this.parallelismTier)));
        this.processingLogic.setEuModifier((double)((float)Math.pow(0.9, Math.max(0, this.coilTier.getTier()))));
        return checkPiece;
    }

    private long calculateMaxParallelismByAddonTier() {
        if (this.addonCount > 0) {
            long infinity = Integer.MAX_VALUE << this.casingMultiplier;
            return this.parallelismTier >= 5 ? infinity / 5L * (long)(1 + this.addonCount) : (64L << this.parallelismTier * 2) * (long)(1 + this.addonCount);
        }
        return 64L;
    }

    private long calculateParallelismByAddonTier() {
        long stackSize = this.machines != null ? this.machines.field_77994_a : 0;
        int casingMultiplier = this.parallelismTier > 3 ? this.parallelismTier + 6 : this.parallelismTier;
        long p = stackSize << casingMultiplier;
        long m = this.calculateMaxParallelismByAddonTier();
        return Math.min(p, m);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_BigBroArray(this.mName);
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return (int)Math.min(this.actualParallelism, 10000L);
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        String message;
        this.machineType = null;
        this.startRecipeProcessing();
        int maxTier = this.frameTier >= 6 || this.addonCount == 0 ? 16 : this.frameTier + 4;
        MachineHintMessages hint = null;
        if (this.machines == null) {
            for (ItemStack storedInput : this.getStoredInputs()) {
                int i;
                for (String[] stringArray : PROCESSING_MACHINE_LIST) {
                    for (i = 0; i < tierNames.length; ++i) {
                        String tierName = tierNames[i];
                        String name = String.format("Machine_%s_%s", tierName, stringArray[0]);
                        ItemStack machineTypeToBeUsed = null;
                        try {
                            ItemList itemList = ItemList.valueOf((String)name);
                            machineTypeToBeUsed = itemList.get(1L, new Object[0]);
                        }
                        catch (IllegalArgumentException ex) {
                            name = String.format("%s%s", stringArray[1], tierName);
                            try {
                                ItemList itemList = ItemList.valueOf((String)name);
                                machineTypeToBeUsed = itemList.get(1L, new Object[0]);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        if (machineTypeToBeUsed == null || !GTUtility.areStacksEqual((ItemStack)machineTypeToBeUsed, (ItemStack)storedInput, (boolean)true)) continue;
                        if (i + 1 <= maxTier) {
                            if (this.machines != null) {
                                if (!GTUtility.areStacksEqual((ItemStack)this.machines, (ItemStack)storedInput)) continue;
                                int d = Math.min(this.machineCountForMaxParallelism - this.machines.field_77994_a, storedInput.field_77994_a);
                                this.machines.field_77994_a += d;
                                storedInput.field_77994_a -= d;
                                continue;
                            }
                            if (storedInput.field_77994_a <= 0) continue;
                            this.machines = storedInput.func_77946_l();
                            this.machines.field_77994_a = Math.min(this.machineCountForMaxParallelism, storedInput.field_77994_a);
                            storedInput.field_77994_a -= this.machines.field_77994_a;
                            this.machineType = stringArray[0];
                            this.machineTier = i + 1;
                            this.mode = MODE_PROCESSOR;
                            continue;
                        }
                        hint = MachineHintMessages.FAIL_TIER_MISMATCH;
                    }
                }
                for (String[] stringArray : GENERATOR_TYPES) {
                    for (i = 0; i < GENERATORS.get(stringArray).length; ++i) {
                        ItemStack machineTypeToBeUsed = GENERATORS.get(stringArray)[i];
                        if (!GTUtility.areStacksEqual((ItemStack)storedInput, (ItemStack)machineTypeToBeUsed, (boolean)true)) continue;
                        this.generatorTE = Block.func_149634_a((Item)machineTypeToBeUsed.func_77973_b()).createTileEntity(aPlayer.field_70170_p, machineTypeToBeUsed.func_77960_j());
                        int tier = "Naquadah".equals(stringArray) ? i + 4 : ("EMT_Solar".equals(stringArray) ? (int)Math.floor(Math.log(((TileEntitySolarBase)this.generatorTE).output / 8.0) / Math.log(4.0)) : i + 1);
                        if (tier <= maxTier) {
                            if (this.machines != null) {
                                if (!GTUtility.areStacksEqual((ItemStack)this.machines, (ItemStack)storedInput)) continue;
                                int d = Math.min(this.machineCountForMaxParallelism - this.machines.field_77994_a, storedInput.field_77994_a);
                                this.machines.field_77994_a += d;
                                storedInput.field_77994_a -= d;
                                continue;
                            }
                            if (storedInput.field_77994_a <= 0) continue;
                            this.mode = MODE_GENERATOR;
                            this.machines = storedInput.func_77946_l();
                            this.machines.field_77994_a = Math.min(this.machineCountForMaxParallelism, this.machines.field_77994_a);
                            storedInput.field_77994_a -= this.machines.field_77994_a;
                            this.machineType = stringArray;
                            if (this.generatorTE != null) {
                                this.generatorTE.func_145834_a(aPlayer.field_70170_p);
                            }
                            this.machineTier = tier;
                            continue;
                        }
                        hint = MachineHintMessages.FAIL_TIER_MISMATCH;
                    }
                }
            }
            if (this.machineType != null) {
                hint = MachineHintMessages.SUCCESS;
                this.actualParallelism = this.calculateParallelismByAddonTier();
                int xCoord = this.getBaseMetaTileEntity().getXCoord();
                short yCoord = this.getBaseMetaTileEntity().getYCoord();
                int zCoord = this.getBaseMetaTileEntity().getZCoord();
                TST_Network.tst.sendToAll((IMessage)new PackSyncMachineType(xCoord, yCoord, zCoord, this.machineType));
            } else if (hint == null) {
                hint = MachineHintMessages.FAIL_NON_ACCEPT;
            }
        } else {
            hint = MachineHintMessages.MACHINE_TO_OUTPUT;
            this.addOutput(this.machines);
            this.machines = null;
            this.generatorTE = null;
            this.mode = null;
            this.actualParallelism = 0L;
            int xCoord = this.getBaseMetaTileEntity().getXCoord();
            short yCoord = this.getBaseMetaTileEntity().getYCoord();
            int zCoord = this.getBaseMetaTileEntity().getZCoord();
            TST_Network.tst.sendToAll((IMessage)new PackSyncMachineType(xCoord, yCoord, zCoord, this.machineType));
        }
        switch (hint) {
            case FAIL_NON_ACCEPT: {
                message = String.format(hint.message, recipeBackendRefMapping.keySet());
                break;
            }
            case FAIL_TIER_MISMATCH: {
                message = String.format(hint.message, 8L << 2 * maxTier);
                break;
            }
            case SUCCESS: {
                message = String.format(hint.message, this.machines.func_82833_r(), this.actualParallelism);
                break;
            }
            default: {
                message = hint.message;
            }
        }
        GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)message);
        this.endRecipeProcessing();
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        HashMap<GTUtility.ItemId, ItemStack> inputsFromME = new HashMap<GTUtility.ItemId, ItemStack>();
        for (MTEHatchInputBus tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            if (tHatch instanceof MTEHatchCraftingInputME) continue;
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            boolean isMEBus = tHatch instanceof MTEHatchInputBusME;
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                if (isMEBus && i >= 16) {
                    inputsFromME.put(GTUtility.ItemId.createNoCopy((ItemStack)itemStack), itemStack);
                    continue;
                }
                rList.add(itemStack);
            }
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(this.func_70301_a(1));
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public static void addRecipes() {
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.ResearchOnAncientPA.get(16, new Object[0]), ItemList.Robot_Arm_IV.get(32L, new Object[0]), ItemList.Emitter_IV.get(32L, new Object[0]), ItemList.Field_Generator_IV.get(32L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)64L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)64L)}).fluidInputs(new FluidStack[]{MaterialsAlloy.NITINOL_60.getFluidStack(24576)}).itemOutputs(new ItemStack[]{GTCMItemList.BigBroArray.get(1, new Object[0])}).eut(TierEU.RECIPE_IV).duration(24000).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Field_Generator_IV.get(2L, new Object[0]), ItemList.Casing_RobustTungstenSteel.get(1L, new Object[0]), ItemList.Robot_Arm_IV.get(16L, new Object[0]), ItemList.Emitter_IV.get(16L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)8L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.Elite, (long)4L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(9216L)}).itemOutputs(new ItemStack[]{GTCMItemList.ParallelismCasing0.get(1, new Object[0])}).eut(6400).duration(3000).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().metadata(GTRecipeConstants.RESEARCH_ITEM, (Object)GTCMItemList.ParallelismCasing0.get(1, new Object[0])).metadata(GTRecipeConstants.SCANNING, (Object)new Scanning(288000, TierEU.RECIPE_LV)).itemInputs(new Object[]{ItemList.Field_Generator_ZPM.get(2L, new Object[0]), ItemList.Casing_StableTitanium.get(1L, new Object[0]), GTCMItemList.ParallelismCasing0.get(4, new Object[0]), ItemList.Robot_Arm_ZPM.get(16L, new Object[0]), ItemList.Emitter_ZPM.get(16L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorZPM, (long)8L), new Object[]{OrePrefixes.circuit.get((Object)Materials.Ultimate), 4}}).itemOutputs(new ItemStack[]{GTCMItemList.ParallelismCasing1.get(1, new Object[0])}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(9216L), new FluidStack(MaterialsAlloy.HELICOPTER.getFluid(), 24576)}).duration(12000).eut((int)TierEU.RECIPE_ZPM).addTo(GTRecipeConstants.AssemblyLine);
        GTValues.RA.stdBuilder().metadata(GTRecipeConstants.RESEARCH_ITEM, (Object)GTCMItemList.ParallelismCasing1.get(1, new Object[0])).metadata(GTRecipeConstants.SCANNING, (Object)new Scanning(576000, TierEU.RECIPE_LV)).itemInputs(new Object[]{ItemList.Field_Generator_UHV.get(4L, new Object[0]), ItemList.Casing_CleanStainlessSteel.get(1L, new Object[0]), GTCMItemList.ParallelismCasing1.get(4, new Object[0]), ItemList.Robot_Arm_UHV.get(16L, new Object[0]), ItemList.Emitter_UHV.get(16L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUHV, (long)8L), new Object[]{OrePrefixes.circuit.get((Object)Materials.Infinite), 4}}).itemOutputs(new ItemStack[]{GTCMItemList.ParallelismCasing2.get(1, new Object[0])}).fluidInputs(new FluidStack[]{new FluidStack(MaterialsAlloy.INDALLOY_140.getFluid(), 9216), new FluidStack(MaterialsAlloy.HELICOPTER.getFluid(), 14400), new FluidStack(MaterialsAlloy.PIKYONIUM.getFluid(), 24576)}).duration(24000).eut((int)TierEU.RECIPE_UHV).addTo(GTRecipeConstants.AssemblyLine);
        Fluid solderUEV = FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") != null ? FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") : FluidRegistry.getFluid((String)"molten.solderingalloy");
        TTRecipeAdder.addResearchableAssemblylineRecipe((ItemStack)GTCMItemList.ParallelismCasing2.get(1, new Object[0]), (int)20000000, (int)2000, (int)0x1E00000, (int)1, (Object[])new Object[]{ItemList.Casing_Dim_Bridge.get(64L, new Object[0]), ItemList.Casing_Dim_Injector.get(64L, new Object[0]), ItemList.Casing_Dim_Trans.get(64L, new Object[0]), new ItemStack(ItemBlock.func_150898_a((Block)TTCasingsContainer.sBlockCasingsTT), 2, 14), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), ItemList.Casing_FrostProof.get(1L, new Object[0]), GTCMItemList.ParallelismCasing2.get(16, new Object[0]), ItemList.Robot_Arm_UIV.get(16L, new Object[0]), ItemList.Emitter_UIV.get(16L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUIV, (long)64L), new Object[]{OrePrefixes.circuit.get((Object)Materials.Optical), 8}}, (FluidStack[])new FluidStack[]{new FluidStack(solderUEV, 9216)}, (ItemStack)GTCMItemList.ParallelismCasing3.get(1, new Object[0]), (int)24000, (int)0x1E00000);
        TTRecipeAdder.addResearchableAssemblylineRecipe((ItemStack)GTCMItemList.ParallelismCasing3.get(1, new Object[0]), (int)200000000, (int)20000, (int)0x1E000000, (int)1, (Object[])new Object[]{GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), GTCMItemList.SolarSail.get(64, new Object[0]), ItemList.Field_Generator_UXV.get(8L, new Object[0]), ItemList.Casing_SolidSteel.get(1L, new Object[0]), GTCMItemList.ParallelismCasing3.get(16, new Object[0]), CustomItemList.StabilisationFieldGeneratorTier2.get(4L, new Object[0]), CustomItemList.SpacetimeCompressionFieldGeneratorTier2.get(4L, new Object[0]), CustomItemList.TimeAccelerationFieldGeneratorTier2.get(4L, new Object[0]), ItemList.Robot_Arm_UXV.get(16L, new Object[0]), ItemList.Emitter_UXV.get(16L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUMV, (long)8L), NHItemList.QuantumCircuit.getIS(4)}, (FluidStack[])new FluidStack[]{MaterialsUEVplus.SpaceTime.getMolten(9216L)}, (ItemStack)GTCMItemList.ParallelismCasing4.get(1, new Object[0]), (int)24000, (int)0x1E000000);
    }

    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        String machineType;
        if (this.activeTextures == null) {
            this.activeTextures = this.getActiveTextures(this.machineType);
        }
        if (this.idleTextures == null) {
            this.idleTextures = this.getIdleTextures(this.machineType);
        }
        if ((machineType = ((TST_BigBroArray)baseMetaTileEntity.getMetaTileEntity()).machineType) == null && baseMetaTileEntity.getWorld() != null) {
            TST_Network.tst.sendToServer((IMessage)new PackRequestMachineType(baseMetaTileEntity.getWorld().field_73011_w.field_76574_g, baseMetaTileEntity.getXCoord(), baseMetaTileEntity.getYCoord(), baseMetaTileEntity.getZCoord()));
        }
        if (side == facing) {
            if (active) {
                return this.activeTextures;
            }
            return this.idleTextures;
        }
        return DEFAULT_CASING_TEXTURE;
    }

    static /* synthetic */ ITexture[] access$302(TST_BigBroArray x0, ITexture[] x1) {
        x0.idleTextures = x1;
        return x1;
    }

    static /* synthetic */ ITexture[] access$502(TST_BigBroArray x0, ITexture[] x1) {
        x0.activeTextures = x1;
        return x1;
    }

    static {
        PROCESSING_MACHINE_LIST = new String[][]{{"Macerator", "Macerator"}, {"OreWasher", "OreWashingPlant"}, {"ChemicalBath", "ChemicalBath"}, {"ThermalCentrifuge", "ThermalCentrifuge"}, {"E_Furnace", "ElectricFurnace"}, {"ArcFurnace", "ArcFurnace"}, {"Bender", "BendingMachine"}, {"Wiremill", "Wiremill"}, {"Lathe", "Lathe"}, {"Hammer", "ForgeHammer"}, {"Extruder", "Extruder"}, {"FluidExtractor", "FluidExtractor"}, {"Compressor", "Compressor"}, {"Press", "FormingPress"}, {"FluidSolidifier", "FluidSolidifier"}, {"Extractor", "Extractor"}, {"LaserEngraver", "PrecisionLaserEngraver"}, {"Autoclave", "Autoclave"}, {"Mixer", "Mixer"}, {"AlloySmelter", "AlloySmelter"}, {"Electrolyzer", "Electrolyzer"}, {"Sifter", "SiftingMachine"}, {"ChemicalReactor", "ChemicalReactor"}, {"ElectromagneticSeparator", "ElectromagneticSeparator"}, {"Recycler", "Recycler"}, {"Massfab", "MassFabricator"}, {"Centrifuge", "Centrifuge"}, {"Cutter", "CuttingMachine"}, {"Assembler", "AssemblingMachine"}, {"CircuitAssembler", "CircuitAssembler"}};
        Out_Format = new DecimalFormat("#,###");
        PATTERN_CORE = new String[][]{{"   AAAAA   ", "  AAAAAAA  ", " AAAAAAAAA ", "AAAAAAAAAAA", "AAAAAAAAAAA", "AAAAAAAAAAA", "AAAAAAAAAAA", "AAAAAAAAAAA", " AAAAAAAAA ", "  AAAAAAA  ", "   AAAAA   "}, {"   CCCCC   ", "  CCCCCCC  ", " CCCCCCCCC ", "CCCCCCCCCCC", "CCCCCCCCCCC", "CCCCCCCCCCC", "CCCCCCCCCCC", "CCCCCCCCCCC", " CCCCCCCCC ", "  CCCCCCC  ", "   CCCCC   "}, {"           ", "           ", "   B   B   ", "  B     B  ", "           ", "           ", "           ", "  B     B  ", "   B   B   ", "           ", "           "}, {"           ", "           ", "   B   B   ", "  B     B  ", "           ", "           ", "           ", "  B     B  ", "   B   B   ", "           ", "           "}, {"           ", "           ", "   B   B   ", "  B     B  ", "    DDD    ", "    DDD    ", "    DDD    ", "  B     B  ", "   B   B   ", "           ", "           "}, {"           ", "           ", "   B   B   ", "  B     B  ", "    D~D    ", "    D D    ", "    DDD    ", "  B     B  ", "   B   B   ", "           ", "           "}, {"           ", "           ", "   B   B   ", "  B     B  ", "    DDD    ", "    DDD    ", "    DDD    ", "  B     B  ", "   B   B   ", "           ", "           "}, {"     F     ", "    EEE    ", "   EEEEE   ", "  EEEEEEE  ", " EEEEEEEEE ", "FEEEEEEEEEF", " EEEEEEEEE ", "  EEEEEEE  ", "   EEEEE   ", "    EEE    ", "     F     "}};
        PATTERN_ADDON = new String[][]{{"                 ", "                 ", "                 ", "                 ", "                 ", "        EEE      ", "       EEEEE     ", "       EEEEE     ", "       EEEEE     ", "        EEE      ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "       EEEEE     ", "      EEEEEEE    ", "     EEE A EEE   ", "     EE  A  EE   ", "     EEAAAAAEE   ", "     EE  A  EE   ", "     EEE A EEE   ", "      EEEEEEE    ", "       EEEEE     ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "       EEEEE     ", "      E  A  E    ", "     E   A   E   ", "    E         E  ", "    E         E  ", "    EAA     AAE  ", "    E         E  ", "    E         E  ", "     E   A   E   ", "      E  A  E    ", "       EEEEE     ", "                 ", "                 "}, {"                 ", "       EEEEE     ", "      E  A  E    ", "     E       E   ", "    E         E  ", "   E           E ", "   E           E ", "   EA         AE ", "   E           E ", "   E           E ", "    E         E  ", "     E       E   ", "      E  A  E    ", "       EEEEE     ", "                 "}, {"                 ", "      EEEEEEE    ", "     E   A   E   ", "    E         E  ", "   E           E ", "   E           E ", "   E           E ", "   EA         AE ", "   E           E ", "   E           E ", "   E           E ", "    E         E  ", "     E   A   E   ", "      EEEEEEE    ", "                 "}, {"        EEE      ", "     EEEAAAEEE   ", "    E         E  ", "   E           E ", "   E           E ", "   E           E ", "  EA           AE", "  EA           AE", "  EA           AE", "   E           E ", "   E           E ", "   E           E ", "    E         E  ", "     EEEAAAEEE   ", "        EEE      "}, {"       EEEEE     ", "     EEA A AEE   ", "    E         E  ", "   E           E ", "   E           E ", "  EA           AE", "  E             E", "  EA           AE", "  E             E", "  EA           AE", "   E           E ", "   E           E ", "    E         E  ", "     EEA A AEE   ", "       EEEEE     "}, {"       EEEEE     ", "     EEAAAAAEE   ", "    EAA     AAE  ", "   EA         AE ", "   EA         AE ", "  EA           AE", "  EA           AE", "  EA           AE", "  EA           AE", "  EA           AE", "   EA         AE ", "   EA         AE ", "    EAA     AAE  ", "     EEAAAAAEE   ", "       EEEEE     "}, {"       EEEEE     ", "     EEA A AEE   ", "    E         E  ", "   E           E ", "   E           E ", "  EA           AE", "  E             E", "  EA           AE", "  E             E", "  EA           AE", "   E           E ", "   E           E ", "    E         E  ", "     EEA A AEE   ", "       EEEEE     "}, {"        EEE      ", "     EEEAAAEEE   ", "    E         E  ", "   E           E ", "   E           E ", "   E           E ", "  EA           AE", "  EA           AE", "  EA           AE", "   E           E ", "   E           E ", "   E           E ", "    E         E  ", "     EEEAAAEEE   ", "        EEE      "}, {"                 ", "      EEEEEEE    ", "     E   A   E   ", "    E         E  ", "   E           E ", "   E           E ", "   E           E ", "   EA         AE ", "   E           E ", "   E           E ", "   E           E ", "    E         E  ", "     E   A   E   ", "      EEEEEEE    ", "                 "}, {"                 ", "       EEEEE     ", "      E  A  E    ", "     E       E   ", "    E         E  ", "   E           E ", "   E           E ", "   EA         AE ", "   E           E ", "   E           E ", "    E         E  ", "     E       E   ", "      E  A  E    ", "       EEEEE     ", "                 "}, {"                 ", "                 ", "       EEEEE     ", "      E  A  E    ", "     E   A   E   ", "    E         E  ", "    E         E  ", "    EAA     AAE  ", "    E         E  ", "    E         E  ", "     E   A   E   ", "      E  A  E    ", "       EEEEE     ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "       EEEEE     ", "      EEEEEEE    ", "     EEE A EEE   ", "     EE  A  EE   ", "     EEAAAAAEE   ", "     EE  A  EE   ", "     EEE A EEE   ", "      EEEEEEE    ", "       EEEEE     ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "         BB      ", "                 ", "        EEE      ", "       EEEEE     ", "       EEEEE     ", "       EEEEE     ", "        EEE      ", "                 ", "        BB       ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "           B     ", "            B    ", "                 ", "        DDD      ", "        DCD      ", "        DDD      ", "                 ", "      B          ", "       B         ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "             B   ", "        DDD  B   ", "        DCD      ", "     B  DDD      ", "     B           ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "     B  DDD      ", "     B  DCD  B   ", "        DDD  B   ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "      B          ", "     B           ", "        DDD      ", "        DCD      ", "        DDD      ", "             B   ", "            B    ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "       BB        ", "                 ", "                 ", "        DDD      ", "        DCD      ", "        DDD      ", "                 ", "                 ", "          BB     ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "         BB      ", "                 ", "                 ", "        DDD      ", "        DCD      ", "        DDD      ", "                 ", "                 ", "        BB       ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "           B     ", "            B    ", "                 ", "        DDD      ", "        DCD      ", "        DDD      ", "                 ", "      B          ", "       B         ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "             B   ", "        DDD  B   ", "        DCD      ", "     B  DDD      ", "     B           ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "     B  CCC      ", "     B  CCC  B   ", "        CCC  B   ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "      B          ", "     B CCCCC     ", "       CCCCC     ", "       CCCCC     ", "       CCCCC     ", "       CCCCC B   ", "            B    ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "FFFFFFFFFFFFFF   ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "     FFFFFFFFF   ", "                 ", "                 ", "                 "}};
        PATTERN_ADDON_90_CW = new String[PATTERN_ADDON.length][PATTERN_ADDON[0][0].length()];
        PATTERN_ADDON_90_CCW = new String[PATTERN_ADDON.length][PATTERN_ADDON[0][0].length()];
        PATTERN_ADDON_180 = new String[PATTERN_ADDON.length][PATTERN_ADDON[0].length];
        overlayMapping = new HashMap<String, String>(){
            {
                this.put("Macerator", "macerator");
                this.put("OreWasher", "ore_washer");
                this.put("ChemicalBath", "chemical_bath");
                this.put("ThermalCentrifuge", "thermal_centrifuge");
                this.put("E_Furnace", "electric_furnace");
                this.put("ArcFurnace", "arc_furnace");
                this.put("Bender", "bender");
                this.put("Wiremill", "wiremill");
                this.put("Lathe", "lathe");
                this.put("Hammer", "hammer");
                this.put("Extruder", "extruder");
                this.put("FluidExtractor", "fluid_extractor");
                this.put("Compressor", "compressor");
                this.put("Press", "press");
                this.put("FluidSolidifier", "fluid_solidifier");
                this.put("Extractor", "extractor");
                this.put("LaserEngraver", "laser_engraver");
                this.put("Autoclave", "autoclave");
                this.put("Mixer", "mixer");
                this.put("AlloySmelter", "alloy_smelter");
                this.put("Electrolyzer", "electrolyzer");
                this.put("ElectromagneticSeparator", "electromagnetic_separator");
                this.put("Recycler", "recycler");
                this.put("Massfab", "amplifab");
                this.put("Centrifuge", "centrifuge");
                this.put("Cutter", "cutter");
                this.put("Assembler", "assembler");
                this.put("CircuitAssembler", "circuitassembler");
            }
        };
        recipeBackendRefMapping = new HashMap<String, Field>(){
            {
                try {
                    this.put("Macerator", RecipeMaps.class.getDeclaredField("maceratorRecipes"));
                    this.put("OreWasher", RecipeMaps.class.getDeclaredField("oreWasherRecipes"));
                    this.put("ChemicalBath", RecipeMaps.class.getDeclaredField("chemicalBathRecipes"));
                    this.put("ThermalCentrifuge", RecipeMaps.class.getDeclaredField("thermalCentrifugeRecipes"));
                    this.put("E_Furnace", RecipeMaps.class.getDeclaredField("furnaceRecipes"));
                    this.put("ArcFurnace", RecipeMaps.class.getDeclaredField("arcFurnaceRecipes"));
                    this.put("Bender", RecipeMaps.class.getDeclaredField("benderRecipes"));
                    this.put("Wiremill", RecipeMaps.class.getDeclaredField("wiremillRecipes"));
                    this.put("Lathe", RecipeMaps.class.getDeclaredField("latheRecipes"));
                    this.put("Hammer", RecipeMaps.class.getDeclaredField("hammerRecipes"));
                    this.put("Extruder", RecipeMaps.class.getDeclaredField("extruderRecipes"));
                    this.put("FluidExtractor", RecipeMaps.class.getDeclaredField("fluidExtractionRecipes"));
                    this.put("Compressor", RecipeMaps.class.getDeclaredField("compressorRecipes"));
                    this.put("Press", RecipeMaps.class.getDeclaredField("formingPressRecipes"));
                    this.put("FluidSolidifier", RecipeMaps.class.getDeclaredField("fluidSolidifierRecipes"));
                    this.put("Extractor", RecipeMaps.class.getDeclaredField("extractorRecipes"));
                    this.put("LaserEngraver", RecipeMaps.class.getDeclaredField("laserEngraverRecipes"));
                    this.put("Autoclave", RecipeMaps.class.getDeclaredField("autoclaveRecipes"));
                    this.put("Mixer", RecipeMaps.class.getDeclaredField("mixerRecipes"));
                    this.put("AlloySmelter", RecipeMaps.class.getDeclaredField("alloySmelterRecipes"));
                    this.put("Electrolyzer", RecipeMaps.class.getDeclaredField("electrolyzerRecipes"));
                    this.put("ElectromagneticSeparator", RecipeMaps.class.getDeclaredField("electroMagneticSeparatorRecipes"));
                    this.put("Recycler", RecipeMaps.class.getDeclaredField("recyclerRecipes"));
                    this.put("Massfab", RecipeMaps.class.getDeclaredField("massFabFakeRecipes"));
                    this.put("Centrifuge", RecipeMaps.class.getDeclaredField("centrifugeRecipes"));
                    this.put("Cutter", RecipeMaps.class.getDeclaredField("cutterRecipes"));
                    this.put("Assembler", RecipeMaps.class.getDeclaredField("assemblerRecipes"));
                    this.put("CircuitAssembler", RecipeMaps.class.getDeclaredField("circuitAssemblerRecipes"));
                    this.put("Diesel", RecipeMaps.class.getDeclaredField("dieselFuels"));
                    this.put("Gas_Turbine", RecipeMaps.class.getDeclaredField("gasTurbineFuels"));
                    this.put("Naquadah_1", RecipeMaps.class.getDeclaredField("smallNaquadahReactorFuels"));
                    this.put("Naquadah_2", RecipeMaps.class.getDeclaredField("largeNaquadahReactorFuels"));
                    this.put("Naquadah_3", RecipeMaps.class.getDeclaredField("hugeNaquadahReactorFuels"));
                    this.put("Naquadah_4", RecipeMaps.class.getDeclaredField("extremeNaquadahReactorFuels"));
                    this.put("Naquadah_5", RecipeMaps.class.getDeclaredField("ultraHugeNaquadahReactorFuels"));
                    this.put("Semi_Fluid", GTPPRecipeMaps.class.getDeclaredField("semiFluidFuels"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        GENERATORS = new HashMap<String, ItemStack[]>();
        GENERATOR_TYPES = new String[]{"ASP_Solar", "EMT_Solar", "Diesel", "Naquadah", "Semi_Fluid", "Gas_Turbine", "Steam_Turbine"};
        GENERATOR_EFFICIENCY = new HashMap<String, float[]>(){
            {
                this.put("Diesel", new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f});
                this.put("Gas_Turbine", new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f});
                this.put("Steam_Turbine", new float[]{1.0f, 1.0f, 1.0f});
                this.put("Semi_Fluid", new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f});
                this.put("Naquadah", new float[]{0.8f, 1.0f, 1.5f, 2.0f, 2.5f});
            }
        };
    }

    static enum MachineHintMessages {
        SUCCESS("Machine [%s] is set, parallelism is %s"),
        FAIL_NON_ACCEPT("Machines are not acceptable, acceptable types are %s"),
        FAIL_TIER_MISMATCH("Tier of machine is beyond the max tier that structure can hold. Max Tier is %s EU/t. Machines will always be accepted when there's no addons. When there's addon attached, arcanite frames unlock IV machines, quantum alloy frames unlock UEV and higher tier machines."),
        MACHINE_TO_OUTPUT("Machines are sent to output bus");

        private String message;

        private MachineHintMessages(String message) {
            this.message = message;
        }
    }

    public static class PackSyncMachineType
    implements IMessageHandler<PackSyncMachineType, PackSyncMachineType>,
    IMessage {
        int x;
        int y;
        int z;
        String machineType;

        public PackSyncMachineType() {
        }

        public PackSyncMachineType(int x, int y, int z, String machineType) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.machineType = machineType;
        }

        public PackSyncMachineType onMessage(PackSyncMachineType message, MessageContext ctx) {
            IMetaTileEntity metaTileEntity;
            TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
            if (tileEntity instanceof BaseMetaTileEntity && (metaTileEntity = ((BaseMetaTileEntity)tileEntity).getMetaTileEntity()) instanceof TST_BigBroArray) {
                TST_BigBroArray bigbro = (TST_BigBroArray)metaTileEntity;
                TST_BigBroArray.access$302(bigbro, bigbro.getIdleTextures(message.machineType));
                TST_BigBroArray.access$502(bigbro, bigbro.getActiveTextures(message.machineType));
                bigbro.machineType = message.machineType;
            }
            return null;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            byte[] bytes = new byte[buf.readShort()];
            buf.readBytes(bytes);
            this.machineType = new String(bytes, StandardCharsets.UTF_8);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            byte[] bytes = this.machineType != null ? this.machineType.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.writeShort(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    public static class PackRequestMachineType
    implements IMessageHandler<PackRequestMachineType, PackSyncMachineType>,
    IMessage {
        int worldId;
        int x;
        int y;
        int z;

        public PackRequestMachineType() {
        }

        public PackRequestMachineType(int worldId, int x, int y, int z) {
            this.worldId = worldId;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void fromBytes(ByteBuf buf) {
            this.worldId = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.worldId);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }

        public PackSyncMachineType onMessage(PackRequestMachineType message, MessageContext ctx) {
            TileEntity tileEntity;
            WorldServer world = DimensionManager.getWorld((int)message.worldId);
            if (world != null && (tileEntity = world.func_147438_o(message.x, message.y, message.z)) instanceof BaseMetaTileEntity) {
                TST_BigBroArray array = (TST_BigBroArray)((BaseMetaTileEntity)tileEntity).getMetaTileEntity();
                return new PackSyncMachineType(message.x, message.y, message.z, array.machineType);
            }
            return null;
        }
    }
}

