/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.gtnewhorizon.gtnhlib.capability.Capabilities;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ICleanroom;
import gregtech.api.interfaces.ICleanroomReceiver;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicHull;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import ic2.core.block.BlockIC2Door;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class TST_CleanRoom
extends TT_MultiMachineBase_EM
implements IConstructable,
ISecondaryDescribable,
ICleanroom {
    private static final int maxX = 63;
    private static final int maxY = 64;
    private static final int maxZ = 63;
    private final Set<ICleanroomReceiver> cleanroomReceivers = new HashSet<ICleanroomReceiver>();
    private int mHeight = -1;
    private static final HashMap<String, ConfigEntry> config = new HashMap();
    private static final String category = "cleanroom_allowed_blocks";

    public TST_CleanRoom(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_CleanRoom(String aName) {
        super(aName);
    }

    public void init() {
        this.ePowerPass = true;
        this.useLongPower = true;
    }

    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        return null;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_CleanRoom(this.mName);
    }

    public int getCleanness() {
        return this.mEfficiency;
    }

    public boolean isValidCleanroom() {
        return this.isValid() && this.mMachine;
    }

    public void pollute() {
        this.mEfficiency = 0;
        this.mWrench = false;
        this.mScrewdriver = false;
        this.mSoftMallet = false;
        this.mHardHammer = false;
        this.mSolderingTool = false;
        this.mCrowbar = false;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_MachineType"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_00"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_01"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_02"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_03"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_04"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_05"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_06"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_07"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_08"));
        tt.addInfo(StatCollector.func_74838_a((String)"Tooltip_TST_CleanRoom_09"));
        tt.addSeparator();
        tt.addInfo(StatCollector.func_74838_a((String)"StructureTooComplex"));
        tt.addInfo(StatCollector.func_74838_a((String)"BLUE_PRINT_INFO"));
        tt.beginVariableStructureBlock(3, 15, 4, 15, 3, 15, true);
        tt.addController("Top center");
        tt.addCasingInfoRange("Plascrete", 20, 1007, false);
        tt.addStructureInfo(GTValues.cleanroomGlass + "% of the Plascrete can be replaced with Reinforced Glass (not counting the top layer)");
        tt.addStructureInfo("Other material can be used in place of Plascrete, even in higher percentages. See config for detail");
        tt.addOtherStructurePart("Filter Machine Casing", "Top besides controller and edges");
        tt.addEnergyHatch("Any casing except top layer. Exactly one.");
        tt.addStructureInfo("0-2x Reinforced Door (keep closed or efficiency will reduce)");
        tt.addStructureInfo("Up to 1 Elevator, Rotating Elevator, and Travel Anchor each");
        tt.addStructureInfo("Up to 10 Machine Hulls for Item & Energy transfer through walls");
        tt.addStructureInfo("You can also use Diodes for more power");
        tt.addStructureInfo("Diodes also count towards 10 Machine Hulls count limit");
        tt.toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[]{"The base can be rectangular."};
    }

    @Nonnull
    public CheckRecipeResult checkProcessing_EM() {
        int i;
        this.mEfficiencyIncrease = 100;
        OverclockCalculator calc = new OverclockCalculator().setEUt(40L).setDuration(45 * Math.max(1, this.mHeight - 1)).setDurationDecreasePerOC(2.0).calculate();
        this.lEUt = calc.getConsumption();
        this.mMaxProgresstime = calc.getDuration();
        this.lEUt /= -10L;
        if (this.ePowerPass) {
            this.mMaxProgresstime = 20;
        } else {
            this.mEfficiencyIncrease = 0;
            this.mMaxProgresstime = 0;
        }
        this.eAmpereFlow = 0L;
        this.mEUt = 0;
        ArrayList a = (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputHatches);
        ArrayList b = (ArrayList)GTUtility.filterValidMTEs((Collection)this.mOutputHatches);
        ArrayList c = (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses);
        ArrayList d = (ArrayList)GTUtility.filterValidMTEs((Collection)this.mOutputBusses);
        boolean item_me = this.canDumpItemToME();
        boolean fluid_me = this.canDumpFluidToME();
        if (a.size() != b.size() && !item_me || c.size() != d.size() && !fluid_me) {
            this.stopMachine();
        }
        for (i = 0; i < c.size(); ++i) {
            for (ItemStack item : ((MTEHatchInputBus)c.get((int)i)).mInventory) {
                if (item == null) continue;
                if (item_me) {
                    if (((MTEHatchOutputBus)d.get(0)).storePartial(item)) continue;
                    continue;
                }
                if (!((MTEHatchOutputBus)d.get(i)).storePartial(item.func_77946_l())) continue;
                item.field_77994_a = 0;
            }
        }
        for (i = 0; i < a.size(); ++i) {
            if (((MTEHatchInput)a.get(i)).getFluid() == null) continue;
            ((MTEHatchInput)a.get((int)i)).getFluid().amount -= ((MTEHatchOutput)b.get(i)).fill(((MTEHatchInput)a.get(i)).getFluid(), true);
        }
        return this.ePowerPass ? SimpleCheckRecipeResult.ofSuccess((String)"routing") : SimpleCheckRecipeResult.ofFailure((String)"running fine");
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int tMeta;
        Block tBlock;
        int i;
        this.repairMachine();
        int x = 1;
        int z = 1;
        int y = 1;
        int mDoorCount = 0;
        int mHullCount = 0;
        int mPlascreteCount = 0;
        HashMap<String, Integer> otherBlocks = new HashMap<String, Integer>();
        boolean doorState = false;
        this.mUpdate = 100;
        this.cleanroomReceivers.forEach(r -> r.setCleanroom(null));
        this.cleanroomReceivers.clear();
        GTValues.debugCleanroom = true;
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: Checking machine");
        }
        for (i = 1; i <= 31; ++i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(i, 0, 0);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(i, 0, 0);
            if (tBlock == GregTechAPI.sBlockCasings3 && tMeta == 11) continue;
            if (tBlock == GregTechAPI.sBlockReinforced || tMeta == 2) {
                x = i;
                break;
            }
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Unable to detect room X edge?");
            }
            return false;
        }
        for (i = 1; i <= 31; ++i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(0, 0, i);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(0, 0, i);
            if (tBlock == GregTechAPI.sBlockCasings3 && tMeta == 11) continue;
            if (tBlock == GregTechAPI.sBlockReinforced || tMeta == 2) {
                z = i;
                break;
            }
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Unable to detect room Z edge?");
            }
            return false;
        }
        for (i = -x + 1; i < x; ++i) {
            for (int j = -z + 1; j < z; ++j) {
                if (i == 0 && j == 0) continue;
                Block tBlock2 = aBaseMetaTileEntity.getBlockOffset(i, 0, j);
                int tMeta2 = aBaseMetaTileEntity.getMetaIDOffset(i, 0, j);
                if (tBlock2 == GregTechAPI.sBlockCasings3 || tMeta2 == 11) continue;
                if (GTValues.debugCleanroom) {
                    GTLog.out.println("Cleanroom: This is not a filter.");
                }
                return false;
            }
        }
        for (i = -1; i > -64; --i) {
            tBlock = aBaseMetaTileEntity.getBlockOffset(x, i, z);
            tMeta = aBaseMetaTileEntity.getMetaIDOffset(x, i, z);
            if (tBlock == GregTechAPI.sBlockReinforced && tMeta == 2) continue;
            y = i + 1;
            break;
        }
        if (y > -2) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Room not tall enough?");
            }
            return false;
        }
        for (int dX = -x; dX <= x; ++dX) {
            for (int dZ = -z; dZ <= z; ++dZ) {
                for (int dY = 0; dY >= y; --dY) {
                    if (dX != -x && dX != x && dY != 0 && dY != y && dZ != -z && dZ != z) continue;
                    Block tBlock3 = aBaseMetaTileEntity.getBlockOffset(dX, dY, dZ);
                    int tMeta3 = aBaseMetaTileEntity.getMetaIDOffset(dX, dY, dZ);
                    if (dY == 0) {
                        if (dX == -x || dX == x || dZ == -z || dZ == z) {
                            if (tBlock3 == GregTechAPI.sBlockReinforced && tMeta3 == 2) continue;
                            if (GTValues.debugCleanroom) {
                                GTLog.out.println("Cleanroom: Non reinforced block on top edge? tMeta != 2");
                            }
                            return false;
                        }
                        if (dX == 0 && dZ == 0 || tBlock3 == GregTechAPI.sBlockCasings3 && tMeta3 == 11) continue;
                        if (GTValues.debugCleanroom) {
                            GTLog.out.println("Cleanroom: Non reinforced block on top face interior? tMeta != 11");
                        }
                        return false;
                    }
                    if (tBlock3 == GregTechAPI.sBlockReinforced && tMeta3 == 2) {
                        ++mPlascreteCount;
                        continue;
                    }
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(dX, dY, dZ);
                    if (this.addToMachineList(tTileEntity, 210)) continue;
                    if (tBlock3 instanceof BlockIC2Door) {
                        if ((tMeta3 & 8) == 0) {
                            if (Math.abs(dZ) < z) {
                                doorState = tMeta3 == 1 || tMeta3 == 3 || tMeta3 == 4 || tMeta3 == 6;
                            } else if (Math.abs(dX) < x) {
                                doorState = tMeta3 == 0 || tMeta3 == 2 || tMeta3 == 5 || tMeta3 == 7;
                            }
                        }
                        ++mDoorCount;
                        continue;
                    }
                    if (tTileEntity != null) {
                        IMetaTileEntity aMetaTileEntity = tTileEntity.getMetaTileEntity();
                        if (aMetaTileEntity == null) {
                            if (GTValues.debugCleanroom) {
                                GTLog.out.println("Cleanroom: Missing block? Not a aMetaTileEntity");
                            }
                            return false;
                        }
                        if (aMetaTileEntity instanceof MTEBasicHull) {
                            ++mHullCount;
                            continue;
                        }
                        if (GTValues.debugCleanroom) {
                            GTLog.out.println("Cleanroom: Incorrect GT block? " + tBlock3.func_149739_a());
                        }
                        return false;
                    }
                    String key = tBlock3.func_149739_a() + ":" + tMeta3;
                    if (config.containsKey(key)) {
                        otherBlocks.compute(key, (k, v) -> v == null ? 1 : v + 1);
                        continue;
                    }
                    key = tBlock3.func_149739_a();
                    if (config.containsKey(key)) {
                        otherBlocks.compute(key, (k, v) -> v == null ? 1 : v + 1);
                        continue;
                    }
                    if (GTValues.debugCleanroom) {
                        GTLog.out.println("Cleanroom: not allowed block " + tBlock3.func_149739_a());
                    }
                    return false;
                }
            }
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() != 1 || mDoorCount > 4 || mHullCount > 10) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Incorrect number of doors, hulls, or hatches.");
            }
            return false;
        }
        if (mPlascreteCount < 20) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Could not find 20 Plascrete.");
            }
            return false;
        }
        float ratio = (float)mPlascreteCount / 100.0f;
        for (Map.Entry e : otherBlocks.entrySet()) {
            ConfigEntry ce = config.get(e.getKey());
            if (ce.allowedCount > 0) {
                if ((Integer)e.getValue() <= ce.allowedCount) continue;
                if (GTValues.debugCleanroom) {
                    GTLog.out.println("Cleanroom: Absolute count too high for a block.");
                }
                return false;
            }
            if (!((float)((Integer)e.getValue()).intValue() > ratio * (float)ce.percentage)) continue;
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Relative count too high for a block.");
            }
            return false;
        }
        this.setCleanroomReceivers(x, y, z, aBaseMetaTileEntity);
        if (doorState) {
            this.mEfficiency = Math.max(0, this.mEfficiency - 200);
        }
        for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
            byte t = (byte)Math.max(1, (byte)(15.0f / (10000.0f / (float)this.mEfficiency)));
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(tSide, t);
        }
        this.mHeight = -y;
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: Check successful.");
        }
        return true;
    }

    private void setCleanroomReceivers(int x, int y, int z, IGregTechTileEntity aBaseMetaTileEntity) {
        for (int dX = -x + 1; dX <= x - 1; ++dX) {
            for (int dZ = -z + 1; dZ <= z - 1; ++dZ) {
                for (int dY = -1; dY >= y + 1; --dY) {
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityOffset(dX, dY, dZ);
                    if (tTileEntity == null) continue;
                    if (tTileEntity instanceof ICleanroomReceiver) {
                        ICleanroomReceiver receiver = (ICleanroomReceiver)tTileEntity;
                        receiver.setCleanroom((ICleanroom)this);
                        this.cleanroomReceivers.add(receiver);
                        continue;
                    }
                    ICleanroomReceiver receiver = (ICleanroomReceiver)Capabilities.getCapability((TileEntity)tTileEntity, ICleanroomReceiver.class);
                    if (receiver == null) continue;
                    receiver.setCleanroom((ICleanroom)this);
                    this.cleanroomReceivers.add(receiver);
                }
            }
        }
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if ((sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0) {
            return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.BLOCK_PLASCRETE), active ? TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE_GLOW).glow().build()}) : TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_CLEANROOM), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_GLOW).glow().build()})};
        }
        return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.BLOCK_PLASCRETE)};
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public void construct(ItemStack itemStack, boolean b) {
        int i = Math.min(itemStack.field_77994_a, 31);
        IGregTechTileEntity baseEntity = this.getBaseMetaTileEntity();
        World world = baseEntity.getWorld();
        int x = baseEntity.getXCoord();
        int y = baseEntity.getYCoord();
        int z = baseEntity.getZCoord();
        int yoff = Math.max(i * 2, 3);
        for (int X = x - i; X <= x + i; ++X) {
            for (int Y = y; Y >= y - yoff; --Y) {
                for (int Z = z - i; Z <= z + i; ++Z) {
                    if (X == x && Y == y && Z == z) continue;
                    if (X == x - i || X == x + i || Z == z - i || Z == z + i || Y == y - yoff) {
                        if (b) {
                            StructureLibAPI.hintParticle((World)world, (int)X, (int)Y, (int)Z, (Block)GregTechAPI.sBlockReinforced, (int)2);
                            continue;
                        }
                        world.func_147465_d(X, Y, Z, GregTechAPI.sBlockReinforced, 2, 2);
                        continue;
                    }
                    if (Y != y) continue;
                    if (b) {
                        StructureLibAPI.hintParticle((World)world, (int)X, (int)Y, (int)Z, (Block)GregTechAPI.sBlockCasings3, (int)11);
                        continue;
                    }
                    world.func_147465_d(X, Y, Z, GregTechAPI.sBlockCasings3, 11, 2);
                }
            }
        }
    }

    private static void setDefaultConfigValues(Configuration cfg) {
        cfg.get("cleanroom_allowed_blocks.manaGlass", "Name", "tile.manaGlass");
        cfg.get("cleanroom_allowed_blocks.manaGlass", "Percentage", 50);
        cfg.get("cleanroom_allowed_blocks.elfGlass", "Name", "tile.elfGlass");
        cfg.get("cleanroom_allowed_blocks.elfGlass", "Percentage", 50);
        cfg.get("cleanroom_allowed_blocks.reinforced_glass", "Name", "blockAlloyGlass");
        cfg.get("cleanroom_allowed_blocks.reinforced_glass", "Percentage", 5);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Name", "BW_GlasBlocks");
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Percentage", 50);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass_0", "Meta", 0);
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass", "Name", "BW_GlasBlocks");
        cfg.get("cleanroom_allowed_blocks.bw_reinforced_glass", "Percentage", 100);
        cfg.get("cleanroom_allowed_blocks.elevator", "Name", "tile.openblocks.elevator");
        cfg.get("cleanroom_allowed_blocks.elevator", "Count", 1);
        cfg.get("cleanroom_allowed_blocks.travel_anchor", "Name", "tile.blockTravelAnchor");
        cfg.get("cleanroom_allowed_blocks.travel_anchor", "Count", 1);
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Name", "tile.blockCosmeticOpaque");
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Meta", 2);
        cfg.get("cleanroom_allowed_blocks.warded_glass", "Percentage", 50);
        cfg.get("cleanroom_allowed_blocks.ethereal_glass", "Name", "tile.extrautils:etherealglass");
        cfg.get("cleanroom_allowed_blocks.ethereal_glass", "Percentage", 50);
    }

    public static void loadConfig(Configuration cfg) {
        if (!cfg.hasCategory(category)) {
            TST_CleanRoom.setDefaultConfigValues(cfg);
        }
        for (ConfigCategory cc : cfg.getCategory(category).getChildren()) {
            String name = cc.get("Name").getString();
            if (cc.containsKey("Count")) {
                if (cc.containsKey("Meta")) {
                    config.put(name + ":" + cc.get("Meta").getInt(), new ConfigEntry(0, cc.get("Count").getInt()));
                    continue;
                }
                config.put(name, new ConfigEntry(0, cc.get("Count").getInt()));
                continue;
            }
            if (!cc.containsKey("Percentage")) continue;
            if (cc.containsKey("Meta")) {
                config.put(name + ":" + cc.get("Meta").getInt(), new ConfigEntry(cc.get("Percentage").getInt(), 0));
                continue;
            }
            config.put(name, new ConfigEntry(cc.get("Percentage").getInt(), 0));
        }
    }

    private static class ConfigEntry {
        final int percentage;
        final int allowedCount;

        ConfigEntry(int percentage, int count) {
            this.percentage = percentage;
            this.allowedCount = count;
        }
    }
}

