/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings8;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class TST_GiantVacuumDryingFurnace
extends GTCM_MultiMachineBase<TST_GiantVacuumDryingFurnace> {
    private static final int MACHINEMODE_VACUUMFURNACE = 0;
    private static final int MACHINEMODE_DEHYDRATOR = 1;
    private int piece = 1;
    private HeatingCoilLevel coilLevel = HeatingCoilLevel.None;
    private static IStructureDefinition<TST_GiantVacuumDryingFurnace> STRUCTURE_DEFINITION = null;
    private static final String[][] shapeVacuumPump = new String[][]{{"         ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", "         "}, {"         ", " SAAAAAS ", " S     S ", " S     S ", " S     S ", " S     S ", " S     S ", " SAAAAAS ", "         "}, {"         ", " SAAAAAS ", " S     S ", " S     S ", " S     S ", " S     S ", " S     S ", " SAAAAAS ", "         "}, {"         ", " SAAAAAS ", " S     S ", " S     S ", " S     S ", " S     S ", " S     S ", " SAAAAAS ", "         "}, {"         ", " SAAAAAS ", " S     S ", " S     S ", " S     S ", " S     S ", " S     S ", " SAAAAAS ", "         "}, {"         ", " SAAAAAS ", " S     S ", " S     S ", " S     S ", " S     S ", " S     S ", " SAAAAAS ", "         "}, {"         ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", " SSSSSSS ", "         "}, {"VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV", "VVVVVVVVV"}};
    private static final String[][] shapeMainFrame = new String[][]{{"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"E~E", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}, {"EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE", "EEE"}};
    private static final String[][] shapeDryingTowerBase = new String[][]{{"           ", " IIIIIIIII ", " IJJJAJJJI ", " IJJJAJJJI ", " IJJJAJJJI ", " AAAAGAAAA ", " IJJJAJJJI ", " IJJJAJJJI ", " IJJJAJJJI ", " IIIIIIIII ", "           "}, {"           ", " H       H ", "           ", "  FFFFFFF  ", "     V     ", "    VGV    ", "     V     ", "  FFFFFFF  ", "           ", " H       H ", "           "}, {"           ", " H       H ", "  FFFFFFF  ", " FGGGGGGGF ", "  FFFFFFF  ", "           ", "  FFFFFFF  ", " FGGGGGGGF ", "  FFFFFFF  ", " H       H ", "           "}, {"  HHHHHHH  ", " H       H ", "H         H", "H FFFFFFF H", "H         H", "H         H", "H         H", "H FFFFFFF H", " H       H ", " H       H ", "  HHHHHHH  "}, {" VVVVVVVVV ", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", "VVVVVVVVVVV", " VVVVVVVVV "}};
    private static final String[][] shapeDryingTowerMiddle = new String[][]{{"           ", "   I   I   ", "  JJJAJJJ  ", " IJJJAJJJI ", "  JJJAJJJ  ", " AAAAGAAAA ", "  JJJAJJJ  ", " IJJJAJJJI ", "  JJJAJJJ  ", "   I   I   ", "           "}, {"           ", "   I   I   ", "           ", " I C   C I ", "           ", "     G     ", "           ", " I C   C I ", "           ", "   I   I   ", "           "}, {"           ", "   I   I   ", "   C   C   ", " IC C C CI ", "   C   C   ", "     G     ", "   C   C   ", " IC C C CI ", "   C   C   ", "   I   I   ", "           "}, {"           ", "   I   I   ", "  CCC CCC  ", " IC C C CI ", "  CCC CCC  ", "     G     ", "  CCC CCC  ", " IC C C CI ", "  CCC CCC  ", "   I   I   ", "           "}, {"           ", "   I   I   ", "  CCC CCC  ", " IC C C CI ", "  CCC CCC  ", "     G     ", "  CCC CCC  ", " IC C C CI ", "  CCC CCC  ", "   I   I   ", "           "}, {"           ", "   I   I   ", "   C   C   ", " IC C C CI ", "   C   C   ", "     G     ", "   C   C   ", " IC C C CI ", "   C   C   ", "   I   I   ", "           "}, {"           ", "   I   I   ", "           ", " I C   C I ", "           ", "     G     ", "           ", " I C   C I ", "           ", "   I   I   ", "           "}};
    private static final String[][] shapeDryingTowerHat = new String[][]{{"           ", "           ", "           ", "    VVV    ", "   VGGGV   ", "   VGGGV   ", "   VGGGV   ", "    VVV    ", "           ", "           ", "           "}, {"           ", "           ", "   I   I   ", "  IV   VI  ", "     V     ", "    VGV    ", "     V     ", "  IV   VI  ", "   I   I   ", "           ", "           "}, {"           ", "           ", "   I   I   ", "  I     I  ", "           ", "     G     ", "           ", "  I     I  ", "   I   I   ", "           ", "           "}};
    private final int VP_horizontalOffSet = 10;
    private final int VP_verticalOffSet = 4;
    private final int VP_depthOffSet = 0;
    private final int MF_horizontalOffSet = 1;
    private final int MF_verticalOffSet = 3;
    private final int MF_depthOffSet = 0;
    private final int DT_horizontalOffSet = -2;
    private final int DT_verticalOffSet = 1;
    private final int DT_depthOffSet = 0;
    private static final String STRUCTURE_PIECE_VP = "VacuumPump";
    private static final String STRUCTURE_PIECE_MF = "MainFrame";
    private static final String STRUCTURE_PIECE_DTB = "DryingTowerBase";
    private static final String STRUCTURE_PIECE_DTM = "DryingTowerMiddle";
    private static final String STRUCTURE_PIECE_DTH = "DryingTowerHat";

    public TST_GiantVacuumDryingFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_GiantVacuumDryingFurnace(String aName) {
        super(aName);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_STEAM);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_INDUSTRIAL_DEHYDRATOR.mode." + mode));
    }

    public RecipeMap<?> getRecipeMap() {
        return this.machineMode == 0 ? GTPPRecipeMaps.vacuumFurnaceRecipes : GTPPRecipeMaps.chemicalDehydratorNonCellRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTPPRecipeMaps.chemicalDehydratorNonCellRecipes, GTPPRecipeMaps.vacuumFurnaceRecipes);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("piece", this.piece);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.piece = aNBT.func_74762_e("piece");
    }

    public IStructureDefinition<TST_GiantVacuumDryingFurnace> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_VP, StructureUtility.transpose((String[][])shapeVacuumPump)).addShape(STRUCTURE_PIECE_MF, StructureUtility.transpose((String[][])shapeMainFrame)).addShape(STRUCTURE_PIECE_DTB, StructureUtility.transpose((String[][])shapeDryingTowerBase)).addShape(STRUCTURE_PIECE_DTM, StructureUtility.transpose((String[][])shapeDryingTowerMiddle)).addShape(STRUCTURE_PIECE_DTH, StructureUtility.transpose((String[][])shapeDryingTowerHat)).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('S', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('V', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)1)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('J', StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)10)).addElement('C', StructureUtility.withChannel((String)"coil", (IStructureElement)GTStructureUtility.ofCoil(TST_GiantVacuumDryingFurnace::setCoilLevel, TST_GiantVacuumDryingFurnace::getCoilLevel))).addElement('E', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy), HatchElement.InputHatch, HatchElement.OutputBus}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(2)).buildAndChain(GregTechAPI.sBlockCasings8, 2)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int piece = stackSize.field_77994_a;
        this.buildPiece(STRUCTURE_PIECE_VP, stackSize, hintsOnly, 10, 4, 0);
        this.buildPiece(STRUCTURE_PIECE_MF, stackSize, hintsOnly, 1, 3, 0);
        this.buildPiece(STRUCTURE_PIECE_DTB, stackSize, hintsOnly, -2, 1, 0);
        for (int pointer = 0; pointer < piece; ++pointer) {
            this.buildPiece(STRUCTURE_PIECE_DTM, stackSize, hintsOnly, -2, 1 + 7 * pointer + 7, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_DTH, stackSize, hintsOnly, -2, 1 + 7 * piece + 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int[] built = new int[stackSize.field_77994_a + 5];
        int piece = stackSize.field_77994_a;
        built[0] = this.survivialBuildPiece(STRUCTURE_PIECE_VP, stackSize, 10, 4, 0, elementBudget, env, false, true);
        built[1] = this.survivialBuildPiece(STRUCTURE_PIECE_MF, stackSize, 1, 3, 0, elementBudget, env, false, true);
        built[2] = this.survivialBuildPiece(STRUCTURE_PIECE_DTB, stackSize, -2, 1, 0, elementBudget, env, false, true);
        for (int pointer = 0; pointer < piece; ++pointer) {
            built[3 + pointer] = this.survivialBuildPiece(STRUCTURE_PIECE_DTM, stackSize, -2, 1 + 7 * pointer + 7, 0, elementBudget, env, false, true);
        }
        built[built.length - 1] = this.survivialBuildPiece(STRUCTURE_PIECE_DTH, stackSize, -2, 1 + 7 * piece + 3, 0, elementBudget, env, false, true);
        return TstUtils.multiBuildPiece(built);
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.coilLevel = aCoilLevel;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    public int getCoilTier() {
        return TstUtils.getVoltageForCoil(this.coilLevel);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_GVDF_MachineType")).addInfo(TextEnums.tr("Tooltip_GVDF_00")).addInfo(TextEnums.tr("Tooltip_GVDF_01")).addInfo(TextEnums.tr("Tooltip_GVDF_02")).addInfo(TextEnums.tr("Tooltip_GVDF_03")).addInfo(TextEnums.tr("Tooltip_GVDF_04")).addInfo(TextEnums.tr("Tooltip_GVDF_05")).addInfo(TextEnums.tr("Tooltip_GVDF_06")).addInfo(TextEnums.tr("Tooltip_GVDF_07")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).beginStructureBlock(11, 10, 23, true).addController(TextLocalization.textFrontCenter).addInputHatch(TextEnums.tr("Tooltip_GVDF_HatchBusInfo")).addOutputHatch(TextEnums.tr("Tooltip_GVDF_HatchBusInfo")).addInputBus(TextEnums.tr("Tooltip_GVDF_HatchBusInfo")).addOutputBus(TextEnums.tr("Tooltip_GVDF_HatchBusInfo")).addEnergyHatch(TextEnums.tr("Tooltip_GVDF_EnergyHatch")).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.coilLevel = HeatingCoilLevel.None;
        this.piece = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_VP, 10, 4, 0)) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_MF, 1, 3, 0)) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_DTB, -2, 1, 0)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_DTM, -2, 1 + 7 * this.piece + 7, 0)) {
            ++this.piece;
        }
        if (this.piece < 1 || !this.checkPiece(STRUCTURE_PIECE_DTH, -2, 1 + 7 * this.piece + 3, 0)) {
            return false;
        }
        this.maxParallel = (int)Math.min((long)this.piece * (long)this.getCoilTier() * (long)Config.Parallel_PerPiece_GiantVacuumDryingFurnace, Integer.MAX_VALUE);
        this.speedBonus = (float)Math.pow(Config.SpeedBonus_MultiplyPerVoltageTier_GiantVacuumDryingFurnace, this.getTotalPowerTier()) / ((float)this.getCoilTier() * Config.SpeedMultiplier_CoilTier_GiantVacuumDryingFurnace);
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_GiantVacuumDryingFurnace(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)2))};
    }
}

