/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.recipes.ResultInsufficientPedestals;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.mojang.authlib.GameProfile;
import goodgenerator.loader.Loaders;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumcraft.common.tiles.TilePedestal;

public class TST_InfusionMaterialDispenser
extends GTCM_MultiMachineBase<TST_InfusionMaterialDispenser> {
    private TileInfusionMatrix targetMatrix;
    private TilePedestal mainPedestal;
    private ArrayList<TilePedestal> subPedestals = new ArrayList();
    public FakePlayer fakePlayer = null;
    public String playerName = null;
    public static final int STATE_IDLE = 0;
    public static final int STATE_INFUSING = 1;
    private static IStructureDefinition<TST_InfusionMaterialDispenser> multiDefinition = null;
    public int infusionState = 0;
    private static Method getReturnedPearlsMethod;
    private static Item wgItemMaterial;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private final int horizontalOffSet = 4;
    private final int verticalOffSet = 0;
    private final int depthOffSet = 4;
    private static final String[][] shape;

    public TST_InfusionMaterialDispenser(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_InfusionMaterialDispenser(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("infusionState", this.infusionState);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.infusionState = aNBT.func_74762_e("infusionState");
        this.subPedestals.clear();
        super.loadNBTData(aNBT);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList tItemsList = this.getStoredInputs();
        this.setElectricityStats();
        World world = this.getBaseMetaTileEntity().getWorld();
        int x = this.getBaseMetaTileEntity().getXCoord();
        short y = this.getBaseMetaTileEntity().getYCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        TileEntity tempTile = null;
        tempTile = world.func_147438_o(x, y - 1, z);
        if (!(tempTile instanceof TileInfusionMatrix)) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_infusion_matrix");
        }
        this.targetMatrix = (TileInfusionMatrix)tempTile;
        if (!this.targetMatrix.active) {
            return SimpleCheckRecipeResult.ofFailure((String)"unactivated_infusion_matrix");
        }
        this.mainPedestal = (TilePedestal)world.func_147438_o(x, y - 3, z);
        if (this.subPedestals.isEmpty()) {
            this.AddSubPedestals();
        }
        if (this.fakePlayer == null) {
            if (this.getControllerSlot() == null) {
                return SimpleCheckRecipeResult.ofFailure((String)"no_paper_in_controller");
            }
            this.playerName = this.getControllerSlot().func_82833_r();
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(UUID.randomUUID(), "[TST_InfusionFakePlayer]"));
            Thaumcraft.proxy.getCompletedResearch().put(this.fakePlayer.func_70005_c_(), ResearchManager.getResearchForPlayerSafe((String)this.playerName));
        }
        if (this.infusionState == 0) {
            if (tItemsList.isEmpty() && this.isAllPedestalsEmpty() && this.mainPedestal.func_70301_a(0) == null) {
                return SimpleCheckRecipeResult.ofSuccess((String)"waiting_for_infusion");
            }
            if (this.isAllPedestalsEmpty() && this.mainPedestal.func_70301_a(0) == null) {
                if (this.isPedestalSpaceSufficient(tItemsList, this.subPedestals) > 0) {
                    return new ResultInsufficientPedestals(this.isPedestalSpaceSufficient(tItemsList, this.subPedestals));
                }
                this.insertItemsIntoPedestals(tItemsList, this.mainPedestal, this.subPedestals);
                for (MTEHatchInputBus bus : GTUtility.validMTEList((Collection)this.mInputBusses)) {
                    if (bus instanceof MTEHatchCraftingInputME) continue;
                    IGregTechTileEntity tile = bus.getBaseMetaTileEntity();
                    for (int i = 0; i < tile.func_70302_i_(); ++i) {
                        tile.func_70299_a(i, null);
                    }
                }
                this.targetMatrix.craftingStart((EntityPlayer)this.fakePlayer);
                this.infusionState = 1;
                return SimpleCheckRecipeResult.ofSuccess((String)"infusioning");
            }
        }
        if (this.infusionState == 1) {
            if (this.targetMatrix.crafting) {
                return SimpleCheckRecipeResult.ofSuccess((String)"infusioning");
            }
            this.collectAndOutputResults();
            this.infusionState = 0;
            return SimpleCheckRecipeResult.ofSuccess((String)"infusion_complete");
        }
        return SimpleCheckRecipeResult.ofFailure((String)"unknown_problem");
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack itemStack) {
        this.fakePlayer = null;
        this.subPedestals.clear();
    }

    public void onDisableWorking() {
        this.mOutputItems = new ItemStack[0];
        super.onDisableWorking();
    }

    protected void setElectricityStats() {
        this.mOutputItems = new ItemStack[0];
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 1;
        OverclockCalculator calculator = new OverclockCalculator().setEUt(0L).setAmperage(0L).setDuration(1).enablePerfectOC();
        calculator.calculate();
    }

    public int isPedestalSpaceSufficient(ArrayList<ItemStack> tItemsList, ArrayList<TilePedestal> subPedestals) {
        int totalItems = 0;
        for (ItemStack stack : tItemsList) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            totalItems += stack.field_77994_a;
        }
        int totalPedestals = subPedestals.size() + 1;
        return totalItems - totalPedestals;
    }

    public void insertItemsIntoPedestals(ArrayList<ItemStack> itemsList, TilePedestal mainPedestal, ArrayList<TilePedestal> subPedestals) {
        if (mainPedestal.func_70301_a(0) == null && !itemsList.isEmpty()) {
            mainPedestal.func_70299_a(0, itemsList.get(itemsList.size() - 1).func_77946_l());
            --itemsList.get((int)(itemsList.size() - 1)).field_77994_a;
            itemsList.spliterator();
            if (itemsList.get((int)(itemsList.size() - 1)).field_77994_a <= 0) {
                itemsList.remove(itemsList.size() - 1);
            }
        }
        block0: for (int i = itemsList.size() - 1; i >= 0; --i) {
            while (itemsList.get((int)i).field_77994_a > 0) {
                TilePedestal tp = null;
                for (TilePedestal pedestal : subPedestals) {
                    if (pedestal.func_70301_a(0) != null) continue;
                    tp = pedestal;
                    break;
                }
                if (tp == null) continue block0;
                tp.func_70299_a(0, itemsList.get(i).func_77946_l());
                --itemsList.get((int)i).field_77994_a;
                if (itemsList.get((int)i).field_77994_a > 0) continue;
                itemsList.remove(i);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAndOutputResults() {
        ArrayList<ItemStack> outputBuffer = new ArrayList<ItemStack>();
        TST_InfusionMaterialDispenser tST_InfusionMaterialDispenser = this;
        synchronized (tST_InfusionMaterialDispenser) {
            ItemStack mainStack = this.mainPedestal.func_70301_a(0);
            if (this.mainPedestal.func_70301_a(0) != null) {
                if (getReturnedPearlsMethod != null && wgItemMaterial != null) {
                    try {
                        int pearls = (Integer)getReturnedPearlsMethod.invoke((Object)mainStack.func_77973_b(), mainStack);
                        if (pearls > 0) {
                            ItemStack pearlStack = new ItemStack(wgItemMaterial, pearls, 12);
                            outputBuffer.add(pearlStack);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                outputBuffer.add(this.mainPedestal.func_70301_a(0).func_77946_l());
                this.mainPedestal.func_70299_a(0, null);
            }
            for (TilePedestal pedestal : this.subPedestals) {
                if (pedestal == null || pedestal.func_70301_a(0) == null) continue;
                outputBuffer.add(pedestal.func_70301_a(0).func_77946_l());
                pedestal.func_70299_a(0, null);
            }
        }
        this.mOutputItems = outputBuffer.toArray(new ItemStack[0]);
    }

    public boolean isAllPedestalsEmpty() {
        if (this.subPedestals == null || this.subPedestals.isEmpty()) {
            return true;
        }
        for (TilePedestal pedestal : this.subPedestals) {
            ItemStack stack = pedestal.func_70301_a(0);
            if (stack == null) continue;
            return false;
        }
        return true;
    }

    public void AddSubPedestals() {
        this.subPedestals.clear();
        World world = this.getBaseMetaTileEntity().getWorld();
        int centerX = this.getBaseMetaTileEntity().getXCoord();
        int centerY = this.getBaseMetaTileEntity().getYCoord();
        --centerY;
        int centerZ = this.getBaseMetaTileEntity().getZCoord();
        for (int xOffset = -12; xOffset <= 12; ++xOffset) {
            block1: for (int zOffset = -12; zOffset <= 12; ++zOffset) {
                if (xOffset == 0 && zOffset == 0) continue;
                for (int yOffset = -5; yOffset <= 10; ++yOffset) {
                    int x = centerX + xOffset;
                    int y = centerY + yOffset;
                    int z = centerZ + zOffset;
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (!(te instanceof TilePedestal)) continue;
                    this.subPedestals.add((TilePedestal)te);
                    continue block1;
                }
            }
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.subPedestals.clear();
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 0, 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        this.subPedestals.clear();
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 4, 0, 4, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_InfusionMaterialDispenser> getStructureDefinition() {
        if (multiDefinition == null) {
            multiDefinition = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shape)).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_InfusionMaterialDispenser.class).atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus}).adder(GTCM_MultiMachineBase::addToMachineList).casingIndex(1536).dot(1).buildAndChain(Loaders.magicCasing, 0)})).build();
        }
        return multiDefinition;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_InfusionMaterialDispenser_MachineType")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_00")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_01")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_02")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_03")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_04")).addInfo(TextEnums.tr("Tooltip_InfusionMaterialDispenser_05")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).beginStructureBlock(11, 10, 23, true).addController(TextLocalization.textFrontCenter).addInputBus(TextEnums.tr("Tooltip_InfusionMaterialDispenser_HatchBusInfo")).addOutputBus(TextEnums.tr("Tooltip_InfusionMaterialDispenser_HatchBusInfo")).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.subPedestals.clear();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 0, 4);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_InfusionMaterialDispenser(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536)};
    }

    static {
        try {
            Class<?> clazz = Class.forName("witchinggadgets.api.IPrimordialCrafting");
            getReturnedPearlsMethod = clazz.getMethod("getReturnedPearls", ItemStack.class);
            Class<?> wgContentClass = Class.forName("witchinggadgets.common.WGContent");
            wgItemMaterial = (Item)wgContentClass.getField("ItemMaterial").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shape = new String[][]{{"         ", "         ", "         ", "         ", "    ~    ", "         ", "         ", "         ", "         "}, {"         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "}, {"         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "}, {"    A    ", "         ", "         ", "         ", "A       A", "         ", "         ", "         ", "    A    "}};
    }
}

