/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.block.meta.multiuse.BlockMultiUseCore;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TstSharedFormat;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class TST_ManufacturingCenter
extends GTPPMultiBlockBase<TST_ManufacturingCenter>
implements ISurvivalConstructable {
    private static final int LOWEST_CORE_TIER = 5;
    private static final double SPEED_BONUS_BASE = Config.ManufacturingCenter_SpeedBonus_Base;
    private static final double SPEED_BONUS_FOR_CORE_TIER = Config.ManufacturingCenter_SpeedBonus_Tier;
    private static final double EU_REDUCTION_FOR_CORE_TIER = Config.ManufacturingCenter_PowerReduction;
    private static final int MAX_PARALLEL_MODIFIER = Config.ManufacturingCenter_MaxParallelModifier;
    public int coreTier = -1;
    public int casingCount = 0;
    private static final BiMap<Integer, ManufacturingMachineType> MODES = HashBiMap.create();
    private static IStructureDefinition<TST_ManufacturingCenter> StructureDef;

    public TST_ManufacturingCenter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_ManufacturingCenter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_ManufacturingCenter(this.mName);
    }

    private RecipeMap<?> getRecipeMapAtCurrentMode() {
        if (!MODES.containsKey((Object)this.machineMode)) {
            this.machineMode = 0;
        }
        return ((ManufacturingMachineType)MODES.get((Object)this.machineMode)).recipeMap;
    }

    public int getMaxParallelRecipes() {
        return MAX_PARALLEL_MODIFIER * GTUtility.getTier((long)this.getMaxInputVoltage());
    }

    private long getMaxVoltageTierAtCurrentMode() {
        return GTValues.V[this.coreTier];
    }

    private double getSpeedBonusAtCurrentCore() {
        return 1.0 / (1.0 + SPEED_BONUS_BASE + SPEED_BONUS_FOR_CORE_TIER * (double)(this.coreTier - 5));
    }

    private double getEuModifierAtCurrentCore() {
        return 1.0 - EU_REDUCTION_FOR_CORE_TIER * (double)Math.max(0, this.coreTier - 5);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 200;
    }

    public RecipeMap<?> getRecipeMap() {
        return this.getRecipeMapAtCurrentMode();
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (GTUtility.getTier((long)recipe.mEUt) > TST_ManufacturingCenter.this.coreTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)GTUtility.getTier((long)recipe.mEUt));
                }
                if ((Integer)recipe.getMetadataOrDefault((RecipeMetadataKey)CompressionTierKey.INSTANCE, (Object)0) > 0) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getAverageInputVoltage());
        logic.setAvailableAmperage(this.getMaxInputAmps());
        logic.setAmperageOC(this.mEnergyHatches.size() > 1);
        logic.setSpeedBonus(this.getSpeedBonusAtCurrentCore());
        logic.setEuModifier(this.getEuModifierAtCurrentCore());
    }

    @Deprecated
    public String getMachineType() {
        return null;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        TstSharedFormat.setDefaultColor(EnumChatFormatting.GRAY);
        tt.addMachineType(TextEnums.tr("ManufacturingCenter_Tooltips_MachineType")).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_1")).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_2")).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_3", TstSharedFormat.getTierName(9))).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_4")).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_5", TstSharedFormat.getTierName(5), TstSharedFormat.percentage(SPEED_BONUS_FOR_CORE_TIER * 100.0))).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_6", TstSharedFormat.getTierName(5), TstSharedFormat.percentage(EU_REDUCTION_FOR_CORE_TIER * 100.0))).addInfo(TextEnums.tr("ManufacturingCenter_Tooltips_7", MAX_PARALLEL_MODIFIER)).addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, false).addController("Front Center").addOtherStructurePart("MultiUse Core", "At Center").addCasingInfoMin("Multi-Use Casings", 6, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).addSeparator().addInfo(TextEnums.Author_Taskeren.toString()).toolTipFinisher(new String[]{TextEnums.Mod_TwistSpaceTechnology.toString()});
        return tt;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.compressorRecipes, RecipeMaps.latheRecipes, RecipeMaps.polarizerRecipes, RecipeMaps.fermentingRecipes, RecipeMaps.fluidExtractionRecipes, RecipeMaps.extractorRecipes, RecipeMaps.laserEngraverRecipes, RecipeMaps.autoclaveRecipes, RecipeMaps.fluidSolidifierRecipes);
    }

    public int getRecipeCatalystPriority() {
        return -10;
    }

    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(EnumChatFormatting.GOLD + "Machine-Mode: " + this.getMachineModeName());
        info.add(EnumChatFormatting.GOLD + "Core-Tier: " + GTUtility.getColoredTierNameFromTier((byte)((byte)this.coreTier)));
        return info.toArray(new String[0]);
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    public boolean supportsMachineModeSwitch() {
        return true;
    }

    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setMachineMode(this.nextMachineMode());
        TstUtils.sendMessageKeyToPlayer(aPlayer, "GT5U.MULTI_MACHINE_CHANGE", this.getMachineMode());
    }

    private static int getMachineModesCount() {
        return MODES.size();
    }

    public int getMachineMode() {
        return this.machineMode;
    }

    private ManufacturingMachineType getManufacturingMachineMode() {
        return (ManufacturingMachineType)MODES.get((Object)this.getMachineMode());
    }

    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)this.getManufacturingMachineMode().unlocalizedName);
    }

    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)((ManufacturingMachineType)MODES.get((Object)mode)).unlocalizedName);
    }

    public void setMachineMode(int index) {
        this.machineMode = index % TST_ManufacturingCenter.getMachineModesCount();
    }

    public int nextMachineMode() {
        return this.getMachineMode() + 1 % TST_ManufacturingCenter.getMachineModesCount();
    }

    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_COMPRESSING);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_POLARIZER);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_DEFAULT);
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.machineMode);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + this.getMachineModeName(tag.func_74762_e("mode")) + EnumChatFormatting.RESET);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    public int getTextureIndex() {
        return TAE.getIndexFromPage((int)2, (int)2);
    }

    protected IIconContainer getActiveOverlay() {
        return TstMachineTextures.oMCAIndustrialMultiMachineActive;
    }

    protected IIconContainer getInactiveOverlay() {
        return TstMachineTextures.oMCAIndustrialMultiMachine;
    }

    protected int getCasingTextureId() {
        return this.getTextureIndex();
    }

    public IStructureDefinition<TST_ManufacturingCenter> getStructureDefinition() {
        if (StructureDef == null) {
            StructureDef = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "CAC", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_ManufacturingCenter.class).atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance, HatchElement.Muffler}).casingIndex(this.getTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(te -> ++te.casingCount, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)2))})).addElement('A', StructureUtility.withChannel((String)"core", BlockMultiUseCore.ofMultiUseCore(-1, (te, tier) -> {
                te.coreTier = tier;
            }, te -> te.coreTier))).build();
        }
        return StructureDef;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("main", stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingCount = 0;
        if (!this.checkPiece("main", 1, 1, 0)) {
            return false;
        }
        return this.mExoticEnergyHatches.isEmpty() && this.casingCount >= 6;
    }

    static {
        MODES.put((Object)0, (Object)ManufacturingMachineType.of(RecipeMaps.compressorRecipes));
        MODES.put((Object)1, (Object)ManufacturingMachineType.of(RecipeMaps.latheRecipes));
        MODES.put((Object)2, (Object)ManufacturingMachineType.of(RecipeMaps.polarizerRecipes));
        MODES.put((Object)3, (Object)ManufacturingMachineType.of(RecipeMaps.fermentingRecipes));
        MODES.put((Object)4, (Object)ManufacturingMachineType.of(RecipeMaps.fluidExtractionRecipes));
        MODES.put((Object)5, (Object)ManufacturingMachineType.of(RecipeMaps.extractorRecipes));
        MODES.put((Object)6, (Object)ManufacturingMachineType.of(RecipeMaps.laserEngraverRecipes));
        MODES.put((Object)7, (Object)ManufacturingMachineType.of(RecipeMaps.autoclaveRecipes));
        MODES.put((Object)8, (Object)ManufacturingMachineType.of(RecipeMaps.fluidSolidifierRecipes));
        StructureDef = null;
    }

    private static final class ManufacturingMachineType {
        private final String typeName;
        private final RecipeMap<?> recipeMap;
        private final String unlocalizedName;

        private ManufacturingMachineType(String typeName, RecipeMap<?> recipeMap, String unlocalizedName) {
            this.typeName = typeName;
            this.recipeMap = recipeMap;
            this.unlocalizedName = unlocalizedName;
        }

        public static ManufacturingMachineType of(RecipeMap<?> recipeMap) {
            String[] recipeMapNameParts = recipeMap.unlocalizedName.split("\\.");
            return new ManufacturingMachineType(recipeMapNameParts[recipeMapNameParts.length - 1], recipeMap, recipeMap.unlocalizedName);
        }

        public String typeName() {
            return this.typeName;
        }

        public RecipeMap<?> recipeMap() {
            return this.recipeMap;
        }

        public String unlocalizedName() {
            return this.unlocalizedName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ManufacturingMachineType that = (ManufacturingMachineType)obj;
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.recipeMap, that.recipeMap) && Objects.equals(this.unlocalizedName, that.unlocalizedName);
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.recipeMap, this.unlocalizedName);
        }

        public String toString() {
            return "ManufacturingMachineType[typeName=" + this.typeName + ", recipeMap=" + this.recipeMap + ", unlocalizedName=" + this.unlocalizedName + ']';
        }
    }
}

