/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class TST_MicroSpaceTimeFabricatorio
extends GTCM_MultiMachineBase<TST_MicroSpaceTimeFabricatorio> {
    public static TST_ItemID SeedSpaceTime;
    protected int transcendentCasingTier = 0;
    protected int injectionCasingTier = 0;
    protected int bridgeCasingTier = 0;
    protected int fieldTier = 0;
    protected MTEHatchInputBus specialInputBus;
    protected static final int horizontalOffSet = 9;
    protected static final int verticalOffSet = 20;
    protected static final int depthOffSet = 1;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static IStructureDefinition<TST_MicroSpaceTimeFabricatorio> STRUCTURE_DEFINITION;
    protected static Textures.BlockIcons.CustomIcon ActiveFace;
    protected static Textures.BlockIcons.CustomIcon InactiveFace;

    public TST_MicroSpaceTimeFabricatorio(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_MicroSpaceTimeFabricatorio(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_MicroSpaceTimeFabricatorio(this.mName);
    }

    public static void initStatics() {
        SeedSpaceTime = TST_ItemID.createNoNBT(GTCMItemList.SeedsSpaceTime.get(1, new Object[0]));
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("transcendentCasingTier", this.transcendentCasingTier);
        aNBT.func_74768_a("injectionCasingTier", this.injectionCasingTier);
        aNBT.func_74768_a("bridgeCasingTier", this.bridgeCasingTier);
        aNBT.func_74768_a("fieldTier", this.fieldTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.transcendentCasingTier = aNBT.func_74762_e("transcendentCasingTier");
        this.injectionCasingTier = aNBT.func_74762_e("injectionCasingTier");
        this.bridgeCasingTier = aNBT.func_74762_e("bridgeCasingTier");
        this.fieldTier = aNBT.func_74762_e("fieldTier");
    }

    public RecipeMap<?> getRecipeMap() {
        return GTCMRecipe.MicroSpaceTimeFabricatorioRecipes;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (!(Config.Safe_Calamity_MicroSpaceTimeFabricatorio || this.fieldTier <= 1 || this.transcendentCasingTier >= 2 && this.injectionCasingTier >= 2 && this.bridgeCasingTier >= 2)) {
            this.explodeMultiblock();
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.setupProcessingLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        result = this.postCheckRecipe(result, this.processingLogic);
        this.updateSlots();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.processingLogic.getDuration();
        this.setEnergyUsage(this.processingLogic);
        this.mOutputItems = this.processingLogic.getOutputItems();
        this.mOutputFluids = this.processingLogic.getOutputFluids();
        if (this.tryConsumeSpaceTimeSeed()) {
            ArrayList<Object> o;
            if (this.mOutputItems != null && this.mOutputItems.length > 0) {
                o = new ArrayList<Object>();
                for (ItemStack itemStack : this.mOutputItems) {
                    o.add(itemStack.func_77946_l());
                    o.add(itemStack);
                }
                this.mOutputItems = o.toArray(new ItemStack[0]);
            }
            if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
                o = new ArrayList();
                for (ItemStack itemStack : this.mOutputFluids) {
                    o.add(itemStack.copy());
                    o.add(itemStack);
                }
                this.mOutputFluids = o.toArray(new FluidStack[0]);
            }
        }
        return result;
    }

    protected boolean tryConsumeSpaceTimeSeed() {
        if (null == this.specialInputBus || !this.specialInputBus.isValid()) {
            return false;
        }
        IGregTechTileEntity te = this.specialInputBus.getBaseMetaTileEntity();
        for (int i = te.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack itemStack = te.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a < 1 || !SeedSpaceTime.equalItemStack(itemStack)) continue;
            --itemStack.field_77994_a;
            return true;
        }
        return false;
    }

    public void updateSlots() {
        super.updateSlots();
        if (null != this.specialInputBus && this.specialInputBus.isValid()) {
            this.specialInputBus.updateSlots();
        }
    }

    @Override
    public int getMaxParallelRecipes() {
        return Config.Parallel_MicroSpaceTimeFabricatorio;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.specialInputBus = null;
        this.transcendentCasingTier = 0;
        this.injectionCasingTier = 0;
        this.bridgeCasingTier = 0;
        this.fieldTier = 0;
        this.enablePerfectOverclock = false;
        this.speedBonus = 1.0f;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 9, 20, 1)) {
            return false;
        }
        if (this.fieldTier < 1) {
            return false;
        }
        if (this.fieldTier > 1) {
            if (Config.Safe_Calamity_MicroSpaceTimeFabricatorio && (this.transcendentCasingTier < 2 || this.injectionCasingTier < 2 || this.bridgeCasingTier < 2)) {
                return false;
            }
            this.enablePerfectOverclock = true;
            if (this.fieldTier > 2) {
                int t = this.fieldTier - 2;
                int speedUp = (t + 1) * t / 2;
                this.speedBonus = 1.0f / (float)speedUp;
            }
        }
        return true;
    }

    public static int getBlockFieldTier(Block block, int meta) {
        if (block == TTCasingsContainer.sBlockCasingsTT && meta == 14) {
            return 1;
        }
        if (block == TTCasingsContainer.StabilisationFieldGenerators && meta <= 8) {
            return meta + 2;
        }
        return -1;
    }

    public static int getBlockTranscendentCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && meta == 12) {
            return 1;
        }
        if (block == TTCasingsContainer.sBlockCasingsBA0 && meta == 11) {
            return 2;
        }
        return 0;
    }

    public static int getBlockInjectionCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && meta == 13) {
            return 1;
        }
        if (block == TTCasingsContainer.sBlockCasingsBA0 && meta == 12) {
            return 2;
        }
        return 0;
    }

    public static int getBlockBridgeCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && meta == 14) {
            return 1;
        }
        if (block == TTCasingsContainer.sBlockCasingsTT && meta == 10) {
            return 2;
        }
        return 0;
    }

    public boolean addSpecialInputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            MTEHatchInputBus hatch = (MTEHatchInputBus)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            hatch.mRecipeMap = this.getRecipeMap();
            this.specialInputBus = hatch;
            return true;
        }
        return false;
    }

    public void startRecipeProcessing() {
        MTEHatchInputBus mTEHatchInputBus;
        super.startRecipeProcessing();
        if (null != this.specialInputBus && this.specialInputBus.isValid() && (mTEHatchInputBus = this.specialInputBus) instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)mTEHatchInputBus;
            aware.startRecipeProcessing();
        }
    }

    public void endRecipeProcessing() {
        MTEHatchInputBus mTEHatchInputBus;
        super.endRecipeProcessing();
        if (null != this.specialInputBus && this.specialInputBus.isValid() && (mTEHatchInputBus = this.specialInputBus) instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)mTEHatchInputBus;
            this.setResultIfFailure(aware.endRecipeProcessing((MTEMultiBlockBase)this));
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.repairMachine();
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 9, 20, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 9, 20, 1, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_MicroSpaceTimeFabricatorio> getStructureDefinition() {
        if (null == STRUCTURE_DEFINITION) {
            IStructureElement tra = StructureUtility.ofBlocksTiered(TST_MicroSpaceTimeFabricatorio::getBlockTranscendentCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)12), (Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsBA0, (Object)11)), (Object)0, (m, t) -> {
                m.transcendentCasingTier = t;
            }, m -> m.transcendentCasingTier);
            IStructureElement inj = StructureUtility.ofBlocksTiered(TST_MicroSpaceTimeFabricatorio::getBlockInjectionCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)13), (Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsBA0, (Object)12)), (Object)0, (m, t) -> {
                m.injectionCasingTier = t;
            }, m -> m.injectionCasingTier);
            IStructureElement bri = StructureUtility.ofBlocksTiered(TST_MicroSpaceTimeFabricatorio::getBlockBridgeCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)14), (Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsTT, (Object)10)), (Object)0, (m, t) -> {
                m.bridgeCasingTier = t;
            }, m -> m.bridgeCasingTier);
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "             D     ", "             D     ", "             D     ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "            D      ", "            D      ", "                   ", "                   ", "                   ", "            D      ", "            D      ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "            D      ", "            D      ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "            D      ", "            D      ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "           D       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "           D       ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "           D       ", "                   ", "                   ", "                   ", "                   ", " D                 ", " D                 ", " D                 ", "                   ", "                   ", "                   ", "                   ", "           D       ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "          D        ", "                   ", "   D               ", "   D               ", "  D                ", "  D                ", "                   ", "                   ", "                   ", "  D                ", "  D                ", "   D               ", "   D               ", "                   ", "          D        ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "          D        ", "    DD             ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "    DD             ", "          D        ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "         D         ", "      DD           ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "      DD           ", "         D         ", "                   "}, {"                   ", "                   ", "                   ", "         C         ", "        DDD        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        DDD        ", "         C         "}, {"                   ", "                   ", "                   ", "                   ", "         D         ", "           DD      ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "           DD      ", "         D         ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "        D          ", "             DD    ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "             DD    ", "        D          ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "        D          ", "                   ", "               D   ", "               D   ", "                D  ", "                D  ", "                   ", "                   ", "                   ", "                D  ", "                D  ", "               D   ", "               D   ", "                   ", "        D          ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       D           ", "                   ", "                   ", "                   ", "                   ", "                 D ", "                 D ", "                 D ", "                   ", "                   ", "                   ", "                   ", "       D           ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       D           ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       D           ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "      D            ", "      D            ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "      D            ", "      D            ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "      D            ", "      D            ", "                   ", "                   ", "                   ", "      D            ", "      D            ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "     D             ", "     D             ", "     D             ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "        CCC        ", "                   ", "    CC       CC    ", "    C         C    ", "                   ", "                   ", "  C             C  ", "  C             C  ", "  C             C  ", "                   ", "                   ", "    C         C    ", "    CC       CC    ", "                   ", "        CCC        ", "                   ", "                   "}, {"                   ", "         ~         ", "                   ", "                   ", "        CCC        ", "      CCBBBCC      ", "    CCBBBBBBBCC    ", "   CBBBBBBBBBBBC   ", "   CBBBBBBBBBBBC   ", "  CBBBBBBBBBBBBBC  ", "  CBBBBBBBBBBBBBC  ", " CBBBBBBBBBBBBBBBC ", " CBBBBBBBBBBBBBBBC ", " CBBBBBBBBBBBBBBBC ", "  CBBBBBBBBBBBBBC  ", "  CBBBBBBBBBBBBBC  ", "   CBBBBBBBBBBBC   ", "   CBBBBBBBBBBBC   ", "    CCBBBBBBBCC    ", "      CCBBBCC      ", "        CCC        ", "                   "}, {"       FAEAF       ", "       FAAAF       ", "       FAAAF       ", "       AAAAA       ", "      AAAAAAA      ", "    AAAAAAAAAAA    ", "   AAAAAAAAAAAAA   ", "  AAAAAAAAAAAAAAA  ", "  AAAAAAAAAAAAAAA  ", " AAAAAAAAAAAAAAAAA ", " AAAAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAAAA ", " AAAAAAAAAAAAAAAAA ", "  AAAAAAAAAAAAAAA  ", "  AAAAAAAAAAAAAAA  ", "   AAAAAAAAAAAAA   ", "    AAAAAAAAAAA    ", "      AAAAAAA      ", "        AAA        "}})).addElement('A', tra).addElement('B', inj).addElement('C', bri).addElement('D', StructureUtility.ofBlocksTiered(TST_MicroSpaceTimeFabricatorio::getBlockFieldTier, (List)ImmutableList.of((Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsTT, (Object)14), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)0), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)1), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)2), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)3), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)4), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)5), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)6), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)7), (Object)Pair.of((Object)TTCasingsContainer.StabilisationFieldGenerators, (Object)8)), (Object)0, (m, t) -> {
                m.fieldTier = t;
            }, m -> m.fieldTier)).addElement('E', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus}).adder(TST_MicroSpaceTimeFabricatorio::addSpecialInputBusToMachineList).dot(2).casingIndex(1036).buildAndChain(new IStructureElement[]{tra})).addElement('F', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(1024).buildAndChain(new IStructureElement[]{inj})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tooltip = new MultiblockTooltipBuilder();
        tooltip.addMachineType(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_MachineType")).addInfo(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_01")).addInfo(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_02")).addInfo(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_03")).addInfo(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_04")).addInfo(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio_05")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).beginStructureBlock(19, 22, 22, false).addOtherStructurePart(TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio.structure.SpecialInputBus.name"), TextEnums.tr("Tooltip_MicroSpaceTimeFabricatorio.structure.SpecialInputBus.location"), new int[]{2}).addInputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addInputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ActiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Adv_on");
        InactiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Adv_off");
        super.registerIcons(aBlockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TTRenderedExtendedFacingTexture((IIconContainer)(active ? ActiveFace : InactiveFace))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    static {
        STRUCTURE_DEFINITION = null;
    }
}

