/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.enums.TierEU;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.apiculture.genetics.Bee;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;

public abstract class TST_SpaceApiary
extends TileEntityModuleBase {
    private static final INameFunction<TST_SpaceApiary> PARALLEL_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.pump.cfgi.2") + " " + (p.hatchId() / 2 + 1);
    private static final IStatusFunction<TST_SpaceApiary> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getMaxParallels(), (double[])new double[0]);
    Parameters.Group.ParameterIn[] parallelSettings;
    private final Fluid liquddna = FluidRegistry.getFluid((String)"liquiddna") != null ? FluidRegistry.getFluid((String)"liquiddna") : FluidRegistry.getFluid((String)"water");
    protected World world;
    protected float voltageTierExact;
    final HashMap<TST_ItemID, Double> dropProgress = new HashMap();

    public TST_SpaceApiary(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
    }

    public TST_SpaceApiary(String aName, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aName, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
    }

    public double getVoltageTierExact() {
        return Math.log((double)GTValues.V[6] / 8.0) / Math.log(4.0) + 1.0E-8;
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick_EM(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.world = this.getBaseMetaTileEntity().getWorld();
            this.voltageTierExact = (float)this.getVoltageTierExact();
        }
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        ItemStack controllerStack = this.getControllerSlot();
        if (controllerStack == null || BeeManager.beeRoot.getType(controllerStack) != EnumBeeType.QUEEN) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int mParallel = this.getCurrentParallel();
        if (TierEU.RECIPE_LuV * (long)mParallel > this.getEUVar()) {
            return CheckRecipeResultRegistry.insufficientPower((long)(TierEU.RECIPE_LuV * (long)mParallel));
        }
        if (ValueEnum.enableDNAConsuming && !this.consumeLiquidDNA()) {
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        this.updateSlots();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        BeeSimulator beeSimulator = new BeeSimulator(controllerStack, this.world, this.voltageTierExact);
        for (ItemStack outItems : beeSimulator.getDrops(this, 6400.0)) {
            if (outItems == null || outItems.field_77994_a < 1) continue;
            long amount = (long)outItems.field_77994_a * (long)mParallel;
            if (amount <= Integer.MAX_VALUE) {
                outputs.add(GTUtility.copyAmountUnsafe((int)((int)amount), (ItemStack)outItems));
                continue;
            }
            while (amount >= Integer.MAX_VALUE) {
                outputs.add(GTUtility.copyAmountUnsafe((int)Integer.MAX_VALUE, (ItemStack)outItems));
                amount -= Integer.MAX_VALUE;
            }
            if (amount <= 0L) continue;
            outputs.add(GTUtility.copyAmountUnsafe((int)((int)amount), (ItemStack)outItems));
        }
        this.lEUt = -TierEU.RECIPE_LuV * (long)mParallel;
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = ValueEnum.SpaceApiaryCycleTime;
        this.mOutputItems = outputs.toArray(new ItemStack[0]);
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected abstract int getLiquidDnaConsumingAmount();

    private boolean consumeLiquidDNA() {
        if (this.getStoredFluids().isEmpty()) {
            return false;
        }
        int consumeAmount = this.getCurrentParallel() * this.getLiquidDnaConsumingAmount();
        for (FluidStack fluid : this.getStoredFluids()) {
            if (fluid.getFluid() != this.liquddna || fluid.amount < consumeAmount) continue;
            fluid.amount -= consumeAmount;
            return true;
        }
        return false;
    }

    protected int getCurrentParallel() {
        return Math.min((int)this.parallelSettings[0].get(), this.getMaxParallels());
    }

    protected int getMaxParallels() {
        return Integer.MAX_VALUE;
    }

    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        this.parallelSettings = new Parameters.Group.ParameterIn[1];
        this.parallelSettings[0] = this.parametrization.getGroup(0, false).makeInParameter(0, 1.0, PARALLEL_SETTING_NAME, PARALLEL_STATUS);
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        if (ValueEnum.SpaceApiaryEnableDisplayInfo) {
            ((Column)((Column)((Column)screenElements.widget(TextWidget.dynamicString(this::generateRecipeInfo).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.mMachine && this.mOutputItems != null && this.mOutputItems.length > 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mProgresstime, val -> {
                this.mProgresstime = val;
            }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mMaxProgresstime, val -> {
                this.mMaxProgresstime = val;
            }))).widget((Widget)new FakeSyncWidget.ListSyncer(() -> this.mOutputItems != null ? Arrays.asList(this.mOutputItems) : Collections.emptyList(), val -> {
                this.mOutputItems = val.toArray(new ItemStack[0]);
            }, NetworkUtils::writeItemStack, NetworkUtils::readItemStack));
        }
    }

    private String generateRecipeInfo() {
        StringBuilder ret = new StringBuilder("Progress: ").append(String.format("%,.2f", (double)this.mProgresstime / 20.0)).append("s / ").append(String.format("%,.2f", (double)this.mMaxProgresstime / 20.0)).append("s (").append(String.format("%,.1f", (double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0)).append("%)\n");
        if (this.mOutputItems != null) {
            for (ItemStack outputItem : this.mOutputItems) {
                String ItemDisplayName = outputItem.func_82833_r();
                ret.append(" - ").append(ItemDisplayName).append(String.format(" x %d", outputItem.field_77994_a)).append("\n");
            }
        }
        return ret.toString();
    }

    private static class BeeSimulator {
        final ItemStack queenStack;
        boolean isValid = false;
        List<BeeDrop> drops = new ArrayList<BeeDrop>();
        List<BeeDrop> specialDrops = new ArrayList<BeeDrop>();
        float beeSpeed;
        float maxBeeCycles;
        private static IBeekeepingMode mode;
        static final Map<TST_ItemID, ItemStack> dropstacks;

        public BeeSimulator(ItemStack queenStack, World world, float t) {
            this.queenStack = queenStack.func_77946_l();
            this.queenStack.field_77994_a = 1;
            this.generate(world, t);
            this.isValid = true;
        }

        public void generate(World world, float t) {
            if (mode == null) {
                mode = BeeManager.beeRoot.getBeekeepingMode(world);
            }
            this.drops.clear();
            this.specialDrops.clear();
            if (BeeManager.beeRoot.getType(this.queenStack) != EnumBeeType.QUEEN) {
                return;
            }
            IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
            IBeeModifier beeModifier = mode.getBeeModifier();
            float mod = beeModifier.getLifespanModifier(null, null, 1.0f);
            int h = queen.getMaxHealth();
            this.maxBeeCycles = (float)h / (1.0f / mod);
            IBeeGenome genome = queen.getGenome();
            IAlleleBeeSpecies primary = genome.getPrimary();
            this.beeSpeed = genome.getSpeed();
            genome.getPrimary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
            genome.getSecondary().getProductChances().forEach((key, value) -> this.drops.add(new BeeDrop((ItemStack)key, value.floatValue() / 2.0f, this.beeSpeed, t)));
            primary.getSpecialtyChances().forEach((key, value) -> this.specialDrops.add(new BeeDrop((ItemStack)key, value.floatValue(), this.beeSpeed, t)));
        }

        public List<ItemStack> getDrops(TST_SpaceApiary MTE, double timePassed) {
            this.drops.forEach(d -> {
                MTE.dropProgress.merge(d.id, d.getAmount(timePassed / 550.0), Double::sum);
                if (!dropstacks.containsKey((Object)d.id)) {
                    dropstacks.put(d.id, d.stack);
                }
            });
            this.specialDrops.forEach(d -> {
                MTE.dropProgress.merge(d.id, d.getAmount(timePassed / 550.0), Double::sum);
                if (!dropstacks.containsKey((Object)d.id)) {
                    dropstacks.put(d.id, d.stack);
                }
            });
            ArrayList<ItemStack> currentDrops = new ArrayList<ItemStack>();
            MTE.dropProgress.entrySet().forEach(e -> {
                double v = (Double)e.getValue();
                long size = (long)v;
                while (size > 0L) {
                    ItemStack stack;
                    if (size > Integer.MAX_VALUE) {
                        stack = dropstacks.get(e.getKey()).func_77946_l();
                        stack.field_77994_a = Integer.MAX_VALUE;
                        currentDrops.add(stack);
                        size -= Integer.MAX_VALUE;
                        v -= 2.147483647E9;
                        continue;
                    }
                    stack = dropstacks.get(e.getKey()).func_77946_l();
                    stack.field_77994_a = (int)size;
                    currentDrops.add(stack);
                    v -= (double)size;
                    size = 0L;
                }
                e.setValue(v);
            });
            return currentDrops;
        }

        static {
            dropstacks = new HashMap<TST_ItemID, ItemStack>();
        }

        private static class BeeDrop {
            private static final float MAX_PRODUCTION_MODIFIER_FROM_UPGRADES = 17.199268f;
            final ItemStack stack;
            double amount;
            final TST_ItemID id;
            final float chance;
            final float beeSpeed;
            float t;

            public BeeDrop(ItemStack stack, float chance, float beeSpeed, float t) {
                this.stack = stack;
                this.chance = chance;
                this.beeSpeed = beeSpeed;
                this.t = t;
                this.id = TST_ItemID.create(this.stack);
                this.evaluate();
            }

            public void evaluate() {
                this.amount = Bee.getFinalChance((float)this.chance, (float)this.beeSpeed, (float)(17.199268f + mode.getBeeModifier().getProductionModifier(null, 17.199268f)), (float)this.t);
            }

            public double getAmount(double speedModifier) {
                return this.amount * speedModifier;
            }

            public int hashCode() {
                return this.id.hashCode();
            }
        }
    }

    public static class TST_SpaceApiaryT4
    extends TST_SpaceApiary {
        protected static final int MODULE_VOLTAGE_TIER = 25;
        protected static final int MODULE_TIER = 4;
        protected static final int MINIMUM_MOTOR_TIER = 4;
        protected static final int MAX_PARALLELS = ValueEnum.SpaceApiaryMaxParallels_T4;

        @Override
        protected int getMaxParallels() {
            return MAX_PARALLELS;
        }

        @Override
        protected int getLiquidDnaConsumingAmount() {
            return ValueEnum.SpaceApiaryDNACost_T4;
        }

        @Override
        public double getVoltageTierExact() {
            return Math.log(2.68435455875E8) / Math.log(4.0) + 1.0E-8;
        }

        public TST_SpaceApiaryT4(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 25, 4, 4, MAX_PARALLELS);
        }

        public TST_SpaceApiaryT4(String aName) {
            super(aName, 25, 4, 4, MAX_PARALLELS);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TST_SpaceApiaryT4(this.mName);
        }

        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addInfo(TextLocalization.Tooltip_SpaceApiary_desc0).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + TextLocalization.Tooltip_SpaceApiary_t4_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc2).addInfo(TextLocalization.Tooltip_SpaceApiary_t4_desc3).addInfo(TextLocalization.Tooltip_SpaceApiary_t4_desc4).addInfo(TextLocalization.Tooltip_SpaceApiary_t4_desc5).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.motorT4")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(StatCollector.func_74838_a((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addOutputBus(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
            return tt;
        }
    }

    public static class TST_SpaceApiaryT3
    extends TST_SpaceApiary {
        protected static final int MODULE_VOLTAGE_TIER = 18;
        protected static final int MODULE_TIER = 3;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAX_PARALLELS = ValueEnum.SpaceApiaryMaxParallels_T3;

        @Override
        protected int getMaxParallels() {
            return MAX_PARALLELS;
        }

        @Override
        protected int getLiquidDnaConsumingAmount() {
            return ValueEnum.SpaceApiaryDNACost_T3;
        }

        @Override
        public double getVoltageTierExact() {
            return Math.log((double)GTValues.V[10] / 8.0) / Math.log(4.0) + 1.0E-8;
        }

        public TST_SpaceApiaryT3(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 18, 3, 3, MAX_PARALLELS);
        }

        public TST_SpaceApiaryT3(String aName) {
            super(aName, 18, 3, 3, MAX_PARALLELS);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TST_SpaceApiaryT3(this.mName);
        }

        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addInfo(TextLocalization.Tooltip_SpaceApiary_desc0).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + TextLocalization.Tooltip_SpaceApiary_t3_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc2).addInfo(TextLocalization.Tooltip_SpaceApiary_t3_desc3).addInfo(TextLocalization.Tooltip_SpaceApiary_t3_desc4).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.motorT3")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(StatCollector.func_74838_a((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addOutputBus(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
            return tt;
        }
    }

    public static class TST_SpaceApiaryT2
    extends TST_SpaceApiary {
        protected static final int MODULE_VOLTAGE_TIER = 14;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 2;
        protected static final int MAX_PARALLELS = ValueEnum.SpaceApiaryMaxParallels_T2;

        @Override
        protected int getMaxParallels() {
            return MAX_PARALLELS;
        }

        @Override
        protected int getLiquidDnaConsumingAmount() {
            return ValueEnum.SpaceApiaryDNACost_T2;
        }

        @Override
        public double getVoltageTierExact() {
            return Math.log((double)GTValues.V[9] / 8.0) / Math.log(4.0) + 1.0E-8;
        }

        public TST_SpaceApiaryT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 14, 2, 2, MAX_PARALLELS);
        }

        public TST_SpaceApiaryT2(String aName) {
            super(aName, 14, 2, 2, MAX_PARALLELS);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TST_SpaceApiaryT2(this.mName);
        }

        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addInfo(TextLocalization.Tooltip_SpaceApiary_desc0).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + TextLocalization.Tooltip_SpaceApiary_t2_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc2).addInfo(TextLocalization.Tooltip_SpaceApiary_t2_desc3).addInfo(TextLocalization.Tooltip_SpaceApiary_t2_desc4).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.motorT2")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(StatCollector.func_74838_a((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addOutputBus(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
            return tt;
        }
    }

    public static class TST_SpaceApiaryT1
    extends TST_SpaceApiary {
        protected static final int MODULE_VOLTAGE_TIER = 10;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 1;
        protected static final int MAX_PARALLELS = ValueEnum.SpaceApiaryMaxParallels_T1;

        @Override
        protected int getMaxParallels() {
            return MAX_PARALLELS;
        }

        @Override
        public double getVoltageTierExact() {
            return Math.log((double)GTValues.V[8] / 8.0) / Math.log(4.0) + 1.0E-8;
        }

        @Override
        protected int getLiquidDnaConsumingAmount() {
            return ValueEnum.SpaceApiaryDNACost_T1;
        }

        public TST_SpaceApiaryT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 10, 1, 1, MAX_PARALLELS);
        }

        public TST_SpaceApiaryT1(String aName) {
            super(aName, 10, 1, 1, MAX_PARALLELS);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TST_SpaceApiaryT1(this.mName);
        }

        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addInfo(TextLocalization.Tooltip_SpaceApiary_desc0).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + TextLocalization.Tooltip_SpaceApiary_t1_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc1).addInfo(TextLocalization.Tooltip_SpaceApiary_desc2).addInfo(TextLocalization.Tooltip_SpaceApiary_t1_desc3).addInfo(TextLocalization.Tooltip_SpaceApiary_t1_desc4).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.motorT1")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(StatCollector.func_74838_a((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addOutputBus(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(StatCollector.func_74838_a((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
            return tt;
        }
    }
}

