/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class GTCM_MultiMachineBase<T extends GTCM_MultiMachineBase<T>>
extends MTEExtendedPowerMultiBlockBase<T>
implements IConstructable,
ISurvivalConstructable {
    protected boolean enablePerfectOverclock = false;
    protected int maxParallel = 1;
    protected float euModifier = 1.0f;
    protected float speedBonus = 1.0f;

    public GTCM_MultiMachineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTCM_MultiMachineBase(String aName) {
        super(aName);
    }

    public void repairMachine() {
        this.mHardHammer = true;
        this.mSoftMallet = true;
        this.mScrewdriver = true;
        this.mCrowbar = true;
        this.mSolderingTool = true;
        this.mWrench = true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("enablePerfectOverclock", this.enablePerfectOverclock);
        aNBT.func_74768_a("maxParallel", this.maxParallel);
        aNBT.func_74776_a("euModifier", this.euModifier);
        aNBT.func_74776_a("speedBonus", this.speedBonus);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.enablePerfectOverclock = aNBT.func_74767_n("enablePerfectOverclock");
        this.maxParallel = Math.max(aNBT.func_74762_e("maxParallel"), 1);
        this.euModifier = aNBT.func_74760_g("euModifier");
        if (this.euModifier <= 0.0f) {
            this.euModifier = 1.0f;
        }
        this.speedBonus = aNBT.func_74760_g("speedBonus");
        if (this.speedBonus <= 0.0f) {
            this.speedBonus = 1.0f;
        }
    }

    @ApiStatus.OverrideOnly
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(GTCM_MultiMachineBase.this.getEuModifier());
                this.setSpeedBonus(GTCM_MultiMachineBase.this.getSpeedBonus());
                this.setOverclockType(GTCM_MultiMachineBase.this.isEnablePerfectOverclock() ? OverclockType.PerfectOverclock : OverclockType.NormalOverclock);
                return super.process();
            }
        }.setMaxParallelSupplier(this::getLimitedMaxParallel);
    }

    @ApiStatus.OverrideOnly
    protected boolean isEnablePerfectOverclock() {
        return this.enablePerfectOverclock;
    }

    @ApiStatus.OverrideOnly
    protected float getEuModifier() {
        return this.euModifier;
    }

    @ApiStatus.OverrideOnly
    protected float getSpeedBonus() {
        return this.speedBonus;
    }

    @ApiStatus.OverrideOnly
    public int getMaxParallelRecipes() {
        return this.maxParallel;
    }

    @ApiStatus.OverrideOnly
    public boolean isUnlimitedTierSkips() {
        return true;
    }

    protected int getLimitedMaxParallel() {
        return this.getMaxParallelRecipes();
    }

    public int getTotalPowerTier() {
        return TstUtils.getMachineTotalPowerTier(this);
    }

    protected long getActualEnergyUsage() {
        return (long)((double)(-this.lEUt) * (10000.0 / (double)Math.max(1000, this.mEfficiency)));
    }

    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (this.processingLogic == null) {
            return this.checkRecipe(this.mInventory[1]) ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.setupProcessingLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        result = this.postCheckRecipe(result, this.processingLogic);
        this.updateSlots();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.processingLogic.getDuration();
        this.setEnergyUsage(this.processingLogic);
        this.mOutputItems = this.processingLogic.getOutputItems();
        this.mOutputFluids = this.processingLogic.getOutputFluids();
        return result;
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        if (this.isUnlimitedTierSkips()) {
            logic.setUnlimitedTierSkips();
        }
    }

    public ArrayList<ItemStack> getStoredInputsWithoutDualInputHatch() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchInputBus tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                rList.add(itemStack);
            }
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(this.func_70301_a(1));
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputItemsWithDualInputHatch() {
        if (this.supportsCraftingMEBuffer() && !this.mDualInputHatches.isEmpty()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator inventoryIterator = dualInputHatch.inventories();
                while (inventoryIterator.hasNext()) {
                    ItemStack[] items = ((IDualInputInventory)inventoryIterator.next()).getItemInputs();
                    if (items == null || items.length == 0) continue;
                    ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i] == null) continue;
                        rList.add(items[i]);
                    }
                    return rList;
                }
            }
        }
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchInputBus tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                rList.add(itemStack);
            }
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(this.func_70301_a(1));
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputsNoSeparation() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator inventoryIterator = dualInputHatch.inventories();
                while (inventoryIterator.hasNext()) {
                    ItemStack[] items = ((IDualInputInventory)inventoryIterator.next()).getItemInputs();
                    if (items == null || items.length == 0) continue;
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i] == null) continue;
                        rList.add(items[i]);
                    }
                }
            }
        }
        HashMap<GTUtility.ItemId, ItemStack> inputsFromME = new HashMap<GTUtility.ItemId, ItemStack>();
        for (MTEHatchInputBus tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            IGregTechTileEntity tileEntity = tHatch.getBaseMetaTileEntity();
            boolean isMEBus = tHatch instanceof MTEHatchInputBusME;
            for (int i = tileEntity.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack itemStack = tileEntity.func_70301_a(i);
                if (itemStack == null) continue;
                if (isMEBus) {
                    inputsFromME.put(GTUtility.ItemId.createNoCopy((ItemStack)itemStack), itemStack);
                    continue;
                }
                rList.add(itemStack);
            }
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(this.func_70301_a(1));
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public ArrayList<FluidStack> getStoredFluidsWithDualInput() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        HashMap<Fluid, FluidStack> inputsFromME = new HashMap<Fluid, FluidStack>();
        for (MTEHatchInput tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputHatches)) {
            this.setHatchRecipeMap(tHatch);
            if (tHatch instanceof MTEHatchMultiInput) {
                MTEHatchMultiInput multiInputHatch = (MTEHatchMultiInput)tHatch;
                for (FluidStack tFluid : multiInputHatch.getStoredFluid()) {
                    if (tFluid == null) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchInputME) {
                MTEHatchInputME meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack fluidStack : meHatch.getStoredFluids()) {
                    if (fluidStack == null) continue;
                    inputsFromME.put(fluidStack.getFluid(), fluidStack);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator inventoryIterator = dualInputHatch.inventories();
                while (inventoryIterator.hasNext()) {
                    FluidStack[] fluids = ((IDualInputInventory)inventoryIterator.next()).getFluidInputs();
                    if (fluids == null || fluids.length == 0) continue;
                    for (int i = 0; i < fluids.length; ++i) {
                        if (fluids[i] == null || fluids[i].amount <= 0) continue;
                        rList.add(fluids[i]);
                    }
                }
            }
        }
        return rList;
    }

    public String[] getInfoData() {
        String dSpeed = String.format("%.3f", Float.valueOf(this.getSpeedBonus() * 100.0f)) + "%";
        String dEUMod = String.format("%.3f", Float.valueOf(this.getEuModifier() * 100.0f)) + "%";
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 3];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + TextEnums.tr("MachineInfoData.Parallels") + ": " + EnumChatFormatting.GOLD + this.getLimitedMaxParallel();
        ret[origin.length + 1] = EnumChatFormatting.AQUA + TextEnums.tr("MachineInfoData.SpeedMultiplier") + ": " + EnumChatFormatting.GOLD + dSpeed;
        ret[origin.length + 2] = EnumChatFormatting.AQUA + TextEnums.tr("MachineInfoData.EuModifier") + ": " + EnumChatFormatting.GOLD + dEUMod;
        return ret;
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addEnergyHatchOrExoticEnergyHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addInputBusOrOutputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addInputBusToMachineList(aTileEntity, aBaseCasingIndex) || this.addOutputBusToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addInputHatchOrOutputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addInputHatchToMachineList(aTileEntity, aBaseCasingIndex) || this.addOutputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchMuffler) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMufflerHatches.add((MTEHatchMuffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (!this.mDynamoHatches.isEmpty()) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (MTEHatchDynamo aDynamo : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mDynamoHatches)) {
            long aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        long actualOutputEU = totalOutput < aEU ? totalOutput : aEU;
        for (MTEHatchDynamo aDynamo : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mDynamoHatches)) {
            long leftToInject = actualOutputEU - (long)injected;
            long aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            for (int i = 0; i < ampsOnCurrentHatch; ++i) {
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage, false);
            }
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits((long)aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void checkMaintenance() {
    }

    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    public final boolean shouldCheckMaintenance() {
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean willExplodeInRain() {
        return false;
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean getDefaultBatchMode() {
        if (!this.supportsBatchMode()) {
            return false;
        }
        return Config.DEFAULT_BATCH_MODE;
    }

    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    public int getRecipeCatalystPriority() {
        return -1;
    }

    public int totalMachineMode() {
        return 1;
    }

    public String getMachineModeName(int mode) {
        return "Unknown Mode " + mode;
    }

    public final String getMachineModeName() {
        return this.getMachineModeName(this.machineMode);
    }

    public void setMachineModeIcons() {
        for (int i = 0; i < this.totalMachineMode(); ++i) {
            this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_DEFAULT);
        }
    }

    public boolean supportsMachineModeSwitch() {
        return this.totalMachineMode() > 1;
    }

    public int nextMachineMode() {
        if (this.machineMode + 1 >= this.totalMachineMode()) {
            return 0;
        }
        return this.machineMode + 1;
    }

    public boolean canButtonSwitchMode() {
        return this.supportsMachineModeSwitch();
    }

    public ButtonWidget createModeSwitchButton(IWidgetBuilder<?> builder) {
        if (!this.supportsMachineModeSwitch()) {
            return null;
        }
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.canButtonSwitchMode()) {
                this.onMachineModeSwitchClick();
                this.setMachineMode(this.nextMachineMode());
            }
        }).setPlayClickSound(this.supportsMachineModeSwitch()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (!this.supportsMachineModeSwitch()) {
                return null;
            }
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(this.getMachineModeIcon(this.getMachineMode()));
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> ((GTCM_MultiMachineBase)this).getMachineMode(), arg_0 -> ((GTCM_MultiMachineBase)this).setMachineMode(arg_0)), builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.mode_switch")).setTooltipShowUpDelay(5).setPos(this.getMachineModeSwitchButtonPos()).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.supportsMachineModeSwitch()) {
                this.setMachineMode(this.nextMachineMode());
                GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)this.getMachineModeName());
            } else {
                super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aStack);
            }
        }
    }

    public boolean showModeInWaila() {
        return this.supportsMachineModeSwitch();
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.showModeInWaila()) {
            tag.func_74768_a("mode", this.machineMode);
        }
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("mode")) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + this.getMachineModeName(tag.func_74762_e("mode")) + EnumChatFormatting.RESET);
        }
    }

    public long getAllDynamoBuffer() {
        long buffer = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList((Collection)this.mDynamoHatches)) {
            buffer += tHatch.getEUVar();
        }
        return buffer;
    }

    public long getAllMaxDynamoBuffer() {
        long buffer = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList((Collection)this.mDynamoHatches)) {
            buffer += tHatch.maxEUStore();
        }
        return buffer;
    }

    public long getDynamoAmperage() {
        long dynamoAmperage = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList((Collection)this.mDynamoHatches)) {
            dynamoAmperage += tHatch.getBaseMetaTileEntity().getOutputAmperage();
        }
        return dynamoAmperage;
    }

    public boolean setDynamoTier(int tier, boolean onlyThisTier) {
        if (onlyThisTier) {
            return this.mDynamoHatches.stream().allMatch(dynamo -> dynamo.getTierForStructure() == tier);
        }
        return this.mDynamoHatches.stream().allMatch(dynamo -> dynamo.getTierForStructure() <= tier);
    }

    public boolean checkMixedDynamo() {
        long firstVoltage = -1L;
        for (MTEHatchDynamo tHatch : GTUtility.validMTEList((Collection)this.mDynamoHatches)) {
            long aVoltage = tHatch.maxEUOutput();
            if (firstVoltage == -1L) {
                firstVoltage = aVoltage;
                continue;
            }
            if (firstVoltage == aVoltage) continue;
            return true;
        }
        return false;
    }

    public boolean checkCountDynamo(int countAvaliableDynamo) {
        int count = 0;
        for (MTEHatchDynamo tHatch : GTUtility.validMTEList((Collection)this.mDynamoHatches)) {
            if (++count <= countAvaliableDynamo) continue;
            return false;
        }
        return true;
    }

    public long getTierDynamo() {
        if (!this.checkMixedDynamo()) {
            return this.mDynamoHatches.stream().mapToLong(MTEHatchDynamo::maxEUOutput).distinct().reduce((a, b) -> 0L).orElse(0L);
        }
        return 0L;
    }
}

