/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class GT_MetaTileEntity_Hatch_DualInput
extends MTEHatchInputBus
implements IAddUIWidgets,
IDualInputHatch {
    private final FluidStack[] mStoredFluid;
    private final FluidStackTank[] fluidTanks;
    public final int mCapacityPer;
    private static final int ITEM_SLOT_AMOUNT = 19;
    private static final int CATALYST_SLOT_1 = 16;
    private static final int CATALYST_SLOT_2 = 17;
    Inventory inventory;

    public GT_MetaTileEntity_Hatch_DualInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 19, new String[]{TextEnums.tr("ToolTip_DualInputHatch_1"), TextLocalization.FluidCapacity + " " + GT_MetaTileEntity_Hatch_DualInput.getCapacityPerTank(aTier) + " L", TextEnums.tr("ToolTip_DualInputHatch_2") + " " + GT_MetaTileEntity_Hatch_DualInput.getSlots((int)aTier) + " " + TextEnums.tr("ToolTip_DualInputHatch_3") + " " + GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier) + " " + TextEnums.tr("ToolTip_DualInputHatch_4"), TextLocalization.AutoSeparation, TextLocalization.ModNameDesc});
        this.mStoredFluid = new FluidStack[GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier)];
        this.fluidTanks = new FluidStackTank[GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier)];
        this.mCapacityPer = GT_MetaTileEntity_Hatch_DualInput.getCapacityPerTank(aTier);
        this.inventory = new Inventory(this.mInventory, this.mStoredFluid);
    }

    public GT_MetaTileEntity_Hatch_DualInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 19, aDescription, aTextures);
        this.mStoredFluid = new FluidStack[GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier)];
        this.fluidTanks = new FluidStackTank[GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier)];
        this.mCapacityPer = GT_MetaTileEntity_Hatch_DualInput.getCapacityPerTank(aTier);
        for (int i = 0; i < GT_MetaTileEntity_Hatch_DualInput.getFluidSlotsAmount(aTier); ++i) {
            int index = i;
            this.fluidTanks[i] = new FluidStackTank(() -> this.mStoredFluid[index], fluid -> {
                this.mStoredFluid[index] = fluid;
            }, this.mCapacityPer);
        }
        this.inventory = new Inventory(this.mInventory, this.mStoredFluid);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_DualInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null) continue;
                aNBT.func_74782_a("mFluid" + i, (NBTBase)this.mStoredFluid[i].writeToNBT(new NBTTagCompound()));
            }
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (!aNBT.func_74764_b("mFluid" + i)) continue;
                this.mStoredFluid[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + i));
            }
        }
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUFFER)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUFFER)};
    }

    public FluidStack getFluid() {
        for (FluidStack tFluid : this.mStoredFluid) {
            if (tFluid == null || tFluid.amount <= 0) continue;
            return tFluid;
        }
        return null;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPullStack(aBaseMetaTileEntity, aIndex, side, aStack) && aIndex != 16 && aIndex != 17;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex != 16 && aIndex != 17 && super.allowPutStack(aBaseMetaTileEntity, aIndex, side, aStack);
    }

    public FluidStack getFluid(int aSlot) {
        if (this.mStoredFluid == null || aSlot < 0 || aSlot >= this.getMaxType()) {
            return null;
        }
        return this.mStoredFluid[aSlot];
    }

    public int getFluidAmount() {
        if (this.getFluid() != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    public int getCapacity() {
        return this.mCapacityPer;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.getMaxType(); ++i) {
            if (this.mStoredFluid[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFluid(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        for (FluidStack tFluid : this.mStoredFluid) {
            if (!aFluid.isFluidEqual(tFluid)) continue;
            return true;
        }
        return false;
    }

    public int getFluidSlot(FluidStack tFluid) {
        if (tFluid == null) {
            return -1;
        }
        for (int i = 0; i < this.getMaxType(); ++i) {
            if (!tFluid.isFluidEqual(this.mStoredFluid[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFluidAmount(FluidStack tFluid) {
        int tSlot = this.getFluidSlot(tFluid);
        if (tSlot != -1) {
            return this.mStoredFluid[tSlot].amount;
        }
        return 0;
    }

    public void setFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        this.mStoredFluid[aSlot] = aFluid;
    }

    public void addFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        if (aFluid.equals((Object)this.mStoredFluid[aSlot])) {
            this.mStoredFluid[aSlot].amount += aFluid.amount;
        }
        if (this.mStoredFluid[aSlot] == null) {
            this.mStoredFluid[aSlot] = aFluid.copy();
        }
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mFluid = this.getFluid();
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public boolean justUpdated() {
        return false;
    }

    public Iterator<? extends IDualInputInventory> inventories() {
        return Arrays.stream(new Inventory[]{this.inventory}).filter(Objects::nonNull).iterator();
    }

    public Optional<IDualInputInventory> getFirstNonEmptyInventory() {
        if (!this.inventory.isEmpty()) {
            return Optional.of(this.inventory);
        }
        return Optional.empty();
    }

    public boolean supportsFluids() {
        return true;
    }

    public ItemStack[] getSharedItems() {
        return new ItemStack[0];
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public int getCircuitSlot() {
        return 18;
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (!this.hasFluid(aFluid) && this.getFirstEmptySlot() != -1) {
            int tFilled = Math.min(aFluid.amount, this.mCapacityPer);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFirstEmptySlot());
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        if (this.hasFluid(aFluid)) {
            int tLeft = this.mCapacityPer - this.getFluidAmount(aFluid);
            int tFilled = Math.min(tLeft, aFluid.amount);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFluidSlot(tFluid));
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack nowFluid = this.getFluid();
        if (nowFluid == null) {
            return null;
        }
        return this.drain(ForgeDirection.UNKNOWN, new FluidStack(nowFluid.getFluid(), maxDrain), doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack aFluid, boolean doDrain) {
        if (aFluid == null || !this.hasFluid(aFluid)) {
            return null;
        }
        FluidStack tStored = this.mStoredFluid[this.getFluidSlot(aFluid)];
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        FluidStack tRemove = tStored.copy();
        tRemove.amount = Math.min(aFluid.amount, tRemove.amount);
        if (doDrain) {
            tStored.amount -= tRemove.amount;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return tRemove;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.updateSlots();
        }
    }

    public void updateSlots() {
        int i;
        if (this.mInventory != null) {
            for (i = 0; i < this.mInventory.length - 1; ++i) {
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                this.mInventory[i] = null;
            }
        }
        if (this.mStoredFluid != null) {
            for (i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null || this.mStoredFluid[i].amount > 0) continue;
                this.mStoredFluid[i] = null;
            }
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] FTI = new FluidTankInfo[this.getMaxType()];
        for (int i = 0; i < this.getMaxType(); ++i) {
            FTI[i] = new FluidTankInfo(this.mStoredFluid[i], this.mCapacityPer);
        }
        return FTI;
    }

    public int getMaxType() {
        return this.mStoredFluid.length;
    }

    public static int getFluidSlotsAmount(int tier) {
        int n;
        switch (tier) {
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static int getCapacityPerTank(int aTier) {
        int n;
        switch (aTier) {
            case 5: {
                n = 20000;
                break;
            }
            case 6: {
                n = 60000;
                break;
            }
            case 7: {
                n = 180000;
                break;
            }
            case 8: {
                n = 540000;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        Pos2d[] pos2dArray;
        int SLOT_NUMBER = this.fluidTanks.length;
        switch (SLOT_NUMBER) {
            case 2: {
                Pos2d[] pos2dArray2 = new Pos2d[2];
                pos2dArray2[0] = new Pos2d(124, 7);
                pos2dArray = pos2dArray2;
                pos2dArray2[1] = new Pos2d(124, 25);
                break;
            }
            case 3: {
                Pos2d[] pos2dArray3 = new Pos2d[3];
                pos2dArray3[0] = new Pos2d(124, 7);
                pos2dArray3[1] = new Pos2d(124, 25);
                pos2dArray = pos2dArray3;
                pos2dArray3[2] = new Pos2d(124, 43);
                break;
            }
            case 4: {
                Pos2d[] pos2dArray4 = new Pos2d[4];
                pos2dArray4[0] = new Pos2d(124, 7);
                pos2dArray4[1] = new Pos2d(124, 25);
                pos2dArray4[2] = new Pos2d(124, 43);
                pos2dArray = pos2dArray4;
                pos2dArray4[3] = new Pos2d(124, 61);
                break;
            }
            case 6: {
                Pos2d[] pos2dArray5 = new Pos2d[6];
                pos2dArray5[0] = new Pos2d(124, 7);
                pos2dArray5[1] = new Pos2d(124, 25);
                pos2dArray5[2] = new Pos2d(124, 43);
                pos2dArray5[3] = new Pos2d(142, 7);
                pos2dArray5[4] = new Pos2d(142, 25);
                pos2dArray = pos2dArray5;
                pos2dArray5[5] = new Pos2d(142, 43);
                break;
            }
            default: {
                pos2dArray = new Pos2d[]{};
            }
        }
        Pos2d[] positions = pos2dArray;
        for (int i = 0; i < SLOT_NUMBER; ++i) {
            builder.widget(new FluidSlotWidget((IFluidTank)this.fluidTanks[i]).setBackground(new IDrawable[]{ModularUITextures.FLUID_SLOT}).setPos(positions[i]));
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(16).endAtSlot(17).background(new IDrawable[]{ModularUITextures.ITEM_SLOT, GTUITextures.OVERLAY_SLOT_MOLECULAR_1}).build().setPos(7, 7));
        this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[0]);
    }

    public static class Inventory
    implements IDualInputInventory {
        private final ItemStack[] itemInventory;
        private final FluidStack[] fluidInventory;

        public Inventory(ItemStack[] items, FluidStack[] fluid) {
            this.itemInventory = items;
            this.fluidInventory = fluid;
        }

        public ItemStack[] getItemInputs() {
            if (this.isEmpty()) {
                return new ItemStack[0];
            }
            return (ItemStack[])Arrays.stream(this.itemInventory).filter(Objects::nonNull).toArray(ItemStack[]::new);
        }

        public FluidStack[] getFluidInputs() {
            if (this.isEmpty()) {
                return new FluidStack[0];
            }
            return (FluidStack[])Arrays.stream(this.fluidInventory).filter(Objects::nonNull).toArray(FluidStack[]::new);
        }

        public boolean isEmpty() {
            if (this.itemInventory != null) {
                for (int i = 0; i < this.itemInventory.length - 3; ++i) {
                    if (this.itemInventory[i] == null || this.itemInventory[i].field_77994_a <= 0) continue;
                    return false;
                }
            }
            if (this.fluidInventory != null) {
                for (FluidStack fluid : this.fluidInventory) {
                    if (fluid == null || fluid.amount <= 0) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

