/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch.GT_MetaTileEntity_Pipe_EnergySmart_Focusing;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaserMirror;
import tectech.util.CommonValues;

public class GT_MetaTileEntity_Pipe_EnergySmart
extends MTETieredMachineBlock
implements IConnectsToEnergyTunnel {
    public long Voltage;
    public long Amperes;
    public long actualInputAmperes = 0L;
    public long actualOutputAmperes = 0L;
    public long lastStoredEU = 0L;
    private static Textures.BlockIcons.CustomIcon EMCandyActive;
    private static Textures.BlockIcons.CustomIcon EMpipe;

    public GT_MetaTileEntity_Pipe_EnergySmart(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 10, 0, (String)null, new ITexture[0]);
    }

    public GT_MetaTileEntity_Pipe_EnergySmart(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMCandyActive = new Textures.BlockIcons.CustomIcon("iconsets/EM_CANDY_ACTIVE");
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_LASER");
        super.registerIcons(aBlockIconRegister);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_Pipe_EnergySmart(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("Voltage", this.Voltage);
        aNBT.func_74772_a("Amperes", this.Amperes);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.Voltage = aNBT.func_74763_f("Voltage");
        this.Amperes = aNBT.func_74763_f("Amperes");
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, TextEnums.tr("LaserSmartNode.getDescription.01"), TextEnums.tr("LaserSmartNode.getDescription.02"), TextEnums.tr("LaserSmartNode.getDescription.03"), TextEnums.tr("LaserFocusedSmartNode.description.04"), TextEnums.tr("LaserFocusedSmartNode.description.05"), TextEnums.AddByTwistSpaceTechnology.getText()};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return new ITexture[]{TextureFactory.of((IIconContainer)EMpipe), Textures.OVERLAYS_ENERGY_IN_LASER_TT[this.mTier], TextureFactory.of((IIconContainer)EMCandyActive, (short[])Dyes.getModulation((int)colorIndex, (short[])Dyes.MACHINE_METAL.getRGBA()))};
        }
        return new ITexture[]{TextureFactory.of((IIconContainer)EMpipe), TextureFactory.of((IIconContainer)EMCandyActive, (short[])Dyes.getModulation((int)colorIndex, (short[])Dyes.MACHINE_METAL.getRGBA()))};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public long maxEUInput() {
        return this.Voltage;
    }

    public long maxEUOutput() {
        return this.Voltage;
    }

    public long maxEUStore() {
        return 24L * this.Voltage * this.Amperes;
    }

    public long maxAmperesOut() {
        return this.Amperes;
    }

    public long maxAmperesIn() {
        return this.Amperes;
    }

    public long getMinimumStoredEU() {
        return this.Voltage;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return !this.isInputFacing(side);
    }

    public void doExplosion(long aExplosionPower) {
    }

    public void setEUVar(long newEU) {
        long deltaEU = newEU - this.lastStoredEU;
        if (deltaEU > 0L) {
            this.actualInputAmperes += deltaEU / (this.Voltage * 20L);
        } else if (deltaEU < 0L) {
            this.actualOutputAmperes += -deltaEU / (this.Voltage * 20L);
        }
        this.lastStoredEU = newEU;
        super.setEUVar(newEU);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L) {
            this.actualInputAmperes = 0L;
            this.actualOutputAmperes = 0L;
            byte color = this.getBaseMetaTileEntity().getColorization();
            if (color < 0) {
                return;
            }
            MTEHatchDynamoTunnel dynamo = null;
            ArrayList<MetaTileEntity> energies = new ArrayList<MetaTileEntity>();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IMetaTileEntity aMetaTileEntity;
                if (side == aBaseMetaTileEntity.getFrontFacing()) {
                    aMetaTileEntity = this.findMTE(aBaseMetaTileEntity, color, side, true);
                    if (aMetaTileEntity instanceof MTEHatchDynamoTunnel) {
                        MTEHatchDynamoTunnel dynamoTunnel;
                        dynamo = dynamoTunnel = (MTEHatchDynamoTunnel)aMetaTileEntity;
                        this.Voltage = dynamoTunnel.maxEUOutput();
                        this.Amperes = dynamoTunnel.Amperes;
                        continue;
                    }
                    if (aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart) {
                        GT_MetaTileEntity_Pipe_EnergySmart energySmart = (GT_MetaTileEntity_Pipe_EnergySmart)aMetaTileEntity;
                        this.Voltage = energySmart.maxEUOutput();
                        this.Amperes = energySmart.Amperes;
                        continue;
                    }
                    if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing)) continue;
                    GT_MetaTileEntity_Pipe_EnergySmart_Focusing energyFocuseSmart = (GT_MetaTileEntity_Pipe_EnergySmart_Focusing)aMetaTileEntity;
                    this.Voltage = energyFocuseSmart.maxEUOutput();
                    this.Amperes = energyFocuseSmart.Amperes;
                    continue;
                }
                aMetaTileEntity = this.findMTE(aBaseMetaTileEntity, color, side, false);
                if (!(aMetaTileEntity instanceof MTEHatchEnergyTunnel) && !(aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart) && !(aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing)) continue;
                energies.add((MetaTileEntity)aMetaTileEntity);
            }
            if (dynamo != null) {
                this.moveEnergy((MetaTileEntity)dynamo, (MetaTileEntity)this);
            }
            for (MetaTileEntity energy : energies) {
                if (aBaseMetaTileEntity.getStoredEU() <= this.getMinimumStoredEU()) continue;
                this.moveEnergy((MetaTileEntity)this, energy);
            }
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    private void moveEnergy(MetaTileEntity dynamo, MetaTileEntity energy) {
        if (dynamo.maxEUOutput() > energy.maxEUInput()) {
            energy.doExplosion(dynamo.maxEUOutput());
            dynamo.setEUVar(dynamo.getBaseMetaTileEntity().getStoredEU() - dynamo.maxEUOutput());
        } else if (dynamo.maxEUOutput() == energy.maxEUInput()) {
            long diff = Math.min(dynamo.maxAmperesOut() * 20L * dynamo.maxEUOutput(), Math.min(energy.maxEUStore() - energy.getBaseMetaTileEntity().getStoredEU(), dynamo.getBaseMetaTileEntity().getStoredEU()));
            dynamo.setEUVar(dynamo.getBaseMetaTileEntity().getStoredEU() - diff);
            energy.setEUVar(energy.getBaseMetaTileEntity().getStoredEU() + diff);
        }
    }

    private IMetaTileEntity findMTE(IGregTechTileEntity base, byte color, ForgeDirection travelDirection, boolean findProvider) {
        IGregTechTileEntity tGTTileEntity;
        if (travelDirection == null) {
            return null;
        }
        ForgeDirection facingSide = travelDirection.getOpposite();
        for (int dist = 1; dist < 1000 && (tGTTileEntity = base.getIGregTechTileEntityAtSideAndDistance(travelDirection, dist)) != null && tGTTileEntity.getColorization() == color; dist = (int)((short)(dist + 1))) {
            IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
            if (aMetaTileEntity instanceof MTEPipeLaserMirror) {
                MTEPipeLaserMirror tMirror = (MTEPipeLaserMirror)aMetaTileEntity;
                ForgeDirection mirrorFacing = tMirror.getBendDirection(facingSide);
                return this.findMTE(tMirror.getBaseMetaTileEntity(), color, mirrorFacing, findProvider);
            }
            if (findProvider && aMetaTileEntity instanceof MTEHatchDynamoTunnel && facingSide == tGTTileEntity.getFrontFacing()) {
                return aMetaTileEntity;
            }
            if (!findProvider && aMetaTileEntity instanceof MTEHatchEnergyTunnel && facingSide == tGTTileEntity.getFrontFacing()) {
                return aMetaTileEntity;
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart && (findProvider && facingSide != tGTTileEntity.getFrontFacing() || !findProvider && facingSide == tGTTileEntity.getFrontFacing())) {
                return aMetaTileEntity;
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing) {
                FMLLog.info((String)"Successful match", (Object[])new Object[0]);
                if (findProvider && facingSide == tGTTileEntity.getFrontFacing() || !findProvider && facingSide != tGTTileEntity.getFrontFacing()) {
                    return aMetaTileEntity;
                }
            }
            if (!(aMetaTileEntity instanceof MTEPipeLaser)) break;
            MTEPipeLaser pipe = (MTEPipeLaser)aMetaTileEntity;
            if (pipe.connectionCount < 2) break;
            pipe.markUsed();
        }
        return null;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("wailaVoltage", this.Voltage);
        tag.func_74772_a("wailaAmperes", this.Amperes);
        tag.func_74772_a("wailaActualInputAmperes", this.actualInputAmperes);
        tag.func_74772_a("wailaActualOutputAmperes", this.actualOutputAmperes);
        tag.func_74772_a("wailaMaxEuStore", this.maxEUStore());
        tag.func_74772_a("wailaGetStoredEU", this.getBaseMetaTileEntity().getStoredEU());
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(EnumChatFormatting.AQUA + "Voltage: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaVoltage"));
        currentTip.add(EnumChatFormatting.AQUA + "Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "Actual Input Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaActualInputAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "Actual Output Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaActualOutputAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "MaxEuStore: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaMaxEuStore"));
        currentTip.add(EnumChatFormatting.AQUA + "NowEuStore: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaGetStoredEU"));
    }

    public boolean canConnect(ForgeDirection side) {
        return true;
    }
}

