/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.common.material.MaterialPool;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.tile.mana.TilePool;

public class TST_ManaHatch
extends MTEHatchInput {
    private boolean isLiquidizerMode;
    private static FluidStack fluidMana;
    private static final int MAX_TRANS_RATE = 50;
    public static final ITexture TEXTURE;

    public TST_ManaHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public TST_ManaHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_ManaHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TEXTURE};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TEXTURE};
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (fluidMana == null) {
            fluidMana = MaterialPool.LiquidMana.getFluidOrGas(0);
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide()) {
            return;
        }
        TilePool pool = this.getManaPool();
        if (pool == null) {
            return;
        }
        int fluidAmount = this.getFluidAmount();
        int currentMana = pool.getCurrentMana();
        if (this.isLiquidizerMode) {
            if (fluidAmount != 0) {
                pool.recieveMana(this.drain((int)Math.min((int)Math.min((int)(pool.getAvailableSpaceForMana() / 10), (int)50), (int)fluidAmount), (boolean)true).amount * 10);
            }
        } else if (currentMana != 0) {
            pool.recieveMana(-this.fill(TST_ManaHatch.createFluidStack(Math.min(Math.min(currentMana / 10, 50), this.getCapacity() - fluidAmount)), true) * 10);
        }
    }

    private static FluidStack createFluidStack(int amount) {
        FluidStack c = fluidMana.copy();
        c.amount = amount;
        return c;
    }

    @Nullable
    private TilePool getManaPool() {
        IGregTechTileEntity ma = this.getBaseMetaTileEntity();
        TileEntity te = ma.getTileEntityAtSideAndDistance(ma.getFrontFacing(), 1);
        if (te instanceof TilePool) {
            TilePool pool = (TilePool)te;
            return pool;
        }
        return null;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        this.isLiquidizerMode = !this.isLiquidizerMode;
        GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("Mana_Hatch.modeMsg." + (this.isLiquidizerMode ? 0 : 1))));
    }

    public synchronized String[] getDescription() {
        this.mDescriptionArray[1] = TextLocalization.FluidCapacity + GTUtility.formatNumbers((long)this.getCapacity()) + "L";
        String[] hatchTierString = new String[]{TextLocalization.HatchTier + GTUtility.getColoredTierNameFromTier((byte)this.mTier)};
        String[] aCustomTips = this.getCustomTooltip();
        String[] desc = new String[this.mDescriptionArray.length + aCustomTips.length + 2];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        System.arraycopy(hatchTierString, 0, desc, this.mDescriptionArray.length, 1);
        System.arraycopy(aCustomTips, 0, desc, this.mDescriptionArray.length + 1, aCustomTips.length);
        desc[this.mDescriptionArray.length + aCustomTips.length] = TextLocalization.ModNameDesc;
        return desc;
    }

    public String[] getCustomTooltip() {
        String[] aTooltip = new String[5];
        aTooltip[0] = TextEnums.tr("GT_MetaTileEntity_Hatch_Mana.Tooltip0");
        aTooltip[1] = TextEnums.tr("GT_MetaTileEntity_Hatch_Mana.Tooltip1");
        aTooltip[2] = TextEnums.tr("GT_MetaTileEntity_Hatch_Mana.Tooltip2");
        aTooltip[3] = TextLocalization.textScrewdriverChangeMode;
        return aTooltip;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isLiquidizerMode", this.isLiquidizerMode);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isLiquidizerMode = aNBT.func_74767_n("isLiquidizerMode");
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().equals(fluidMana.getFluid());
    }

    public int getCapacity() {
        return 100000;
    }

    static {
        TEXTURE = TextureFactory.of((IIconContainer)TexturesGtBlock.Overlay_Hatch_Muffler_Adv);
    }
}

