/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.treefarm;

import com.Nxer.TwistSpaceTechnology.common.machine.TST_MegaTreeFarm;
import com.Nxer.TwistSpaceTechnology.common.machine.treefarm.IEGSBucketFactory;
import com.Nxer.TwistSpaceTechnology.common.misc.TSTMath;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.ItemList;
import gregtech.mixin.interfaces.accessors.IBlockStemAccessor;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import ic2.core.crop.IC2Crops;
import ic2.core.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.Objects;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.utils.ItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EGSArtificialGreenHouseOutputBucket {
    public static final IEGSBucketFactory factory = new Factory();
    public static final String NBT_IDENTIFIER = "GREENHOUSE";
    private static final int NUMBER_OF_DROPS_TO_SIMULATE = 1000;
    @Nullable
    protected ItemStack seed = null;
    protected int seedCount = 0;
    protected boolean isValid = false;
    protected EIGDropTable drops = new EIGDropTable();

    public EGSArtificialGreenHouseOutputBucket(@NotNull TST_MegaTreeFarm greenhouse) {
        this.updateBucket(greenhouse);
    }

    public EGSArtificialGreenHouseOutputBucket(@NotNull NBTTagCompound nbt) {
        this.seed = ItemUtils.readItemStackFromNBT((NBTTagCompound)nbt.func_74775_l("seed"));
        this.seedCount = nbt.func_74762_e("count");
    }

    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", this.getNBTIdentifier());
        if (this.seed != null) {
            nbt.func_74782_a("seed", (NBTBase)ItemUtils.writeItemStackToNBT((ItemStack)this.seed));
        }
        nbt.func_74768_a("count", this.seedCount);
        return nbt;
    }

    public ItemStack getSeedStack() {
        if (this.seed != null) {
            ItemStack copied = this.seed.func_77946_l();
            copied.field_77994_a = this.seedCount;
            return copied;
        }
        return null;
    }

    public int getSeedCount() {
        return this.seedCount;
    }

    public String getDisplayName() {
        if (this.seed != null) {
            return this.seed.func_82833_r();
        }
        return "No valid seed found";
    }

    @NotNull
    public String getInfoData() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isValid() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED);
        sb.append("x");
        sb.append(this.getSeedCount());
        sb.append(" ");
        sb.append(this.getDisplayName());
        this.getAdditionalInfoData(sb);
        sb.append(EnumChatFormatting.RESET);
        return sb.toString();
    }

    protected void getAdditionalInfoData(StringBuilder sb) {
    }

    public void updateBucket(@NotNull TST_MegaTreeFarm greenhouse) {
        if (greenhouse.getControllerSlot() == null) {
            return;
        }
        if (greenhouse.getControllerSlot().field_77994_a <= 0) {
            return;
        }
        this.seed = greenhouse.getControllerSlot().func_77946_l();
        if (!this.isSeedSupported()) {
            this.seed = null;
            this.seedCount = 0;
            return;
        }
        this.createMoreSeeds(greenhouse);
        this.seed = greenhouse.getControllerSlot().func_77946_l();
        this.seedCount = greenhouse.getControllerSlot().field_77994_a;
        this.revalidate(greenhouse);
    }

    private void createMoreSeeds(@NotNull TST_MegaTreeFarm greenhouse) {
        NBTTagCompound nbt;
        greenhouse.getControllerSlot().field_77994_a = 64;
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)greenhouse.getControllerSlot(), true, true) && greenhouse.getControllerSlot().func_77942_o() && (nbt = greenhouse.getControllerSlot().func_77978_p()).func_74764_b("growth") && nbt.func_74764_b("gain") && nbt.func_74764_b("resistance")) {
            nbt.func_74768_a("growth", 31);
            nbt.func_74768_a("gain", 31);
            nbt.func_74768_a("resistance", 1);
        }
    }

    public boolean isValid() {
        return this.seed != null && this.seedCount > 0 && this.isValid;
    }

    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    public void addProgress(double multiplier, EIGDropTable tracker) {
        if (!this.isValid()) {
            return;
        }
        this.drops.addTo(tracker, multiplier * (double)this.seedCount);
    }

    public boolean revalidate(TST_MegaTreeFarm greenhouse) {
        this.recalculateDrops(greenhouse);
        return this.isValid();
    }

    public void recalculateDrops(TST_MegaTreeFarm greenhouse) {
        CropCard cropCard;
        NBTTagCompound nbt;
        this.isValid = false;
        if (this.seed == null) {
            return;
        }
        EIGDropTable drops = new EIGDropTable();
        Item item = this.seed.func_77973_b();
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)this.seed, true, true) && this.seed.func_77942_o() && (nbt = this.seed.func_77978_p()).func_74764_b("growth") && nbt.func_74764_b("gain") && nbt.func_74764_b("resistance") && (cropCard = IC2Crops.instance.getCropCard(this.seed)) != null) {
            int[] xyz = new int[]{0, 0, 0};
            xyz[0] = xyz[0] + greenhouse.getBaseMetaTileEntity().getXCoord();
            xyz[1] = xyz[1] + greenhouse.getBaseMetaTileEntity().getYCoord();
            xyz[2] = xyz[2] + greenhouse.getBaseMetaTileEntity().getZCoord();
            try {
                FakeTileEntityCrop crop = new FakeTileEntityCrop(this, greenhouse, xyz);
                crop.setSize((byte)cropCard.maxSize());
                if (!cropCard.canBeHarvested((ICropTile)crop)) {
                    crop.setSize((byte)(cropCard.maxSize() - 2));
                    if (!cropCard.canBeHarvested((ICropTile)crop)) {
                        return;
                    }
                }
                double avgDropRounds = EGSArtificialGreenHouseOutputBucket.getRealAverageDropRounds(crop, cropCard);
                double avgStackIncrease = EGSArtificialGreenHouseOutputBucket.getRealAverageDropIncrease(crop, cropCard);
                for (int i = 0; i < 1000; ++i) {
                    ItemStack drop = cropCard.getGain((ICropTile)crop);
                    if (drop == null || drop.field_77994_a <= 0) continue;
                    double avgAmount = ((double)drop.field_77994_a + avgStackIncrease) * avgDropRounds;
                    drops.addDrop(drop, avgAmount / 1000.0);
                }
                if (drops.isEmpty()) {
                    return;
                }
                this.drops = drops;
                this.isValid = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (item instanceof IPlantable) {
            IPlantable plantable = (IPlantable)item;
            Block plantBlock = null;
            if (plantable instanceof ItemSeeds) {
                ItemSeeds itemSeeds = (ItemSeeds)plantable;
                plantBlock = itemSeeds.getPlant((IBlockAccess)greenhouse.getBaseMetaTileEntity().getWorld(), 0, 0, 0);
            } else if (plantable instanceof ItemSeedFood) {
                ItemSeedFood itemSeedFood = (ItemSeedFood)plantable;
                plantBlock = itemSeedFood.getPlant((IBlockAccess)greenhouse.getBaseMetaTileEntity().getWorld(), 0, 0, 0);
            } else {
                plantBlock = plantable.getPlant((IBlockAccess)greenhouse.getBaseMetaTileEntity().getWorld(), 0, 0, 0);
            }
            int metadata = -1;
            if (plantBlock instanceof BlockStem) {
                BlockStem blockStem = (BlockStem)plantBlock;
                Block cropBlock = ((IBlockStemAccessor)blockStem).gt5u$getCropBlock();
                metadata = 0;
                if (cropBlock != null && cropBlock != Blocks.field_150350_a) {
                    for (int i = 0; i < 1000; ++i) {
                        ItemStack drop;
                        ArrayList blockDrops = cropBlock.getDrops(greenhouse.getBaseMetaTileEntity().getWorld(), greenhouse.getBaseMetaTileEntity().getXCoord(), (int)greenhouse.getBaseMetaTileEntity().getYCoord(), greenhouse.getBaseMetaTileEntity().getZCoord(), metadata, 0);
                        if (blockDrops == null || blockDrops.isEmpty()) continue;
                        if (i == 0 && blockDrops.size() == 1 && (drop = (ItemStack)blockDrops.get(0)) != null && drop.field_77994_a >= 1 && drop.func_77973_b() == Item.func_150898_a((Block)cropBlock)) {
                            drops.addDrop(drop, (double)drop.field_77994_a);
                            break;
                        }
                        for (ItemStack drop2 : blockDrops) {
                            drops.addDrop(drop2, (double)drop2.field_77994_a / 1000.0);
                        }
                    }
                }
            } else if (plantBlock != null) {
                metadata = 7;
                GameRegistry.UniqueIdentifier u = GameRegistry.findUniqueIdentifierFor((Item)item);
                if (u != null && Objects.equals(u.modId, "Natura")) {
                    metadata = 8;
                }
                for (int i = 0; i < 1000; ++i) {
                    ArrayList plantDrops = plantBlock.getDrops(greenhouse.getBaseMetaTileEntity().getWorld(), greenhouse.getBaseMetaTileEntity().getXCoord(), (int)greenhouse.getBaseMetaTileEntity().getYCoord(), greenhouse.getBaseMetaTileEntity().getZCoord(), metadata, 0);
                    for (ItemStack drop : plantDrops) {
                        drops.addDrop(drop, (double)drop.field_77994_a);
                    }
                }
                ItemStack seedSafe = this.seed.func_77946_l();
                seedSafe.field_77994_a = 1;
                int inputSeedDropCountAfterRemoval = (int)Math.round(drops.getItemAmount(seedSafe)) - 1000;
                if (inputSeedDropCountAfterRemoval > 0) {
                    drops.setItemAmount(seedSafe, (double)inputSeedDropCountAfterRemoval);
                } else {
                    drops.removeItem(seedSafe);
                }
                drops.entrySet().forEach(x -> x.setValue((Double)x.getValue() / 1000.0));
            }
        }
        if (drops.isEmpty()) {
            return;
        }
        this.drops = drops;
        this.isValid = true;
    }

    public boolean isSeedSupported() {
        CropCard cropCard;
        NBTTagCompound nbt;
        if (this.seed == null) {
            return false;
        }
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)this.seed, true, true) && this.seed.func_77942_o() && (nbt = this.seed.func_77978_p()).func_74764_b("growth") && nbt.func_74764_b("gain") && nbt.func_74764_b("resistance") && (cropCard = IC2Crops.instance.getCropCard(this.seed)) != null) {
            return true;
        }
        Item item = this.seed.func_77973_b();
        if (item == Items.field_151120_aE) {
            return true;
        }
        if (item instanceof IPlantable) {
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        if (block == Blocks.field_150434_aF) {
            return true;
        }
        if (block instanceof BlockFlower) {
            return true;
        }
        return block instanceof BlockStem;
    }

    private static double getRealAverageDropRounds(TileEntityCrop te, CropCard cc) {
        double chance = (double)cc.dropGainChance() * TSTMath.powInt(1.03, te.getGain());
        double min = -10.0;
        double max = 10.0;
        int steps = 10000;
        double stepSize = (max - min) / (double)steps;
        double sum = 0.0;
        for (int k = 1; k <= steps - 1; ++k) {
            sum += TSTMath.getWeightedDropChance(min + (double)k * stepSize, chance);
        }
        double minVal = TSTMath.getWeightedDropChance(min, chance);
        double maxVal = TSTMath.getWeightedDropChance(max, chance);
        return stepSize * ((minVal + maxVal) / 2.0 + sum);
    }

    private static double getRealAverageDropIncrease(TileEntityCrop te, CropCard cc) {
        return (double)(te.getGain() + 1) / 100.0;
    }

    private static class FakeTileEntityCrop
    extends TileEntityCrop {
        public boolean isValid = false;
        private int lightLevel = 0;

        public FakeTileEntityCrop(EGSArtificialGreenHouseOutputBucket bucket, TST_MegaTreeFarm greenhouse, int[] xyz) {
            this.ticker = '\u0001';
            if (bucket.seed == null) {
                return;
            }
            CropCard cc = Crops.instance.getCropCard(bucket.seed);
            this.setCrop(cc);
            NBTTagCompound nbt = bucket.seed.func_77978_p();
            this.setGrowth(nbt.func_74771_c("growth"));
            this.setGain(nbt.func_74771_c("gain"));
            this.setResistance(nbt.func_74771_c("resistance"));
            this.func_145834_a(greenhouse.getBaseMetaTileEntity().getWorld());
            this.field_145851_c = xyz[0];
            this.field_145848_d = xyz[1];
            this.field_145849_e = xyz[2];
            this.field_145854_h = Block.func_149634_a((Item)Ic2Items.crop.func_77973_b());
            this.field_145847_g = 0;
            this.isValid = this.canMature();
        }

        public boolean canMature() {
            CropCard cc = this.getCrop();
            this.size = cc.maxSize() - 1;
            this.lightLevel = this.getLightLevel();
            if (cc.canGrow((ICropTile)this)) {
                return true;
            }
            this.lightLevel = 9;
            return cc.canGrow((ICropTile)this);
        }

        public boolean isBlockBelow(Block reqBlock) {
            return true;
        }

        public boolean isBlockBelow(String oreDictionaryName) {
            return true;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public byte getHumidity() {
            return 127;
        }

        public byte updateHumidity() {
            return 127;
        }

        public byte getNutrients() {
            return 127;
        }

        public byte updateNutrients() {
            return 127;
        }

        public byte getAirQuality() {
            return 127;
        }

        public byte updateAirQuality() {
            return 127;
        }

        public int getWeedExStorage() {
            return 200;
        }

        public void setWeedExStorage(int weedExStorage) {
        }

        public int getHydrationStorage() {
            return 200;
        }

        public void setHydrationStorage(int hydrationStorage) {
        }

        public int getNutrientStorage() {
            return 200;
        }

        public void setNutrientStorage(int weedExStorage) {
        }
    }

    public static class Factory
    implements IEGSBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EGSArtificialGreenHouseOutputBucket.NBT_IDENTIFIER;
        }

        @Override
        public EGSArtificialGreenHouseOutputBucket tryCreateBucket(TST_MegaTreeFarm greenhouse) {
            return new EGSArtificialGreenHouseOutputBucket(greenhouse);
        }

        @Override
        public EGSArtificialGreenHouseOutputBucket restore(NBTTagCompound nbt) {
            return new EGSArtificialGreenHouseOutputBucket(nbt);
        }
    }
}

