/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.misc;

import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import net.minecraft.util.EnumChatFormatting;

public enum OverclockType {
    NONE(1, 1),
    NormalOverclock(2, 4),
    LowSpeedPerfectOverclock(2, 2),
    PerfectOverclock(4, 4),
    SingularityPerfectOverclock(8, 4),
    EOHStupidOverclock(2, 8);

    public final int timeReduction;
    public final int powerIncrease;
    public final double powerIncreaseMultiplierPerOverclock;
    public final boolean perfectOverclock;

    private OverclockType(int timeReduction, int powerIncrease) {
        this.timeReduction = timeReduction;
        this.powerIncrease = powerIncrease;
        this.perfectOverclock = timeReduction >= powerIncrease;
        this.powerIncreaseMultiplierPerOverclock = timeReduction == powerIncrease ? 1.0 : Math.pow(2.0, powerIncrease - timeReduction);
    }

    public boolean isPerfectOverclock() {
        return this.perfectOverclock;
    }

    public static OverclockType checkOverclockType(int timeReduction, int powerIncrease) {
        for (OverclockType t : OverclockType.values()) {
            if (t.timeReduction != timeReduction || t.powerIncrease != powerIncrease) continue;
            return t;
        }
        return NormalOverclock;
    }

    public int getID() {
        return this.ordinal();
    }

    public String getDescription() {
        return TextEnums.tr("OverclockType.Description.01") + " " + EnumChatFormatting.AQUA + this.timeReduction + EnumChatFormatting.GRAY + " , " + TextEnums.tr("OverclockType.Description.02") + " " + EnumChatFormatting.RED + this.powerIncrease + EnumChatFormatting.GRAY + " .";
    }

    public static OverclockType getFromID(int ID) {
        return OverclockType.values()[ID];
    }
}

