/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic;

import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.IModularizedMachine;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularBlockTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineBase;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ModularizedMachineSupportAllModuleBase<T extends ModularizedMachineSupportAllModuleBase<T>>
extends ModularizedMachineBase<T>
implements IModularizedMachine.ISupportAllModularHatches {
    public OverclockType overclockType = this.getDefaultOverclockType();
    public int staticParallel = 0;
    public int dynamicParallel = 0;
    public float staticPowerConsumptionMultiplier = 1.0f;
    public float staticSpeedBonus = 1.0f;
    public float dynamicSpeedBonus = 1.0f;
    private static final Collection<ModularHatchTypes> supportedModularHatchTypes = ImmutableList.of((Object)((Object)ModularHatchTypes.ALL));

    public ModularizedMachineSupportAllModuleBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public ModularizedMachineSupportAllModuleBase(String aName) {
        super(aName);
    }

    protected OverclockType getDefaultOverclockType() {
        return OverclockType.NormalOverclock;
    }

    @Override
    public void resetModularStaticSettings() {
        this.overclockType = this.getDefaultOverclockType();
        this.staticParallel = 0;
        this.staticPowerConsumptionMultiplier = 1.0f;
        this.staticSpeedBonus = 1.0f;
    }

    @Override
    public void resetModularDynamicParameters() {
        this.dynamicParallel = 0;
        this.dynamicSpeedBonus = 1.0f;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("OverclockTypeTimeReduction", this.overclockType.timeReduction);
        aNBT.func_74768_a("OverclockTypePowerIncrease", this.overclockType.timeReduction);
        aNBT.func_74768_a("staticParallel", this.staticParallel);
        aNBT.func_74768_a("dynamicParallel", this.dynamicParallel);
        aNBT.func_74776_a("staticPowerConsumptionMultiplier", this.staticPowerConsumptionMultiplier);
        aNBT.func_74776_a("staticSpeedBonus", this.staticSpeedBonus);
        aNBT.func_74776_a("dynamicSpeedBonus", this.dynamicSpeedBonus);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.overclockType = OverclockType.checkOverclockType(aNBT.func_74762_e("OverclockTypeTimeReduction"), aNBT.func_74762_e("OverclockTypePowerIncrease"));
        this.staticParallel = aNBT.func_74762_e("staticParallel");
        this.dynamicParallel = aNBT.func_74762_e("dynamicParallel");
        this.staticPowerConsumptionMultiplier = aNBT.func_74760_g("staticPowerConsumptionMultiplier");
        this.staticSpeedBonus = aNBT.func_74760_g("staticSpeedBonus");
        this.dynamicSpeedBonus = aNBT.func_74760_g("dynamicSpeedBonus");
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return this.overclockType.isPerfectOverclock();
    }

    @Override
    protected float getSpeedBonus() {
        return this.staticSpeedBonus * this.dynamicSpeedBonus;
    }

    @Override
    protected float getEuModifier() {
        return this.staticPowerConsumptionMultiplier;
    }

    @Override
    public int getMaxParallelRecipes() {
        if (this.dynamicParallel == Integer.MAX_VALUE || this.staticParallel == Integer.MAX_VALUE || this.dynamicParallel >= 0x7FFFFFFE - this.staticParallel) {
            return Integer.MAX_VALUE;
        }
        return this.dynamicParallel + this.staticParallel + 1;
    }

    @Override
    public void setOverclockType(OverclockType type) {
        this.overclockType = type;
    }

    @Override
    public int getStaticParallelParameterValue() {
        return this.staticParallel;
    }

    @Override
    public void setStaticParallelParameter(int value) {
        this.staticParallel = value;
    }

    @Override
    public int getDynamicParallelParameterValue() {
        return this.dynamicParallel;
    }

    @Override
    public void setDynamicParallelParameter(int value) {
        this.dynamicParallel = value;
    }

    @Override
    public float getStaticPowerConsumptionParameterValue() {
        return this.staticPowerConsumptionMultiplier;
    }

    @Override
    public void setStaticPowerConsumptionParameterValue(float value) {
        this.staticPowerConsumptionMultiplier = value;
    }

    @Override
    public float getStaticSpeedParameterValue() {
        return this.staticSpeedBonus;
    }

    @Override
    public void setStaticSpeedParameterValue(float value) {
        this.staticSpeedBonus = value;
    }

    @Override
    public float getDynamicSpeedParameterValue() {
        return this.dynamicSpeedBonus;
    }

    @Override
    public void setDynamicSpeedParameterValue(float value) {
        this.dynamicSpeedBonus = value;
    }

    @Override
    public Collection<ModularHatchTypes> getSupportedModularHatchTypes() {
        return supportedModularHatchTypes;
    }

    @Override
    public Collection<ModularBlockTypes> getSupportedModularBlockTypes() {
        return Collections.emptyList();
    }
}

